/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.core.threading;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.giphy.sdk.core.network.api.CompletionHandler;
import com.giphy.sdk.core.threading.HandlerExecutor;
import java.io.InterruptedIOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u0011*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0011B\u0015\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005B%\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000eJ\u000b\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/giphy/sdk/core/threading/ApiTask;", "V", "", "callable", "Ljava/util/concurrent/Callable;", "(Ljava/util/concurrent/Callable;)V", "networkRequestExecutor", "Ljava/util/concurrent/ExecutorService;", "completionExecutor", "Ljava/util/concurrent/Executor;", "(Ljava/util/concurrent/Callable;Ljava/util/concurrent/ExecutorService;Ljava/util/concurrent/Executor;)V", "executeAsyncTask", "Ljava/util/concurrent/Future;", "completionHandler", "Lcom/giphy/sdk/core/network/api/CompletionHandler;", "executeImmediately", "()Ljava/lang/Object;", "Companion", "giphy-ui-2.3.4_release"})
public final class ApiTask<V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Callable<V> callable;
    @NotNull
    private final ExecutorService networkRequestExecutor;
    @NotNull
    private final Executor completionExecutor;
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int THREAD_POOL_CORE_SIZE = CPU_COUNT + 2;
    private static final int THREAD_POOL_MAX_SIZE = CPU_COUNT * 2 + 2;
    private static final long THREAD_POOL_KEEP_ALIVE_TIME = 1L;
    @Nullable
    private static ExecutorService NETWORK_REQUEST_EXECUTOR;
    @Nullable
    private static Executor COMPLETION_EXECUTOR;

    public ApiTask(@NotNull Callable<V> callable) {
        Intrinsics.checkNotNullParameter(callable, (String)"callable");
        this.callable = callable;
        this.networkRequestExecutor = Companion.getNetworkRequestExecutor();
        this.completionExecutor = Companion.getCompletionExecutor();
    }

    public ApiTask(@NotNull Callable<V> callable, @NotNull ExecutorService networkRequestExecutor, @NotNull Executor completionExecutor) {
        Intrinsics.checkNotNullParameter(callable, (String)"callable");
        Intrinsics.checkNotNullParameter((Object)networkRequestExecutor, (String)"networkRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)completionExecutor, (String)"completionExecutor");
        this.callable = callable;
        this.networkRequestExecutor = networkRequestExecutor;
        this.completionExecutor = completionExecutor;
    }

    @NotNull
    public final Future<?> executeAsyncTask(@Nullable CompletionHandler<? super V> completionHandler) {
        Future<?> future = this.networkRequestExecutor.submit(() -> ApiTask.executeAsyncTask$lambda-3(this, completionHandler));
        Intrinsics.checkNotNullExpressionValue(future, (String)"networkRequestExecutor.s\u2026}\n            }\n        }");
        return future;
    }

    public static /* synthetic */ Future executeAsyncTask$default(ApiTask apiTask, CompletionHandler completionHandler, int n, Object object) {
        if ((n & 1) != 0) {
            completionHandler = null;
        }
        return apiTask.executeAsyncTask(completionHandler);
    }

    public final V executeImmediately() throws Exception {
        return this.callable.call();
    }

    private static final void executeAsyncTask$lambda-3$lambda-0(CompletionHandler $completionHandler, Object $value) {
        block0: {
            CompletionHandler completionHandler = $completionHandler;
            if (completionHandler == null) break block0;
            completionHandler.onComplete($value, null);
        }
    }

    private static final void executeAsyncTask$lambda-3$lambda-1(CompletionHandler $completionHandler, ExecutionException $e) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
            CompletionHandler completionHandler = $completionHandler;
            if (completionHandler == null) break block0;
            completionHandler.onComplete(null, $e);
        }
    }

    private static final void executeAsyncTask$lambda-3$lambda-2(CompletionHandler $completionHandler, Throwable $e) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
            CompletionHandler completionHandler = $completionHandler;
            if (completionHandler == null) break block0;
            completionHandler.onComplete(null, $e);
        }
    }

    private static final void executeAsyncTask$lambda-3(ApiTask this$0, CompletionHandler $completionHandler) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            Object value = this$0.callable.call();
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            this$0.completionExecutor.execute(() -> ApiTask.executeAsyncTask$lambda-3$lambda-0($completionHandler, value));
        }
        catch (ExecutionException e) {
            Log.e((String)ApiTask.class.getName(), (String)"Unable to perform async task, cancelling\u2026", (Throwable)e);
            this$0.completionExecutor.execute(() -> ApiTask.executeAsyncTask$lambda-3$lambda-1($completionHandler, e));
        }
        catch (InterruptedIOException e) {
        }
        catch (InterruptedException e) {
        }
        catch (Throwable e) {
            this$0.completionExecutor.execute(() -> ApiTask.executeAsyncTask$lambda-3$lambda-2($completionHandler, e));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0013\u001a\u00020\u0004J\u0006\u0010\u0014\u001a\u00020\nR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0014\u0010\r\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/giphy/sdk/core/threading/ApiTask$Companion;", "", "()V", "COMPLETION_EXECUTOR", "Ljava/util/concurrent/Executor;", "CPU_COUNT", "", "getCPU_COUNT", "()I", "NETWORK_REQUEST_EXECUTOR", "Ljava/util/concurrent/ExecutorService;", "THREAD_POOL_CORE_SIZE", "getTHREAD_POOL_CORE_SIZE", "THREAD_POOL_KEEP_ALIVE_TIME", "", "getTHREAD_POOL_KEEP_ALIVE_TIME", "()J", "THREAD_POOL_MAX_SIZE", "getTHREAD_POOL_MAX_SIZE", "getCompletionExecutor", "getNetworkRequestExecutor", "giphy-ui-2.3.4_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int getCPU_COUNT() {
            return CPU_COUNT;
        }

        public final int getTHREAD_POOL_CORE_SIZE() {
            return THREAD_POOL_CORE_SIZE;
        }

        public final int getTHREAD_POOL_MAX_SIZE() {
            return THREAD_POOL_MAX_SIZE;
        }

        public final long getTHREAD_POOL_KEEP_ALIVE_TIME() {
            return THREAD_POOL_KEEP_ALIVE_TIME;
        }

        @NotNull
        public final ExecutorService getNetworkRequestExecutor() {
            if (NETWORK_REQUEST_EXECUTOR == null) {
                NETWORK_REQUEST_EXECUTOR = new ThreadPoolExecutor(this.getTHREAD_POOL_CORE_SIZE(), this.getTHREAD_POOL_MAX_SIZE(), this.getTHREAD_POOL_KEEP_ALIVE_TIME(), TimeUnit.SECONDS, new LinkedBlockingQueue());
            }
            ExecutorService executorService = NETWORK_REQUEST_EXECUTOR;
            Intrinsics.checkNotNull((Object)executorService);
            return executorService;
        }

        @NotNull
        public final Executor getCompletionExecutor() {
            if (COMPLETION_EXECUTOR == null) {
                COMPLETION_EXECUTOR = new HandlerExecutor(new Handler(Looper.getMainLooper()));
            }
            Executor executor = COMPLETION_EXECUTOR;
            Intrinsics.checkNotNull((Object)executor);
            return executor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

