/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.core;

import android.net.Uri;
import android.os.SystemClock;
import com.facebook.imagepipeline.backends.okhttp3.OkHttpNetworkFetcher;
import com.facebook.imagepipeline.producers.NetworkFetcher;
import com.facebook.imagepipeline.request.ImageRequest;
import com.giphy.sdk.core.GPHNetworkImageRequest;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/giphy/sdk/core/GPHOkHttpNetworkFetcher;", "Lcom/facebook/imagepipeline/backends/okhttp3/OkHttpNetworkFetcher;", "mOkHttpClient", "Lokhttp3/OkHttpClient;", "(Lokhttp3/OkHttpClient;)V", "mCancellationExecutor", "Ljava/util/concurrent/Executor;", "fetch", "", "fetchState", "Lcom/facebook/imagepipeline/backends/okhttp3/OkHttpNetworkFetcher$OkHttpNetworkFetchState;", "callback", "Lcom/facebook/imagepipeline/producers/NetworkFetcher$Callback;", "Companion", "giphy-ui-2.3.4_release"})
public final class GPHOkHttpNetworkFetcher
extends OkHttpNetworkFetcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Executor mCancellationExecutor;
    @NotNull
    private static final String TAG = "ReactOkHttpNetworkFetcher";

    public GPHOkHttpNetworkFetcher(@NotNull OkHttpClient mOkHttpClient) {
        Intrinsics.checkNotNullParameter((Object)mOkHttpClient, (String)"mOkHttpClient");
        super(mOkHttpClient);
        ExecutorService executorService = mOkHttpClient.dispatcher().executorService();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"mOkHttpClient.dispatcher().executorService()");
        this.mCancellationExecutor = executorService;
    }

    public void fetch(@NotNull OkHttpNetworkFetcher.OkHttpNetworkFetchState fetchState, @Nullable NetworkFetcher.Callback callback) {
        Intrinsics.checkNotNullParameter((Object)fetchState, (String)"fetchState");
        fetchState.submitTime = SystemClock.elapsedRealtime();
        Uri uri = fetchState.getUri();
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"fetchState.uri");
        Uri uri2 = uri;
        Map requestHeaders = MapsKt.emptyMap();
        if (fetchState.getContext().getImageRequest() instanceof GPHNetworkImageRequest) {
            ImageRequest imageRequest = fetchState.getContext().getImageRequest();
            Intrinsics.checkNotNull((Object)imageRequest, (String)"null cannot be cast to non-null type com.giphy.sdk.core.GPHNetworkImageRequest");
            Map map = ((GPHNetworkImageRequest)imageRequest).getHeaders();
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            requestHeaders = map;
        }
        Request request = new Request.Builder().cacheControl(new CacheControl.Builder().noStore().build()).url(uri2.toString()).headers(Headers.of((Map)requestHeaders)).get().build();
        this.fetchWithRequest(fetchState, callback, request);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/giphy/sdk/core/GPHOkHttpNetworkFetcher$Companion;", "", "()V", "TAG", "", "giphy-ui-2.3.4_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

