/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.analytics.util;

import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a8\u0006\n"}, d2={"Lcom/giphy/sdk/analytics/util/HashUtils;", "", "()V", "hashString", "", "type", "input", "sha1", "sha256", "sha512", "giphy-ui-2.3.4_release"})
public final class HashUtils {
    @NotNull
    public static final HashUtils INSTANCE = new HashUtils();

    private HashUtils() {
    }

    @NotNull
    public final String sha512(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this.hashString("SHA-512", input);
    }

    @NotNull
    public final String sha256(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this.hashString("SHA-256", input);
    }

    @NotNull
    public final String sha1(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this.hashString("SHA-1", input);
    }

    private final String hashString(String type, String input) {
        String HEX_CHARS = "0123456789ABCDEF";
        MessageDigest messageDigest = MessageDigest.getInstance(type);
        String string = input;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] bytes = messageDigest.digest(byArray);
        StringBuilder result = new StringBuilder(bytes.length * 2);
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
        byte[] $this$forEach$iv = bytes;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            byte element$iv;
            byte it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            byte i2 = it;
            result.append(HEX_CHARS.charAt(i2 >> 4 & 0xF));
            result.append(HEX_CHARS.charAt(i2 & 0xF));
        }
        String string2 = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"result.toString()");
        return string2;
    }
}

