/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.analytics.batching;

import android.util.Log;
import com.giphy.sdk.analytics.GiphyPingbacks;
import com.giphy.sdk.analytics.batching.AnalyticsId;
import com.giphy.sdk.analytics.models.Session;
import com.giphy.sdk.analytics.network.api.GPHPingbackApi;
import com.giphy.sdk.analytics.network.api.GPHPingbackClient;
import com.giphy.sdk.analytics.network.response.PingbackResponse;
import com.giphy.sdk.core.network.api.CompletionHandler;
import com.giphy.sdk.core.network.engine.DefaultNetworkSession;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0018J\u0006\u0010\u001e\u001a\u00020\u001cJ\b\u0010\u001f\u001a\u00020\u001cH\u0002J\b\u0010 \u001a\u00020\u001cH\u0002J\b\u0010!\u001a\u00020\u001cH\u0002R\u0019\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006#"}, d2={"Lcom/giphy/sdk/analytics/batching/PingbackSubmissionQueue;", "", "pingbackClient", "Lcom/giphy/sdk/analytics/network/api/GPHPingbackApi;", "(Lcom/giphy/sdk/analytics/network/api/GPHPingbackApi;)V", "apiKey", "", "isMainInstance", "", "enableVerificationMode", "(Ljava/lang/String;ZZ)V", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "getExecutorService", "()Ljava/util/concurrent/ScheduledExecutorService;", "retriesCount", "", "retryFlush", "Ljava/lang/Runnable;", "retryFuture", "Ljava/util/concurrent/ScheduledFuture;", "sessions", "Ljava/util/LinkedList;", "Lcom/giphy/sdk/analytics/models/Session;", "getSessions", "()Ljava/util/LinkedList;", "add", "", "session", "flush", "scheduleReattempt", "submitAllSessions", "trimQueueIfNecessary", "Companion", "giphy-ui-2.3.4_release"})
public final class PingbackSubmissionQueue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int retriesCount;
    @Nullable
    private ScheduledFuture<?> retryFuture;
    private final ScheduledExecutorService executorService;
    @NotNull
    private GPHPingbackApi pingbackClient;
    @NotNull
    private final LinkedList<Session> sessions;
    @NotNull
    private final Runnable retryFlush;
    private static int maximumQueuedSessions = 10;
    private static long delayAfterFailure = 5000L;
    private static long maximumRetriesCount = 3L;

    public final ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    @NotNull
    public final LinkedList<Session> getSessions() {
        return this.sessions;
    }

    public PingbackSubmissionQueue(@NotNull GPHPingbackApi pingbackClient) {
        Intrinsics.checkNotNullParameter((Object)pingbackClient, (String)"pingbackClient");
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.sessions = new LinkedList();
        this.retryFlush = () -> PingbackSubmissionQueue.retryFlush$lambda-0(this);
        this.pingbackClient = pingbackClient;
    }

    public PingbackSubmissionQueue(@NotNull String apiKey, boolean isMainInstance, boolean enableVerificationMode) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.sessions = new LinkedList();
        this.retryFlush = () -> PingbackSubmissionQueue.retryFlush$lambda-0(this);
        ScheduledExecutorService scheduledExecutorService = this.executorService;
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"executorService");
        ExecutorService executorService = scheduledExecutorService;
        ScheduledExecutorService scheduledExecutorService2 = this.executorService;
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService2, (String)"executorService");
        this.pingbackClient = new GPHPingbackClient(apiKey, new DefaultNetworkSession(executorService, scheduledExecutorService2), new AnalyticsId(apiKey, isMainInstance, enableVerificationMode));
    }

    public final void add(@NotNull Session session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.executorService.execute(() -> PingbackSubmissionQueue.add$lambda-1(this, session));
    }

    public final void flush() {
        this.executorService.execute(() -> PingbackSubmissionQueue.flush$lambda-2(this));
    }

    private final void submitAllSessions() {
        while (!this.sessions.isEmpty()) {
            Session session;
            if (this.sessions.pollFirst() == null) continue;
            boolean bl = false;
            this.pingbackClient.submitSession(session, (CompletionHandler<? super PingbackResponse>)new CompletionHandler<PingbackResponse>(this, session){
                final /* synthetic */ PingbackSubmissionQueue this$0;
                final /* synthetic */ Session $session;
                {
                    this.this$0 = $receiver;
                    this.$session = $session;
                }

                public void onComplete(@Nullable PingbackResponse result, @Nullable Throwable e) {
                    if (e != null) {
                        if (GiphyPingbacks.INSTANCE.getLogsEnabled()) {
                            Log.d((String)"PINGBACK", (String)("Error submitting session. " + e.getLocalizedMessage()));
                        }
                        this.this$0.getSessions().addLast(this.$session);
                        PingbackSubmissionQueue.access$trimQueueIfNecessary(this.this$0);
                        PingbackSubmissionQueue.access$scheduleReattempt(this.this$0);
                    } else {
                        PingbackSubmissionQueue.access$setRetriesCount$p(this.this$0, 0);
                        if (GiphyPingbacks.INSTANCE.getLogsEnabled()) {
                            String string = "Successfully submitted session %s %s";
                            Object[] objectArray = new Object[]{this.$session.getSessionId(), this.$session.getEvents().size()};
                            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                            Log.d((String)"PINGBACK", (String)string2);
                        }
                    }
                }
            });
        }
    }

    private final void trimQueueIfNecessary() {
        while (this.sessions.size() > maximumQueuedSessions) {
            if (GiphyPingbacks.INSTANCE.getLogsEnabled()) {
                String string = "trimming queued session because count == %s";
                Object[] objectArray = new Object[]{this.sessions.size()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                Log.d((String)"PINGBACK", (String)string2);
            }
            this.sessions.removeLast();
        }
    }

    private final void scheduleReattempt() {
        if (this.retryFuture != null) {
            ScheduledFuture<?> scheduledFuture = this.retryFuture;
            Intrinsics.checkNotNull(scheduledFuture);
            if (!scheduledFuture.isCancelled()) {
                ScheduledFuture<?> scheduledFuture2 = this.retryFuture;
                Intrinsics.checkNotNull(scheduledFuture2);
                scheduledFuture2.cancel(false);
            }
        }
        if ((long)this.retriesCount < maximumRetriesCount) {
            this.retryFuture = this.executorService.schedule(this.retryFlush, delayAfterFailure * (long)Math.pow(3.0, this.retriesCount), TimeUnit.MILLISECONDS);
        } else {
            int n = this.retriesCount;
            this.retriesCount = n + 1;
        }
    }

    private static final void retryFlush$lambda-0(PingbackSubmissionQueue this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.submitAllSessions();
    }

    private static final void add$lambda-1(PingbackSubmissionQueue this$0, Session $session) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$session, (String)"$session");
        if (this$0.sessions.contains($session)) {
            return;
        }
        this$0.sessions.addFirst($session);
        this$0.trimQueueIfNecessary();
        this$0.submitAllSessions();
    }

    private static final void flush$lambda-2(PingbackSubmissionQueue this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.submitAllSessions();
    }

    public static final /* synthetic */ void access$trimQueueIfNecessary(PingbackSubmissionQueue $this) {
        $this.trimQueueIfNecessary();
    }

    public static final /* synthetic */ void access$scheduleReattempt(PingbackSubmissionQueue $this) {
        $this.scheduleReattempt();
    }

    public static final /* synthetic */ void access$setRetriesCount$p(PingbackSubmissionQueue $this, int n) {
        $this.retriesCount = n;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/giphy/sdk/analytics/batching/PingbackSubmissionQueue$Companion;", "", "()V", "delayAfterFailure", "", "getDelayAfterFailure", "()J", "setDelayAfterFailure", "(J)V", "maximumQueuedSessions", "", "getMaximumQueuedSessions", "()I", "setMaximumQueuedSessions", "(I)V", "maximumRetriesCount", "getMaximumRetriesCount", "setMaximumRetriesCount", "giphy-ui-2.3.4_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int getMaximumQueuedSessions() {
            return maximumQueuedSessions;
        }

        public final void setMaximumQueuedSessions(int n) {
            maximumQueuedSessions = n;
        }

        public final long getDelayAfterFailure() {
            return delayAfterFailure;
        }

        public final void setDelayAfterFailure(long l) {
            delayAfterFailure = l;
        }

        public final long getMaximumRetriesCount() {
            return maximumRetriesCount;
        }

        public final void setMaximumRetriesCount(long l) {
            maximumRetriesCount = l;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

