/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.analytics.batching;

import android.util.Log;
import com.giphy.sdk.analytics.tracking.GPHSessionID;
import com.giphy.sdk.analytics.util.ConstantsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000bR\u001e\u0010\r\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u001e\u0010\u000f\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/giphy/sdk/analytics/batching/AnalyticsId;", "", "apikey", "", "isMainInstance", "", "enableVerificationMode", "(Ljava/lang/String;ZZ)V", "getApikey", "()Ljava/lang/String;", "getEnableVerificationMode", "()Z", "<set-?>", "pingbackId", "getPingbackId", "verificationID", "getVerificationID", "cachePrefix", "giphy-ui-2.3.4_release"})
public final class AnalyticsId {
    @NotNull
    private final String apikey;
    private final boolean isMainInstance;
    private final boolean enableVerificationMode;
    @NotNull
    private String pingbackId;
    @NotNull
    private String verificationID;

    public AnalyticsId(@NotNull String apikey, boolean isMainInstance, boolean enableVerificationMode) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)apikey, (String)"apikey");
        this.apikey = apikey;
        this.isMainInstance = isMainInstance;
        this.enableVerificationMode = enableVerificationMode;
        this.pingbackId = "";
        this.verificationID = "";
        GPHSessionID sessionId = new GPHSessionID(this.cachePrefix());
        this.pingbackId = sessionId.getValue();
        this.verificationID = sessionId.getVerificationID();
        if (this.enableVerificationMode && !((charSequence = (CharSequence)this.verificationID) == null || charSequence.length() == 0)) {
            Log.v((String)"PINGBACK", (String)ConstantsKt.pingbackVerificationMessage(this.verificationID));
        }
    }

    public /* synthetic */ AnalyticsId(String string, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        this(string, bl, bl2);
    }

    @NotNull
    public final String getApikey() {
        return this.apikey;
    }

    public final boolean isMainInstance() {
        return this.isMainInstance;
    }

    public final boolean getEnableVerificationMode() {
        return this.enableVerificationMode;
    }

    @NotNull
    public final String getPingbackId() {
        return this.pingbackId;
    }

    @NotNull
    public final String getVerificationID() {
        return this.verificationID;
    }

    private final String cachePrefix() {
        return this.isMainInstance ? "" : this.apikey + '_';
    }
}

