/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.ui.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Outline;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewOutlineProvider;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import com.facebook.common.internal.Supplier;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.RetainingDataSourceSupplier;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.drawee.backends.pipeline.PipelineDraweeControllerBuilder;
import com.facebook.drawee.controller.BaseControllerListener;
import com.facebook.drawee.controller.ControllerListener;
import com.facebook.drawee.drawable.ProgressBarDrawable;
import com.facebook.drawee.drawable.ScaleTypeDrawable;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.view.SimpleDraweeView;
import com.facebook.fresco.animation.drawable.AnimatedDrawable2;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.ImageInfo;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.giphy.sdk.core.GiphyCore;
import com.giphy.sdk.core.models.Image;
import com.giphy.sdk.core.models.Media;
import com.giphy.sdk.core.models.enums.RenditionType;
import com.giphy.sdk.core.network.api.CompletionHandler;
import com.giphy.sdk.core.network.response.MediaResponse;
import com.giphy.sdk.tracking.MediaExtensionKt;
import com.giphy.sdk.ui.Giphy;
import com.giphy.sdk.ui.R;
import com.giphy.sdk.ui.drawables.GifStepAction;
import com.giphy.sdk.ui.drawables.GifStepMapping;
import com.giphy.sdk.ui.drawables.ImageFormat;
import com.giphy.sdk.ui.drawables.ImageUriInfo;
import com.giphy.sdk.ui.drawables.LoadStep;
import com.giphy.sdk.ui.themes.LightTheme;
import com.giphy.sdk.ui.utils.GifUtils;
import com.giphy.sdk.ui.utils.ImageDownloadChooserKt;
import com.giphy.sdk.ui.utils.IntExtensionsKt;
import com.giphy.sdk.ui.views.GifView;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00c9\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0006*\u0001\\\b\u0016\u0018\u0000 \u0087\u00012\u00020\u0001:\u0004\u0087\u0001\u0088\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010Z\u001a\u00020AH\u0002J\r\u0010[\u001a\u00020\\H\u0002\u00a2\u0006\u0002\u0010]J\u000e\u0010^\u001a\b\u0012\u0004\u0012\u00020V0_H\u0002J\b\u0010`\u001a\u00020aH\u0002J\u0010\u0010b\u001a\u00020A2\b\b\u0001\u0010c\u001a\u00020\u0007J\u0010\u0010b\u001a\u00020A2\b\u0010d\u001a\u0004\u0018\u00010:J\b\u0010e\u001a\u00020AH\u0002J\u0010\u0010f\u001a\u00020A2\u0006\u0010g\u001a\u00020hH\u0002J\b\u0010i\u001a\u00020AH\u0002J\b\u0010j\u001a\u00020AH\u0002J&\u0010k\u001a\u00020A2\b\u0010l\u001a\u0004\u0018\u00010:2\b\u0010m\u001a\u0004\u0018\u00010n2\b\u0010o\u001a\u0004\u0018\u00010pH\u0016J\u0018\u0010q\u001a\u00020A2\u0006\u0010r\u001a\u00020\u00072\u0006\u0010s\u001a\u00020\u0007H\u0014J\b\u0010t\u001a\u00020AH\u0014J\u0006\u0010u\u001a\u00020AJ\u0006\u0010v\u001a\u00020AJ\u0006\u0010w\u001a\u00020AJ\u0006\u0010x\u001a\u00020AJ\u0010\u0010y\u001a\u00020A2\u0006\u0010g\u001a\u00020hH\u0002J\u0006\u0010z\u001a\u00020AJ(\u00107\u001a\u00020A2\b\u00104\u001a\u0004\u0018\u0001032\n\b\u0002\u0010{\u001a\u0004\u0018\u00010Y2\n\b\u0002\u0010F\u001a\u0004\u0018\u00010\fJk\u0010|\u001a\u00020A2\u0006\u0010l\u001a\u00020:2\b\b\u0002\u0010{\u001a\u00020Y2\n\b\u0002\u0010F\u001a\u0004\u0018\u00010\f2E\b\u0002\u0010}\u001a?\u0012\u0018\u0012\u0016\u0018\u00010\u007f\u00a2\u0006\u000f\b\u0080\u0001\u0012\n\b\u0081\u0001\u0012\u0005\b\b(\u0082\u0001\u0012\u0019\u0012\u0017\u0018\u00010\u0083\u0001\u00a2\u0006\u000f\b\u0080\u0001\u0012\n\b\u0081\u0001\u0012\u0005\b\b(\u0084\u0001\u0012\u0004\u0012\u00020A\u0018\u00010~J\t\u0010\u0085\u0001\u001a\u00020AH\u0002J\t\u0010\u0086\u0001\u001a\u00020AH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001d\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u000e\u0010.\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010/\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010+\"\u0004\b1\u0010-R(\u00104\u001a\u0004\u0018\u0001032\b\u00102\u001a\u0004\u0018\u000103@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u001c\u00109\u001a\u0004\u0018\u00010:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\"\u0010?\u001a\n\u0012\u0004\u0012\u00020A\u0018\u00010@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u0010\u0010F\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010H\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020K0J0IX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010L\u001a\u0004\u0018\u00010MX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010O\"\u0004\bP\u0010QR\u001a\u0010R\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010+\"\u0004\bT\u0010-R\u0010\u0010U\u001a\u0004\u0018\u00010VX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010W\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010X\u001a\u0004\u0018\u00010YX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0089\u0001"}, d2={"Lcom/giphy/sdk/ui/views/GifView;", "Lcom/facebook/drawee/view/SimpleDraweeView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "autoPlay", "", "bgDrawable", "Landroid/graphics/drawable/Drawable;", "getBgDrawable", "()Landroid/graphics/drawable/Drawable;", "setBgDrawable", "(Landroid/graphics/drawable/Drawable;)V", "cornerRadius", "", "getCornerRadius", "()F", "setCornerRadius", "(F)V", "defaultAspectRatio", "fixedAspectRatio", "getFixedAspectRatio", "()Ljava/lang/Float;", "setFixedAspectRatio", "(Ljava/lang/Float;)V", "Ljava/lang/Float;", "gifCallback", "Lcom/giphy/sdk/ui/views/GifView$GifCallback;", "getGifCallback", "()Lcom/giphy/sdk/ui/views/GifView$GifCallback;", "setGifCallback", "(Lcom/giphy/sdk/ui/views/GifView$GifCallback;)V", "imageFormat", "Lcom/giphy/sdk/ui/drawables/ImageFormat;", "getImageFormat", "()Lcom/giphy/sdk/ui/drawables/ImageFormat;", "setImageFormat", "(Lcom/giphy/sdk/ui/drawables/ImageFormat;)V", "isBackgroundVisible", "()Z", "setBackgroundVisible", "(Z)V", "keepGifRatio", "loaded", "getLoaded", "setLoaded", "value", "Lcom/giphy/sdk/core/models/Media;", "media", "getMedia", "()Lcom/giphy/sdk/core/models/Media;", "setMedia", "(Lcom/giphy/sdk/core/models/Media;)V", "mediaId", "", "getMediaId", "()Ljava/lang/String;", "setMediaId", "(Ljava/lang/String;)V", "onPingbackGifLoadSuccess", "Lkotlin/Function0;", "", "getOnPingbackGifLoadSuccess", "()Lkotlin/jvm/functions/Function0;", "setOnPingbackGifLoadSuccess", "(Lkotlin/jvm/functions/Function0;)V", "placeholderDrawable", "renditionAspectRatio", "retainingSupplier", "Lcom/facebook/datasource/RetainingDataSourceSupplier;", "Lcom/facebook/common/references/CloseableReference;", "Lcom/facebook/imagepipeline/image/CloseableImage;", "scaleType", "Lcom/facebook/drawee/drawable/ScalingUtils$ScaleType;", "getScaleType", "()Lcom/facebook/drawee/drawable/ScalingUtils$ScaleType;", "setScaleType", "(Lcom/facebook/drawee/drawable/ScalingUtils$ScaleType;)V", "showProgress", "getShowProgress", "setShowProgress", "step", "Lcom/giphy/sdk/ui/drawables/LoadStep;", "stepIndex", "targetRendition", "Lcom/giphy/sdk/core/models/enums/RenditionType;", "addOutline", "getControllerListener", "com/giphy/sdk/ui/views/GifView$getControllerListener$1", "()Lcom/giphy/sdk/ui/views/GifView$getControllerListener$1;", "getLoadingSteps", "", "getProgressDrawable", "Lcom/facebook/drawee/drawable/ProgressBarDrawable;", "loadAsset", "resId", "url", "loadCurrentStep", "loadImageFromUri", "uri", "Landroid/net/Uri;", "loadMedia", "loadNextStep", "onFinalImageSet", "id", "imageInfo", "Lcom/facebook/imagepipeline/image/ImageInfo;", "anim", "Landroid/graphics/drawable/Animatable;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onMediaChanged", "pause", "play", "recycle", "removeLock", "replaceImage", "setLocked", "renditionType", "setMediaWithId", "completionHandler", "Lkotlin/Function2;", "Lcom/giphy/sdk/core/network/response/MediaResponse;", "Lkotlin/ParameterName;", "name", "result", "", "e", "tryLoadCurrentStep", "tryLoadNextStep", "Companion", "GifCallback", "giphy-ui-2.3.17_release"})
public class GifView
extends SimpleDraweeView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean keepGifRatio;
    @Nullable
    private RenditionType targetRendition;
    private boolean autoPlay;
    private final float defaultAspectRatio;
    @Nullable
    private Drawable placeholderDrawable;
    private int stepIndex;
    @Nullable
    private LoadStep step;
    @NotNull
    private final RetainingDataSourceSupplier<CloseableReference<CloseableImage>> retainingSupplier;
    @Nullable
    private GifCallback gifCallback;
    @Nullable
    private Function0<Unit> onPingbackGifLoadSuccess;
    @Nullable
    private Float fixedAspectRatio;
    private float renditionAspectRatio;
    private boolean showProgress;
    private boolean isBackgroundVisible;
    @NotNull
    private ImageFormat imageFormat;
    private boolean loaded;
    @Nullable
    private ScalingUtils.ScaleType scaleType;
    private float cornerRadius;
    @Nullable
    private Media media;
    @Nullable
    private String mediaId;
    @Nullable
    private Drawable bgDrawable;
    private static final float CORNER_RADIUS = IntExtensionsKt.getPx(4);

    @JvmOverloads
    public GifView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.autoPlay = Giphy.INSTANCE.getAutoPlay();
        this.defaultAspectRatio = 1.7777778f;
        this.retainingSupplier = new RetainingDataSourceSupplier();
        this.renditionAspectRatio = this.defaultAspectRatio;
        this.isBackgroundVisible = true;
        this.imageFormat = ImageFormat.WEBP;
        this.cornerRadius = IntExtensionsKt.getPx(0);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.GifView, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026.styleable.GifView, 0, 0)");
        TypedArray array = typedArray;
        this.keepGifRatio = array.getBoolean(R.styleable.GifView_gphKeepGifRatio, true);
        this.cornerRadius = array.getDimension(R.styleable.GifView_gphCornerRadius, 0.0f);
        array.recycle();
        this.bgDrawable = ContextCompat.getDrawable((Context)context, (int)(Intrinsics.areEqual((Object)Giphy.INSTANCE.getThemeUsed$giphy_ui_2_3_17_release(), (Object)LightTheme.INSTANCE) ? R.drawable.gph_sticker_bg_drawable_light : R.drawable.gph_sticker_bg_drawable));
    }

    public /* synthetic */ GifView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @Nullable
    public final GifCallback getGifCallback() {
        return this.gifCallback;
    }

    public final void setGifCallback(@Nullable GifCallback gifCallback) {
        this.gifCallback = gifCallback;
    }

    @Nullable
    public final Function0<Unit> getOnPingbackGifLoadSuccess() {
        return this.onPingbackGifLoadSuccess;
    }

    public final void setOnPingbackGifLoadSuccess(@Nullable Function0<Unit> function0) {
        this.onPingbackGifLoadSuccess = function0;
    }

    @Nullable
    public final Float getFixedAspectRatio() {
        return this.fixedAspectRatio;
    }

    public final void setFixedAspectRatio(@Nullable Float f) {
        this.fixedAspectRatio = f;
    }

    public final boolean getShowProgress() {
        return this.showProgress;
    }

    public final void setShowProgress(boolean bl) {
        this.showProgress = bl;
    }

    public final boolean isBackgroundVisible() {
        return this.isBackgroundVisible;
    }

    public final void setBackgroundVisible(boolean bl) {
        this.isBackgroundVisible = bl;
    }

    @NotNull
    public final ImageFormat getImageFormat() {
        return this.imageFormat;
    }

    public final void setImageFormat(@NotNull ImageFormat imageFormat) {
        Intrinsics.checkNotNullParameter((Object)((Object)imageFormat), (String)"<set-?>");
        this.imageFormat = imageFormat;
    }

    public final boolean getLoaded() {
        return this.loaded;
    }

    public final void setLoaded(boolean bl) {
        this.loaded = bl;
    }

    @Nullable
    public final ScalingUtils.ScaleType getScaleType() {
        return this.scaleType;
    }

    public final void setScaleType(@Nullable ScalingUtils.ScaleType scaleType) {
        this.scaleType = scaleType;
    }

    public final float getCornerRadius() {
        return this.cornerRadius;
    }

    public final void setCornerRadius(float f) {
        this.cornerRadius = f;
    }

    @Nullable
    public final Media getMedia() {
        return this.media;
    }

    private final void setMedia(Media value) {
        this.loaded = false;
        Media media = value;
        CharSequence charSequence = media != null ? media.getAltText() : null;
        if (!(charSequence == null || charSequence.length() == 0)) {
            Media media2 = value;
            this.setContentDescription(media2 != null ? media2.getAltText() : null);
        } else {
            Media media3 = value;
            charSequence = media3 != null ? media3.getTitle() : null;
            if (!(charSequence == null || charSequence.length() == 0)) {
                Media media4 = value;
                this.setContentDescription(media4 != null ? media4.getTitle() : null);
            }
        }
        this.media = value;
        this.onMediaChanged();
        this.requestLayout();
        this.post(() -> GifView._set_media_$lambda$0(this));
    }

    @Nullable
    public final String getMediaId() {
        return this.mediaId;
    }

    public final void setMediaId(@Nullable String string2) {
        this.mediaId = string2;
    }

    @Nullable
    public final Drawable getBgDrawable() {
        return this.bgDrawable;
    }

    public final void setBgDrawable(@Nullable Drawable drawable2) {
        this.bgDrawable = drawable2;
    }

    protected void onMediaChanged() {
    }

    public final void setMedia(@Nullable Media media, @Nullable RenditionType renditionType, @Nullable Drawable placeholderDrawable) {
        this.setMedia(media);
        this.targetRendition = renditionType;
        this.placeholderDrawable = placeholderDrawable;
    }

    public static /* synthetic */ void setMedia$default(GifView gifView, Media media, RenditionType renditionType, Drawable drawable2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setMedia");
        }
        if ((n & 2) != 0) {
            renditionType = null;
        }
        if ((n & 4) != 0) {
            drawable2 = null;
        }
        gifView.setMedia(media, renditionType, drawable2);
    }

    public final void setMediaWithId(@NotNull String id2, @NotNull RenditionType renditionType, @Nullable Drawable placeholderDrawable, @Nullable Function2<? super MediaResponse, ? super Throwable, Unit> completionHandler) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)renditionType), (String)"renditionType");
        this.mediaId = id2;
        GiphyCore.INSTANCE.getApiClient().gifById(id2, (CompletionHandler<? super MediaResponse>)new CompletionHandler<MediaResponse>(completionHandler, this, renditionType, placeholderDrawable){
            final /* synthetic */ Function2<MediaResponse, Throwable, Unit> $completionHandler;
            final /* synthetic */ GifView this$0;
            final /* synthetic */ RenditionType $renditionType;
            final /* synthetic */ Drawable $placeholderDrawable;
            {
                this.$completionHandler = $completionHandler;
                this.this$0 = $receiver;
                this.$renditionType = $renditionType;
                this.$placeholderDrawable = $placeholderDrawable;
            }

            public void onComplete(@Nullable MediaResponse result, @Nullable Throwable e) {
                block3: {
                    MediaResponse mediaResponse = result;
                    if (mediaResponse != null) {
                        MediaResponse mediaResponse2 = mediaResponse;
                        GifView gifView = this.this$0;
                        RenditionType renditionType = this.$renditionType;
                        Drawable drawable2 = this.$placeholderDrawable;
                        MediaResponse it = mediaResponse2;
                        boolean bl = false;
                        Media media = it.getData();
                        if (Intrinsics.areEqual((Object)(media != null ? media.getId() : null), (Object)gifView.getMediaId())) {
                            gifView.setMedia(it.getData(), renditionType, drawable2);
                        }
                    }
                    Throwable throwable = e;
                    if (throwable != null) {
                        throwable.printStackTrace();
                    }
                    Function2<MediaResponse, Throwable, Unit> function2 = this.$completionHandler;
                    if (function2 == null) break block3;
                    function2.invoke((Object)result, (Object)e);
                }
            }
        });
    }

    public static /* synthetic */ void setMediaWithId$default(GifView gifView, String string2, RenditionType renditionType, Drawable drawable2, Function2 function2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setMediaWithId");
        }
        if ((n & 2) != 0) {
            renditionType = RenditionType.fixedWidth;
        }
        if ((n & 4) != 0) {
            drawable2 = null;
        }
        if ((n & 8) != 0) {
            function2 = null;
        }
        gifView.setMediaWithId(string2, renditionType, drawable2, (Function2<? super MediaResponse, ? super Throwable, Unit>)function2);
    }

    public final void loadAsset(@Nullable String url) {
        try {
            this.setMedia(null);
            Uri uri = Uri.parse((String)url);
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(url)");
            this.loadImageFromUri(uri);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void loadAsset(@DrawableRes int resId) {
        this.setMedia(null);
        this.loaded = false;
        ImageRequest request = ImageRequestBuilder.newBuilderWithResourceId((int)resId).build();
        this.setController((DraweeController)((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setOldController(this.getController())).setControllerListener((ControllerListener)this.getControllerListener())).setImageRequest((Object)request)).build());
    }

    /*
     * Unable to fully structure code
     */
    private final void loadMedia() {
        block5: {
            this.loaded = false;
            this.stepIndex = 0;
            v0 = this.placeholderDrawable;
            if (v0 != null) {
                it = v0;
                $i$a$-let-GifView$loadMedia$1 = false;
                ((GenericDraweeHierarchy)this.getHierarchy()).setPlaceholderImage(it);
            }
            if (this.showProgress) {
                ((GenericDraweeHierarchy)this.getHierarchy()).setProgressBarImage((Drawable)this.getProgressDrawable());
            }
            v1 = this.media;
            v2 = v1 != null ? v1.isSticker() : false;
            if (!v2) ** GOTO lbl-1000
            v3 = this.media;
            if (!(v3 != null ? Intrinsics.areEqual((Object)MediaExtensionKt.isEmoji(v3), (Object)true) : false) && this.isBackgroundVisible) {
                v4 = this.bgDrawable;
            } else lbl-1000:
            // 2 sources

            {
                v4 = null;
            }
            this.setBackground(v4);
            if (this.media != null) {
                this.loadCurrentStep();
            }
            v5 = this.scaleType;
            if (v5 == null) break block5;
            it = v5;
            $i$a$-let-GifView$loadMedia$2 = false;
            ((GenericDraweeHierarchy)this.getHierarchy()).setActualImageScaleType(this.scaleType);
        }
    }

    private final void tryLoadNextStep() {
        if (this.stepIndex >= this.getLoadingSteps().size()) {
            return;
        }
        LoadStep step = this.getLoadingSteps().get(this.stepIndex);
        switch (WhenMappings.$EnumSwitchMapping$0[step.getActionIfLoaded().ordinal()]) {
            case 1: {
                ++this.stepIndex;
                this.tryLoadCurrentStep();
                break;
            }
            case 2: {
                this.stepIndex += 2;
                this.tryLoadCurrentStep();
            }
        }
    }

    private final void tryLoadCurrentStep() {
        if (this.stepIndex < this.getLoadingSteps().size()) {
            this.loadCurrentStep();
        }
    }

    private final void loadCurrentStep() {
        Uri uri;
        Image imageData;
        List<LoadStep> loadingSteps = this.getLoadingSteps();
        LoadStep step = loadingSteps.get(this.stepIndex);
        Media media = this.media;
        Image image = imageData = media != null ? ImageDownloadChooserKt.imageWithRenditionType(media, step.getType()) : null;
        Uri uri2 = uri = image != null ? ImageDownloadChooserKt.uriWithFormatOrFallback(image, this.imageFormat) : null;
        if (uri != null) {
            if (loadingSteps.size() > 1) {
                this.setController((DraweeController)((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setOldController(this.getController())).setControllerListener((ControllerListener)this.getControllerListener())).setDataSourceSupplier((Supplier)this.retainingSupplier)).build());
                this.replaceImage(uri);
            } else {
                this.loadImageFromUri(uri);
            }
        } else {
            this.tryLoadNextStep();
        }
    }

    private final void replaceImage(Uri uri) {
        LoadStep loadStep = this.step;
        ImageRequest.CacheChoice cacheChoice = (loadStep != null ? loadStep.getActionIfLoaded() : null) == GifStepAction.TERMINATE ? ImageRequest.CacheChoice.DEFAULT : ImageRequest.CacheChoice.SMALL;
        ImageRequest request = Giphy.INSTANCE.getFrescoImageRequestHandler().getRequest(uri, (Map<String, String>)GiphyCore.INSTANCE.getAdditionalHeaders(), cacheChoice);
        BuildersKt.async$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, request, null){
            int label;
            final /* synthetic */ GifView this$0;
            final /* synthetic */ ImageRequest $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        GifView.access$getRetainingSupplier$p(this.this$0).replaceSupplier(Fresco.getImagePipeline().getDataSourceSupplier(this.$request, null, ImageRequest.RequestLevel.FULL_FETCH));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void loadNextStep() {
        block0: {
            ImageUriInfo imageToLoad;
            Image imageData;
            LoadStep loadStep = this.step = this.getLoadingSteps().get(this.stepIndex);
            Intrinsics.checkNotNull((Object)loadStep);
            Image image = imageData = GifUtils.INSTANCE.getImageDataForType(this.media, loadStep.getType());
            Intrinsics.checkNotNull((Object)image);
            ImageUriInfo imageUriInfo = imageToLoad = GifUtils.INSTANCE.getImageToLoad(image, this.imageFormat);
            if (imageUriInfo == null) break block0;
            ImageUriInfo it = imageUriInfo;
            boolean bl = false;
            this.replaceImage(it.getUri());
        }
    }

    private final void loadImageFromUri(Uri uri) {
        ImageRequest request = Giphy.INSTANCE.getFrescoImageRequestHandler().getRequest(uri, (Map<String, String>)GiphyCore.INSTANCE.getAdditionalHeaders(), ImageRequest.CacheChoice.DEFAULT);
        this.setController((DraweeController)((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setOldController(this.getController())).setControllerListener((ControllerListener)this.getControllerListener())).setImageRequest((Object)request)).build());
    }

    private final List<LoadStep> getLoadingSteps() {
        List list;
        if (this.targetRendition != null) {
            RenditionType renditionType = this.targetRendition;
            Intrinsics.checkNotNull((Object)((Object)renditionType));
            list = GifStepMapping.INSTANCE.getLoadingSteps(renditionType);
        } else {
            Media media = this.media;
            list = (media != null ? Intrinsics.areEqual((Object)MediaExtensionKt.isEmoji(media), (Object)true) : false) ? (List)GifStepMapping.INSTANCE.getEMOJI_STEPS() : (List)GifStepMapping.INSTANCE.getFIXED_WIDTH_STEPS();
        }
        return list;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        Timber.d((String)("onMeasure " + this.getSuggestedMinimumHeight() + ' ' + View.MeasureSpec.toString((int)widthMeasureSpec) + ' ' + View.MeasureSpec.toString((int)heightMeasureSpec) + ' ' + this.media), (Object[])new Object[0]);
        int desiredWidth = 0;
        desiredWidth = 300;
        int desiredHeight = 0;
        desiredHeight = 200;
        Parcelable imageData = null;
        if (this.media != null) {
            Parcelable parcelable;
            LoadStep step = (LoadStep)CollectionsKt.last(this.getLoadingSteps());
            Parcelable parcelable2 = this.media;
            if ((parcelable2 == null || (parcelable2 = ImageDownloadChooserKt.imageWithRenditionType((Media)parcelable2, step.getType())) == null) && ((parcelable = this.media) != null && (parcelable = parcelable.getImages()) != null ? parcelable.getOriginal() : (parcelable2 = null)) == null) {
                Parcelable parcelable3 = this.media;
                parcelable2 = parcelable3 != null && (parcelable3 = parcelable3.getImages()) != null ? parcelable3.getFixedWidth() : null;
            }
            Parcelable parcelable4 = imageData = parcelable2;
            if (parcelable4 != null) {
                Parcelable it = parcelable4;
                boolean bl = false;
                this.renditionAspectRatio = (float)imageData.getWidth() / (float)imageData.getHeight();
                desiredWidth = IntExtensionsKt.getPx(imageData.getWidth());
                desiredHeight = IntExtensionsKt.getPx(imageData.getHeight());
            }
        }
        this.renditionAspectRatio = (float)desiredWidth / (float)desiredHeight;
        if (this.renditionAspectRatio == 0.0f || Float.isNaN(this.renditionAspectRatio)) {
            this.renditionAspectRatio = this.defaultAspectRatio;
        }
        Timber.d((String)("rendition size [" + desiredWidth + " x " + desiredHeight + "] measured=[" + this.getMeasuredWidth() + " x " + this.getMeasuredHeight() + "] " + this.renditionAspectRatio), (Object[])new Object[0]);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = 0;
        int height = 0;
        switch (widthMode) {
            case 0x40000000: {
                n2 = widthSize;
                break;
            }
            case -2147483648: {
                n2 = RangesKt.coerceAtMost((int)desiredWidth, (int)widthSize);
                break;
            }
            default: {
                n2 = desiredWidth;
            }
        }
        width = n2;
        switch (heightMode) {
            case 0x40000000: {
                n = heightSize;
                break;
            }
            case -2147483648: {
                n = RangesKt.coerceAtMost((int)desiredHeight, (int)heightSize);
                break;
            }
            default: {
                n = desiredHeight;
            }
        }
        height = n;
        float actualRatio = (float)width / (float)height;
        Timber.d((String)("[1] aspectRatio=" + this.renditionAspectRatio + " actualRatio=" + actualRatio), (Object[])new Object[0]);
        if (!(actualRatio == this.renditionAspectRatio)) {
            switch (heightMode) {
                case -2147483648: {
                    height = RangesKt.coerceAtMost((int)((int)((float)width / this.renditionAspectRatio)), (int)height);
                    break;
                }
                case 0: {
                    Float f = this.fixedAspectRatio;
                    height = (int)((float)width / (f != null ? f.floatValue() : this.renditionAspectRatio));
                }
            }
            switch (widthMode) {
                case -2147483648: {
                    width = RangesKt.coerceAtMost((int)((int)((float)height * this.renditionAspectRatio)), (int)desiredWidth);
                    break;
                }
                case 0: {
                    Float f = this.fixedAspectRatio;
                    width = (int)((float)height * (f != null ? f.floatValue() : this.renditionAspectRatio));
                }
            }
        }
        actualRatio = (float)width / (float)height;
        Timber.d((String)("[2] aspectRatio=" + this.renditionAspectRatio + " actualRatio=" + actualRatio), (Object[])new Object[0]);
        this.setMeasuredDimension(width, height);
        this.addOutline();
    }

    private final void addOutline() {
        if (Build.VERSION.SDK_INT >= 21 && this.cornerRadius > 0.0f) {
            this.setOutlineProvider(new ViewOutlineProvider(this){
                final /* synthetic */ GifView this$0;
                {
                    this.this$0 = $receiver;
                }

                public void getOutline(@NotNull View view, @NotNull Outline outline) {
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    Intrinsics.checkNotNullParameter((Object)outline, (String)"outline");
                    outline.setRoundRect(0, 0, this.this$0.getWidth(), this.this$0.getHeight(), this.this$0.getCornerRadius());
                }
            });
            this.setClipToOutline(true);
        }
    }

    private final getControllerListener.1 getControllerListener() {
        return new BaseControllerListener<ImageInfo>(this){
            final /* synthetic */ GifView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onFinalImageSet(@Nullable String id2, @Nullable ImageInfo imageInfo, @Nullable Animatable anim) {
                this.this$0.onFinalImageSet(id2, imageInfo, anim);
            }

            public void onFailure(@Nullable String id2, @Nullable Throwable throwable) {
                block2: {
                    StringBuilder stringBuilder = new StringBuilder().append("Failed to load media: ");
                    String string2 = id2;
                    if (string2 == null) {
                        string2 = "";
                    }
                    Timber.e((String)stringBuilder.append(string2).toString(), (Object[])new Object[0]);
                    Throwable throwable2 = throwable;
                    if (throwable2 != null) {
                        throwable2.printStackTrace();
                    }
                    GifCallback gifCallback = this.this$0.getGifCallback();
                    if (gifCallback == null) break block2;
                    gifCallback.onFailure(throwable);
                }
            }
        };
    }

    public void onFinalImageSet(@Nullable String id2, @Nullable ImageInfo imageInfo, @Nullable Animatable anim) {
        if (!this.loaded) {
            this.loaded = true;
            GifCallback gifCallback = this.gifCallback;
            if (gifCallback != null) {
                GifCallback.DefaultImpls.onImageSet$default(gifCallback, imageInfo, anim, 0L, 0, 12, null);
            }
            Function0<Unit> function0 = this.onPingbackGifLoadSuccess;
            if (function0 != null) {
                function0.invoke();
            }
        }
        int loopCount = 0;
        long loopDuration = 0L;
        loopDuration = -1L;
        AnimatedDrawable2 animatedDrawable2 = anim instanceof AnimatedDrawable2 ? (AnimatedDrawable2)anim : null;
        if (animatedDrawable2 != null) {
            AnimatedDrawable2 it = animatedDrawable2;
            boolean bl = false;
            loopCount = it.getLoopCount();
            loopDuration = it.getLoopDurationMs();
        }
        if (this.autoPlay) {
            Animatable animatable = anim;
            if (animatable != null) {
                animatable.start();
            }
        }
        GifCallback gifCallback = this.gifCallback;
        if (gifCallback != null) {
            gifCallback.onImageSet(imageInfo, anim, loopDuration, loopCount);
        }
        this.tryLoadNextStep();
    }

    public final void play() {
        block0: {
            DraweeController draweeController;
            this.autoPlay = true;
            DraweeController draweeController2 = this.getController();
            boolean bl = draweeController2 != null && (draweeController2 = draweeController2.getAnimatable()) != null ? !draweeController2.isRunning() : false;
            if (!bl || (draweeController = this.getController()) == null || (draweeController = draweeController.getAnimatable()) == null) break block0;
            draweeController.start();
        }
    }

    public final void pause() {
        block0: {
            DraweeController draweeController;
            this.autoPlay = false;
            DraweeController draweeController2 = this.getController();
            boolean bl = draweeController2 != null && (draweeController2 = draweeController2.getAnimatable()) != null ? draweeController2.isRunning() : false;
            if (!bl || (draweeController = this.getController()) == null || (draweeController = draweeController.getAnimatable()) == null) break block0;
            draweeController.stop();
        }
    }

    private final ProgressBarDrawable getProgressDrawable() {
        ProgressBarDrawable progress = new ProgressBarDrawable();
        progress.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.gph_gif_details_progress_bar_bg));
        progress.setBounds(0, this.getHeight() - 6, this.getWidth(), this.getHeight());
        progress.setPadding(0);
        return progress;
    }

    public final void setLocked() {
        Drawable overlay = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.gph_ic_locked_red);
        ScaleTypeDrawable scaledOverlayDrawable = new ScaleTypeDrawable(overlay, ScalingUtils.ScaleType.CENTER_INSIDE);
        ((GenericDraweeHierarchy)this.getHierarchy()).setOverlayImage((Drawable)scaledOverlayDrawable);
        this.invalidate();
    }

    public final void removeLock() {
        ((GenericDraweeHierarchy)this.getHierarchy()).setOverlayImage(null);
        this.invalidate();
    }

    public final void recycle() {
        this.setMedia(null);
        this.placeholderDrawable = null;
        ((GenericDraweeHierarchy)this.getHierarchy()).setPlaceholderImage(null);
    }

    @JvmOverloads
    public GifView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public GifView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void _set_media_$lambda$0(GifView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.loadMedia();
    }

    public static final /* synthetic */ RetainingDataSourceSupplier access$getRetainingSupplier$p(GifView $this) {
        return $this.retainingSupplier;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/giphy/sdk/ui/views/GifView$Companion;", "", "()V", "CORNER_RADIUS", "", "getCORNER_RADIUS", "()F", "giphy-ui-2.3.17_release"})
    public static final class Companion {
        private Companion() {
        }

        public final float getCORNER_RADIUS() {
            return CORNER_RADIUS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&J0\u0010\u0006\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH&\u00a8\u0006\u000f"}, d2={"Lcom/giphy/sdk/ui/views/GifView$GifCallback;", "", "onFailure", "", "throwable", "", "onImageSet", "imageInfo", "Lcom/facebook/imagepipeline/image/ImageInfo;", "anim", "Landroid/graphics/drawable/Animatable;", "loopDuration", "", "loopCount", "", "giphy-ui-2.3.17_release"})
    public static interface GifCallback {
        public void onImageSet(@Nullable ImageInfo var1, @Nullable Animatable var2, long var3, int var5);

        public void onFailure(@Nullable Throwable var1);

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onImageSet$default(GifCallback gifCallback, ImageInfo imageInfo, Animatable animatable, long l, int n, int n2, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onImageSet");
                }
                if ((n2 & 4) != 0) {
                    l = -1L;
                }
                if ((n2 & 8) != 0) {
                    n = 0;
                }
                gifCallback.onImageSet(imageInfo, animatable, l, n);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GifStepAction.values().length];
            try {
                nArray[GifStepAction.NEXT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GifStepAction.SKIP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GifStepAction.TERMINATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

