/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.ui.views;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcelable;
import android.view.View;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.core.view.ViewCompat;
import com.giphy.sdk.core.models.Media;
import com.giphy.sdk.core.models.User;
import com.giphy.sdk.tracking.MediaExtensionKt;
import com.giphy.sdk.ui.R;
import com.giphy.sdk.ui.databinding.GphActionsViewBinding;
import com.giphy.sdk.ui.utils.GifUtils;
import com.giphy.sdk.ui.utils.IntExtensionsKt;
import com.giphy.sdk.ui.views.GPHActions;
import com.giphy.sdk.ui.views.GPHMediaActionsView;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020$H\u0002J\u0012\u0010&\u001a\u00020\u00192\b\u0010'\u001a\u0004\u0018\u00010\u0018H\u0002J\b\u0010(\u001a\u00020$H\u0002J\u000e\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+J\b\u0010,\u001a\u00020\u0019H\u0002J\b\u0010-\u001a\u00020$H\u0002R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR(\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R(\u0010\u0016\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u00190\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR(\u0010\u001e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u00190\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/giphy/sdk/ui/views/GPHMediaActionsView;", "Landroid/widget/PopupWindow;", "context", "Landroid/content/Context;", "actions", "", "Lcom/giphy/sdk/ui/views/GPHActions;", "(Landroid/content/Context;[Lcom/giphy/sdk/ui/views/GPHActions;)V", "getActions", "()[Lcom/giphy/sdk/ui/views/GPHActions;", "[Lcom/giphy/sdk/ui/views/GPHActions;", "contentViewBinding", "Lcom/giphy/sdk/ui/databinding/GphActionsViewBinding;", "getContext", "()Landroid/content/Context;", "value", "Lcom/giphy/sdk/core/models/Media;", "media", "getMedia", "()Lcom/giphy/sdk/core/models/Media;", "setMedia", "(Lcom/giphy/sdk/core/models/Media;)V", "onRemoveMedia", "Lkotlin/Function1;", "", "", "getOnRemoveMedia", "()Lkotlin/jvm/functions/Function1;", "setOnRemoveMedia", "(Lkotlin/jvm/functions/Function1;)V", "onShowMore", "getOnShowMore", "setOnShowMore", "shadowSize", "", "copyLink", "Landroid/view/View$OnClickListener;", "removeFromRecents", "saveToClipboard", "url", "showMoreAction", "showRemoveOption", "show", "", "updateWidth", "viewOnGiphyAction", "giphy-ui-2.3.17_release"})
@SourceDebugExtension(value={"SMAP\nGPHMediaActionsView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GPHMediaActionsView.kt\ncom/giphy/sdk/ui/views/GPHMediaActionsView\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,123:1\n13346#2,2:124\n*S KotlinDebug\n*F\n+ 1 GPHMediaActionsView.kt\ncom/giphy/sdk/ui/views/GPHMediaActionsView\n*L\n50#1:124,2\n*E\n"})
public final class GPHMediaActionsView
extends PopupWindow {
    @Nullable
    private final Context context;
    @NotNull
    private final GPHActions[] actions;
    @NotNull
    private Function1<? super String, Unit> onShowMore;
    @NotNull
    private Function1<? super String, Unit> onRemoveMedia;
    private final int shadowSize;
    @NotNull
    private final GphActionsViewBinding contentViewBinding;
    @Nullable
    private Media media;

    public GPHMediaActionsView(@Nullable Context context, @NotNull GPHActions[] actions) {
        GphActionsViewBinding gphActionsViewBinding;
        Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
        this.context = context;
        this.actions = actions;
        this.onShowMore = onShowMore.1.INSTANCE;
        this.onRemoveMedia = onRemoveMedia.1.INSTANCE;
        this.shadowSize = IntExtensionsKt.getPx(2);
        this.setContentView(View.inflate((Context)this.context, (int)R.layout.gph_actions_view, null));
        GphActionsViewBinding gphActionsViewBinding2 = GphActionsViewBinding.bind(this.getContentView());
        Intrinsics.checkNotNullExpressionValue((Object)gphActionsViewBinding2, (String)"bind(contentView)");
        this.contentViewBinding = gphActionsViewBinding2;
        this.setWidth(-2);
        this.setHeight(-2);
        if (Build.VERSION.SDK_INT >= 21) {
            this.setElevation(this.shadowSize);
        } else {
            ViewCompat.setElevation((View)this.getContentView(), (float)this.shadowSize);
        }
        if (Build.VERSION.SDK_INT >= 23) {
            this.setOverlapAnchor(true);
        }
        GphActionsViewBinding $this$_init__u24lambda_u241 = gphActionsViewBinding = this.contentViewBinding;
        boolean bl = false;
        $this$_init__u24lambda_u241.gphActionMore.setOnClickListener(this.showMoreAction());
        $this$_init__u24lambda_u241.gphCopyLink.setOnClickListener(this.copyLink());
        $this$_init__u24lambda_u241.gphActionViewGiphy.setOnClickListener(this.viewOnGiphyAction());
        $this$_init__u24lambda_u241.gphActionRemove.setOnClickListener(this.removeFromRecents());
        GPHActions[] $this$forEach$iv = this.actions;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            GPHActions element$iv;
            GPHActions it = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                case 1: {
                    $this$_init__u24lambda_u241.gphActionMore.setVisibility(0);
                    break;
                }
                case 2: {
                    $this$_init__u24lambda_u241.gphCopyLink.setVisibility(0);
                    break;
                }
                case 3: {
                    $this$_init__u24lambda_u241.gphActionViewGiphy.setVisibility(0);
                }
            }
        }
        this.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.setOutsideTouchable(true);
    }

    @Nullable
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final GPHActions[] getActions() {
        return this.actions;
    }

    @NotNull
    public final Function1<String, Unit> getOnShowMore() {
        return this.onShowMore;
    }

    public final void setOnShowMore(@NotNull Function1<? super String, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onShowMore = function1;
    }

    @NotNull
    public final Function1<String, Unit> getOnRemoveMedia() {
        return this.onRemoveMedia;
    }

    public final void setOnRemoveMedia(@NotNull Function1<? super String, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onRemoveMedia = function1;
    }

    @Nullable
    public final Media getMedia() {
        return this.media;
    }

    public final void setMedia(@Nullable Media value) {
        block3: {
            this.media = value;
            this.contentViewBinding.gphActionMore.setVisibility(8);
            Media media = value;
            boolean bl = media != null ? !media.isAnonymous() : false;
            if (!bl || !ArraysKt.contains((Object[])this.actions, (Object)((Object)GPHActions.SearchMore)) || Intrinsics.areEqual((Object)MediaExtensionKt.isText(value), (Object)true)) break block3;
            Object object = value.getUser();
            if (object != null && (object = ((User)object).getUsername()) != null) {
                String string2;
                String string3;
                Object it = object;
                boolean bl2 = false;
                TextView textView = this.contentViewBinding.gphActionMore;
                Object object2 = this.context;
                if (object2 != null && (object2 = (string3 = object2.getString(R.string.gph_more_by))) != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getString(R.string.gph_more_by)");
                    String string4 = string3;
                    Object[] objectArray = new Object[]{it};
                    String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                    string2 = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
                } else {
                    string2 = null;
                }
                textView.setText((CharSequence)string2);
                this.contentViewBinding.gphActionMore.setVisibility(0);
                this.updateWidth();
            }
        }
    }

    private final View.OnClickListener copyLink() {
        return arg_0 -> GPHMediaActionsView.copyLink$lambda$3(this, arg_0);
    }

    public final void showRemoveOption(boolean show) {
        this.contentViewBinding.gphActionRemove.setVisibility(show ? 0 : 8);
        this.updateWidth();
    }

    private final void updateWidth() {
        this.getContentView().measure(-2, -2);
        this.setWidth(this.getContentView().getMeasuredWidth());
    }

    private final void saveToClipboard(String url) {
        Context context = this.context;
        Object object = context != null ? context.getSystemService("clipboard") : null;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.content.ClipboardManager");
        ClipboardManager clipboardManager = (ClipboardManager)object;
        ClipData clip = ClipData.newPlainText((CharSequence)"Giphy", (CharSequence)url);
        clipboardManager.setPrimaryClip(clip);
    }

    private final View.OnClickListener showMoreAction() {
        return arg_0 -> GPHMediaActionsView.showMoreAction$lambda$4(this, arg_0);
    }

    private final View.OnClickListener viewOnGiphyAction() {
        return arg_0 -> GPHMediaActionsView.viewOnGiphyAction$lambda$5(this, arg_0);
    }

    private final View.OnClickListener removeFromRecents() {
        return arg_0 -> GPHMediaActionsView.removeFromRecents$lambda$6(this, arg_0);
    }

    private static final void copyLink$lambda$3(GPHMediaActionsView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Parcelable parcelable = this$0.media;
        this$0.saveToClipboard(parcelable != null && (parcelable = parcelable.getImages()) != null && (parcelable = parcelable.getOriginal()) != null ? parcelable.getGifUrl() : null);
        this$0.dismiss();
    }

    private static final void showMoreAction$lambda$4(GPHMediaActionsView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Parcelable parcelable = this$0.media;
        this$0.onShowMore.invoke(parcelable != null && (parcelable = parcelable.getUser()) != null ? parcelable.getUsername() : null);
        this$0.dismiss();
    }

    private static final void viewOnGiphyAction$lambda$5(GPHMediaActionsView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Context context = this$0.context;
        if (context != null) {
            context.startActivity(GifUtils.INSTANCE.getViewGifIntent(this$0.media));
        }
        this$0.dismiss();
    }

    private static final void removeFromRecents$lambda$6(GPHMediaActionsView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Media media = this$0.media;
        this$0.onRemoveMedia.invoke((Object)(media != null ? media.getId() : null));
        this$0.dismiss();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GPHActions.values().length];
            try {
                nArray[GPHActions.SearchMore.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GPHActions.CopyLink.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GPHActions.OpenGiphy.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

