/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.ui.views;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.provider.Settings;
import android.view.SurfaceView;
import com.giphy.sdk.core.models.Images;
import com.giphy.sdk.core.models.Media;
import com.giphy.sdk.ui.utils.MediaExtensionKt;
import com.giphy.sdk.ui.utils.VideoCache;
import com.giphy.sdk.ui.views.GPHVideoPlayer;
import com.giphy.sdk.ui.views.GPHVideoPlayerState;
import com.giphy.sdk.ui.views.GPHVideoPlayerView;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.PlaybackException;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.source.DefaultMediaSourceFactory;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.TextOutput;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.upstream.DataSource;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002B%\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u001e\u0010A\u001a\u00020$2\u0016\u0010B\u001a\u0012\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"j\u0002`%J\u0006\u0010C\u001a\u00020DJ\u0006\u0010E\u001a\u00020\u0006J5\u0010F\u001a\u00020$2\u0006\u0010&\u001a\u00020\u001e2\b\b\u0002\u0010G\u001a\u00020\u00062\n\b\u0002\u0010H\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010IJ\u0016\u0010J\u001a\u00020$2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020M0LH\u0016J\u0006\u0010N\u001a\u00020$J\u0010\u0010O\u001a\u00020$2\u0006\u0010P\u001a\u00020\u0006H\u0016J\u0010\u0010Q\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J\u001a\u0010R\u001a\u00020$2\b\u0010S\u001a\u0004\u0018\u00010T2\u0006\u0010U\u001a\u00020VH\u0016J\u0006\u0010W\u001a\u00020$J\u0010\u0010X\u001a\u00020$2\u0006\u0010Y\u001a\u00020VH\u0016J\u0010\u0010Z\u001a\u00020$2\u0006\u0010[\u001a\u00020\\H\u0016J\u0006\u0010]\u001a\u00020$J\b\u0010^\u001a\u00020$H\u0002J\u0018\u0010_\u001a\u00020$2\u0006\u0010`\u001a\u00020a2\u0006\u0010U\u001a\u00020VH\u0016J\u0006\u0010b\u001a\u00020$J\b\u0010c\u001a\u00020$H\u0002J\u001e\u0010d\u001a\u00020$2\u0016\u0010B\u001a\u0012\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"j\u0002`%J\u000e\u0010e\u001a\u00020$2\u0006\u0010f\u001a\u00020\u0012J\u0010\u0010g\u001a\u00020$2\b\u0010h\u001a\u0004\u0018\u00010iJ\u000e\u0010j\u001a\u00020$2\u0006\u0010k\u001a\u00020DJ\b\u0010l\u001a\u00020$H\u0002J\b\u0010m\u001a\u00020$H\u0002J\b\u0010n\u001a\u00020$H\u0002J\b\u0010o\u001a\u00020$H\u0002J\u0010\u0010p\u001a\u00020$2\u0006\u0010f\u001a\u00020\u0012H\u0002J\b\u0010q\u001a\u00020$H\u0002R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u001a\u0010\u0017\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010 \u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"j\u0002`%0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0018\"\u0004\b-\u0010\u001aR\u001c\u0010.\u001a\u0004\u0018\u00010/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u0010\u00108\u001a\u0004\u0018\u000109X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010:\u001a\u0004\u0018\u00010;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u0018\"\u0004\b=\u0010\u001aR$\u0010\u0007\u001a\u00020\u00062\u0006\u0010>\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\u0018\"\u0004\b@\u0010\u001a\u00a8\u0006r"}, d2={"Lcom/giphy/sdk/ui/views/GPHVideoPlayer;", "Lcom/google/android/exoplayer2/Player$Listener;", "Lcom/google/android/exoplayer2/text/TextOutput;", "playerView", "Lcom/giphy/sdk/ui/views/GPHVideoPlayerView;", "repeatable", "", "showCaptions", "(Lcom/giphy/sdk/ui/views/GPHVideoPlayerView;ZZ)V", "audioManager", "Landroid/media/AudioManager;", "getAudioManager", "()Landroid/media/AudioManager;", "setAudioManager", "(Landroid/media/AudioManager;)V", "contentObserver", "Landroid/database/ContentObserver;", "currentPosition", "", "getCurrentPosition", "()J", "duration", "getDuration", "isDestroyed", "()Z", "setDestroyed", "(Z)V", "isDeviceMuted", "isPlaying", "lastMedia", "Lcom/giphy/sdk/core/models/Media;", "lastProgress", "listeners", "", "Lkotlin/Function1;", "Lcom/giphy/sdk/ui/views/GPHVideoPlayerState;", "", "Lcom/giphy/sdk/ui/views/GPHPlayerStateListener;", "media", "getMedia", "()Lcom/giphy/sdk/core/models/Media;", "setMedia", "(Lcom/giphy/sdk/core/models/Media;)V", "paused", "getPaused", "setPaused", "player", "Lcom/google/android/exoplayer2/ExoPlayer;", "getPlayer", "()Lcom/google/android/exoplayer2/ExoPlayer;", "setPlayer", "(Lcom/google/android/exoplayer2/ExoPlayer;)V", "getPlayerView", "()Lcom/giphy/sdk/ui/views/GPHVideoPlayerView;", "setPlayerView", "(Lcom/giphy/sdk/ui/views/GPHVideoPlayerView;)V", "progressTimer", "Ljava/util/Timer;", "progressTimerTask", "Ljava/util/TimerTask;", "getRepeatable", "setRepeatable", "value", "getShowCaptions", "setShowCaptions", "addListener", "listener", "getVolume", "", "isActive", "loadMedia", "autoPlay", "view", "(Lcom/giphy/sdk/core/models/Media;ZLcom/giphy/sdk/ui/views/GPHVideoPlayerView;Ljava/lang/Boolean;)V", "onCues", "cues", "", "Lcom/google/android/exoplayer2/text/Cue;", "onDestroy", "onIsLoadingChanged", "isLoading", "onIsPlayingChanged", "onMediaItemTransition", "mediaItem", "Lcom/google/android/exoplayer2/MediaItem;", "reason", "", "onPause", "onPlaybackStateChanged", "state", "onPlayerError", "error", "Lcom/google/android/exoplayer2/PlaybackException;", "onResume", "onStopPlaying", "onTimelineChanged", "timeline", "Lcom/google/android/exoplayer2/Timeline;", "play", "releasePlayer", "removeListener", "seekTo", "position", "setVideoSurfaceView", "surfaceView", "Landroid/view/SurfaceView;", "setVolume", "audioVolume", "startListeningToDeviceVolume", "startProgressTimer", "stopListeningToDeviceVolume", "stopProgressTimer", "updateProgress", "updateRepeatMode", "giphy-ui-2.1.16_release"})
public final class GPHVideoPlayer
implements Player.Listener,
TextOutput {
    @Nullable
    private GPHVideoPlayerView playerView;
    private boolean repeatable;
    private boolean showCaptions;
    @Nullable
    private ExoPlayer player;
    private final Set<Function1<GPHVideoPlayerState, Unit>> listeners;
    private Timer progressTimer;
    private TimerTask progressTimerTask;
    private ContentObserver contentObserver;
    @NotNull
    private Media media;
    private boolean isDestroyed;
    @Nullable
    private AudioManager audioManager;
    private boolean isDeviceMuted;
    private long lastProgress;
    private Media lastMedia;
    private boolean paused;

    @Nullable
    public final GPHVideoPlayerView getPlayerView() {
        return this.playerView;
    }

    public final void setPlayerView(@Nullable GPHVideoPlayerView gPHVideoPlayerView) {
        this.playerView = gPHVideoPlayerView;
    }

    public final boolean getRepeatable() {
        return this.repeatable;
    }

    public final void setRepeatable(boolean bl) {
        this.repeatable = bl;
    }

    public final boolean getShowCaptions() {
        return this.showCaptions;
    }

    public final void setShowCaptions(boolean value) {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)new GPHVideoPlayerState.CaptionsVisibilityChanged(value));
        }
        this.showCaptions = value;
    }

    @Nullable
    public final ExoPlayer getPlayer() {
        return this.player;
    }

    public final void setPlayer(@Nullable ExoPlayer exoPlayer) {
        this.player = exoPlayer;
    }

    @NotNull
    public final Media getMedia() {
        return this.media;
    }

    public final void setMedia(@NotNull Media media2) {
        Intrinsics.checkNotNullParameter((Object)media2, (String)"<set-?>");
        this.media = media2;
    }

    public final boolean isDestroyed() {
        return this.isDestroyed;
    }

    public final void setDestroyed(boolean bl) {
        this.isDestroyed = bl;
    }

    @Nullable
    public final AudioManager getAudioManager() {
        return this.audioManager;
    }

    public final void setAudioManager(@Nullable AudioManager audioManager) {
        this.audioManager = audioManager;
    }

    public final long getDuration() {
        ExoPlayer exoPlayer = this.player;
        return exoPlayer != null ? exoPlayer.getDuration() : 0L;
    }

    public final long getCurrentPosition() {
        ExoPlayer exoPlayer = this.player;
        return exoPlayer != null ? exoPlayer.getCurrentPosition() : 0L;
    }

    public final boolean isPlaying() {
        ExoPlayer exoPlayer = this.player;
        return exoPlayer != null ? exoPlayer.isPlaying() : false;
    }

    private final void startListeningToDeviceVolume() {
        if (this.playerView == null) {
            return;
        }
        Function0<Unit> $fun$setVolumeValue$1 = new Function0<Unit>(this){
            final /* synthetic */ GPHVideoPlayer this$0;

            public final void invoke() {
                AudioManager audioManager = this.this$0.getAudioManager();
                Intrinsics.checkNotNull((Object)audioManager);
                int currentVolume = audioManager.getStreamVolume(3);
                float playerVolumeValue = currentVolume > 0 ? 1.0f : 0.0f;
                GPHVideoPlayer.access$setDeviceMuted$p(this.this$0, playerVolumeValue == 0.0f);
                this.this$0.setVolume(playerVolumeValue);
            }
            {
                this.this$0 = gPHVideoPlayer;
                super(0);
            }
        };
        GPHVideoPlayerView gPHVideoPlayerView = this.playerView;
        Intrinsics.checkNotNull((Object)((Object)gPHVideoPlayerView));
        Object object = gPHVideoPlayerView.getContext().getSystemService("audio");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.media.AudioManager");
        }
        this.audioManager = (AudioManager)object;
        $fun$setVolumeValue$1.invoke();
        this.contentObserver = new ContentObserver($fun$setVolumeValue$1, new Handler(Looper.getMainLooper())){
            final /* synthetic */ startListeningToDeviceVolume.1 $setVolumeValue$1;

            public void onChange(boolean selfChange) {
                super.onChange(selfChange);
                this.$setVolumeValue$1.invoke();
            }
            {
                this.$setVolumeValue$1 = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
        GPHVideoPlayerView gPHVideoPlayerView2 = this.playerView;
        Intrinsics.checkNotNull((Object)((Object)gPHVideoPlayerView2));
        Context context = gPHVideoPlayerView2.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"playerView!!.context");
        ContentResolver contentResolver = context.getContentResolver();
        ContentObserver contentObserver = this.contentObserver;
        Intrinsics.checkNotNull((Object)contentObserver);
        contentResolver.registerContentObserver(Settings.System.CONTENT_URI, true, contentObserver);
    }

    private final void stopListeningToDeviceVolume() {
        if (this.playerView == null || this.contentObserver == null) {
            return;
        }
        GPHVideoPlayerView gPHVideoPlayerView = this.playerView;
        Intrinsics.checkNotNull((Object)((Object)gPHVideoPlayerView));
        Context context = gPHVideoPlayerView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"playerView!!.context");
        ContentResolver contentResolver = context.getContentResolver();
        ContentObserver contentObserver = this.contentObserver;
        Intrinsics.checkNotNull((Object)contentObserver);
        contentResolver.unregisterContentObserver(contentObserver);
        this.contentObserver = null;
    }

    private final void startProgressTimer() {
        block2: {
            TimerTask timerTask = this.progressTimerTask;
            if (timerTask != null) {
                timerTask.cancel();
            }
            Timer timer = this.progressTimer;
            if (timer != null) {
                timer.cancel();
            }
            this.progressTimerTask = new TimerTask(this){
                final /* synthetic */ GPHVideoPlayer this$0;

                public void run() {
                    new Handler(Looper.getMainLooper()).post(new Runnable(this){
                        final /* synthetic */ startProgressTimer.1 this$0;

                        public final void run() {
                            ExoPlayer exoPlayer = this.this$0.this$0.getPlayer();
                            if (exoPlayer != null) {
                                if (!exoPlayer.isPlaying()) {
                                    return;
                                }
                            }
                            ExoPlayer exoPlayer2 = this.this$0.this$0.getPlayer();
                            if (exoPlayer2 == null) {
                                return;
                            }
                            long playerPosition = exoPlayer2.getCurrentPosition();
                            GPHVideoPlayer.access$updateProgress(this.this$0.this$0, playerPosition);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = this$0;
                }
            };
            Timer timer2 = this.progressTimer = new Timer("VideoProgressTimer");
            if (timer2 == null) break block2;
            timer2.schedule(this.progressTimerTask, 0L, 40L);
        }
    }

    private final void stopProgressTimer() {
        block0: {
            Timer timer = this.progressTimer;
            if (timer == null) break block0;
            timer.cancel();
        }
    }

    public final float getVolume() {
        ExoPlayer exoPlayer = this.player;
        return exoPlayer != null && (exoPlayer = exoPlayer.getAudioComponent()) != null ? exoPlayer.getVolume() : 0.0f;
    }

    public final void setVolume(float audioVolume) {
        float volume = this.isDeviceMuted ? 0.0f : audioVolume;
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null && (exoPlayer = exoPlayer.getAudioComponent()) != null) {
            exoPlayer.setVolume(volume);
        }
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)new GPHVideoPlayerState.MuteChanged(volume > 0.0f));
        }
    }

    public final void setVideoSurfaceView(@Nullable SurfaceView surfaceView) {
        block0: {
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer == null) break block0;
            exoPlayer.setVideoSurfaceView(surfaceView);
        }
    }

    public final void addListener(@NotNull Function1<? super GPHVideoPlayerState, Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    public final void removeListener(@NotNull Function1<? super GPHVideoPlayerState, Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    public final void seekTo(long position) {
        block0: {
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer == null) break block0;
            exoPlayer.seekTo(position);
        }
    }

    public final void play() {
        block0: {
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer == null) break block0;
            exoPlayer.play();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void loadMedia(@NotNull Media media2, boolean autoPlay, @Nullable GPHVideoPlayerView view, @Nullable Boolean repeatable) throws Exception {
        void $this$apply;
        boolean bl;
        Object element$iv2;
        Intrinsics.checkNotNullParameter((Object)media2, (String)"media");
        Boolean bl2 = repeatable;
        if (bl2 != null) {
            Boolean bl3 = bl2;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean it = bl3;
            boolean bl6 = false;
            this.repeatable = it;
        }
        if (this.isDestroyed) {
            Timber.e((String)"Player is already destroyed!", (Object[])new Object[0]);
            return;
        }
        Timber.d((String)("loadMedia " + media2.getId() + ' ' + autoPlay + ' ' + (Object)((Object)view)), (Object[])new Object[0]);
        long t0 = SystemClock.elapsedRealtime();
        if (view != null) {
            if (Intrinsics.areEqual((Object)((Object)view), (Object)((Object)this.playerView)) ^ true) {
                GPHVideoPlayerView gPHVideoPlayerView = this.playerView;
                if (gPHVideoPlayerView != null) {
                    gPHVideoPlayerView.onPause();
                }
            }
            this.playerView = view;
        }
        this.media = media2;
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Function1 it = (Function1)element$iv2;
            bl = false;
            it.invoke((Object)new GPHVideoPlayerState.MediaChanged(media2));
        }
        this.releasePlayer();
        if (this.playerView == null) {
            throw (Throwable)new Exception("playerView must not be null");
        }
        this.paused = false;
        GPHVideoPlayerView gPHVideoPlayerView = this.playerView;
        if (gPHVideoPlayerView != null) {
            gPHVideoPlayerView.setVisibility(0);
        }
        String videoUrl = MediaExtensionKt.getVideoUrl(media2);
        Timber.d((String)("load url " + videoUrl), (Object[])new Object[0]);
        DefaultLoadControl defaultLoadControl = new DefaultLoadControl.Builder().setPrioritizeTimeOverSizeThresholds(true).setBufferDurationsMs(500, 5000, 500, 500).build();
        Intrinsics.checkNotNullExpressionValue((Object)defaultLoadControl, (String)"DefaultLoadControl.Build\u2026500\n            ).build()");
        DefaultLoadControl loadControl = defaultLoadControl;
        this.lastMedia = media2;
        this.lastProgress = 0L;
        GPHVideoPlayerView gPHVideoPlayerView2 = this.playerView;
        Intrinsics.checkNotNull((Object)((Object)gPHVideoPlayerView2));
        DefaultTrackSelector trackSelector = new DefaultTrackSelector(gPHVideoPlayerView2.getContext());
        trackSelector.setParameters(trackSelector.buildUponParameters().setPreferredTextLanguage("en"));
        GPHVideoPlayerView gPHVideoPlayerView3 = this.playerView;
        Intrinsics.checkNotNull((Object)((Object)gPHVideoPlayerView3));
        element$iv2 = new ExoPlayer.Builder(gPHVideoPlayerView3.getContext()).setTrackSelector((TrackSelector)trackSelector).setLoadControl((LoadControl)loadControl).build();
        boolean it = false;
        bl = false;
        Object object = element$iv2;
        GPHVideoPlayer gPHVideoPlayer = this;
        boolean bl7 = false;
        $this$apply.addListener((Player.Listener)this);
        $this$apply.setPlayWhenReady(autoPlay);
        Unit unit = Unit.INSTANCE;
        gPHVideoPlayer.player = element$iv2;
        GPHVideoPlayerView gPHVideoPlayerView4 = this.playerView;
        Intrinsics.checkNotNull((Object)((Object)gPHVideoPlayerView4));
        gPHVideoPlayerView4.preloadFirstFrame(media2);
        GPHVideoPlayerView gPHVideoPlayerView5 = this.playerView;
        Intrinsics.checkNotNull((Object)((Object)gPHVideoPlayerView5));
        gPHVideoPlayerView5.prepare(media2, this);
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null) {
            exoPlayer.setVideoScalingMode(1);
        }
        if (videoUrl != null) {
            this.updateRepeatMode();
            this.startProgressTimer();
            DefaultExtractorsFactory defaultExtractorsFactory = new DefaultExtractorsFactory().setConstantBitrateSeekingEnabled(true);
            Intrinsics.checkNotNullExpressionValue((Object)defaultExtractorsFactory, (String)"DefaultExtractorsFactory\u2026trateSeekingEnabled(true)");
            DefaultExtractorsFactory extractoryFactory = defaultExtractorsFactory;
            Uri uri = Uri.parse((String)videoUrl);
            MediaItem.Builder builder = new MediaItem.Builder().setUri(uri).setCustomCacheKey(uri.buildUpon().clearQuery().build().toString());
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"MediaItem.Builder()\n    \u2026ery().build().toString())");
            MediaItem.Builder mediaItemBuilder = builder;
            MediaItem mediaItem = mediaItemBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)mediaItem, (String)"mediaItemBuilder\n                .build()");
            MediaItem mediaItem2 = mediaItem;
            MediaSource mediaSource = new DefaultMediaSourceFactory((DataSource.Factory)VideoCache.INSTANCE.getCacheDataSourceFactory(), (ExtractorsFactory)extractoryFactory).createMediaSource(mediaItem2);
            Intrinsics.checkNotNullExpressionValue((Object)mediaSource, (String)"DefaultMediaSourceFactor\u2026ateMediaSource(mediaItem)");
            MediaSource mediaSource2 = mediaSource;
            ExoPlayer exoPlayer2 = this.player;
            if (exoPlayer2 != null) {
                exoPlayer2.setMediaSource(mediaSource2);
            }
            ExoPlayer exoPlayer3 = this.player;
            if (exoPlayer3 != null) {
                exoPlayer3.prepare();
            }
            this.stopListeningToDeviceVolume();
            this.startListeningToDeviceVolume();
        } else {
            ExoPlaybackException exoPlaybackException = ExoPlaybackException.createForSource((IOException)new IOException("Video url is null"), (int)-1);
            Intrinsics.checkNotNullExpressionValue((Object)exoPlaybackException, (String)"ExoPlaybackException.cre\u2026\"Video url is null\"), -1)");
            this.onPlayerError((PlaybackException)exoPlaybackException);
        }
        Timber.d((String)("loadMedia time=" + (SystemClock.elapsedRealtime() - t0)), (Object[])new Object[0]);
    }

    public static /* synthetic */ void loadMedia$default(GPHVideoPlayer gPHVideoPlayer, Media media2, boolean bl, GPHVideoPlayerView gPHVideoPlayerView, Boolean bl2, int n, Object object) throws Exception {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            gPHVideoPlayerView = null;
        }
        if ((n & 8) != 0) {
            bl2 = null;
        }
        gPHVideoPlayer.loadMedia(media2, bl, gPHVideoPlayerView, bl2);
    }

    private final void releasePlayer() {
        this.stopProgressTimer();
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null) {
            exoPlayer.release();
        }
        this.player = null;
    }

    private final void updateProgress(long position) {
        block0: {
            GPHVideoPlayerView gPHVideoPlayerView = this.playerView;
            if (gPHVideoPlayerView == null) break block0;
            gPHVideoPlayerView.onProgress(position);
        }
    }

    public void onMediaItemTransition(@Nullable MediaItem mediaItem, int reason) {
        super.onMediaItemTransition(mediaItem, reason);
        if (reason == 0) {
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                it.invoke((Object)GPHVideoPlayerState.Repeated.INSTANCE);
            }
        }
    }

    public void onPlaybackStateChanged(int state) {
        super.onPlaybackStateChanged(state);
        String stateStr = null;
        GPHVideoPlayerState videoPlaybackState = null;
        switch (state) {
            case 3: {
                stateStr = "STATE_READY";
                videoPlaybackState = GPHVideoPlayerState.Ready.INSTANCE;
                break;
            }
            case 2: {
                stateStr = "STATE_BUFFERING";
                videoPlaybackState = GPHVideoPlayerState.Buffering.INSTANCE;
                break;
            }
            case 4: {
                stateStr = "STATE_ENDED";
                videoPlaybackState = GPHVideoPlayerState.Ended.INSTANCE;
                break;
            }
            case 1: {
                stateStr = "STATE_IDLE";
                videoPlaybackState = GPHVideoPlayerState.Idle.INSTANCE;
                break;
            }
            default: {
                stateStr = "STATE_UNKNOWN";
                videoPlaybackState = GPHVideoPlayerState.Unknown.INSTANCE;
            }
        }
        Timber.d((String)("onPlayerStateChanged " + stateStr), (Object[])new Object[0]);
        if (state == 4) {
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer != null) {
                long l = exoPlayer.getDuration();
                boolean bl = false;
                boolean bl2 = false;
                long it = l;
                boolean bl3 = false;
                this.updateProgress(it);
            }
        }
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)videoPlaybackState);
        }
    }

    public void onIsLoadingChanged(boolean isLoading) {
        super.onIsLoadingChanged(isLoading);
        Timber.d((String)("onLoadingChanged " + isLoading), (Object[])new Object[0]);
        if (isLoading && this.lastProgress > 0L) {
            Timber.d((String)("restore seek " + this.lastProgress), (Object[])new Object[0]);
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer != null) {
                exoPlayer.seekTo(this.lastProgress);
            }
            this.lastProgress = 0L;
        }
    }

    public void onIsPlayingChanged(boolean isPlaying) {
        block4: {
            block3: {
                Timber.d((String)("onIsPlayingChanged " + this.media.getId() + ' ' + isPlaying), (Object[])new Object[0]);
                if (!isPlaying) break block3;
                Iterable $this$forEach$iv = this.listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Function1 it = (Function1)element$iv;
                    boolean bl = false;
                    it.invoke((Object)GPHVideoPlayerState.Playing.INSTANCE);
                }
                GPHVideoPlayerView gPHVideoPlayerView = this.playerView;
                if (gPHVideoPlayerView == null) break block4;
                gPHVideoPlayerView.setKeepScreenOn(true);
                break block4;
            }
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer != null) {
                int n = exoPlayer.getPlaybackState();
                boolean bl = false;
                boolean bl2 = false;
                int it = n;
                boolean bl3 = false;
                if (it != 4) {
                    this.onPlaybackStateChanged(it);
                }
            }
            GPHVideoPlayerView gPHVideoPlayerView = this.playerView;
            if (gPHVideoPlayerView == null) break block4;
            gPHVideoPlayerView.setKeepScreenOn(false);
        }
    }

    public void onTimelineChanged(@NotNull Timeline timeline, int reason) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)timeline, (String)"timeline");
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer == null) break block4;
            long l = exoPlayer.getDuration();
            boolean bl = false;
            boolean bl2 = false;
            long duration = l;
            boolean bl3 = false;
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl4 = false;
                it.invoke((Object)new GPHVideoPlayerState.TimelineChanged(duration));
            }
            if (duration > 0L) {
                if (this.media.getUserDictionary() == null) {
                    this.media.setUserDictionary(new HashMap<String, String>());
                }
                HashMap<String, String> hashMap = this.media.getUserDictionary();
                if (hashMap != null) {
                    hashMap.put("video_length", String.valueOf(duration));
                }
            }
        }
    }

    private final void onStopPlaying() {
        this.releasePlayer();
        this.playerView = null;
    }

    public void onPlayerError(@NotNull PlaybackException error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        super.onPlayerError(error);
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            String string2 = error.getLocalizedMessage();
            if (string2 == null) {
                string2 = "Error occurred";
            }
            it.invoke((Object)new GPHVideoPlayerState.Error(string2));
        }
    }

    public final boolean getPaused() {
        return this.paused;
    }

    public final void setPaused(boolean bl) {
        this.paused = bl;
    }

    public final void onPause() {
        this.paused = true;
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null) {
            exoPlayer.pause();
        }
        GPHVideoPlayerView gPHVideoPlayerView = this.playerView;
        if (gPHVideoPlayerView != null) {
            gPHVideoPlayerView.onPause();
        }
        CharSequence charSequence = this.media.getId();
        boolean bl = false;
        if (charSequence.length() > 0) {
            this.lastMedia = this.media;
        }
        ExoPlayer exoPlayer2 = this.player;
        this.lastProgress = exoPlayer2 != null ? exoPlayer2.getCurrentPosition() : 0L;
        this.releasePlayer();
    }

    public final void onResume() {
        block1: {
            this.paused = false;
            GPHVideoPlayerView gPHVideoPlayerView = this.playerView;
            if (gPHVideoPlayerView != null) {
                gPHVideoPlayerView.onResume();
            }
            Media media2 = this.lastMedia;
            if (media2 == null) break block1;
            Media media3 = media2;
            boolean bl = false;
            boolean bl2 = false;
            Media it = media3;
            boolean bl3 = false;
            GPHVideoPlayer.loadMedia$default(this, it, false, null, null, 14, null);
        }
    }

    public final void onDestroy() {
        this.isDestroyed = true;
        this.stopListeningToDeviceVolume();
        this.onStopPlaying();
    }

    public final boolean isActive() {
        return this.playerView != null;
    }

    private final void updateRepeatMode() {
        block0: {
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer == null) break block0;
            exoPlayer.setRepeatMode(this.repeatable ? 2 : 0);
        }
    }

    public void onCues(@NotNull List<Cue> cues) {
        Intrinsics.checkNotNullParameter(cues, (String)"cues");
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)new GPHVideoPlayerState.CaptionsTextChanged(cues.size() > 0 ? String.valueOf(cues.get((int)0).text) : ""));
        }
    }

    public GPHVideoPlayer(@Nullable GPHVideoPlayerView playerView, boolean repeatable, boolean showCaptions) {
        boolean bl = false;
        this.listeners = new LinkedHashSet();
        this.media = new Media("", null, null, null, null, null, null, null, null, null, null, null, null, null, new Images(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1048575, null), null, null, null, null, null, null, null, null, false, false, false, false, false, false, false, false, false, null, null, null, false, null, -16386, 31, null);
        this.startListeningToDeviceVolume();
        this.playerView = playerView;
        this.repeatable = repeatable;
        this.setShowCaptions(showCaptions);
    }

    public /* synthetic */ GPHVideoPlayer(GPHVideoPlayerView gPHVideoPlayerView, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        this(gPHVideoPlayerView, bl, bl2);
    }

    public static final /* synthetic */ boolean access$isDeviceMuted$p(GPHVideoPlayer $this) {
        return $this.isDeviceMuted;
    }

    public static final /* synthetic */ void access$setDeviceMuted$p(GPHVideoPlayer $this, boolean bl) {
        $this.isDeviceMuted = bl;
    }

    public static final /* synthetic */ void access$updateProgress(GPHVideoPlayer $this, long position) {
        $this.updateProgress(position);
    }
}

