/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.ui.views;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.FrameLayout;
import com.giphy.sdk.ui.views.GPHTouchInterceptor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u00012\u00020\u0002B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001a\u00106\u001a\u0004\u0018\u00010\u001e2\u0006\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\bH\u0002J\u001a\u00109\u001a\u00020\u00162\b\u0010:\u001a\u0004\u0018\u00010\u001e2\u0006\u0010;\u001a\u00020<H\u0002J \u00109\u001a\u00020\u00162\b\u0010:\u001a\u0004\u0018\u00010\u001e2\u0006\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\bJ\u0012\u0010=\u001a\u00020\u00162\b\u0010>\u001a\u0004\u0018\u00010<H\u0016J,\u0010?\u001a\u00020\u00162\b\u0010@\u001a\u0004\u0018\u00010<2\b\u0010A\u001a\u0004\u0018\u00010<2\u0006\u0010B\u001a\u00020\f2\u0006\u0010C\u001a\u00020\fH\u0016J\u0010\u0010D\u001a\u00020\u00162\u0006\u0010;\u001a\u00020<H\u0016J\u0012\u0010E\u001a\u00020\u00102\b\u0010>\u001a\u0004\u0018\u00010<H\u0016J,\u0010F\u001a\u00020\u00162\b\u0010@\u001a\u0004\u0018\u00010<2\b\u0010A\u001a\u0004\u0018\u00010<2\u0006\u0010G\u001a\u00020\f2\u0006\u0010H\u001a\u00020\fH\u0016J\u0012\u0010I\u001a\u00020\u00102\b\u0010>\u001a\u0004\u0018\u00010<H\u0016J\u0012\u0010J\u001a\u00020\u00162\b\u0010>\u001a\u0004\u0018\u00010<H\u0016J\u0012\u0010K\u001a\u00020\u00162\b\u0010;\u001a\u0004\u0018\u00010<H\u0016R5\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010.\u001a\u0004\u0018\u00010\u001e2\b\u0010-\u001a\u0004\u0018\u00010\u001e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010 \"\u0004\b0\u0010\"R\u000e\u00101\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u00103\u001a\b\u0012\u0004\u0012\u00020\u00100\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u001a\"\u0004\b5\u0010\u001c\u00a8\u0006L"}, d2={"Lcom/giphy/sdk/ui/views/GPHTouchInterceptor;", "Landroid/widget/FrameLayout;", "Landroid/view/GestureDetector$OnGestureListener;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "dragAccumulator", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "drag", "", "getDragAccumulator", "()Lkotlin/jvm/functions/Function1;", "setDragAccumulator", "(Lkotlin/jvm/functions/Function1;)V", "dragLock", "", "dragRelease", "Lkotlin/Function0;", "getDragRelease", "()Lkotlin/jvm/functions/Function0;", "setDragRelease", "(Lkotlin/jvm/functions/Function0;)V", "dragView", "Landroid/view/View;", "getDragView", "()Landroid/view/View;", "setDragView", "(Landroid/view/View;)V", "gestureDetector", "Landroid/view/GestureDetector;", "getGestureDetector", "()Landroid/view/GestureDetector;", "setGestureDetector", "(Landroid/view/GestureDetector;)V", "globalRect", "Landroid/graphics/Rect;", "lastMoveX", "lastMoveY", "value", "slideView", "getSlideView", "setSlideView", "startX", "startY", "touchOutside", "getTouchOutside", "setTouchOutside", "findTopChildUnder", "x", "y", "isViewUnder", "view", "event", "Landroid/view/MotionEvent;", "onDown", "e", "onFling", "e1", "e2", "velocityX", "velocityY", "onInterceptTouchEvent", "onLongPress", "onScroll", "distanceX", "distanceY", "onShowPress", "onSingleTapUp", "onTouchEvent", "giphy-ui-2.1.16_release"})
public final class GPHTouchInterceptor
extends FrameLayout
implements GestureDetector.OnGestureListener {
    private boolean dragLock;
    private float startX;
    private float startY;
    private float lastMoveX;
    private float lastMoveY;
    @Nullable
    private View dragView;
    @Nullable
    private View slideView;
    @NotNull
    private GestureDetector gestureDetector;
    @NotNull
    private Function1<? super Float, Unit> dragAccumulator;
    @NotNull
    private Function0<Unit> dragRelease;
    @NotNull
    private Function0<Unit> touchOutside;
    private final Rect globalRect;

    @Nullable
    public final View getDragView() {
        return this.dragView;
    }

    public final void setDragView(@Nullable View view) {
        this.dragView = view;
    }

    @Nullable
    public final View getSlideView() {
        return this.slideView;
    }

    public final void setSlideView(@Nullable View value) {
        block3: {
            this.slideView = value;
            View view = value;
            if (view != null) {
                view.setOnClickListener(null);
            }
            View view2 = value;
            if (view2 != null) {
                view2.setClickable(true);
            }
            View view3 = value;
            if (view3 != null) {
                view3.setFocusableInTouchMode(false);
            }
            View view4 = value;
            if (view4 == null) break block3;
            view4.setFocusable(false);
        }
    }

    @NotNull
    public final GestureDetector getGestureDetector() {
        return this.gestureDetector;
    }

    public final void setGestureDetector(@NotNull GestureDetector gestureDetector) {
        Intrinsics.checkNotNullParameter((Object)gestureDetector, (String)"<set-?>");
        this.gestureDetector = gestureDetector;
    }

    @NotNull
    public final Function1<Float, Unit> getDragAccumulator() {
        return this.dragAccumulator;
    }

    public final void setDragAccumulator(@NotNull Function1<? super Float, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.dragAccumulator = function1;
    }

    @NotNull
    public final Function0<Unit> getDragRelease() {
        return this.dragRelease;
    }

    public final void setDragRelease(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.dragRelease = function0;
    }

    @NotNull
    public final Function0<Unit> getTouchOutside() {
        return this.touchOutside;
    }

    public final void setTouchOutside(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.touchOutside = function0;
    }

    public boolean onInterceptTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Timber.d((String)"onInterceptTouchEvent", (Object[])new Object[0]);
        float x = event.getX();
        float y = event.getY();
        switch (event.getActionMasked()) {
            case 0: {
                this.startX = event.getX();
                this.startY = event.getY();
                if (!this.isViewUnder(this.dragView, event)) break;
                this.dragLock = false;
                return false;
            }
            case 2: {
                Timber.d((String)"onInterceptTouch move", (Object[])new Object[0]);
                this.lastMoveX = event.getX() - this.startX;
                this.lastMoveY = event.getY() - this.startY;
                if (!this.isViewUnder(this.dragView, event)) break;
                float f = this.lastMoveY;
                boolean bl = false;
                float f2 = Math.abs(f);
                ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)this.getContext());
                Intrinsics.checkNotNullExpressionValue((Object)viewConfiguration, (String)"ViewConfiguration.get(context)");
                if (!(f2 > (float)viewConfiguration.getScaledTouchSlop())) break;
                if (!this.dragLock) {
                    this.startX = event.getX();
                    this.startY = event.getY();
                }
                this.dragLock = true;
                break;
            }
            case 1: 
            case 3: {
                this.dragLock = false;
                break;
            }
        }
        Timber.d((String)("onInterceptTouch " + event.getAction() + ' ' + event.getActionMasked() + ' ' + event.getY() + ' ' + this.dragLock), (Object[])new Object[0]);
        return this.dragLock;
    }

    public boolean onTouchEvent(@Nullable MotionEvent event) {
        block3: {
            block5: {
                int n;
                Integer n2;
                block4: {
                    block2: {
                        Timber.d((String)("onTouchEvent " + this.dragLock), (Object[])new Object[0]);
                        this.gestureDetector.onTouchEvent(event);
                        MotionEvent motionEvent = event;
                        Integer n3 = n2 = motionEvent != null ? Integer.valueOf(motionEvent.getAction()) : null;
                        n = 0;
                        if (n3 == null || n3 != 0) break block2;
                        this.startX = event.getX();
                        this.startY = event.getY();
                        break block3;
                    }
                    Integer n4 = n2;
                    n = 2;
                    if (n4 == null || n4 != n) break block4;
                    float f = this.lastMoveY;
                    boolean bl = false;
                    float f2 = Math.abs(f);
                    ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)this.getContext());
                    Intrinsics.checkNotNullExpressionValue((Object)viewConfiguration, (String)"ViewConfiguration.get(context)");
                    if (f2 > (float)viewConfiguration.getScaledTouchSlop()) {
                        if (!this.dragLock) {
                            this.startX = event.getX();
                            this.startY = event.getY();
                        }
                        this.dragLock = true;
                    }
                    Timber.d((String)("onMove " + event.getX() + ' ' + event.getY()), (Object[])new Object[0]);
                    this.lastMoveX = event.getX() - this.startX;
                    this.lastMoveY = event.getY() - this.startY;
                    if (!this.dragLock) break block3;
                    this.lastMoveX = event.getX() - this.startX;
                    this.lastMoveY = event.getY() - this.startY;
                    this.dragAccumulator.invoke((Object)Float.valueOf(this.lastMoveY));
                    this.startX = event.getX();
                    this.startY = event.getY();
                    break block3;
                }
                Integer n5 = n2;
                n = 1;
                if (n5 != null && n5 == n) break block5;
                Integer n6 = n2;
                n = 3;
                if (n6 == null || n6 != n) break block3;
            }
            this.dragRelease.invoke();
            this.dragLock = false;
        }
        return this.dragLock;
    }

    public final boolean isViewUnder(@Nullable View view, int x, int y) {
        return view == null ? false : x >= view.getLeft() && x < view.getRight() && y >= view.getTop() && y < view.getBottom();
    }

    private final boolean isViewUnder(View view, MotionEvent event) {
        View view2 = view;
        if (view2 != null) {
            if (!view2.getGlobalVisibleRect(this.globalRect)) {
                return false;
            }
        }
        return this.globalRect.contains((int)event.getRawX(), (int)event.getRawY());
    }

    /*
     * WARNING - void declaration
     */
    private final View findTopChildUnder(int x, int y) {
        int n = this.getChildCount() - 1;
        boolean bl = false;
        while (n >= 0) {
            void i;
            View child;
            View view = child = this.getChildAt((int)i);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"child");
            if (x >= view.getLeft() && x < child.getRight() && y >= child.getTop() && y < child.getBottom()) {
                return child;
            }
            --i;
        }
        return null;
    }

    public void onShowPress(@Nullable MotionEvent e) {
    }

    public boolean onSingleTapUp(@Nullable MotionEvent e) {
        return false;
    }

    public boolean onDown(@Nullable MotionEvent e) {
        MotionEvent motionEvent = e;
        if (motionEvent != null) {
            MotionEvent motionEvent2 = motionEvent;
            boolean bl = false;
            boolean bl2 = false;
            MotionEvent it = motionEvent2;
            boolean bl3 = false;
            if (!this.isViewUnder(this.slideView, it)) {
                Timber.d((String)"user tapped outside", (Object[])new Object[0]);
                this.touchOutside.invoke();
                return true;
            }
        }
        return false;
    }

    public boolean onFling(@Nullable MotionEvent e1, @Nullable MotionEvent e2, float velocityX, float velocityY) {
        return false;
    }

    public boolean onScroll(@Nullable MotionEvent e1, @Nullable MotionEvent e2, float distanceX, float distanceY) {
        return false;
    }

    public void onLongPress(@Nullable MotionEvent e) {
    }

    @JvmOverloads
    public GPHTouchInterceptor(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
        this.dragAccumulator = dragAccumulator.1.INSTANCE;
        this.dragRelease = dragRelease.1.INSTANCE;
        this.touchOutside = touchOutside.1.INSTANCE;
        this.globalRect = new Rect();
    }

    public /* synthetic */ GPHTouchInterceptor(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public GPHTouchInterceptor(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public GPHTouchInterceptor(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }
}

