/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.ui.views;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentManager;
import com.giphy.sdk.core.models.Image;
import com.giphy.sdk.core.models.Media;
import com.giphy.sdk.core.models.User;
import com.giphy.sdk.core.models.enums.RenditionType;
import com.giphy.sdk.tracking.MediaExtensionKt;
import com.giphy.sdk.ui.ConstantsKt;
import com.giphy.sdk.ui.Giphy;
import com.giphy.sdk.ui.R;
import com.giphy.sdk.ui.databinding.GphMediaPreviewDialogBinding;
import com.giphy.sdk.ui.utils.GifUtils;
import com.giphy.sdk.ui.utils.IntExtensionsKt;
import com.giphy.sdk.ui.views.GPHMediaPreviewDialog;
import com.giphy.sdk.ui.views.GPHMediaView;
import com.giphy.sdk.ui.views.GPHVideoPlayer;
import com.giphy.sdk.ui.views.GPHVideoPlayerView;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 E2\u00020\u0001:\u0001EB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u000fH\u0002J$\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\b\u0010/\u001a\u00020\u000fH\u0016J\u0010\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020\u000fH\u0016J\b\u00104\u001a\u00020\u000fH\u0016J\u0010\u00105\u001a\u00020\u000f2\u0006\u00106\u001a\u00020.H\u0016J\u001a\u00107\u001a\u00020\u000f2\u0006\u00108\u001a\u00020(2\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\b\u00109\u001a\u00020\u000fH\u0002J\b\u0010:\u001a\u00020;H\u0002J\b\u0010<\u001a\u00020;H\u0002J\"\u0010=\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020?2\b\u0010@\u001a\u0004\u0018\u00010\u000e2\b\u0010A\u001a\u0004\u0018\u00010BJ\b\u0010C\u001a\u00020;H\u0002J\b\u0010D\u001a\u00020;H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R(\u0010\f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R&\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R(\u0010\u0017\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006F"}, d2={"Lcom/giphy/sdk/ui/views/GPHMediaPreviewDialog;", "Landroidx/fragment/app/DialogFragment;", "()V", "_binding", "Lcom/giphy/sdk/ui/databinding/GphMediaPreviewDialogBinding;", "binding", "getBinding", "()Lcom/giphy/sdk/ui/databinding/GphMediaPreviewDialogBinding;", "dismissListener", "Landroid/content/DialogInterface$OnDismissListener;", "media", "Lcom/giphy/sdk/core/models/Media;", "onRemoveMedia", "Lkotlin/Function1;", "", "", "getOnRemoveMedia", "()Lkotlin/jvm/functions/Function1;", "setOnRemoveMedia", "(Lkotlin/jvm/functions/Function1;)V", "onSelectMedia", "getOnSelectMedia", "setOnSelectMedia", "onShowMore", "getOnShowMore", "setOnShowMore", "player", "Lcom/giphy/sdk/ui/views/GPHVideoPlayer;", "showRemoveOption", "", "value", "showViewOnGiphy", "getShowViewOnGiphy", "()Z", "setShowViewOnGiphy", "(Z)V", "getTheme", "", "initUI", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "savedInstanceState", "Landroid/os/Bundle;", "onDestroyView", "onDismiss", "dialog", "Landroid/content/DialogInterface;", "onPause", "onResume", "onSaveInstanceState", "outState", "onViewCreated", "view", "prepareVideo", "removeFromRecentsAction", "Landroid/view/View$OnClickListener;", "selectMediaAction", "show", "manager", "Landroidx/fragment/app/FragmentManager;", "tag", "listener", "", "showMoreAction", "viewOnGiphyAction", "Companion", "giphy-ui-2.1.16_release"})
public final class GPHMediaPreviewDialog
extends DialogFragment {
    private GphMediaPreviewDialogBinding _binding;
    private Media media;
    private boolean showRemoveOption;
    private boolean showViewOnGiphy = true;
    private GPHVideoPlayer player;
    private DialogInterface.OnDismissListener dismissListener;
    @NotNull
    private Function1<? super String, Unit> onShowMore = onShowMore.1.INSTANCE;
    @NotNull
    private Function1<? super String, Unit> onRemoveMedia = onRemoveMedia.1.INSTANCE;
    @NotNull
    private Function1<? super Media, Unit> onSelectMedia = onSelectMedia.1.INSTANCE;
    private static final String MEDIA_KEY;
    private static final String REMOVE_ACTION_VISIBILITY_KEY;
    private static final String SHOW_ON_GIPHY_ACTION_VISIBILITY_KEY;
    @NotNull
    public static final Companion Companion;

    private final GphMediaPreviewDialogBinding getBinding() {
        GphMediaPreviewDialogBinding gphMediaPreviewDialogBinding = this._binding;
        Intrinsics.checkNotNull((Object)gphMediaPreviewDialogBinding);
        return gphMediaPreviewDialogBinding;
    }

    public final boolean getShowViewOnGiphy() {
        return this.showViewOnGiphy;
    }

    public final void setShowViewOnGiphy(boolean value) {
        block0: {
            this.showViewOnGiphy = value;
            GphMediaPreviewDialogBinding gphMediaPreviewDialogBinding = this._binding;
            if (gphMediaPreviewDialogBinding == null) break block0;
            GphMediaPreviewDialogBinding gphMediaPreviewDialogBinding2 = gphMediaPreviewDialogBinding;
            boolean bl = false;
            boolean bl2 = false;
            GphMediaPreviewDialogBinding it = gphMediaPreviewDialogBinding2;
            boolean bl3 = false;
            LinearLayout linearLayout = it.gphActionViewGiphy;
            Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"it.gphActionViewGiphy");
            linearLayout.setVisibility(value ? 0 : 8);
        }
    }

    @NotNull
    public final Function1<String, Unit> getOnShowMore() {
        return this.onShowMore;
    }

    public final void setOnShowMore(@NotNull Function1<? super String, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onShowMore = function1;
    }

    @NotNull
    public final Function1<String, Unit> getOnRemoveMedia() {
        return this.onRemoveMedia;
    }

    public final void setOnRemoveMedia(@NotNull Function1<? super String, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onRemoveMedia = function1;
    }

    @NotNull
    public final Function1<Media, Unit> getOnSelectMedia() {
        return this.onSelectMedia;
    }

    public final void setOnSelectMedia(@NotNull Function1<? super Media, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onSelectMedia = function1;
    }

    public int getTheme() {
        return R.style.GiphyDialogStyle;
    }

    @NotNull
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        this._binding = GphMediaPreviewDialogBinding.inflate(inflater, container, false);
        FrameLayout frameLayout = this.getBinding().getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"binding.root");
        return (View)frameLayout;
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        Parcelable parcelable = this.requireArguments().getParcelable(MEDIA_KEY);
        Intrinsics.checkNotNull((Object)parcelable);
        this.media = (Media)parcelable;
        this.showRemoveOption = this.requireArguments().getBoolean(REMOVE_ACTION_VISIBILITY_KEY);
        this.setShowViewOnGiphy(this.requireArguments().getBoolean(SHOW_ON_GIPHY_ACTION_VISIBILITY_KEY));
        this.initUI();
    }

    public void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            bundle.putBoolean(SHOW_ON_GIPHY_ACTION_VISIBILITY_KEY, this.showViewOnGiphy);
        }
        super.onSaveInstanceState(outState);
    }

    public void onDestroyView() {
        this._binding = null;
        super.onDestroyView();
    }

    private final void initUI() {
        boolean bl;
        boolean bl2;
        Object object;
        GphMediaPreviewDialogBinding gphMediaPreviewDialogBinding = this.getBinding();
        boolean bl3 = false;
        boolean bl4 = false;
        GphMediaPreviewDialogBinding $this$apply = gphMediaPreviewDialogBinding;
        boolean bl5 = false;
        LinearLayout linearLayout = $this$apply.gphActionRemove;
        Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"gphActionRemove");
        linearLayout.setVisibility(this.showRemoveOption ? 0 : 8);
        LinearLayout linearLayout2 = $this$apply.gphActionViewGiphy;
        Intrinsics.checkNotNullExpressionValue((Object)linearLayout2, (String)"gphActionViewGiphy");
        linearLayout2.setVisibility(this.showViewOnGiphy ? 0 : 8);
        $this$apply.actionsContainer.setBackgroundColor(Giphy.INSTANCE.getThemeUsed$giphy_ui_2_1_16_release().getBackgroundColor());
        $this$apply.dialogContainer.setBackgroundColor(Giphy.INSTANCE.getThemeUsed$giphy_ui_2_1_16_release().getDialogOverlayBackgroundColor());
        GradientDrawable shape = new GradientDrawable();
        shape.setCornerRadius((float)IntExtensionsKt.getPx(12));
        shape.setColor(Giphy.INSTANCE.getThemeUsed$giphy_ui_2_1_16_release().getBackgroundColor());
        ConstraintLayout constraintLayout = $this$apply.dialogBody;
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"dialogBody");
        constraintLayout.setBackground((Drawable)shape);
        GradientDrawable buttonShape = new GradientDrawable();
        buttonShape.setCornerRadius((float)IntExtensionsKt.getPx(2));
        buttonShape.setColor(Giphy.INSTANCE.getThemeUsed$giphy_ui_2_1_16_release().getBackgroundColor());
        TextView[] $this$forEach$iv = new TextView[]{$this$apply.channelName, $this$apply.gphActionRemoveText, $this$apply.gphActionSelectText, $this$apply.gphActionViewGiphyText};
        boolean $i$f$forEach = false;
        TextView[] textViewArray = $this$forEach$iv;
        int n = textViewArray.length;
        for (int i = 0; i < n; ++i) {
            TextView element$iv;
            TextView it = element$iv = textViewArray[i];
            boolean bl6 = false;
            it.setTextColor(Giphy.INSTANCE.getThemeUsed$giphy_ui_2_1_16_release().getTextColor());
        }
        Media media2 = this.media;
        if (media2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"media");
        }
        User user = media2.getUser();
        if (user != null) {
            object = user;
            bl2 = false;
            bl = false;
            Object it = object;
            boolean bl7 = false;
            TextView textView = $this$apply.channelName;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"channelName");
            textView.setText((CharSequence)('@' + ((User)it).getUsername()));
            ImageView imageView = $this$apply.verifiedBadge;
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"verifiedBadge");
            imageView.setVisibility(((User)it).getVerified() ? 0 : 8);
            $this$apply.userChannelGifAvatar.loadAsset(((User)it).getAvatarUrl());
        } else {
            object = $this$apply;
            bl2 = false;
            bl = false;
            Object $this$run = object;
            boolean bl8 = false;
            ConstraintLayout constraintLayout2 = ((GphMediaPreviewDialogBinding)$this$run).userAttrContainer;
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout2, (String)"userAttrContainer");
            constraintLayout2.setVisibility(8);
        }
        GPHMediaView gPHMediaView = $this$apply.mainGif;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gPHMediaView), (String)"mainGif");
        gPHMediaView.setAdjustViewBounds(true);
        GPHMediaView gPHMediaView2 = $this$apply.mainGif;
        Media media3 = this.media;
        if (media3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"media");
        }
        gPHMediaView2.setMedia(media3, RenditionType.original, (Drawable)new ColorDrawable(ConstantsKt.getPlaceholderColor()));
        $this$apply.dialogContainer.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ GPHMediaPreviewDialog this$0;
            {
                this.this$0 = gPHMediaPreviewDialog;
            }

            public final void onClick(View it) {
                this.this$0.dismiss();
            }
        });
        $this$apply.mainGif.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ GPHMediaPreviewDialog this$0;
            {
                this.this$0 = gPHMediaPreviewDialog;
            }

            public final void onClick(View it) {
                this.this$0.dismiss();
            }
        });
        object = $this$apply.dialogBody;
        bl2 = false;
        bl = false;
        Object $this$apply2 = object;
        boolean bl9 = false;
        $this$apply2.setScaleX(0.7f);
        $this$apply2.setScaleY(0.7f);
        $this$apply2.setTranslationY((float)IntExtensionsKt.getPx(200));
        $this$apply2.animate().scaleX(1.0f).scaleY(1.0f).translationY(0.0f).setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        $this$apply.userAttrContainer.setOnClickListener(this.showMoreAction());
        $this$apply.gphActionRemove.setOnClickListener(this.removeFromRecentsAction());
        $this$apply.gphActionSelect.setOnClickListener(this.selectMediaAction());
        $this$apply.gphActionViewGiphy.setOnClickListener(this.viewOnGiphyAction());
        Media media4 = this.media;
        if (media4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"media");
        }
        if (MediaExtensionKt.isVideo(media4)) {
            this.prepareVideo();
        }
    }

    public void onDismiss(@NotNull DialogInterface dialog2) {
        Intrinsics.checkNotNullParameter((Object)dialog2, (String)"dialog");
        GPHVideoPlayer gPHVideoPlayer = this.player;
        if (gPHVideoPlayer != null) {
            gPHVideoPlayer.onDestroy();
        }
        DialogInterface.OnDismissListener onDismissListener = this.dismissListener;
        if (onDismissListener != null) {
            onDismissListener.onDismiss(dialog2);
        }
        super.onDismiss(dialog2);
    }

    public void onPause() {
        GPHVideoPlayer gPHVideoPlayer = this.player;
        if (gPHVideoPlayer != null) {
            gPHVideoPlayer.onPause();
        }
        super.onPause();
    }

    public void onResume() {
        block0: {
            super.onResume();
            GPHVideoPlayer gPHVideoPlayer = this.player;
            if (gPHVideoPlayer == null) break block0;
            gPHVideoPlayer.onResume();
        }
    }

    public final void show(@NotNull FragmentManager manager, @Nullable String tag, @Nullable Object listener2) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (listener2 instanceof DialogInterface.OnDismissListener) {
            this.dismissListener = (DialogInterface.OnDismissListener)listener2;
        }
        super.show(manager, tag);
    }

    private final void prepareVideo() {
        GPHVideoPlayerView gPHVideoPlayerView = this.getBinding().videoPlayerView;
        Media media2 = this.media;
        if (media2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"media");
        }
        Image image = media2.getImages().getOriginal();
        gPHVideoPlayerView.setMaxHeight(image != null ? IntExtensionsKt.getPx(image.getHeight()) : Integer.MAX_VALUE);
        GPHMediaView gPHMediaView = this.getBinding().mainGif;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gPHMediaView), (String)"binding.mainGif");
        gPHMediaView.setVisibility(4);
        GPHVideoPlayerView gPHVideoPlayerView2 = this.getBinding().videoPlayerView;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gPHVideoPlayerView2), (String)"binding.videoPlayerView");
        gPHVideoPlayerView2.setVisibility(0);
        GPHVideoPlayer gPHVideoPlayer = this.player = new GPHVideoPlayer(this.getBinding().videoPlayerView, true, false, 4, null);
        if (gPHVideoPlayer != null) {
            Media media3 = this.media;
            if (media3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"media");
            }
            GPHVideoPlayer.loadMedia$default(gPHVideoPlayer, media3, true, null, null, 12, null);
        }
        GPHVideoPlayerView cfr_ignored_0 = this.getBinding().videoPlayerView;
        this.getBinding().videoPlayerView.setPreviewMode((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ GPHMediaPreviewDialog this$0;

            public final void invoke() {
                this.this$0.dismiss();
            }
            {
                this.this$0 = gPHMediaPreviewDialog;
                super(0);
            }
        }));
    }

    private final View.OnClickListener showMoreAction() {
        return new View.OnClickListener(this){
            final /* synthetic */ GPHMediaPreviewDialog this$0;

            public final void onClick(View it) {
                User user = GPHMediaPreviewDialog.access$getMedia$p(this.this$0).getUser();
                if (user != null) {
                    User user2 = user;
                    boolean bl = false;
                    boolean bl2 = false;
                    User it2 = user2;
                    boolean bl3 = false;
                    this.this$0.getOnShowMore().invoke((Object)it2.getUsername());
                }
                this.this$0.dismiss();
            }
            {
                this.this$0 = gPHMediaPreviewDialog;
            }
        };
    }

    private final View.OnClickListener selectMediaAction() {
        return new View.OnClickListener(this){
            final /* synthetic */ GPHMediaPreviewDialog this$0;

            public final void onClick(View it) {
                this.this$0.getOnSelectMedia().invoke((Object)GPHMediaPreviewDialog.access$getMedia$p(this.this$0));
                this.this$0.dismiss();
            }
            {
                this.this$0 = gPHMediaPreviewDialog;
            }
        };
    }

    private final View.OnClickListener removeFromRecentsAction() {
        return new View.OnClickListener(this){
            final /* synthetic */ GPHMediaPreviewDialog this$0;

            public final void onClick(View it) {
                this.this$0.getOnRemoveMedia().invoke((Object)GPHMediaPreviewDialog.access$getMedia$p(this.this$0).getId());
                this.this$0.dismiss();
            }
            {
                this.this$0 = gPHMediaPreviewDialog;
            }
        };
    }

    private final View.OnClickListener viewOnGiphyAction() {
        return new View.OnClickListener(this){
            final /* synthetic */ GPHMediaPreviewDialog this$0;

            public final void onClick(View it) {
                Context context = this.this$0.getContext();
                if (context != null) {
                    context.startActivity(GifUtils.INSTANCE.getViewGifIntent(GPHMediaPreviewDialog.access$getMedia$p(this.this$0)));
                }
                this.this$0.dismiss();
            }
            {
                this.this$0 = gPHMediaPreviewDialog;
            }
        };
    }

    static {
        Companion = new Companion(null);
        MEDIA_KEY = "gph_media_preview_dialog_media";
        REMOVE_ACTION_VISIBILITY_KEY = "gph_media_preview_remove_action_show";
        SHOW_ON_GIPHY_ACTION_VISIBILITY_KEY = "gph_show_on_giphy_action_show";
    }

    public static final /* synthetic */ Media access$getMedia$p(GPHMediaPreviewDialog $this) {
        Media media2 = $this.media;
        if (media2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"media");
        }
        return media2;
    }

    public static final /* synthetic */ void access$setMedia$p(GPHMediaPreviewDialog $this, Media media2) {
        $this.media = media2;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/giphy/sdk/ui/views/GPHMediaPreviewDialog$Companion;", "", "()V", "MEDIA_KEY", "", "REMOVE_ACTION_VISIBILITY_KEY", "SHOW_ON_GIPHY_ACTION_VISIBILITY_KEY", "newInstance", "Lcom/giphy/sdk/ui/views/GPHMediaPreviewDialog;", "media", "Lcom/giphy/sdk/core/models/Media;", "showRemoveOption", "", "showOnGiphyOption", "giphy-ui-2.1.16_release"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final GPHMediaPreviewDialog newInstance(@NotNull Media media2, boolean showRemoveOption, boolean showOnGiphyOption) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)media2, (String)"media");
            GPHMediaPreviewDialog gPHMediaPreviewDialog = new GPHMediaPreviewDialog();
            boolean bl = false;
            boolean bl2 = false;
            GPHMediaPreviewDialog $this$apply2 = gPHMediaPreviewDialog;
            boolean bl3 = false;
            Bundle bundle = new Bundle();
            boolean bl4 = false;
            boolean bl5 = false;
            Bundle bundle2 = bundle;
            GPHMediaPreviewDialog gPHMediaPreviewDialog2 = $this$apply2;
            boolean bl6 = false;
            $this$apply.putParcelable(MEDIA_KEY, (Parcelable)media2);
            $this$apply.putBoolean(REMOVE_ACTION_VISIBILITY_KEY, showRemoveOption);
            $this$apply.putBoolean(SHOW_ON_GIPHY_ACTION_VISIBILITY_KEY, showOnGiphyOption);
            Unit unit = Unit.INSTANCE;
            gPHMediaPreviewDialog2.setArguments(bundle);
            return gPHMediaPreviewDialog;
        }

        public static /* synthetic */ GPHMediaPreviewDialog newInstance$default(Companion companion, Media media2, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 4) != 0) {
                bl2 = true;
            }
            return companion.newInstance(media2, bl, bl2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

