/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.ui.views;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.core.view.ViewCompat;
import com.giphy.sdk.core.models.Image;
import com.giphy.sdk.core.models.Images;
import com.giphy.sdk.core.models.Media;
import com.giphy.sdk.core.models.User;
import com.giphy.sdk.tracking.MediaExtensionKt;
import com.giphy.sdk.ui.R;
import com.giphy.sdk.ui.databinding.GphActionsViewBinding;
import com.giphy.sdk.ui.utils.GifUtils;
import com.giphy.sdk.ui.utils.IntExtensionsKt;
import com.giphy.sdk.ui.views.GPHActions;
import com.giphy.sdk.ui.views.GPHMediaActionsView;
import com.giphy.sdk.ui.views.GPHMediaActionsView$WhenMappings;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020$H\u0002J\u0012\u0010&\u001a\u00020\u00192\b\u0010'\u001a\u0004\u0018\u00010\u0018H\u0002J\b\u0010(\u001a\u00020$H\u0002J\u000e\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+J\b\u0010,\u001a\u00020\u0019H\u0002J\b\u0010-\u001a\u00020$H\u0002R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR(\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R(\u0010\u0016\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u00190\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR(\u0010\u001e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u00190\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/giphy/sdk/ui/views/GPHMediaActionsView;", "Landroid/widget/PopupWindow;", "context", "Landroid/content/Context;", "actions", "", "Lcom/giphy/sdk/ui/views/GPHActions;", "(Landroid/content/Context;[Lcom/giphy/sdk/ui/views/GPHActions;)V", "getActions", "()[Lcom/giphy/sdk/ui/views/GPHActions;", "[Lcom/giphy/sdk/ui/views/GPHActions;", "contentViewBinding", "Lcom/giphy/sdk/ui/databinding/GphActionsViewBinding;", "getContext", "()Landroid/content/Context;", "value", "Lcom/giphy/sdk/core/models/Media;", "media", "getMedia", "()Lcom/giphy/sdk/core/models/Media;", "setMedia", "(Lcom/giphy/sdk/core/models/Media;)V", "onRemoveMedia", "Lkotlin/Function1;", "", "", "getOnRemoveMedia", "()Lkotlin/jvm/functions/Function1;", "setOnRemoveMedia", "(Lkotlin/jvm/functions/Function1;)V", "onShowMore", "getOnShowMore", "setOnShowMore", "shadowSize", "", "copyLink", "Landroid/view/View$OnClickListener;", "removeFromRecents", "saveToClipboard", "url", "showMoreAction", "showRemoveOption", "show", "", "updateWidth", "viewOnGiphyAction", "giphy-ui-2.1.16_release"})
public final class GPHMediaActionsView
extends PopupWindow {
    @NotNull
    private Function1<? super String, Unit> onShowMore;
    @NotNull
    private Function1<? super String, Unit> onRemoveMedia;
    private final int shadowSize;
    private final GphActionsViewBinding contentViewBinding;
    @Nullable
    private Media media;
    @Nullable
    private final Context context;
    @NotNull
    private final GPHActions[] actions;

    @NotNull
    public final Function1<String, Unit> getOnShowMore() {
        return this.onShowMore;
    }

    public final void setOnShowMore(@NotNull Function1<? super String, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onShowMore = function1;
    }

    @NotNull
    public final Function1<String, Unit> getOnRemoveMedia() {
        return this.onRemoveMedia;
    }

    public final void setOnRemoveMedia(@NotNull Function1<? super String, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onRemoveMedia = function1;
    }

    @Nullable
    public final Media getMedia() {
        return this.media;
    }

    public final void setMedia(@Nullable Media value) {
        block4: {
            this.media = value;
            TextView textView = this.contentViewBinding.gphActionMore;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"contentViewBinding.gphActionMore");
            textView.setVisibility(8);
            Media media2 = value;
            if (media2 == null) break block4;
            if (!media2.isAnonymous()) {
                Object object;
                if (ArraysKt.contains((Object[])this.actions, (Object)((Object)GPHActions.SearchMore)) && !Intrinsics.areEqual((Object)MediaExtensionKt.isText(value), (Object)true) && (object = value.getUser()) != null && (object = ((User)object).getUsername()) != null) {
                    String string2;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    TextView textView2 = this.contentViewBinding.gphActionMore;
                    Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"contentViewBinding.gphActionMore");
                    Object object3 = this.context;
                    if (object3 != null && (object3 = object3.getString(R.string.gph_more_by)) != null) {
                        Object object4 = object3;
                        Object[] objectArray = new Object[]{it};
                        boolean bl4 = false;
                        String string3 = String.format((String)object4, Arrays.copyOf(objectArray, objectArray.length));
                        string2 = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(this, *args)");
                    } else {
                        string2 = null;
                    }
                    textView2.setText((CharSequence)string2);
                    TextView textView3 = this.contentViewBinding.gphActionMore;
                    Intrinsics.checkNotNullExpressionValue((Object)textView3, (String)"contentViewBinding.gphActionMore");
                    textView3.setVisibility(0);
                    this.updateWidth();
                }
            }
        }
    }

    private final View.OnClickListener copyLink() {
        return new View.OnClickListener(this){
            final /* synthetic */ GPHMediaActionsView this$0;

            public final void onClick(View it) {
                Object object = this.this$0.getMedia();
                GPHMediaActionsView.access$saveToClipboard(this.this$0, object != null && (object = ((Media)object).getImages()) != null && (object = ((Images)object).getOriginal()) != null ? ((Image)object).getGifUrl() : null);
                this.this$0.dismiss();
            }
            {
                this.this$0 = gPHMediaActionsView;
            }
        };
    }

    public final void showRemoveOption(boolean show) {
        TextView textView = this.contentViewBinding.gphActionRemove;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"contentViewBinding.gphActionRemove");
        textView.setVisibility(show ? 0 : 8);
        this.updateWidth();
    }

    private final void updateWidth() {
        this.getContentView().measure(-2, -2);
        View view = this.getContentView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"contentView");
        this.setWidth(view.getMeasuredWidth());
    }

    private final void saveToClipboard(String url) {
        Context context = this.context;
        Object object = context != null ? context.getSystemService("clipboard") : null;
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.content.ClipboardManager");
        }
        ClipboardManager clipboardManager = (ClipboardManager)object;
        ClipData clip = ClipData.newPlainText((CharSequence)"Giphy", (CharSequence)url);
        clipboardManager.setPrimaryClip(clip);
    }

    private final View.OnClickListener showMoreAction() {
        return new View.OnClickListener(this){
            final /* synthetic */ GPHMediaActionsView this$0;

            public final void onClick(View it) {
                Object object;
                this.this$0.getOnShowMore().invoke((object = this.this$0.getMedia()) != null && (object = ((Media)object).getUser()) != null ? ((User)object).getUsername() : null);
                this.this$0.dismiss();
            }
            {
                this.this$0 = gPHMediaActionsView;
            }
        };
    }

    private final View.OnClickListener viewOnGiphyAction() {
        return new View.OnClickListener(this){
            final /* synthetic */ GPHMediaActionsView this$0;

            public final void onClick(View it) {
                Context context = this.this$0.getContext();
                if (context != null) {
                    context.startActivity(GifUtils.INSTANCE.getViewGifIntent(this.this$0.getMedia()));
                }
                this.this$0.dismiss();
            }
            {
                this.this$0 = gPHMediaActionsView;
            }
        };
    }

    private final View.OnClickListener removeFromRecents() {
        return new View.OnClickListener(this){
            final /* synthetic */ GPHMediaActionsView this$0;

            public final void onClick(View it) {
                Media media2 = this.this$0.getMedia();
                this.this$0.getOnRemoveMedia().invoke((Object)(media2 != null ? media2.getId() : null));
                this.this$0.dismiss();
            }
            {
                this.this$0 = gPHMediaActionsView;
            }
        };
    }

    @Nullable
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final GPHActions[] getActions() {
        return this.actions;
    }

    public GPHMediaActionsView(@Nullable Context context, @NotNull GPHActions[] actions) {
        Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
        this.context = context;
        this.actions = actions;
        this.onShowMore = onShowMore.1.INSTANCE;
        this.onRemoveMedia = onRemoveMedia.1.INSTANCE;
        this.shadowSize = IntExtensionsKt.getPx(2);
        this.setContentView(View.inflate((Context)this.context, (int)R.layout.gph_actions_view, null));
        GphActionsViewBinding gphActionsViewBinding = GphActionsViewBinding.bind(this.getContentView());
        Intrinsics.checkNotNullExpressionValue((Object)gphActionsViewBinding, (String)"GphActionsViewBinding.bind(contentView)");
        this.contentViewBinding = gphActionsViewBinding;
        this.setWidth(-2);
        this.setHeight(-2);
        if (Build.VERSION.SDK_INT >= 21) {
            this.setElevation(this.shadowSize);
        } else {
            ViewCompat.setElevation((View)this.getContentView(), (float)this.shadowSize);
        }
        if (Build.VERSION.SDK_INT >= 23) {
            this.setOverlapAnchor(true);
        }
        GphActionsViewBinding gphActionsViewBinding2 = this.contentViewBinding;
        boolean bl = false;
        boolean bl2 = false;
        GphActionsViewBinding $this$apply = gphActionsViewBinding2;
        boolean bl3 = false;
        $this$apply.gphActionMore.setOnClickListener(this.showMoreAction());
        $this$apply.gphCopyLink.setOnClickListener(this.copyLink());
        $this$apply.gphActionViewGiphy.setOnClickListener(this.viewOnGiphyAction());
        $this$apply.gphActionRemove.setOnClickListener(this.removeFromRecents());
        GPHActions[] $this$forEach$iv = this.actions;
        boolean $i$f$forEach = false;
        GPHActions[] gPHActionsArray = $this$forEach$iv;
        int n = gPHActionsArray.length;
        block5: for (int i = 0; i < n; ++i) {
            GPHActions element$iv;
            GPHActions it = element$iv = gPHActionsArray[i];
            boolean bl4 = false;
            switch (GPHMediaActionsView$WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                case 1: {
                    TextView textView = $this$apply.gphActionMore;
                    Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"gphActionMore");
                    textView.setVisibility(0);
                    continue block5;
                }
                case 2: {
                    TextView textView = $this$apply.gphCopyLink;
                    Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"gphCopyLink");
                    textView.setVisibility(0);
                    continue block5;
                }
                case 3: {
                    TextView textView = $this$apply.gphActionViewGiphy;
                    Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"gphActionViewGiphy");
                    textView.setVisibility(0);
                }
            }
        }
        this.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.setOutsideTouchable(true);
    }

    public static final /* synthetic */ void access$saveToClipboard(GPHMediaActionsView $this, String url) {
        $this.saveToClipboard(url);
    }
}

