/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.ui.universallist;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.lifecycle.MutableLiveData;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.giphy.sdk.core.GiphyCore;
import com.giphy.sdk.core.models.Media;
import com.giphy.sdk.core.models.enums.RenditionType;
import com.giphy.sdk.core.network.api.CompletionHandler;
import com.giphy.sdk.core.network.api.GPHApiClient;
import com.giphy.sdk.core.network.engine.ApiException;
import com.giphy.sdk.core.network.response.ListMediaResponse;
import com.giphy.sdk.tracking.GifTrackingManager;
import com.giphy.sdk.tracking.MediaExtensionKt;
import com.giphy.sdk.ui.GPHContentType;
import com.giphy.sdk.ui.GPHRequestType;
import com.giphy.sdk.ui.R;
import com.giphy.sdk.ui.pagination.GPHContent;
import com.giphy.sdk.ui.pagination.NetworkState;
import com.giphy.sdk.ui.themes.GridType;
import com.giphy.sdk.ui.universallist.SmartGridAdapter;
import com.giphy.sdk.ui.universallist.SmartGridRecyclerView;
import com.giphy.sdk.ui.universallist.SmartGridRecyclerView$WhenMappings;
import com.giphy.sdk.ui.universallist.SmartItemData;
import com.giphy.sdk.ui.universallist.SmartItemType;
import com.giphy.sdk.ui.universallist.WrapStaggeredGridLayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e*\u0002ps\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010i\u001a\u00020HJ\b\u0010j\u001a\u00020HH\u0002J\u0010\u0010k\u001a\u00020l2\u0006\u0010f\u001a\u00020\u0007H\u0002J\b\u0010m\u001a\u00020lH\u0002J\u0006\u0010n\u001a\u00020&J\r\u0010o\u001a\u00020pH\u0002\u00a2\u0006\u0002\u0010qJ\r\u0010r\u001a\u00020sH\u0002\u00a2\u0006\u0002\u0010tJ\u0006\u0010u\u001a\u00020&J\u0016\u0010u\u001a\u00020&2\f\u0010v\u001a\b\u0012\u0004\u0012\u00020x0wH\u0002J\u0010\u0010y\u001a\u00020H2\u0006\u0010z\u001a\u00020>H\u0002J\u0010\u0010{\u001a\u00020H2\u0006\u0010|\u001a\u00020\u0007H\u0002J\u0006\u0010}\u001a\u00020HJ\u0006\u0010~\u001a\u00020HJ\b\u0010\u007f\u001a\u00020HH\u0016J'\u0010\u0080\u0001\u001a\u00020H2\u0006\u00106\u001a\u0002072\b\u0010f\u001a\u0004\u0018\u00010\u00072\u0006\u0010'\u001a\u00020(\u00a2\u0006\u0003\u0010\u0081\u0001J\u000f\u0010\u0082\u0001\u001a\u00020H2\u0006\u0010\u001b\u001a\u00020\u001cJ\t\u0010\u0083\u0001\u001a\u00020HH\u0002J\t\u0010\u0084\u0001\u001a\u00020HH\u0002J\t\u0010\u0085\u0001\u001a\u00020HH\u0002R\u001a\u0010\t\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R(\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u00158F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u001f0\u001ej\b\u0012\u0004\u0012\u00020\u001f` X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010)\u001a\u0012\u0012\u0004\u0012\u00020\u001f0\u001ej\b\u0012\u0004\u0012\u00020\u001f` X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\"\"\u0004\b+\u0010$R\u001a\u0010,\u001a\u00020-X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u0011\u00102\u001a\u000203\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u000e\u00106\u001a\u000207X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u00108\u001a\u0012\u0012\u0004\u0012\u00020\u001f0\u001ej\b\u0012\u0004\u0012\u00020\u001f` X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\"\"\u0004\b:\u0010$R\u000e\u0010;\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010<\u001a\b\u0012\u0004\u0012\u00020>0=X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u0084\u0001\u0010I\u001a2\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\bD\u0012\b\bE\u0012\u0004\b\b(F\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\bD\u0012\b\bE\u0012\u0004\b\b(G\u0012\u0004\u0012\u00020H0C26\u0010\u000f\u001a2\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\bD\u0012\b\bE\u0012\u0004\b\b(F\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\bD\u0012\b\bE\u0012\u0004\b\b(G\u0012\u0004\u0012\u00020H0C8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR\u008a\u0001\u0010N\u001a4\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\bD\u0012\b\bE\u0012\u0004\b\b(F\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\bD\u0012\b\bE\u0012\u0004\b\b(G\u0012\u0004\u0012\u00020H\u0018\u00010C28\u0010\u000f\u001a4\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\bD\u0012\b\bE\u0012\u0004\b\b(F\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\bD\u0012\b\bE\u0012\u0004\b\b(G\u0012\u0004\u0012\u00020H\u0018\u00010C8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010K\"\u0004\bP\u0010MR&\u0010Q\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020H0RX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010T\"\u0004\bU\u0010VRZ\u0010W\u001a\u001d\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\bD\u0012\b\bE\u0012\u0004\b\b(F\u0012\u0004\u0012\u00020H0R2!\u0010\u000f\u001a\u001d\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\bD\u0012\b\bE\u0012\u0004\b\b(F\u0012\u0004\u0012\u00020H0R8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bX\u0010T\"\u0004\bY\u0010VR$\u0010Z\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010\u0012\"\u0004\b\\\u0010\u0014R(\u0010]\u001a\u0004\u0018\u00010\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u00158F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b^\u0010\u0018\"\u0004\b_\u0010\u001aR \u0010`\u001a\b\u0012\u0004\u0012\u00020a0=X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010@\"\u0004\bc\u0010BR\u0014\u0010d\u001a\b\u0012\u0002\b\u0003\u0018\u00010eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010f\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bg\u0010\u0012\"\u0004\bh\u0010\u0014\u00a8\u0006\u0086\u0001"}, d2={"Lcom/giphy/sdk/ui/universallist/SmartGridRecyclerView;", "Landroidx/recyclerview/widget/RecyclerView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "apiClient", "Lcom/giphy/sdk/core/network/api/GPHApiClient;", "getApiClient$giphy_ui_2_1_16_release", "()Lcom/giphy/sdk/core/network/api/GPHApiClient;", "setApiClient$giphy_ui_2_1_16_release", "(Lcom/giphy/sdk/core/network/api/GPHApiClient;)V", "value", "cellPadding", "getCellPadding", "()I", "setCellPadding", "(I)V", "Lcom/giphy/sdk/core/models/enums/RenditionType;", "clipsPreviewRenditionType", "getClipsPreviewRenditionType", "()Lcom/giphy/sdk/core/models/enums/RenditionType;", "setClipsPreviewRenditionType", "(Lcom/giphy/sdk/core/models/enums/RenditionType;)V", "content", "Lcom/giphy/sdk/ui/pagination/GPHContent;", "contentItems", "Ljava/util/ArrayList;", "Lcom/giphy/sdk/ui/universallist/SmartItemData;", "Lkotlin/collections/ArrayList;", "getContentItems", "()Ljava/util/ArrayList;", "setContentItems", "(Ljava/util/ArrayList;)V", "contentLoading", "", "contentType", "Lcom/giphy/sdk/ui/GPHContentType;", "footerItems", "getFooterItems", "setFooterItems", "gifTrackingManager", "Lcom/giphy/sdk/tracking/GifTrackingManager;", "getGifTrackingManager$giphy_ui_2_1_16_release", "()Lcom/giphy/sdk/tracking/GifTrackingManager;", "setGifTrackingManager$giphy_ui_2_1_16_release", "(Lcom/giphy/sdk/tracking/GifTrackingManager;)V", "gifsAdapter", "Lcom/giphy/sdk/ui/universallist/SmartGridAdapter;", "getGifsAdapter", "()Lcom/giphy/sdk/ui/universallist/SmartGridAdapter;", "gridType", "Lcom/giphy/sdk/ui/themes/GridType;", "headerItems", "getHeaderItems", "setHeaderItems", "mRequestedLayout", "networkState", "Landroidx/lifecycle/MutableLiveData;", "Lcom/giphy/sdk/ui/pagination/NetworkState;", "getNetworkState", "()Landroidx/lifecycle/MutableLiveData;", "setNetworkState", "(Landroidx/lifecycle/MutableLiveData;)V", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "item", "position", "", "onItemLongPressListener", "getOnItemLongPressListener", "()Lkotlin/jvm/functions/Function2;", "setOnItemLongPressListener", "(Lkotlin/jvm/functions/Function2;)V", "onItemSelectedListener", "getOnItemSelectedListener", "setOnItemSelectedListener", "onResultsUpdateListener", "Lkotlin/Function1;", "getOnResultsUpdateListener", "()Lkotlin/jvm/functions/Function1;", "setOnResultsUpdateListener", "(Lkotlin/jvm/functions/Function1;)V", "onUserProfileInfoPressListener", "getOnUserProfileInfoPressListener", "setOnUserProfileInfoPressListener", "orientation", "getOrientation", "setOrientation", "renditionType", "getRenditionType", "setRenditionType", "responseId", "", "getResponseId", "setResponseId", "runningQuery", "Ljava/util/concurrent/Future;", "spanCount", "getSpanCount", "setSpanCount", "clear", "configureRecyclerViewForGridType", "createItemDecorationForGrid", "Landroidx/recyclerview/widget/RecyclerView$ItemDecoration;", "createItemDecorationForStaggered", "emptyResults", "getPostComparator", "com/giphy/sdk/ui/universallist/SmartGridRecyclerView$getPostComparator$1", "()Lcom/giphy/sdk/ui/universallist/SmartGridRecyclerView$getPostComparator$1;", "getSpanSizeLookup", "com/giphy/sdk/ui/universallist/SmartGridRecyclerView$getSpanSizeLookup$1", "()Lcom/giphy/sdk/ui/universallist/SmartGridRecyclerView$getSpanSizeLookup$1;", "isAllDynamic", "list", "", "Lcom/giphy/sdk/core/models/Media;", "loadGifs", "state", "loadNextPage", "aroundPosition", "refresh", "refreshItems", "requestLayout", "update", "(Lcom/giphy/sdk/ui/themes/GridType;Ljava/lang/Integer;Lcom/giphy/sdk/ui/GPHContentType;)V", "updateContent", "updateGridTypeIfNeeded", "updateItemDecorations", "updateNetworkState", "giphy-ui-2.1.16_release"})
public final class SmartGridRecyclerView
extends RecyclerView {
    @NotNull
    private ArrayList<SmartItemData> headerItems;
    @NotNull
    private ArrayList<SmartItemData> contentItems;
    @NotNull
    private ArrayList<SmartItemData> footerItems;
    @NotNull
    private GPHApiClient apiClient;
    private GPHContent content;
    @NotNull
    private GifTrackingManager gifTrackingManager;
    private int orientation;
    private int spanCount;
    private int cellPadding;
    private GridType gridType;
    private GPHContentType contentType;
    @NotNull
    private Function1<? super Integer, Unit> onResultsUpdateListener;
    @Nullable
    private Function2<? super SmartItemData, ? super Integer, Unit> onItemSelectedListener;
    private boolean contentLoading;
    @NotNull
    private MutableLiveData<NetworkState> networkState;
    @NotNull
    private MutableLiveData<String> responseId;
    private Future<?> runningQuery;
    @NotNull
    private final SmartGridAdapter gifsAdapter;
    private boolean mRequestedLayout;

    @NotNull
    public final ArrayList<SmartItemData> getHeaderItems() {
        return this.headerItems;
    }

    public final void setHeaderItems(@NotNull ArrayList<SmartItemData> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.headerItems = arrayList;
    }

    @NotNull
    public final ArrayList<SmartItemData> getContentItems() {
        return this.contentItems;
    }

    public final void setContentItems(@NotNull ArrayList<SmartItemData> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.contentItems = arrayList;
    }

    @NotNull
    public final ArrayList<SmartItemData> getFooterItems() {
        return this.footerItems;
    }

    public final void setFooterItems(@NotNull ArrayList<SmartItemData> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.footerItems = arrayList;
    }

    @NotNull
    public final GPHApiClient getApiClient$giphy_ui_2_1_16_release() {
        return this.apiClient;
    }

    public final void setApiClient$giphy_ui_2_1_16_release(@NotNull GPHApiClient gPHApiClient) {
        Intrinsics.checkNotNullParameter((Object)gPHApiClient, (String)"<set-?>");
        this.apiClient = gPHApiClient;
    }

    @NotNull
    public final GifTrackingManager getGifTrackingManager$giphy_ui_2_1_16_release() {
        return this.gifTrackingManager;
    }

    public final void setGifTrackingManager$giphy_ui_2_1_16_release(@NotNull GifTrackingManager gifTrackingManager) {
        Intrinsics.checkNotNullParameter((Object)gifTrackingManager, (String)"<set-?>");
        this.gifTrackingManager = gifTrackingManager;
    }

    public final int getOrientation() {
        return this.orientation;
    }

    public final void setOrientation(int value) {
        this.orientation = value;
        this.updateGridTypeIfNeeded();
    }

    public final int getSpanCount() {
        return this.spanCount;
    }

    public final void setSpanCount(int value) {
        this.spanCount = value;
        this.updateGridTypeIfNeeded();
    }

    public final int getCellPadding() {
        return this.cellPadding;
    }

    public final void setCellPadding(int value) {
        this.cellPadding = value;
        this.updateItemDecorations();
    }

    public final void update(@NotNull GridType gridType, @Nullable Integer spanCount, @NotNull GPHContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)((Object)gridType), (String)"gridType");
        Intrinsics.checkNotNullParameter((Object)((Object)contentType), (String)"contentType");
        this.gridType = gridType;
        this.contentType = contentType;
        this.gifsAdapter.getAdapterHelper().setContentType(contentType);
        int sCount = 2;
        int orientation = 0;
        switch (SmartGridRecyclerView$WhenMappings.$EnumSwitchMapping$0[gridType.ordinal()]) {
            case 1: {
                Resources resources = this.getResources();
                Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
                if (resources.getConfiguration().orientation == 2) {
                    sCount = 4;
                } else {
                    Resources resources2 = this.getResources();
                    Intrinsics.checkNotNullExpressionValue((Object)resources2, (String)"resources");
                    sCount = (resources2.getConfiguration().screenLayout & 0xF) == 4 ? 4 : 2;
                }
                Integer n = spanCount;
                sCount = n != null ? n : sCount;
                orientation = 1;
                break;
            }
            case 2: {
                sCount = 1;
                orientation = 0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (contentType == GPHContentType.emoji) {
            Integer n = spanCount;
            sCount = n != null ? n : 5;
        }
        this.setOrientation(orientation);
        this.setSpanCount(sCount);
    }

    @Nullable
    public final RenditionType getRenditionType() {
        return this.gifsAdapter.getAdapterHelper().getRenditionType();
    }

    public final void setRenditionType(@Nullable RenditionType value) {
        this.gifsAdapter.getAdapterHelper().setRenditionType(value);
    }

    @Nullable
    public final RenditionType getClipsPreviewRenditionType() {
        return this.gifsAdapter.getAdapterHelper().getClipsPreviewRenditionType();
    }

    public final void setClipsPreviewRenditionType(@Nullable RenditionType value) {
        this.gifsAdapter.getAdapterHelper().setClipsPreviewRenditionType(value);
    }

    @NotNull
    public final Function1<Integer, Unit> getOnResultsUpdateListener() {
        return this.onResultsUpdateListener;
    }

    public final void setOnResultsUpdateListener(@NotNull Function1<? super Integer, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onResultsUpdateListener = function1;
    }

    @Nullable
    public final Function2<SmartItemData, Integer, Unit> getOnItemSelectedListener() {
        return this.gifsAdapter.getItemSelectedListener();
    }

    public final void setOnItemSelectedListener(@Nullable Function2<? super SmartItemData, ? super Integer, Unit> value) {
        this.onItemSelectedListener = value;
        this.gifsAdapter.setItemSelectedListener((Function2<? super SmartItemData, ? super Integer, Unit>)((Function2)new Function2<SmartItemData, Integer, Unit>(value){
            final /* synthetic */ Function2 $value;

            public final void invoke(@NotNull SmartItemData item, int position) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                    Function2 function2 = this.$value;
                    if (function2 == null) break block0;
                    Unit cfr_ignored_0 = (Unit)function2.invoke((Object)item, (Object)position);
                }
            }
            {
                this.$value = function2;
                super(2);
            }
        }));
    }

    @NotNull
    public final Function2<SmartItemData, Integer, Unit> getOnItemLongPressListener() {
        return this.gifsAdapter.getItemLongPressListener();
    }

    public final void setOnItemLongPressListener(@NotNull Function2<? super SmartItemData, ? super Integer, Unit> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.gifsAdapter.setItemLongPressListener(value);
    }

    @NotNull
    public final Function1<SmartItemData, Unit> getOnUserProfileInfoPressListener() {
        return this.gifsAdapter.getUserProfileInfoPressListener();
    }

    public final void setOnUserProfileInfoPressListener(@NotNull Function1<? super SmartItemData, Unit> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.gifsAdapter.setUserProfileInfoPressListener(value);
    }

    @NotNull
    public final MutableLiveData<NetworkState> getNetworkState() {
        return this.networkState;
    }

    public final void setNetworkState(@NotNull MutableLiveData<NetworkState> mutableLiveData) {
        Intrinsics.checkNotNullParameter(mutableLiveData, (String)"<set-?>");
        this.networkState = mutableLiveData;
    }

    @NotNull
    public final MutableLiveData<String> getResponseId() {
        return this.responseId;
    }

    public final void setResponseId(@NotNull MutableLiveData<String> mutableLiveData) {
        Intrinsics.checkNotNullParameter(mutableLiveData, (String)"<set-?>");
        this.responseId = mutableLiveData;
    }

    public final void updateContent(@NotNull GPHContent content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.clear();
        this.gifTrackingManager.reset();
        this.content = content;
        this.gifsAdapter.setMediaType(content.getMediaType());
        this.loadGifs(NetworkState.Companion.getLOADING_INITIAL());
    }

    private final getPostComparator.1 getPostComparator() {
        return new DiffUtil.ItemCallback<SmartItemData>(){

            public boolean areItemsTheSame(@NotNull SmartItemData oldItem, @NotNull SmartItemData newItem) {
                Intrinsics.checkNotNullParameter((Object)oldItem, (String)"oldItem");
                Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
                return oldItem.getViewType() == newItem.getViewType() && Intrinsics.areEqual((Object)oldItem.getData(), (Object)newItem.getData());
            }

            @SuppressLint(value={"DiffUtilEquals"})
            public boolean areContentsTheSame(@NotNull SmartItemData oldItem, @NotNull SmartItemData newItem) {
                Intrinsics.checkNotNullParameter((Object)oldItem, (String)"oldItem");
                Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
                return oldItem.getViewType() == newItem.getViewType() && Intrinsics.areEqual((Object)oldItem.getData(), (Object)newItem.getData());
            }
        };
    }

    @NotNull
    public final SmartGridAdapter getGifsAdapter() {
        return this.gifsAdapter;
    }

    private final void updateGridTypeIfNeeded() {
        RecyclerView.LayoutManager layoutManager;
        RecyclerView.LayoutManager layoutManager2;
        LinearLayoutManager it;
        boolean bl;
        boolean bl2;
        Object object;
        boolean requiresUpdate = false;
        RecyclerView.LayoutManager layoutManager3 = this.getLayoutManager();
        if (!(layoutManager3 instanceof LinearLayoutManager)) {
            layoutManager3 = null;
        }
        LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager3;
        if (linearLayoutManager != null) {
            object = linearLayoutManager;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl3 = false;
            requiresUpdate = this.orientation != it.getOrientation();
        }
        if (!((layoutManager2 = this.getLayoutManager()) instanceof GridLayoutManager)) {
            layoutManager2 = null;
        }
        GridLayoutManager gridLayoutManager = (GridLayoutManager)layoutManager2;
        if (gridLayoutManager != null) {
            object = gridLayoutManager;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl4 = false;
            requiresUpdate = this.spanCount != it.getSpanCount();
        }
        if (!((layoutManager = this.getLayoutManager()) instanceof WrapStaggeredGridLayoutManager)) {
            layoutManager = null;
        }
        WrapStaggeredGridLayoutManager wrapStaggeredGridLayoutManager = (WrapStaggeredGridLayoutManager)layoutManager;
        if (wrapStaggeredGridLayoutManager != null) {
            object = wrapStaggeredGridLayoutManager;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl5 = false;
            requiresUpdate = this.orientation != it.getOrientation() || this.spanCount != it.getSpanCount();
        }
        Timber.d((String)("updateGridTypeIfNeeded requiresUpdate=" + requiresUpdate), (Object[])new Object[0]);
        if (requiresUpdate) {
            this.configureRecyclerViewForGridType();
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void configureRecyclerViewForGridType() {
        Timber.d((String)"configureRecyclerViewForGridType", (Object[])new Object[0]);
        v0 = this.contentType;
        if (v0 == null) ** GOTO lbl-1000
        switch (SmartGridRecyclerView$WhenMappings.$EnumSwitchMapping$1[v0.ordinal()]) {
            case 1: {
                gridLayoutManager = new GridLayoutManager(this.getContext(), this.spanCount, this.orientation, false);
                gridLayoutManager.setSpanSizeLookup((GridLayoutManager.SpanSizeLookup)this.getSpanSizeLookup());
                this.setLayoutManager((RecyclerView.LayoutManager)gridLayoutManager);
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                this.setLayoutManager((RecyclerView.LayoutManager)new WrapStaggeredGridLayoutManager(this.spanCount, this.orientation));
            }
        }
        this.updateItemDecorations();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void updateItemDecorations() {
        while (this.getItemDecorationCount() > 0) {
            this.removeItemDecorationAt(0);
        }
        GPHContentType gPHContentType = this.contentType;
        if (gPHContentType != null) {
            switch (SmartGridRecyclerView$WhenMappings.$EnumSwitchMapping$2[gPHContentType.ordinal()]) {
                case 1: {
                    this.addItemDecoration(this.createItemDecorationForGrid(this.spanCount));
                    return;
                }
            }
        }
        this.addItemDecoration(this.createItemDecorationForStaggered());
    }

    private final void loadNextPage(int aroundPosition) {
        Timber.d((String)("loadNextPage aroundPosition=" + aroundPosition), (Object[])new Object[0]);
        this.post(new Runnable(this){
            final /* synthetic */ SmartGridRecyclerView this$0;

            public final void run() {
                block4: {
                    block3: {
                        if (SmartGridRecyclerView.access$getContentLoading$p(this.this$0)) break block3;
                        GPHContent gPHContent = SmartGridRecyclerView.access$getContent$p(this.this$0);
                        if (gPHContent == null) break block4;
                        if (gPHContent.getHasPagination()) break block4;
                    }
                    return;
                }
                if (Intrinsics.areEqual((Object)((NetworkState)this.this$0.getNetworkState().getValue()), (Object)NetworkState.Companion.getLOADED()) || Intrinsics.areEqual((Object)((NetworkState)this.this$0.getNetworkState().getValue()), (Object)NetworkState.Companion.getLOADED_INITIAL())) {
                    Collection collection = this.this$0.getContentItems();
                    boolean bl = false;
                    if (!collection.isEmpty()) {
                        SmartGridRecyclerView.access$loadGifs(this.this$0, NetworkState.Companion.getLOADING());
                    }
                }
            }
            {
                this.this$0 = smartGridRecyclerView;
            }
        });
    }

    private final void loadGifs(NetworkState state) {
        GPHContent gPHContent;
        Timber.d((String)("loadGifs " + (Object)((Object)state.getStatus())), (Object[])new Object[0]);
        this.networkState.setValue((Object)state);
        this.updateNetworkState();
        if (Intrinsics.areEqual((Object)state, (Object)NetworkState.Companion.getLOADING_INITIAL())) {
            this.contentItems.clear();
            Future<?> future = this.runningQuery;
            if (future != null) {
                future.cancel(true);
            }
            this.runningQuery = null;
        }
        Timber.d((String)("loadGifs " + state + " offset=" + this.contentItems.size()), (Object[])new Object[0]);
        this.contentLoading = true;
        GPHContent gPHContent2 = this.content;
        GPHRequestType requestType = gPHContent2 != null ? gPHContent2.getRequestType() : null;
        Future<?> future = this.runningQuery;
        if (future != null) {
            future.cancel(true);
        }
        this.runningQuery = (gPHContent = this.content) != null && (gPHContent = gPHContent.withApiClient$giphy_ui_2_1_16_release(this.apiClient)) != null ? gPHContent.queryGifs(this.contentItems.size(), (CompletionHandler<? super ListMediaResponse>)new CompletionHandler<ListMediaResponse>(this, state, requestType){
            final /* synthetic */ SmartGridRecyclerView this$0;
            final /* synthetic */ NetworkState $state;
            final /* synthetic */ GPHRequestType $requestType;

            /*
             * Unable to fully structure code
             */
            public void onComplete(@Nullable ListMediaResponse result, @Nullable Throwable e) {
                block28: {
                    block26: {
                        block27: {
                            block25: {
                                if (e instanceof ApiException && ((ApiException)e).getErrorResponse().getMeta().getStatus() == 422) break block25;
                                v0 = result;
                                if ((v0 != null ? v0.getData() : null) == null) break block26;
                            }
                            this.this$0.getNetworkState().setValue((Object)(Intrinsics.areEqual((Object)((NetworkState)this.this$0.getNetworkState().getValue()), (Object)NetworkState.Companion.getLOADING_INITIAL()) != false ? NetworkState.Companion.getLOADED_INITIAL() : NetworkState.Companion.getLOADED()));
                            Timber.d((String)("loadGifs " + this.$state + " newGifCount=" + ((v1 = result) != null && (v1 = v1.getData()) != null ? Integer.valueOf(v1.size()) : null)), (Object[])new Object[0]);
                            this.this$0.getFooterItems().clear();
                            v2 = result;
                            if (v2 != null && (v2 = v2.getData()) != null) {
                                var3_3 = v2;
                                var4_5 = false;
                                var5_7 = false;
                                it = var3_3;
                                $i$a$-let-SmartGridRecyclerView$loadGifs$1$onComplete$1 = false;
                                mediaList = it;
                                v3 = this.this$0.getGifsAdapter().getAdapterHelper().getGphSettings();
                                v4 = enableDynamicText = v3 != null ? v3.getEnableDynamicText() : false;
                                if (!enableDynamicText) {
                                    $this$filter$iv = (Iterable)mediaList;
                                    $i$f$filter = false;
                                    var12_27 = $this$filter$iv;
                                    destination$iv$iv = new ArrayList<E>();
                                    $i$f$filterTo = false;
                                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                                        it = (Media)element$iv$iv;
                                        $i$a$-filter-SmartGridRecyclerView$loadGifs$1$onComplete$1$1 = false;
                                        if (!(it.isDynamic() == false)) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    mediaList = (List)destination$iv$iv;
                                }
                                isAllDynamic = SmartGridRecyclerView.access$isAllDynamic(this.this$0, (List)mediaList);
                                $i$f$filter = (Iterable)mediaList;
                                var19_47 = this.this$0.getContentItems();
                                $i$f$map = false;
                                destination$iv$iv = $this$map$iv;
                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                $i$f$mapTo = false;
                                for (E item$iv$iv : $this$mapTo$iv$iv) {
                                    $i$a$-filter-SmartGridRecyclerView$loadGifs$1$onComplete$1$1 = (Media)item$iv$iv;
                                    var20_48 = destination$iv$iv;
                                    $i$a$-map-SmartGridRecyclerView$loadGifs$1$onComplete$1$2 = false;
                                    viewType = null;
                                    viewType = isAllDynamic != false ? SmartItemType.DynamicText : (it.isDynamic() != false ? SmartItemType.DynamicTextWithMoreByYou : (MediaExtensionKt.isVideo((Media)it) != false ? SmartItemType.Video : SmartItemType.Gif));
                                    var23_52 = new SmartItemData(viewType, it, 0, 4, null);
                                    var20_48.add(var23_52);
                                }
                                var20_48 = (List)destination$iv$iv;
                                var19_47.addAll(var20_48);
                                v5 = SmartGridRecyclerView.access$getContent$p(this.this$0);
                                if (v5 == null || (v5 = v5.getSearchQuery()) == null) {
                                    v5 = "";
                                }
                                searchQuery = v5;
                                v6 = (SmartItemData)CollectionsKt.firstOrNull((List)this.this$0.getContentItems());
                                v7 = v6 != null ? v6.getData() : null;
                                if (!(v7 instanceof Media)) {
                                    v7 = null;
                                }
                                v8 = (Media)v7;
                                user = v8 != null ? v8.getUser() : null;
                                $this$filter$iv = this.this$0.getContentItems();
                                $i$f$filter = false;
                                element$iv$iv = $this$filter$iv;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$filterTo = false;
                                for (T element$iv$iv : $this$filterTo$iv$iv) {
                                    it = (SmartItemData)element$iv$iv;
                                    $i$a$-filter-SmartGridRecyclerView$loadGifs$1$onComplete$1$filteredByUser$1 = false;
                                    v9 = it.getData();
                                    if (!(v9 instanceof Media)) {
                                        v9 = null;
                                    }
                                    v10 = user;
                                    v11 = (Media)v9;
                                    if (!Intrinsics.areEqual((Object)(v11 != null && (v11 = v11.getUser()) != null ? v11.getUsername() : null), (Object)(v10 != null ? v10.getUsername() : null))) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                filteredByUser = (List)destination$iv$iv;
                                v12 = this.this$0.getGifsAdapter().getAdapterHelper().getGphSettings();
                                if (v12 != null) {
                                    if (v12.getEnablePartnerProfiles()) {
                                        v13 = StringsKt.firstOrNull((CharSequence)((CharSequence)searchQuery));
                                        if (v13 != null && v13.charValue() == '@') {
                                            var14_36 = (CharSequence)searchQuery;
                                            var15_40 = false;
                                            if (var14_36.length() > 1 && this.this$0.getContentItems().size() <= 25) {
                                                var14_36 = this.this$0.getContentItems();
                                                var15_40 = false;
                                                if (var14_36.isEmpty() == false && user != null && Intrinsics.areEqual((Object)searchQuery, (Object)("@" + user.getUsername()))) {
                                                    var14_36 = filteredByUser;
                                                    var15_40 = false;
                                                    v14 = var14_36.size();
                                                    var14_36 = this.this$0.getContentItems();
                                                    var15_40 = false;
                                                    if (v14 == var14_36.size()) {
                                                        var14_36 = user.getDisplayName();
                                                        var15_40 = false;
                                                        var16_42 = false;
                                                        if (!(var14_36 == null || StringsKt.isBlank((CharSequence)var14_36) != false)) {
                                                            var14_36 = user.getAvatarUrl();
                                                            var15_40 = false;
                                                            var16_42 = false;
                                                            if (!(var14_36 == null || StringsKt.isBlank((CharSequence)var14_36) != false)) {
                                                                CollectionsKt.removeAll((List)this.this$0.getHeaderItems(), (Function1)loadGifs.onComplete.1.3.INSTANCE);
                                                                this.this$0.getHeaderItems().add(new SmartItemData(SmartItemType.UserProfile, user, this.this$0.getSpanCount()));
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (!Intrinsics.areEqual((Object)((NetworkState)this.this$0.getNetworkState().getValue()), (Object)NetworkState.Companion.getLOADED_INITIAL()) || !this.this$0.getContentItems().isEmpty()) break block27;
                            noResultsDescription = null;
                            v15 = SmartGridRecyclerView.access$getContent$p(this.this$0);
                            v16 = v15 != null ? v15.getMediaType() : null;
                            if (v16 == null) ** GOTO lbl-1000
                            switch (SmartGridRecyclerView$WhenMappings.$EnumSwitchMapping$3[v16.ordinal()]) {
                                case 1: {
                                    v17 = this.this$0.getContext().getString(R.string.gph_error_no_stickers_found);
                                    Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"context.getString(R.stri\u2026_error_no_stickers_found)");
                                    noResultsDescription = v17;
                                    break;
                                }
                                case 2: {
                                    v18 = this.this$0.getContext().getString(R.string.gph_error_no_texts_found);
                                    Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"context.getString(R.stri\u2026gph_error_no_texts_found)");
                                    noResultsDescription = v18;
                                    break;
                                }
                                case 3: {
                                    v19 = this.this$0.getContext().getString(R.string.gph_error_no_clips_found);
                                    Intrinsics.checkNotNullExpressionValue((Object)v19, (String)"context.getString(R.stri\u2026gph_error_no_clips_found)");
                                    noResultsDescription = v19;
                                    break;
                                }
                                default: lbl-1000:
                                // 2 sources

                                {
                                    v20 = this.this$0.getContext().getString(R.string.gph_error_no_gifs_found);
                                    Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"context.getString(R.stri\u2026.gph_error_no_gifs_found)");
                                    noResultsDescription = v20;
                                }
                            }
                            this.this$0.getFooterItems().add(new SmartItemData(SmartItemType.NoResults, noResultsDescription, this.this$0.getSpanCount()));
                        }
                        if ((v21 = result) != null && (v21 = v21.getMeta()) != null) {
                            var3_3 = v21;
                            var4_5 = false;
                            var5_7 = false;
                            it = var3_3;
                            $i$a$-let-SmartGridRecyclerView$loadGifs$1$onComplete$2 = false;
                            this.this$0.getResponseId().setValue((Object)it.getResponseId());
                        }
                        this.this$0.refreshItems();
                        return;
                    }
                    if (this.$requestType == GPHRequestType.recents) {
                        this.this$0.getFooterItems().clear();
                        this.this$0.getFooterItems().add(new SmartItemData(SmartItemType.NoResults, this.this$0.getContext().getString(R.string.gph_error_no_recent_found), this.this$0.getSpanCount()));
                        this.this$0.refreshItems();
                        return;
                    }
                    v22 = e;
                    if (v22 == null) break block28;
                    var3_4 = v22;
                    var4_6 = false;
                    var5_8 = false;
                    it = var3_4;
                    $i$a$-let-SmartGridRecyclerView$loadGifs$1$onComplete$3 = false;
                    v23 = this.this$0.getNetworkState();
                    if (Intrinsics.areEqual((Object)((NetworkState)this.this$0.getNetworkState().getValue()), (Object)NetworkState.Companion.getLOADING_INITIAL())) {
                        var8_14 = NetworkState.Companion.errorInitial(e.getMessage());
                        var9_17 = false;
                        var10_21 = false;
                        searchQuery = var8_14;
                        var12_30 = v23;
                        $i$a$-apply-SmartGridRecyclerView$loadGifs$1$onComplete$3$1 = false;
                        $this$apply.setCallableAction((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0){

                            public final void invoke() {
                                ((SmartGridRecyclerView)((Object)this.receiver)).refresh();
                            }
                        }));
                        var14_37 = Unit.INSTANCE;
                        v24 = var12_30;
                        v25 = var8_14;
                    } else {
                        var8_15 = NetworkState.Companion.error(e.getMessage());
                        var9_18 = false;
                        var10_22 = false;
                        $this$apply = var8_15;
                        var12_31 = v23;
                        $i$a$-apply-SmartGridRecyclerView$loadGifs$1$onComplete$3$2 = false;
                        $this$apply.setCallableAction((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0){

                            public final void invoke() {
                                ((SmartGridRecyclerView)((Object)this.receiver)).refresh();
                            }
                        }));
                        var14_38 = Unit.INSTANCE;
                        v24 = var12_31;
                        v25 = var8_15;
                    }
                    v24.setValue((Object)v25);
                    SmartGridRecyclerView.access$updateNetworkState(this.this$0);
                    this.this$0.refreshItems();
                }
            }
            {
                this.this$0 = this$0;
                this.$state = $captured_local_variable$1;
                this.$requestType = $captured_local_variable$2;
            }
        }) : null;
    }

    private final boolean isAllDynamic(List<Media> list) {
        int n;
        block2: {
            List<Media> $this$indexOfFirst$iv = list;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<Media> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                Media item$iv;
                Media it = item$iv = iterator.next();
                boolean bl = false;
                if (!it.isDynamic()) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n == -1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isAllDynamic() {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable iterable = this.contentItems;
        SmartGridRecyclerView smartGridRecyclerView = this;
        boolean $i$f$mapNotNull = false;
        void var3_4 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Media media2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SmartItemData it = (SmartItemData)element$iv$iv;
            boolean bl2 = false;
            Object object = it.getData();
            if (!(object instanceof Media)) {
                object = null;
            }
            if ((Media)object == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Media it$iv$iv = media2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return smartGridRecyclerView.isAllDynamic(list);
    }

    private final void updateNetworkState() {
        Timber.d((String)"updateNetworkState", (Object[])new Object[0]);
        this.footerItems.clear();
        this.footerItems.add(new SmartItemData(SmartItemType.NetworkState, this.networkState.getValue(), this.spanCount));
    }

    public final void refreshItems() {
        Timber.d((String)("refreshItems " + this.headerItems.size() + ' ' + this.contentItems.size() + ' ' + this.footerItems.size()), (Object[])new Object[0]);
        ArrayList items = new ArrayList();
        items.addAll(this.headerItems);
        items.addAll(this.contentItems);
        items.addAll(this.footerItems);
        this.gifsAdapter.submitList(items, new Runnable(this){
            final /* synthetic */ SmartGridRecyclerView this$0;

            public final void run() {
                SmartGridRecyclerView.access$setContentLoading$p(this.this$0, false);
                int response = this.this$0.getContentItems().size();
                if (this.this$0.getContentItems().isEmpty()) {
                    SmartItemData smartItemData = (SmartItemData)CollectionsKt.firstOrNull((List)this.this$0.getFooterItems());
                    if ((smartItemData != null ? smartItemData.getViewType() : null) == SmartItemType.NetworkState) {
                        response = -1;
                    }
                }
                this.this$0.getOnResultsUpdateListener().invoke((Object)response);
                this.this$0.getGifTrackingManager$giphy_ui_2_1_16_release().updateTracking();
            }
            {
                this.this$0 = smartGridRecyclerView;
            }
        });
    }

    private final getSpanSizeLookup.1 getSpanSizeLookup() {
        return new GridLayoutManager.SpanSizeLookup(this){
            final /* synthetic */ SmartGridRecyclerView this$0;

            public int getSpanSize(int position) {
                return this.this$0.getGifsAdapter().getSpanCountForPosition(position);
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    private final RecyclerView.ItemDecoration createItemDecorationForGrid(int spanCount) {
        return new RecyclerView.ItemDecoration(this, spanCount){
            final /* synthetic */ SmartGridRecyclerView this$0;
            final /* synthetic */ int $spanCount;

            public void getItemOffsets(@NotNull Rect outRect, @NotNull View view, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
                Intrinsics.checkNotNullParameter((Object)outRect, (String)"outRect");
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
                if (layoutParams == null) {
                    throw new NullPointerException("null cannot be cast to non-null type androidx.recyclerview.widget.GridLayoutManager.LayoutParams");
                }
                GridLayoutManager.LayoutParams layoutParams2 = (GridLayoutManager.LayoutParams)layoutParams;
                int itemSpanIndex = layoutParams2.getSpanIndex();
                outRect.set(itemSpanIndex == 0 && this.$spanCount < 3 ? 0 : this.this$0.getCellPadding() / 2, 0, itemSpanIndex == this.$spanCount - 1 && this.$spanCount < 3 ? 0 : this.this$0.getCellPadding() / 2, this.this$0.getCellPadding());
            }
            {
                this.this$0 = this$0;
                this.$spanCount = $captured_local_variable$1;
            }
        };
    }

    private final RecyclerView.ItemDecoration createItemDecorationForStaggered() {
        return new RecyclerView.ItemDecoration(this){
            private final int borderSizePx;
            final /* synthetic */ SmartGridRecyclerView this$0;

            public final int getBorderSizePx() {
                return this.borderSizePx;
            }

            public void getItemOffsets(@NotNull Rect outRect, @NotNull View view, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
                Intrinsics.checkNotNullParameter((Object)outRect, (String)"outRect");
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                boolean disableMarginForProfileItem = false;
                RecyclerView.Adapter adapter = parent.getAdapter();
                if (adapter != null) {
                    RecyclerView.Adapter adapter2 = adapter;
                    boolean bl = false;
                    boolean bl2 = false;
                    RecyclerView.Adapter it = adapter2;
                    boolean bl3 = false;
                    int position = parent.getChildAdapterPosition(view);
                    if (it.getItemViewType(position) == SmartItemType.UserProfile.ordinal()) {
                        disableMarginForProfileItem = true;
                    }
                }
                ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
                if (layoutParams == null) {
                    throw new NullPointerException("null cannot be cast to non-null type androidx.recyclerview.widget.StaggeredGridLayoutManager.LayoutParams");
                }
                StaggeredGridLayoutManager.LayoutParams layoutParams2 = (StaggeredGridLayoutManager.LayoutParams)layoutParams;
                int itemSpanIndex = layoutParams2.getSpanIndex();
                outRect.set(itemSpanIndex == 0 && this.this$0.getSpanCount() < 3 || disableMarginForProfileItem ? 0 : this.borderSizePx / 2, 0, itemSpanIndex == this.this$0.getSpanCount() - 1 && this.this$0.getSpanCount() < 3 || disableMarginForProfileItem ? 0 : this.borderSizePx / 2, this.borderSizePx);
            }
            {
                this.this$0 = this$0;
                this.borderSizePx = this$0.getCellPadding();
            }
        };
    }

    public final void clear() {
        this.contentItems.clear();
        this.headerItems.clear();
        this.footerItems.clear();
        this.gifsAdapter.submitList(null);
    }

    public final void refresh() {
        block0: {
            GPHContent gPHContent = this.content;
            if (gPHContent == null) break block0;
            GPHContent gPHContent2 = gPHContent;
            boolean bl = false;
            boolean bl2 = false;
            GPHContent it = gPHContent2;
            boolean bl3 = false;
            this.updateContent(it);
        }
    }

    public final boolean emptyResults() {
        return this.contentItems.isEmpty();
    }

    public void requestLayout() {
        super.requestLayout();
        if (!this.mRequestedLayout) {
            this.mRequestedLayout = true;
            this.post(new Runnable(this){
                final /* synthetic */ SmartGridRecyclerView this$0;

                public final void run() {
                    SmartGridRecyclerView.access$setMRequestedLayout$p(this.this$0, false);
                    this.this$0.layout(this.this$0.getLeft(), this.this$0.getTop(), this.this$0.getRight(), this.this$0.getBottom());
                    SmartGridRecyclerView.access$onLayout(this.this$0, false, this.this$0.getLeft(), this.this$0.getTop(), this.this$0.getRight(), this.this$0.getBottom());
                }
                {
                    this.this$0 = smartGridRecyclerView;
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public SmartGridRecyclerView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.headerItems = new ArrayList();
        this.contentItems = new ArrayList();
        this.footerItems = new ArrayList();
        this.apiClient = GiphyCore.INSTANCE.getApiClient();
        this.gifTrackingManager = new GifTrackingManager(true);
        this.orientation = 1;
        this.spanCount = 2;
        this.cellPadding = -1;
        this.gridType = GridType.waterfall;
        this.onResultsUpdateListener = onResultsUpdateListener.1.INSTANCE;
        this.networkState = new MutableLiveData();
        this.responseId = new MutableLiveData();
        SmartGridAdapter smartGridAdapter = new SmartGridAdapter(context, (DiffUtil.ItemCallback<SmartItemData>)((DiffUtil.ItemCallback)this.getPostComparator()));
        boolean bl = false;
        boolean bl2 = false;
        SmartGridAdapter smartGridAdapter2 = smartGridAdapter;
        SmartGridRecyclerView smartGridRecyclerView = this;
        boolean bl3 = false;
        $this$apply.setLoadingTrigger((Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this){

            public final void invoke(int p1) {
                SmartGridRecyclerView.access$loadNextPage((SmartGridRecyclerView)((Object)this.receiver), p1);
            }
        }));
        $this$apply.setUpdateTracking((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ SmartGridRecyclerView this$0;
            {
                this.this$0 = smartGridRecyclerView;
                super(0);
            }

            public final void invoke() {
                this.this$0.getGifTrackingManager$giphy_ui_2_1_16_release().updateTracking();
            }
        }));
        Unit unit = Unit.INSTANCE;
        smartGridRecyclerView.gifsAdapter = smartGridAdapter;
        if (this.cellPadding == -1) {
            this.setCellPadding(this.getResources().getDimensionPixelSize(R.dimen.gph_gif_border_size));
        }
        this.configureRecyclerViewForGridType();
        this.setAdapter((RecyclerView.Adapter)this.gifsAdapter);
        this.gifTrackingManager.attachToRecyclerView(this, this.gifsAdapter);
    }

    public /* synthetic */ SmartGridRecyclerView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public SmartGridRecyclerView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public SmartGridRecyclerView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ boolean access$getContentLoading$p(SmartGridRecyclerView $this) {
        return $this.contentLoading;
    }

    public static final /* synthetic */ void access$setContentLoading$p(SmartGridRecyclerView $this, boolean bl) {
        $this.contentLoading = bl;
    }

    public static final /* synthetic */ GPHContent access$getContent$p(SmartGridRecyclerView $this) {
        return $this.content;
    }

    public static final /* synthetic */ void access$setContent$p(SmartGridRecyclerView $this, GPHContent gPHContent) {
        $this.content = gPHContent;
    }

    public static final /* synthetic */ void access$loadGifs(SmartGridRecyclerView $this, NetworkState state) {
        $this.loadGifs(state);
    }

    public static final /* synthetic */ boolean access$isAllDynamic(SmartGridRecyclerView $this, List list) {
        return $this.isAllDynamic(list);
    }

    public static final /* synthetic */ void access$updateNetworkState(SmartGridRecyclerView $this) {
        $this.updateNetworkState();
    }

    public static final /* synthetic */ boolean access$getMRequestedLayout$p(SmartGridRecyclerView $this) {
        return $this.mRequestedLayout;
    }

    public static final /* synthetic */ void access$setMRequestedLayout$p(SmartGridRecyclerView $this, boolean bl) {
        $this.mRequestedLayout = bl;
    }

    public static final /* synthetic */ void access$onLayout(SmartGridRecyclerView $this, boolean p0, int p1, int p2, int p3, int p4) {
        $this.onLayout(p0, p1, p2, p3, p4);
    }

    public static final /* synthetic */ void access$loadNextPage(SmartGridRecyclerView $this, int aroundPosition) {
        $this.loadNextPage(aroundPosition);
    }
}

