/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.tracking;

import android.graphics.Rect;
import android.util.Log;
import android.view.View;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.giphy.sdk.analytics.GiphyPingbacks;
import com.giphy.sdk.analytics.batching.PingbackCollector;
import com.giphy.sdk.analytics.models.Attribute;
import com.giphy.sdk.analytics.models.enums.ActionType;
import com.giphy.sdk.analytics.models.enums.EventType;
import com.giphy.sdk.core.models.Media;
import com.giphy.sdk.tracking.GifTrackingCallback;
import com.giphy.sdk.tracking.GifTrackingManager;
import com.giphy.sdk.tracking.GifVisibilityListener;
import com.giphy.sdk.tracking.MediaExtensionKt;
import com.giphy.sdk.tracking.PingbacksDeduplicator;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0083\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\b\b\u0010\u0018\u0000 B2\u00020\u0001:\u0001BB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000eJ\u0016\u0010-\u001a\u00020+2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010.\u001a\u00020+J\u0006\u0010/\u001a\u00020+J\u0006\u00100\u001a\u00020+J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u00105\u001a\u0004\u0018\u000106H\u0002J\u000e\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u000209J\u000e\u0010:\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000eJ\u0006\u0010;\u001a\u00020+J\u0018\u0010<\u001a\u00020+2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0016J\u0006\u0010A\u001a\u00020+R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0013\"\u0004\b \u0010\u0015R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010\u0004R\u000e\u0010&\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0013\"\u0004\b)\u0010\u0015\u00a8\u0006C"}, d2={"Lcom/giphy/sdk/tracking/GifTrackingManager;", "", "trackPingbacks", "", "(Z)V", "drawingRect", "Landroid/graphics/Rect;", "getRecyclerScrollListener", "com/giphy/sdk/tracking/GifTrackingManager$getRecyclerScrollListener$1", "Lcom/giphy/sdk/tracking/GifTrackingManager$getRecyclerScrollListener$1;", "gifTrackingCallback", "Lcom/giphy/sdk/tracking/GifTrackingCallback;", "gifVisibilityListeners", "", "Lcom/giphy/sdk/tracking/GifVisibilityListener;", "globalRect", "layoutType", "", "getLayoutType", "()Ljava/lang/String;", "setLayoutType", "(Ljava/lang/String;)V", "pingbackCollector", "Lcom/giphy/sdk/analytics/batching/PingbackCollector;", "getPingbackCollector", "()Lcom/giphy/sdk/analytics/batching/PingbackCollector;", "setPingbackCollector", "(Lcom/giphy/sdk/analytics/batching/PingbackCollector;)V", "pingbacksDeduplicator", "Lcom/giphy/sdk/tracking/PingbacksDeduplicator;", "placement", "getPlacement", "setPlacement", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "getTrackPingbacks", "()Z", "setTrackPingbacks", "trackSessions", "userId", "getUserId", "setUserId", "addGifVisibilityListener", "", "gifVisibilityListener", "attachToRecyclerView", "detach", "disableTracking", "enableTracking", "getCellVisibility", "", "view", "Landroid/view/View;", "layoutManager", "Landroidx/recyclerview/widget/RecyclerView$LayoutManager;", "isMediaLoadedForIndex", "position", "", "removeGifVisibilityListener", "reset", "trackMedia", "media", "Lcom/giphy/sdk/core/models/Media;", "actionType", "Lcom/giphy/sdk/analytics/models/enums/ActionType;", "updateTracking", "Companion", "giphy-ui-2.1.16_release"})
public class GifTrackingManager {
    private RecyclerView recyclerView;
    private final Rect globalRect;
    private final Rect drawingRect;
    private GifTrackingCallback gifTrackingCallback;
    private final List<GifVisibilityListener> gifVisibilityListeners;
    private PingbacksDeduplicator pingbacksDeduplicator;
    private boolean trackSessions;
    @NotNull
    private PingbackCollector pingbackCollector;
    @NotNull
    private String userId;
    @Nullable
    private String layoutType;
    @Nullable
    private String placement;
    private final getRecyclerScrollListener.1 getRecyclerScrollListener;
    private boolean trackPingbacks;
    private static final String TAG;
    @NotNull
    private static String versionString;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final PingbackCollector getPingbackCollector() {
        return this.pingbackCollector;
    }

    public final void setPingbackCollector(@NotNull PingbackCollector pingbackCollector) {
        Intrinsics.checkNotNullParameter((Object)pingbackCollector, (String)"<set-?>");
        this.pingbackCollector = pingbackCollector;
    }

    @NotNull
    public final String getUserId() {
        return this.userId;
    }

    public final void setUserId(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.userId = string2;
    }

    @Nullable
    public final String getLayoutType() {
        return this.layoutType;
    }

    public final void setLayoutType(@Nullable String string2) {
        this.layoutType = string2;
    }

    @Nullable
    public final String getPlacement() {
        return this.placement;
    }

    public final void setPlacement(@Nullable String string2) {
        this.placement = string2;
    }

    public final boolean isMediaLoadedForIndex(int position) {
        GifTrackingCallback gifTrackingCallback = this.gifTrackingCallback;
        return gifTrackingCallback != null && gifTrackingCallback.isMediaLoadedForIndex(position, (Function0<Unit>)((Function0)new Function0<Unit>(this){

            public final void invoke() {
                ((GifTrackingManager)this.receiver).updateTracking();
            }
        }));
    }

    public final void attachToRecyclerView(@NotNull RecyclerView recyclerView, @NotNull GifTrackingCallback gifTrackingCallback) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)gifTrackingCallback, (String)"gifTrackingCallback");
        this.recyclerView = recyclerView;
        this.gifTrackingCallback = gifTrackingCallback;
        recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this.getRecyclerScrollListener);
        this.layoutType = this.getLayoutType(recyclerView.getLayoutManager());
    }

    public final void detach() {
        RecyclerView recyclerView = this.recyclerView;
        if (recyclerView != null) {
            recyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this.getRecyclerScrollListener);
        }
        this.recyclerView = null;
        this.layoutType = null;
    }

    public final void disableTracking() {
        this.trackSessions = false;
    }

    public final void enableTracking() {
        this.trackSessions = true;
    }

    public final void addGifVisibilityListener(@NotNull GifVisibilityListener gifVisibilityListener) {
        Intrinsics.checkNotNullParameter((Object)gifVisibilityListener, (String)"gifVisibilityListener");
        this.gifVisibilityListeners.add(gifVisibilityListener);
    }

    public final void removeGifVisibilityListener(@NotNull GifVisibilityListener gifVisibilityListener) {
        Intrinsics.checkNotNullParameter((Object)gifVisibilityListener, (String)"gifVisibilityListener");
        this.gifVisibilityListeners.remove(gifVisibilityListener);
    }

    private final String getLayoutType(RecyclerView.LayoutManager layoutManager) {
        RecyclerView.LayoutManager layoutManager2 = layoutManager;
        return layoutManager2 instanceof LinearLayoutManager ? Attribute.Companion.getLAYOUT_TYPE_CAROUSEL() : (layoutManager2 instanceof GridLayoutManager ? Attribute.Companion.getLAYOUT_TYPE_GRID() : (layoutManager2 instanceof StaggeredGridLayoutManager ? Attribute.Companion.getLAYOUT_TYPE_GRID() : null));
    }

    /*
     * WARNING - void declaration
     */
    public final void updateTracking() {
        if (!this.trackSessions) {
            return;
        }
        Log.d((String)TAG, (String)"updateTracking");
        RecyclerView recyclerView = this.recyclerView;
        if (recyclerView != null) {
            RecyclerView recyclerView2 = recyclerView;
            boolean bl = false;
            boolean bl2 = false;
            RecyclerView recyclerView3 = recyclerView2;
            boolean bl3 = false;
            int n = 0;
            int n2 = recyclerView3.getChildCount();
            while (n < n2) {
                void i;
                View view = recyclerView3.getChildAt((int)i);
                int position = recyclerView3.getChildAdapterPosition(recyclerView3.getChildAt((int)i));
                if (position != -1 && this.isMediaLoadedForIndex(position)) {
                    Media media2;
                    GifTrackingCallback gifTrackingCallback = this.gifTrackingCallback;
                    Media media3 = media2 = gifTrackingCallback != null ? gifTrackingCallback.mediaForIndex(position) : null;
                    if (media2 != null) {
                        Media media4;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        Media trackedMedia = media4;
                        boolean bl6 = false;
                        View view2 = view;
                        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view");
                        float visiblePercent = this.getCellVisibility(view2);
                        if (this.trackPingbacks && visiblePercent == 1.0f) {
                            this.trackMedia(trackedMedia, ActionType.SEEN);
                        }
                        Iterable $this$forEach$iv = this.gifVisibilityListeners;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            GifVisibilityListener visibilityListener = (GifVisibilityListener)element$iv;
                            boolean bl7 = false;
                            visibilityListener.onVisible(position, trackedMedia, view, visiblePercent);
                        }
                    }
                }
                ++i;
            }
        }
    }

    public void trackMedia(@NotNull Media media2, @NotNull ActionType actionType) {
        block6: {
            int n;
            CharSequence charSequence;
            block5: {
                Intrinsics.checkNotNullParameter((Object)media2, (String)"media");
                Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
                charSequence = media2.getAnalyticsResponsePayload();
                n = 0;
                boolean bl = false;
                if (charSequence == null || charSequence.length() == 0) {
                    return;
                }
                if (actionType != ActionType.SEEN) break block5;
                String string2 = media2.getId();
                String string3 = MediaExtensionKt.getResponseId(media2);
                if (string3 == null) {
                    string3 = "";
                }
                if (!this.pingbacksDeduplicator.trackNeeded(string2, string3)) break block6;
            }
            Integer n2 = MediaExtensionKt.getPosition(media2);
            charSequence = this.placement;
            n = n2 != null ? n2 : -1;
            String string4 = this.layoutType;
            String string5 = null;
            String string6 = null;
            ActionType actionType2 = actionType;
            String string7 = media2.getTid();
            EventType eventType = MediaExtensionKt.getEventType(media2);
            String string8 = media2.getId();
            this.pingbackCollector.addPingback(this.userId, media2.getAnalyticsResponsePayload(), string6, eventType, string8, string7, actionType2, string5, string4, n, (String)charSequence);
        }
    }

    private final float getCellVisibility(View view) {
        float f;
        if (!view.getGlobalVisibleRect(this.globalRect)) {
            return 0.0f;
        }
        view.getHitRect(this.drawingRect);
        int visibleViewArea = this.globalRect.width() * this.globalRect.height();
        int totalViewArea = this.drawingRect.width() * this.drawingRect.height();
        float visibility = (float)visibleViewArea / (float)totalViewArea;
        if (totalViewArea <= 0) {
            f = 0.0f;
        } else {
            float f2 = 1.0f;
            boolean bl = false;
            f = Math.min(visibility, f2);
        }
        return f;
    }

    public final void reset() {
        if (!this.trackSessions) {
            return;
        }
        this.pingbacksDeduplicator.reset();
        Iterable $this$forEach$iv = this.gifVisibilityListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GifVisibilityListener it = (GifVisibilityListener)element$iv;
            boolean bl = false;
            it.reset();
        }
    }

    public final boolean getTrackPingbacks() {
        return this.trackPingbacks;
    }

    public final void setTrackPingbacks(boolean bl) {
        this.trackPingbacks = bl;
    }

    public GifTrackingManager(boolean trackPingbacks) {
        this.trackPingbacks = trackPingbacks;
        this.globalRect = new Rect();
        this.drawingRect = new Rect();
        boolean bl = false;
        this.gifVisibilityListeners = new ArrayList();
        this.pingbacksDeduplicator = new PingbacksDeduplicator();
        this.trackSessions = true;
        this.pingbackCollector = GiphyPingbacks.INSTANCE.getPingbackCollector$giphy_ui_2_1_16_release();
        this.userId = "";
        this.getRecyclerScrollListener = new RecyclerView.OnScrollListener(this){
            final /* synthetic */ GifTrackingManager this$0;

            public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
                Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
                super.onScrolled(recyclerView, dx, dy);
                this.this$0.updateTracking();
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    public /* synthetic */ GifTrackingManager(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    public GifTrackingManager() {
        this(false, 1, null);
    }

    static {
        Companion = new Companion(null);
        TAG = GifTrackingManager.class.getSimpleName();
        versionString = "n/a";
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/giphy/sdk/tracking/GifTrackingManager$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "getTAG", "()Ljava/lang/String;", "versionString", "getVersionString", "setVersionString", "(Ljava/lang/String;)V", "giphy-ui-2.1.16_release"})
    public static final class Companion {
        public final String getTAG() {
            return TAG;
        }

        @NotNull
        public final String getVersionString() {
            return versionString;
        }

        public final void setVersionString(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            versionString = string2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

