/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.core.network.engine;

import android.net.Uri;
import android.util.Log;
import com.giphy.sdk.core.models.Meta;
import com.giphy.sdk.core.models.json.BooleanDeserializer;
import com.giphy.sdk.core.models.json.DateDeserializer;
import com.giphy.sdk.core.models.json.DateSerializer;
import com.giphy.sdk.core.models.json.IntDeserializer;
import com.giphy.sdk.core.models.json.MainAdapterFactory;
import com.giphy.sdk.core.network.api.GPHApiClient;
import com.giphy.sdk.core.network.engine.ApiException;
import com.giphy.sdk.core.network.engine.NetworkSession;
import com.giphy.sdk.core.network.response.ErrorResponse;
import com.giphy.sdk.core.threading.ApiTask;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.brotli.dec.BrotliInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007Jr\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00182\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001a2\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016Jh\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00182\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001a2\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001aH\u0016J3\u0010\u001f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0018H\u0002\u00a2\u0006\u0002\u0010$R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/giphy/sdk/core/network/engine/DefaultNetworkSession;", "Lcom/giphy/sdk/core/network/engine/NetworkSession;", "()V", "networkRequestExecutor", "Ljava/util/concurrent/ExecutorService;", "completionExecutor", "Ljava/util/concurrent/Executor;", "(Ljava/util/concurrent/ExecutorService;Ljava/util/concurrent/Executor;)V", "getCompletionExecutor", "()Ljava/util/concurrent/Executor;", "completionExecutor1", "getNetworkRequestExecutor", "()Ljava/util/concurrent/ExecutorService;", "networkRequestExecutor1", "postStringConnection", "Lcom/giphy/sdk/core/threading/ApiTask;", "T", "serverUrl", "Landroid/net/Uri;", "path", "", "method", "Lcom/giphy/sdk/core/network/api/GPHApiClient$HTTPMethod;", "responseClass", "Ljava/lang/Class;", "queryStrings", "", "headers", "requestBody", "", "queryStringConnection", "readJsonResponse", "url", "Ljava/net/URL;", "connection", "Ljava/net/HttpURLConnection;", "(Ljava/net/URL;Ljava/net/HttpURLConnection;Ljava/lang/Class;)Ljava/lang/Object;", "Companion", "giphy-ui-2.1.16_release"})
public final class DefaultNetworkSession
implements NetworkSession {
    private final ExecutorService networkRequestExecutor1;
    private final Executor completionExecutor1;
    private static final Gson GSON_INSTANCE;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public ExecutorService getNetworkRequestExecutor() {
        return this.networkRequestExecutor1;
    }

    @Override
    @NotNull
    public Executor getCompletionExecutor() {
        return this.completionExecutor1;
    }

    @Override
    @NotNull
    public <T> ApiTask<T> queryStringConnection(@NotNull Uri serverUrl, @Nullable String path, @NotNull GPHApiClient.HTTPMethod method, @NotNull Class<T> responseClass, @Nullable Map<String, String> queryStrings, @Nullable Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
        return this.postStringConnection(serverUrl, path, method, responseClass, queryStrings, headers, null);
    }

    @Override
    @NotNull
    public <T> ApiTask<T> postStringConnection(@NotNull Uri serverUrl, @Nullable String path, @NotNull GPHApiClient.HTTPMethod method, @NotNull Class<T> responseClass, @Nullable Map<String, String> queryStrings, @Nullable Map<String, String> headers, @Nullable Object requestBody) {
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
        return new ApiTask(new Callable<T>(this, serverUrl, path, queryStrings, method, headers, requestBody, responseClass){
            final /* synthetic */ DefaultNetworkSession this$0;
            final /* synthetic */ Uri $serverUrl;
            final /* synthetic */ String $path;
            final /* synthetic */ Map $queryStrings;
            final /* synthetic */ GPHApiClient.HTTPMethod $method;
            final /* synthetic */ Map $headers;
            final /* synthetic */ Object $requestBody;
            final /* synthetic */ Class $responseClass;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final T call() {
                HttpURLConnection connection = null;
                URL url = null;
                try {
                    Object postDataBytes;
                    boolean bl;
                    Map.Entry<K, V> entry;
                    Uri.Builder uriBuilder = this.$serverUrl.buildUpon();
                    String string = this.$path;
                    if (string != null) {
                        entry = string;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        String it = entry;
                        boolean bl4 = false;
                        uriBuilder.appendEncodedPath(this.$path);
                    }
                    if (this.$queryStrings != null) {
                        Object object = this.$queryStrings;
                        boolean it = false;
                        Iterator<Map.Entry<K, V>> iterator = object.entrySet().iterator();
                        while (iterator.hasNext()) {
                            void key;
                            Map.Entry<K, V> entry2 = entry = iterator.next();
                            bl = false;
                            object = (String)entry2.getKey();
                            entry2 = entry;
                            bl = false;
                            String value = (String)entry2.getValue();
                            uriBuilder.appendQueryParameter((String)key, value);
                        }
                    }
                    url = new URL(uriBuilder.build().toString());
                    URLConnection uRLConnection = url.openConnection();
                    if (uRLConnection == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
                    }
                    connection = (HttpURLConnection)uRLConnection;
                    connection.setRequestMethod(this.$method.name());
                    if (this.$headers != null) {
                        Object key = this.$headers;
                        boolean value = false;
                        Iterator<Map.Entry<K, V>> iterator = key.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<K, V> entry3 = entry = iterator.next();
                            bl = false;
                            key = (String)entry3.getKey();
                            entry3 = entry;
                            bl = false;
                            String value2 = (String)entry3.getValue();
                            connection.setRequestProperty((String)key, value2);
                        }
                    }
                    if (this.$method == GPHApiClient.HTTPMethod.POST) {
                        connection.setDoOutput(true);
                        connection.connect();
                        if (this.$requestBody != null) {
                            String string2 = DefaultNetworkSession.Companion.getGSON_INSTANCE().toJson(this.$requestBody);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GSON_INSTANCE.toJson(requestBody)");
                            String string3 = string2;
                            Object object = "UTF-8";
                            boolean bl5 = false;
                            Charset charset = Charset.forName((String)object);
                            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.forName(charsetName)");
                            object = charset;
                            bl5 = false;
                            String string4 = string3;
                            if (string4 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            byte[] byArray = string4.getBytes((Charset)object);
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                            postDataBytes = byArray;
                            connection.getOutputStream().write((byte[])postDataBytes);
                        }
                    } else {
                        connection.connect();
                    }
                    postDataBytes = DefaultNetworkSession.access$readJsonResponse(this.this$0, url, connection, this.$responseClass);
                    return (T)postDataBytes;
                }
                catch (Throwable t) {
                    if (!(t instanceof InterruptedIOException) && !(t instanceof InterruptedException)) {
                        String string = NetworkSession.class.getName();
                        StringBuilder stringBuilder = new StringBuilder().append("Unable to perform network request for url=");
                        URL uRL = url;
                        Intrinsics.checkNotNull((Object)uRL);
                        Log.e((String)string, (String)stringBuilder.append(uRL).toString(), (Throwable)t);
                    }
                    throw t;
                }
                finally {
                    block16: {
                        HttpURLConnection httpURLConnection = connection;
                        if (httpURLConnection == null) break block16;
                        httpURLConnection.disconnect();
                    }
                }
            }
            {
                this.this$0 = defaultNetworkSession;
                this.$serverUrl = uri;
                this.$path = string;
                this.$queryStrings = map;
                this.$method = hTTPMethod;
                this.$headers = map2;
                this.$requestBody = object;
                this.$responseClass = clazz;
            }
        }, this.getNetworkRequestExecutor(), this.getCompletionExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T readJsonResponse(URL url, HttpURLConnection connection, Class<T> responseClass) throws IOException, ApiException {
        Object encoding;
        InputStream inputStream;
        int responseCode = connection.getResponseCode();
        boolean succeeded = responseCode == 200 || responseCode == 201 || responseCode == 202;
        String contents = "";
        Map<String, List<String>> responseHeaders = connection.getHeaderFields();
        if (succeeded) {
            InputStream inputStream2 = connection.getInputStream();
            inputStream = inputStream2;
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"connection.inputStream");
        } else {
            InputStream inputStream3 = connection.getErrorStream();
            inputStream = inputStream3;
            Intrinsics.checkNotNullExpressionValue((Object)inputStream3, (String)"connection.errorStream");
        }
        InputStream stream = inputStream;
        if (responseHeaders.containsKey("Content-Encoding")) {
            List<String> list = responseHeaders.get("Content-Encoding");
            Intrinsics.checkNotNull(list);
            encoding = list;
            Thread thread = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"Thread.currentThread()");
            if (!thread.isInterrupted()) {
            } else {
                throw (Throwable)new InterruptedIOException();
            }
            stream = encoding.contains("gzip") ? (InputStream)new GZIPInputStream(stream) : (encoding.contains("br") ? (InputStream)new BrotliInputStream(stream) : stream);
        }
        encoding = stream;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)encoding;
            boolean bl3 = false;
            InputStream inputStream4 = it;
            Intrinsics.checkNotNull((Object)inputStream4);
            InputStream inputStream5 = inputStream4;
            Charset charset = Charsets.UTF_8;
            boolean bl4 = false;
            Closeable closeable = inputStream5;
            int n = 0;
            closeable = new InputStreamReader((InputStream)closeable, charset);
            n = 8192;
            boolean bl5 = false;
            contents = TextStreamsKt.readText((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)encoding, (Throwable)throwable);
        }
        if (succeeded) {
            if (!Intrinsics.areEqual(responseClass, String.class)) {
                try {
                    if (!StringsKt.startsWith$default((String)contents, (String)"{", (boolean)false, (int)2, null)) {
                        contents = "{}";
                    }
                    return (T)GSON_INSTANCE.fromJson(contents, responseClass);
                }
                catch (JsonParseException e) {
                    return responseClass.newInstance();
                }
            }
        } else {
            try {
                ErrorResponse errorResponse;
                if (!StringsKt.startsWith$default((String)contents, (String)"{", (boolean)false, (int)2, null)) {
                    contents = "{\"error\": \"" + contents + "\"}";
                }
                if ((errorResponse = (ErrorResponse)GSON_INSTANCE.fromJson(contents, ErrorResponse.class)).getMeta() == null) {
                    errorResponse.setMeta(new Meta(responseCode, errorResponse.getMessage(), null, 4, null));
                }
                ErrorResponse errorResponse2 = errorResponse;
                Intrinsics.checkNotNullExpressionValue((Object)errorResponse2, (String)"errorResponse");
                throw (Throwable)new ApiException(errorResponse2);
            }
            catch (JsonParseException e) {
                throw (Throwable)new ApiException("Unable to parse server error response : " + url + " : " + contents + " : " + e.getMessage(), new ErrorResponse(responseCode, contents));
            }
        }
        return (T)contents;
    }

    public DefaultNetworkSession() {
        this.networkRequestExecutor1 = ApiTask.Companion.getNetworkRequestExecutor();
        this.completionExecutor1 = ApiTask.Companion.getCompletionExecutor();
    }

    public DefaultNetworkSession(@NotNull ExecutorService networkRequestExecutor, @NotNull Executor completionExecutor) {
        Intrinsics.checkNotNullParameter((Object)networkRequestExecutor, (String)"networkRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)completionExecutor, (String)"completionExecutor");
        this.networkRequestExecutor1 = networkRequestExecutor;
        this.completionExecutor1 = completionExecutor;
    }

    static {
        Companion = new Companion(null);
        GSON_INSTANCE = new GsonBuilder().registerTypeHierarchyAdapter(Date.class, (Object)new DateDeserializer()).registerTypeHierarchyAdapter(Date.class, (Object)new DateSerializer()).registerTypeHierarchyAdapter(Boolean.TYPE, (Object)new BooleanDeserializer()).registerTypeHierarchyAdapter(Integer.TYPE, (Object)new IntDeserializer()).registerTypeAdapterFactory((TypeAdapterFactory)new MainAdapterFactory()).create();
    }

    public static final /* synthetic */ Object access$readJsonResponse(DefaultNetworkSession $this, URL url, HttpURLConnection connection, Class responseClass) {
        return $this.readJsonResponse(url, connection, responseClass);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/giphy/sdk/core/network/engine/DefaultNetworkSession$Companion;", "", "()V", "GSON_INSTANCE", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "getGSON_INSTANCE", "()Lcom/google/gson/Gson;", "giphy-ui-2.1.16_release"})
    public static final class Companion {
        public final Gson getGSON_INSTANCE() {
            return GSON_INSTANCE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

