/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.analytics.network.api;

import android.net.Uri;
import com.giphy.sdk.analytics.GiphyPingbacks;
import com.giphy.sdk.analytics.batching.AnalyticsId;
import com.giphy.sdk.analytics.models.Session;
import com.giphy.sdk.analytics.models.SessionsRequestData;
import com.giphy.sdk.analytics.network.api.GPHPingbackApi;
import com.giphy.sdk.analytics.network.response.PingbackResponse;
import com.giphy.sdk.core.GiphyCore;
import com.giphy.sdk.core.network.api.CompletionHandler;
import com.giphy.sdk.core.network.api.Constants;
import com.giphy.sdk.core.network.api.GPHApiClient;
import com.giphy.sdk.core.network.engine.DefaultNetworkSession;
import com.giphy.sdk.core.network.engine.NetworkSession;
import com.giphy.sdk.core.network.response.GenericResponse;
import com.giphy.sdk.core.threading.ApiTask;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJp\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0011\"\b\b\u0000\u0010\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00120\u001a2\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001c2\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u001fJ\"\u0010 \u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006'"}, d2={"Lcom/giphy/sdk/analytics/network/api/GPHPingbackClient;", "Lcom/giphy/sdk/analytics/network/api/GPHPingbackApi;", "apiKey", "", "networkSession", "Lcom/giphy/sdk/core/network/engine/NetworkSession;", "analyticsId", "Lcom/giphy/sdk/analytics/batching/AnalyticsId;", "(Ljava/lang/String;Lcom/giphy/sdk/core/network/engine/NetworkSession;Lcom/giphy/sdk/analytics/batching/AnalyticsId;)V", "getAnalyticsId", "()Lcom/giphy/sdk/analytics/batching/AnalyticsId;", "getApiKey", "()Ljava/lang/String;", "applicationJson", "getNetworkSession", "()Lcom/giphy/sdk/core/network/engine/NetworkSession;", "postStringConnectionWithRandomId", "Lcom/giphy/sdk/core/threading/ApiTask;", "T", "Lcom/giphy/sdk/core/network/response/GenericResponse;", "serverUrl", "Landroid/net/Uri;", "path", "method", "Lcom/giphy/sdk/core/network/api/GPHApiClient$HTTPMethod;", "responseClass", "Ljava/lang/Class;", "queryStrings", "", "headers", "requestBody", "Lcom/giphy/sdk/analytics/models/SessionsRequestData;", "submitSession", "Ljava/util/concurrent/Future;", "session", "Lcom/giphy/sdk/analytics/models/Session;", "completionHandler", "Lcom/giphy/sdk/core/network/api/CompletionHandler;", "Lcom/giphy/sdk/analytics/network/response/PingbackResponse;", "giphy-ui-2.1.16_release"})
public final class GPHPingbackClient
implements GPHPingbackApi {
    private final String applicationJson;
    @NotNull
    private final String apiKey;
    @NotNull
    private final NetworkSession networkSession;
    @NotNull
    private final AnalyticsId analyticsId;

    @Override
    @NotNull
    public Future<?> submitSession(@NotNull Session session, @NotNull CompletionHandler<? super PingbackResponse> completionHandler) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(completionHandler, (String)"completionHandler");
        HashMap params = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)Constants.INSTANCE.getAPI_KEY(), (Object)this.apiKey), TuplesKt.to((Object)Constants.INSTANCE.getPINGBACK_ID(), (Object)GiphyPingbacks.INSTANCE.getPingbackCollector$giphy_ui_2_1_16_release().getAnalyticsId().getPingbackId())});
        Map headers = MapsKt.toMutableMap((Map)MapsKt.plus((Map)MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)Constants.INSTANCE.getCONTENT_TYPE(), (Object)this.applicationJson)}), (Map)GiphyPingbacks.INSTANCE.getAdditionalHeaders()));
        String userAgent = "Android Pingback " + GiphyCore.INSTANCE.getName() + " v" + GiphyCore.INSTANCE.getVersionName();
        headers.put("User-Agent", userAgent);
        Uri uri = Constants.INSTANCE.getPINGBACK_SERVER_URL();
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"Constants.PINGBACK_SERVER_URL");
        return this.postStringConnectionWithRandomId(uri, Constants.Paths.INSTANCE.getPINGBACK(), GPHApiClient.HTTPMethod.POST, PingbackResponse.class, params, headers, new SessionsRequestData(session)).executeAsyncTask(completionHandler);
    }

    @NotNull
    public final <T extends GenericResponse> ApiTask<T> postStringConnectionWithRandomId(@NotNull Uri serverUrl, @NotNull String path, @NotNull GPHApiClient.HTTPMethod method, @NotNull Class<T> responseClass, @Nullable Map<String, String> queryStrings, @Nullable Map<String, String> headers, @NotNull SessionsRequestData requestBody) {
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        return this.networkSession.postStringConnection(serverUrl, path, method, responseClass, queryStrings, headers, requestBody);
    }

    @NotNull
    public final String getApiKey() {
        return this.apiKey;
    }

    @NotNull
    public final NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    @NotNull
    public final AnalyticsId getAnalyticsId() {
        return this.analyticsId;
    }

    @JvmOverloads
    public GPHPingbackClient(@NotNull String apiKey, @NotNull NetworkSession networkSession, @NotNull AnalyticsId analyticsId) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)networkSession, (String)"networkSession");
        Intrinsics.checkNotNullParameter((Object)analyticsId, (String)"analyticsId");
        this.apiKey = apiKey;
        this.networkSession = networkSession;
        this.analyticsId = analyticsId;
        this.applicationJson = "application/json";
    }

    public /* synthetic */ GPHPingbackClient(String string2, NetworkSession networkSession, AnalyticsId analyticsId, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            networkSession = new DefaultNetworkSession();
        }
        if ((n & 4) != 0) {
            analyticsId = new AnalyticsId(string2, false, false, 6, null);
        }
        this(string2, networkSession, analyticsId);
    }

    @JvmOverloads
    public GPHPingbackClient(@NotNull String apiKey, @NotNull NetworkSession networkSession) {
        this(apiKey, networkSession, null, 4, null);
    }

    @JvmOverloads
    public GPHPingbackClient(@NotNull String apiKey) {
        this(apiKey, null, null, 6, null);
    }
}

