/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.analytics.batching;

import android.util.Log;
import com.giphy.sdk.analytics.GiphyPingbacks;
import com.giphy.sdk.analytics.batching.AnalyticsId;
import com.giphy.sdk.analytics.batching.PingbackSubmissionQueue;
import com.giphy.sdk.analytics.batching.PingbackWrapperRecycler;
import com.giphy.sdk.analytics.models.AnalyticsEvent;
import com.giphy.sdk.analytics.models.Session;
import com.giphy.sdk.analytics.models.enums.ActionType;
import com.giphy.sdk.analytics.models.enums.AttributeKey;
import com.giphy.sdk.analytics.models.enums.EventType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\t\b\u0000\u0018\u0000 <2\u00020\u0001:\u0001<B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJl\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\b\u0010$\u001a\u0004\u0018\u00010\u00032\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u00032\b\u0010(\u001a\u0004\u0018\u00010\u00032\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010\u00032\b\u0010,\u001a\u0004\u0018\u00010\u00032\u0006\u0010-\u001a\u00020.2\n\b\u0002\u0010/\u001a\u0004\u0018\u00010\u0003J\u0006\u00100\u001a\u00020!J\u0010\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u0003H\u0002J\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001904J\u001a\u00105\u001a\u00020\u001c2\b\u0010+\u001a\u0004\u0018\u00010\u00032\u0006\u00102\u001a\u00020\u0003H\u0002J\b\u00106\u001a\u00020!H\u0002J\b\u00107\u001a\u00020!H\u0002J\b\u00108\u001a\u00020!H\u0002J\u0010\u00109\u001a\u00020!2\u0006\u0010:\u001a\u00020\u001cH\u0002J\u001a\u0010;\u001a\u00020\u00032\b\u0010+\u001a\u0004\u0018\u00010\u00032\u0006\u00102\u001a\u00020\u0003H\u0002R\u0014\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/giphy/sdk/analytics/batching/PingbackCollector;", "", "apiKey", "", "isMainInstance", "", "enableVerificationMode", "submissionQueue", "Lcom/giphy/sdk/analytics/batching/PingbackSubmissionQueue;", "verificationMode", "(Ljava/lang/String;ZZLcom/giphy/sdk/analytics/batching/PingbackSubmissionQueue;Z)V", "addPingbackFuture", "Ljava/util/concurrent/ScheduledFuture;", "addPingbackRunnable", "Ljava/lang/Runnable;", "analyticsId", "Lcom/giphy/sdk/analytics/batching/AnalyticsId;", "getAnalyticsId", "()Lcom/giphy/sdk/analytics/batching/AnalyticsId;", "eventWrapperRecycler", "Lcom/giphy/sdk/analytics/batching/PingbackWrapperRecycler;", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "pingbacksBatch", "", "Lcom/giphy/sdk/analytics/batching/PingbackWrapperRecycler$PingbackWrapper;", "sessions", "Ljava/util/HashMap;", "Lcom/giphy/sdk/analytics/models/Session;", "getSessions", "()Ljava/util/HashMap;", "submitReadySessionsFuture", "addPingback", "", "loggedInUserId", "analyticsResponsePayload", "referrer", "eventType", "Lcom/giphy/sdk/analytics/models/enums/EventType;", "mediaId", "tid", "actionType", "Lcom/giphy/sdk/analytics/models/enums/ActionType;", "sessionId", "layoutType", "position", "", "placement", "flush", "generalSessionKeyForUser", "userId", "getPingbacksBatch", "", "getSession", "processPingbacksBatch", "scheduleSubmitAllSessions", "submitAllSessions", "submitReadySession", "session", "uniqueSessionKey", "Companion", "giphy-ui-2.1.16_release"})
public final class PingbackCollector {
    private final ScheduledExecutorService executorService;
    @NotNull
    private final HashMap<String, Session> sessions;
    private ScheduledFuture<?> addPingbackFuture;
    private ScheduledFuture<?> submitReadySessionsFuture;
    private final PingbackWrapperRecycler eventWrapperRecycler;
    private final List<PingbackWrapperRecycler.PingbackWrapper> pingbacksBatch;
    @NotNull
    private final AnalyticsId analyticsId;
    private final Runnable addPingbackRunnable;
    private final String apiKey;
    private final boolean isMainInstance;
    private final boolean enableVerificationMode;
    private final PingbackSubmissionQueue submissionQueue;
    private final boolean verificationMode;
    private static long addPingbackDelay;
    private static long maximumIdleTimeBeforeSubmitting;
    private static int maximumPingbacksBeforeSubmitting;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final HashMap<String, Session> getSessions() {
        return this.sessions;
    }

    @NotNull
    public final AnalyticsId getAnalyticsId() {
        return this.analyticsId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPingback(@NotNull String loggedInUserId, @NotNull String analyticsResponsePayload, @Nullable String referrer, @Nullable EventType eventType, @NotNull String mediaId, @Nullable String tid, @NotNull ActionType actionType, @Nullable String sessionId, @Nullable String layoutType, int position, @Nullable String placement) {
        Intrinsics.checkNotNullParameter((Object)loggedInUserId, (String)"loggedInUserId");
        Intrinsics.checkNotNullParameter((Object)analyticsResponsePayload, (String)"analyticsResponsePayload");
        Intrinsics.checkNotNullParameter((Object)mediaId, (String)"mediaId");
        Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
        PingbackWrapperRecycler.PingbackWrapper pingbackWrapper = null;
        PingbackWrapperRecycler pingbackWrapperRecycler = this.eventWrapperRecycler;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (pingbackWrapperRecycler) {
            boolean bl3 = false;
            pingbackWrapper = this.eventWrapperRecycler.getItem(this.analyticsId.getPingbackId(), loggedInUserId, this.analyticsId.getVerificationID(), analyticsResponsePayload, referrer, eventType, mediaId, tid, actionType, sessionId, layoutType, position, placement);
            Unit unit = Unit.INSTANCE;
        }
        int pingbacksBatchSize = 0;
        List<PingbackWrapperRecycler.PingbackWrapper> list = this.pingbacksBatch;
        boolean bl4 = false;
        boolean bl5 = false;
        synchronized (list) {
            boolean bl6 = false;
            PingbackWrapperRecycler.PingbackWrapper pingbackWrapper2 = pingbackWrapper;
            if (pingbackWrapper2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pingbackWrapper");
            }
            this.pingbacksBatch.add(pingbackWrapper2);
            pingbacksBatchSize = this.pingbacksBatch.size();
            Unit unit = Unit.INSTANCE;
        }
        if (this.addPingbackFuture != null) {
            ScheduledFuture<?> scheduledFuture = this.addPingbackFuture;
            Intrinsics.checkNotNull(scheduledFuture);
            if (!scheduledFuture.isCancelled()) {
                ScheduledFuture<?> scheduledFuture2 = this.addPingbackFuture;
                Intrinsics.checkNotNull(scheduledFuture2);
                scheduledFuture2.cancel(false);
            }
        }
        if (tid != null) {
            this.flush();
        } else if (pingbacksBatchSize < maximumPingbacksBeforeSubmitting) {
            this.addPingbackFuture = this.executorService.schedule(this.addPingbackRunnable, addPingbackDelay, TimeUnit.MILLISECONDS);
        } else {
            this.executorService.execute(this.addPingbackRunnable);
        }
    }

    public static /* synthetic */ void addPingback$default(PingbackCollector pingbackCollector, String string2, String string3, String string4, EventType eventType, String string5, String string6, ActionType actionType, String string7, String string8, int n, String string9, int n2, Object object) {
        if ((n2 & 0x400) != 0) {
            string9 = null;
        }
        pingbackCollector.addPingback(string2, string3, string4, eventType, string5, string6, actionType, string7, string8, n, string9);
    }

    public final void flush() {
        this.executorService.execute(new Runnable(this){
            final /* synthetic */ PingbackCollector this$0;

            public final void run() {
                PingbackCollector.access$processPingbacksBatch(this.this$0);
                PingbackCollector.access$submitAllSessions(this.this$0);
                PingbackCollector.access$getSubmissionQueue$p(this.this$0).flush();
            }
            {
                this.this$0 = pingbackCollector;
            }
        });
    }

    @NotNull
    public final List<PingbackWrapperRecycler.PingbackWrapper> getPingbacksBatch() {
        return this.pingbacksBatch;
    }

    private final void submitAllSessions() {
        Iterator<Map.Entry<String, Session>> it = this.sessions.entrySet().iterator();
        while (it.hasNext()) {
            Session session;
            Intrinsics.checkNotNullExpressionValue((Object)it.next().getValue(), (String)"it.next().value");
            if (session.getEvents().size() >= 0) {
                if (GiphyPingbacks.INSTANCE.getLogsEnabled()) {
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string2 = "Enqueueing session %s %s";
                    Object[] objectArray = new Object[]{session.getSessionId(), session.getEvents().size()};
                    boolean bl = false;
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                    Log.d((String)"PINGBACK", (String)string3);
                }
                this.submissionQueue.add(session);
            }
            it.remove();
        }
    }

    private final void submitReadySession(Session session) {
        if (GiphyPingbacks.INSTANCE.getLogsEnabled()) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "Enqueueing ready session %s %s";
            Object[] objectArray = new Object[]{session.getSessionId(), session.getEvents().size()};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
            Log.d((String)"PINGBACK", (String)string3);
        }
        this.submissionQueue.add(session);
        String string4 = session.getSessionId();
        String string5 = session.getUserId();
        if (string5 == null) {
            string5 = "";
        }
        this.sessions.remove(this.uniqueSessionKey(string4, string5));
    }

    private final void scheduleSubmitAllSessions() {
        if (this.submitReadySessionsFuture != null) {
            ScheduledFuture<?> scheduledFuture = this.submitReadySessionsFuture;
            Intrinsics.checkNotNull(scheduledFuture);
            if (!scheduledFuture.isCancelled()) {
                ScheduledFuture<?> scheduledFuture2 = this.submitReadySessionsFuture;
                Intrinsics.checkNotNull(scheduledFuture2);
                scheduledFuture2.cancel(false);
            }
        }
        this.submitReadySessionsFuture = this.executorService.schedule(new Runnable(this){
            final /* synthetic */ PingbackCollector this$0;

            public final void run() {
                PingbackCollector.access$submitAllSessions(this.this$0);
            }
            {
                this.this$0 = pingbackCollector;
            }
        }, maximumIdleTimeBeforeSubmitting, TimeUnit.MILLISECONDS);
    }

    private final Session getSession(String sessionId, String userId) {
        String sessionKey = this.uniqueSessionKey(sessionId, userId);
        Session cachedSession = this.sessions.get(sessionKey);
        if (cachedSession != null) {
            return cachedSession;
        }
        Session newSession = new Session(sessionId, null, 2, null);
        ((Map)this.sessions).put(sessionKey, newSession);
        return newSession;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String uniqueSessionKey(String sessionId, String userId) {
        String string2;
        if (sessionId != null) {
            CharSequence charSequence = sessionId;
            boolean bl = false;
            if (!(charSequence.length() == 0)) {
                string2 = sessionId;
                return string2;
            }
        }
        string2 = this.generalSessionKeyForUser(userId);
        return string2;
    }

    private final String generalSessionKeyForUser(String userId) {
        return "user:" + userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processPingbacksBatch() {
        Object object;
        boolean bl;
        ArrayList pingbacksBatchCopy = new ArrayList();
        Object object2 = this.pingbacksBatch;
        boolean bl2 = false;
        boolean bl3 = false;
        synchronized (object2) {
            bl = false;
            pingbacksBatchCopy.addAll(this.pingbacksBatch);
            this.pingbacksBatch.clear();
            Unit unit = Unit.INSTANCE;
        }
        for (PingbackWrapperRecycler.PingbackWrapper pingbackWrapper : pingbacksBatchCopy) {
            Object it;
            boolean bl4;
            boolean bl5;
            bl = false;
            HashMap<String, String> attributes = new HashMap<String, String>();
            Session session = this.getSession(pingbackWrapper.getSessionId(), pingbackWrapper.getUserId());
            if (pingbackWrapper.getLayoutType() != null) {
                bl5 = false;
                bl4 = false;
                it = object;
                boolean bl6 = false;
                ((Map)attributes).put(AttributeKey.layout_type.name(), it);
            }
            if (pingbackWrapper.getPosition() >= 0) {
                Map map = attributes;
                String string2 = AttributeKey.position.name();
                String string3 = Integer.toString(pingbackWrapper.getPosition());
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Integer.toString(pingbackWrapper.position)");
                map.put(string2, string3);
            }
            if (pingbackWrapper.getPlacement() != null) {
                bl5 = false;
                bl4 = false;
                it = object;
                boolean bl7 = false;
                ((Map)attributes).put(AttributeKey.placement.name(), it);
            }
            session.getEvents().add(new AnalyticsEvent(pingbackWrapper.getAnalyticsResponsePayload(), pingbackWrapper.getEventType(), pingbackWrapper.getActionType(), pingbackWrapper.getMediaId(), pingbackWrapper.getTid(), pingbackWrapper.getTs(), attributes, pingbackWrapper.getUserId(), pingbackWrapper.getLoggedInUserId(), pingbackWrapper.getRandomId()));
            if (GiphyPingbacks.INSTANCE.getLogsEnabled()) {
                object = StringCompanionObject.INSTANCE;
                String string4 = "Event added %s %s %s | %s %s %s %s | %s | %s %s %s";
                Object[] objectArray = new Object[]{pingbackWrapper.getActionType(), pingbackWrapper.getMediaId(), pingbackWrapper.getTs(), pingbackWrapper.getAnalyticsResponsePayload(), pingbackWrapper.getRandomId(), pingbackWrapper.getReferrer(), pingbackWrapper.getEventType(), pingbackWrapper.getSessionId(), pingbackWrapper.getLayoutType(), pingbackWrapper.getPosition(), pingbackWrapper.getPlacement()};
                boolean bl8 = false;
                String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
                Log.d((String)"PINGBACK", (String)string5);
            }
            if (session.getEvents().size() < maximumPingbacksBeforeSubmitting) continue;
            this.submitReadySession(session);
        }
        object2 = this.eventWrapperRecycler;
        boolean bl9 = false;
        boolean bl10 = false;
        synchronized (object2) {
            boolean bl11 = false;
            object = pingbacksBatchCopy.iterator();
            while (object.hasNext()) {
                PingbackWrapperRecycler.PingbackWrapper eventWrapper;
                PingbackWrapperRecycler.PingbackWrapper pingbackWrapper = eventWrapper = (PingbackWrapperRecycler.PingbackWrapper)object.next();
                Intrinsics.checkNotNullExpressionValue((Object)pingbackWrapper, (String)"eventWrapper");
                this.eventWrapperRecycler.recycleItem(pingbackWrapper);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public PingbackCollector(@NotNull String apiKey, boolean isMainInstance, boolean enableVerificationMode, @NotNull PingbackSubmissionQueue submissionQueue, boolean verificationMode) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)submissionQueue, (String)"submissionQueue");
        this.apiKey = apiKey;
        this.isMainInstance = isMainInstance;
        this.enableVerificationMode = enableVerificationMode;
        this.submissionQueue = submissionQueue;
        this.verificationMode = verificationMode;
        this.analyticsId = new AnalyticsId(this.apiKey, this.isMainInstance, this.enableVerificationMode);
        this.addPingbackRunnable = new Runnable(this){
            final /* synthetic */ PingbackCollector this$0;

            public final void run() {
                PingbackCollector.access$processPingbacksBatch(this.this$0);
                PingbackCollector.access$scheduleSubmitAllSessions(this.this$0);
            }
            {
                this.this$0 = pingbackCollector;
            }
        };
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"Executors.newSingleThreadScheduledExecutor()");
        this.executorService = scheduledExecutorService;
        this.sessions = new HashMap();
        this.pingbacksBatch = new ArrayList();
        this.eventWrapperRecycler = new PingbackWrapperRecycler();
    }

    public /* synthetic */ PingbackCollector(String string2, boolean bl, boolean bl2, PingbackSubmissionQueue pingbackSubmissionQueue, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            pingbackSubmissionQueue = new PingbackSubmissionQueue(string2, bl, bl2);
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        this(string2, bl, bl2, pingbackSubmissionQueue, bl3);
    }

    static {
        Companion = new Companion(null);
        addPingbackDelay = 3000L;
        maximumIdleTimeBeforeSubmitting = 10000L;
        maximumPingbacksBeforeSubmitting = 100;
    }

    public static final /* synthetic */ void access$processPingbacksBatch(PingbackCollector $this) {
        $this.processPingbacksBatch();
    }

    public static final /* synthetic */ void access$submitAllSessions(PingbackCollector $this) {
        $this.submitAllSessions();
    }

    public static final /* synthetic */ PingbackSubmissionQueue access$getSubmissionQueue$p(PingbackCollector $this) {
        return $this.submissionQueue;
    }

    public static final /* synthetic */ void access$scheduleSubmitAllSessions(PingbackCollector $this) {
        $this.scheduleSubmitAllSessions();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/giphy/sdk/analytics/batching/PingbackCollector$Companion;", "", "()V", "addPingbackDelay", "", "getAddPingbackDelay", "()J", "setAddPingbackDelay", "(J)V", "maximumIdleTimeBeforeSubmitting", "getMaximumIdleTimeBeforeSubmitting", "setMaximumIdleTimeBeforeSubmitting", "maximumPingbacksBeforeSubmitting", "", "getMaximumPingbacksBeforeSubmitting", "()I", "setMaximumPingbacksBeforeSubmitting", "(I)V", "giphy-ui-2.1.16_release"})
    public static final class Companion {
        public final long getAddPingbackDelay() {
            return addPingbackDelay;
        }

        public final void setAddPingbackDelay(long l) {
            addPingbackDelay = l;
        }

        public final long getMaximumIdleTimeBeforeSubmitting() {
            return maximumIdleTimeBeforeSubmitting;
        }

        public final void setMaximumIdleTimeBeforeSubmitting(long l) {
            maximumIdleTimeBeforeSubmitting = l;
        }

        public final int getMaximumPingbacksBeforeSubmitting() {
            return maximumPingbacksBeforeSubmitting;
        }

        public final void setMaximumPingbacksBeforeSubmitting(int n) {
            maximumPingbacksBeforeSubmitting = n;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

