/*
 * Decompiled with CFR 0.152.
 */
package com.ginsberg.junit.exit;

import com.ginsberg.junit.exit.ExitPreventerStrategy;
import com.ginsberg.junit.exit.ExpectSystemExitWithStatus;
import com.ginsberg.junit.exit.FailOnSystemExit;
import com.ginsberg.junit.exit.SystemExitPreventedException;
import com.ginsberg.junit.exit.agent.AgentSystemExitHandlerStrategy;
import com.ginsberg.junit.exit.agent.DoNotRewriteExitCalls;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.platform.commons.support.AnnotationSupport;

@DoNotRewriteExitCalls
public class SystemExitExtension
implements BeforeEachCallback,
AfterEachCallback,
TestExecutionExceptionHandler {
    private Integer expectedStatusCode;
    private boolean failOnSystemExit;
    private final ExitPreventerStrategy exitPreventerStrategy;

    public SystemExitExtension() {
        if (!AgentSystemExitHandlerStrategy.isLoadedFromAgent()) {
            throw new IllegalStateException("SystemExitExtension Agent not loaded, please see documentation");
        }
        this.exitPreventerStrategy = new AgentSystemExitHandlerStrategy();
    }

    public void afterEach(ExtensionContext context) {
        this.exitPreventerStrategy.afterTest();
        try {
            if (this.failOnSystemExit) {
                Assertions.assertNull((Object)this.exitPreventerStrategy.firstExitStatusCode(), (String)("Unexpected System.exit(" + this.exitPreventerStrategy.firstExitStatusCode() + ") caught"));
            } else if (this.expectedStatusCode == null) {
                Assertions.assertNotNull((Object)this.exitPreventerStrategy.firstExitStatusCode(), (String)"Expected System.exit() to be called, but it was not");
            } else {
                Assertions.assertEquals((Integer)this.expectedStatusCode, (Integer)this.exitPreventerStrategy.firstExitStatusCode(), (String)("Expected System.exit(" + this.expectedStatusCode + ") to be called, but it was not."));
            }
        }
        finally {
            this.expectedStatusCode = null;
            this.failOnSystemExit = false;
            this.exitPreventerStrategy.resetBetweenTests();
        }
    }

    public void beforeEach(ExtensionContext context) {
        this.failOnSystemExit = this.getAnnotation(context, FailOnSystemExit.class).isPresent();
        this.getAnnotation(context, ExpectSystemExitWithStatus.class).ifPresent(code -> {
            this.expectedStatusCode = code.value();
        });
        this.exitPreventerStrategy.beforeTest();
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        if (!(throwable instanceof SystemExitPreventedException)) {
            throw throwable;
        }
    }

    private <T extends Annotation> Optional<T> getAnnotation(ExtensionContext context, Class<T> annotationClass) {
        Optional method = AnnotationSupport.findAnnotation((Optional)context.getTestMethod(), annotationClass);
        return method.isPresent() ? method : AnnotationSupport.findAnnotation((Optional)context.getTestClass(), annotationClass);
    }
}

