/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.core.datastore;

import com.giffing.wicket.spring.boot.context.extensions.ApplicationInitExtension;
import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketAutoConfig;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketEndpointRepository;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.core.datastore.DataStoreHttpSessionProperties;
import org.apache.wicket.Application;
import org.apache.wicket.DefaultPageManagerProvider;
import org.apache.wicket.IPageManagerProvider;
import org.apache.wicket.page.DefaultPageManagerContext;
import org.apache.wicket.page.IPageManagerContext;
import org.apache.wicket.pageStore.IDataStore;
import org.apache.wicket.pageStore.memory.HttpSessionDataStore;
import org.apache.wicket.pageStore.memory.IDataStoreEvictionStrategy;
import org.apache.wicket.pageStore.memory.PageNumberEvictionStrategy;
import org.apache.wicket.protocol.http.WebApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@ApplicationInitExtension
@ConditionalOnProperty(prefix="wicket.core.datastore.httpsession", value={"enabled"}, matchIfMissing=false)
@EnableConfigurationProperties(value={DataStoreHttpSessionProperties.class})
@AutoConfigureAfter(value={HttpSessionDataStore.class})
public class DataStoreHttpSessionConfig
implements WicketApplicationInitConfiguration {
    @Autowired
    private DataStoreHttpSessionProperties props;
    @Autowired
    private WicketEndpointRepository wicketEndpointRepository;

    public void init(WebApplication webApplication) {
        webApplication.setPageManagerProvider((IPageManagerProvider)new DefaultPageManagerProvider((Application)webApplication){

            protected IDataStore newDataStore() {
                return new HttpSessionDataStore((IPageManagerContext)new DefaultPageManagerContext(), (IDataStoreEvictionStrategy)new PageNumberEvictionStrategy(DataStoreHttpSessionConfig.this.props.getPagesNumber()));
            }
        });
        this.wicketEndpointRepository.add(new WicketAutoConfig.Builder(this.getClass()).withDetail("properties", (Object)this.props).build());
    }
}

