/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.player.framesequence;

import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.util.Pair;
import com.gfycat.common.ContextDetails;
import com.gfycat.common.utils.Assertions;
import com.gfycat.common.utils.Logging;
import com.gfycat.core.GfyCore;
import com.gfycat.core.NetworkUtils;
import com.gfycat.core.bi.analytics.GfycatAnalytics;
import com.gfycat.core.bi.corelogger.CoreLogger;
import com.gfycat.core.gfycatapi.pojo.Gfycat;
import com.gfycat.core.storage.CachedMediaFilesManager;
import com.gfycat.core.storage.MediaType;
import com.gfycat.framesequence.view.FrameSequenceSource;
import io.reactivex.Single;
import java.io.InterruptedIOException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;

public abstract class GfycatFrameSequenceSource
implements FrameSequenceSource {
    private static final String LOG_TAG = "GfycatFrameSequenceSource";
    private static final Integer MAX_INTERRUPTION_RETRY = 2;
    private final Gfycat gfycat;
    private final ContextDetails contextDetails;
    private final Context context;

    protected abstract MediaType getPlayerType();

    public GfycatFrameSequenceSource(Context context, Gfycat gfycat, ContextDetails details) {
        this.context = context;
        this.gfycat = gfycat;
        this.contextDetails = details.copy().put("gfyid", gfycat.getGfyId()).put("player", this.getPlayerType().getName());
    }

    public GfycatFrameSequenceSource(Context context, Gfycat gfycat) {
        this.context = context;
        this.gfycat = gfycat;
        this.contextDetails = new ContextDetails(new Pair[]{Pair.create((Object)"gfyid", (Object)gfycat.getGfyId()), Pair.create((Object)"player", (Object)this.getPlayerType().getName())});
    }

    protected Gfycat getGfycat() {
        return this.gfycat;
    }

    public String getId() {
        return this.gfycat.getGfyId();
    }

    public String getType() {
        return "gfycat";
    }

    @NonNull
    public ContextDetails getContextDetails() {
        return this.contextDetails;
    }

    public int getAverageColorInt() {
        return this.gfycat.hasTransparency() ? 0 : this.gfycat.getAvgColorInt();
    }

    public int getWidth() {
        return this.gfycat.getWidth();
    }

    public int getHeight() {
        return this.gfycat.getHeight();
    }

    public Single<Drawable> loadPoster() {
        return GfyCore.getMediaFilesManager().loadAsFile(this.gfycat, MediaType.posterType((Gfycat)this.gfycat)).retry((integer, throwable) -> integer < MAX_INTERRUPTION_RETRY && throwable instanceof InterruptedIOException).map(file -> BitmapFactory.decodeFile((String)file.getPath())).map(bitmap -> new BitmapDrawable(this.context.getResources(), bitmap));
    }

    public void failedToGetPoster(Throwable throwable) {
        this.failedToGetContent(MediaType.posterType((Gfycat)this.gfycat), throwable);
    }

    public void failedToGetFrameSequence(Throwable throwable) {
        this.failedToGetContent(this.getPlayerType(), throwable);
    }

    private void failedToGetContent(MediaType mediaType, Throwable throwable) {
        if (throwable instanceof SSLHandshakeException || throwable.getCause() instanceof SSLHandshakeException) {
            Assertions.fail((Throwable)new SSLException("SSLHandshakeException happnes on get gfycat: " + this.getId() + " " + this.getContextDetails(), throwable));
        } else if (throwable instanceof SSLProtocolException || throwable.getCause() instanceof SSLProtocolException) {
            Assertions.fail((Throwable)new SSLException("SSLProtocolException happnes on get gfycat: " + this.getId() + " " + this.getContextDetails(), throwable));
        } else if (throwable instanceof CachedMediaFilesManager.ForbiddenGfycatException) {
            ((CoreLogger)GfycatAnalytics.getLogger(CoreLogger.class)).logForbidden(this.getGfycat(), mediaType);
        } else if (!NetworkUtils.isAcceptableNetworkException((Throwable)throwable)) {
            Assertions.fail((Throwable)new FailedToGetContentException(LOG_TAG, throwable));
        } else {
            Logging.d((String)LOG_TAG, (Throwable)throwable, (Object[])new Object[]{"Possible exception happens for " + this.gfycat});
        }
    }

    private static class FailedToGetContentException
    extends Exception {
        FailedToGetContentException(String message, Throwable throwable) {
            super(message, throwable);
        }
    }
}

