/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.player;

import android.content.Context;
import com.gfycat.common.utils.Logging;
import com.gfycat.player.GfycatPlayer;
import com.gfycat.player.GfycatPlayerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class MainPlayerFactory
implements GfycatPlayerFactory {
    private static final String LOG_TAG = "MainPlayerFactory";
    private static final MainPlayerFactory mainFactory = new MainPlayerFactory();
    private GfycatPlayerFactory delegate;

    public static void setup(GfycatPlayerFactory delegate) {
        MainPlayerFactory.mainFactory.delegate = delegate;
    }

    public static GfycatPlayerFactory get() {
        return mainFactory;
    }

    @Override
    public GfycatPlayer create(Context context) {
        if (this.delegate == null) {
            this.delegate = this.tryCreateWebpFactory();
            if (this.delegate == null) {
                this.delegate = this.tryCreateGifFactory();
            }
            if (this.delegate == null) {
                throw new IllegalStateException("Can not create GfycatPlayerView, cause GfycatPlayerFactory was not provided.");
            }
        }
        return this.delegate.create(context);
    }

    private GfycatPlayerFactory tryCreateFactory(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            return (GfycatPlayerFactory)constructor.newInstance(new Object[0]);
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Logging.w((String)LOG_TAG, (Object[])new Object[]{"Can not instantiate factory:", className, "."});
            return null;
        }
    }

    private GfycatPlayerFactory tryCreateWebpFactory() {
        return this.tryCreateFactory("com.gfycat.webp.GfycatWebpPlayerFactory");
    }

    private GfycatPlayerFactory tryCreateGifFactory() {
        return this.tryCreateFactory("com.gfycat.gif.GfycatGifPlayerFactory");
    }
}

