/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.player;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.gfycat.common.ContextDetails;
import com.gfycat.core.gfycatapi.pojo.Gfycat;
import com.gfycat.framesequence.R;
import com.gfycat.player.GfycatPlayer;
import com.gfycat.player.MainPlayerFactory;

public class GfycatPlayerWrapper
extends FrameLayout
implements GfycatPlayer {
    private GfycatPlayer player;

    public GfycatPlayerWrapper(@NonNull Context context) {
        super(context);
        this.sharedCtor(context);
    }

    public GfycatPlayerWrapper(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.sharedCtor(context);
        this.internalAttrsInit(context, attrs);
    }

    public GfycatPlayerWrapper(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.sharedCtor(context);
        this.internalAttrsInit(context, attrs);
    }

    private void sharedCtor(Context context) {
        this.player = MainPlayerFactory.get().create(context);
        this.addView(this.player.getView());
    }

    private void internalAttrsInit(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FrameSequenceView);
        boolean shouldLoadPreview = a.getBoolean(R.styleable.FrameSequenceView_shouldLoadPreview, false);
        boolean shouldPlay = a.getBoolean(R.styleable.FrameSequenceView_autoplay, false);
        this.player.setShouldLoadPreview(shouldLoadPreview);
        if (shouldPlay) {
            this.player.play();
        }
        a.recycle();
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public void setShouldLoadPreview(boolean shouldLoadPreview) {
        this.player.setShouldLoadPreview(shouldLoadPreview);
    }

    @Override
    public void setupPreview(Drawable drawable, boolean animate) {
        this.player.setupPreview(drawable, animate);
    }

    @Override
    public void setupGfycat(Gfycat gfycat, ContextDetails contextDetails) {
        this.player.setupGfycat(gfycat, contextDetails);
    }

    @Override
    public void setupGfycat(Gfycat gfycat) {
        this.player.setupGfycat(gfycat);
    }

    @Override
    public void play() {
        this.player.play();
    }

    @Override
    public void pause() {
        this.player.pause();
    }

    @Override
    public void setScaleType(ImageView.ScaleType scaleType) {
        this.player.setScaleType(scaleType);
    }

    @Override
    public void release() {
        this.player.release();
    }

    @Override
    public void setOnStartAnimationListener(Runnable onStartAnimationListener) {
        this.player.setOnStartAnimationListener(onStartAnimationListener);
    }
}

