/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.framesequence.view;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.gfycat.common.ContextDetails;
import java.util.LinkedList;
import java.util.Queue;

public class GfycatTransitionDrawable
extends Drawable
implements Drawable.Callback {
    private Drawable first;
    private Drawable second;
    private ColorFilter colorFilter;
    private Queue<DrawableToAnimate> drawableQueue = new LinkedList<DrawableToAnimate>();
    private long startTime;
    private long duration;
    private ContextDetails contextDetails;
    private Rect bounds = new Rect();

    public GfycatTransitionDrawable(Drawable drawable) {
        this.assignToFirst(drawable);
    }

    public void setDrawable(Drawable drawable) {
        this.assignToFirst(drawable);
        this.assignToSecond(null);
        this.drawableQueue.clear();
    }

    private void assignToFirst(Drawable drawable) {
        if (this.first != null) {
            this.first.setCallback(null);
        }
        this.first = drawable;
        if (this.first != null) {
            this.first.setBounds(this.bounds);
            this.first.setCallback((Drawable.Callback)this);
            this.first.setColorFilter(this.colorFilter);
        }
    }

    private void assignToSecond(Drawable drawable) {
        if (this.second != null) {
            this.second.setCallback(null);
        }
        this.second = drawable;
        if (this.second != null) {
            this.second.setBounds(this.bounds);
            this.second.setCallback((Drawable.Callback)this);
            this.second.setColorFilter(this.colorFilter);
        }
    }

    public void setContextDetails(ContextDetails contextDetails) {
        this.contextDetails = contextDetails;
    }

    public void addDrawable(Drawable drawable, int durationMs) {
        if (this.first == null) {
            this.assignToFirst(drawable);
            this.invalidateSelf();
        } else if (this.second == null) {
            this.assignToSecond(drawable);
            this.startAnimation(durationMs);
        } else {
            this.drawableQueue.add(new DrawableToAnimate(drawable, durationMs));
        }
    }

    protected void onBoundsChange(Rect bounds) {
        this.bounds = bounds;
        if (this.first != null) {
            this.first.setBounds(bounds);
        }
        if (this.second != null) {
            this.second.setBounds(bounds);
        }
    }

    private void startAnimation(int durationMs) {
        this.startTime = SystemClock.uptimeMillis();
        this.duration = durationMs;
        this.invalidateSelf();
    }

    public void draw(@NonNull Canvas canvas) {
        if (this.first == null) {
            return;
        }
        if (this.second == null) {
            this.first.draw(canvas);
            return;
        }
        int normalized = (int)(255L * (SystemClock.uptimeMillis() - this.startTime) / this.duration);
        if (normalized >= 255) {
            this.second.setAlpha(255);
            this.second.draw(canvas);
            this.evictFirstDrawable();
        } else {
            this.first.setAlpha(255);
            this.first.draw(canvas);
            this.second.setAlpha(normalized);
            this.second.draw(canvas);
            this.invalidateSelf();
        }
    }

    private void evictFirstDrawable() {
        this.assignToFirst(this.second);
        if (!this.drawableQueue.isEmpty()) {
            DrawableToAnimate drawableToAnimate = this.drawableQueue.poll();
            this.assignToSecond(drawableToAnimate.drawable);
            this.startAnimation(drawableToAnimate.duration);
        } else {
            this.second = null;
        }
    }

    public int getIntrinsicWidth() {
        return this.first.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        return this.first.getIntrinsicHeight();
    }

    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
    }

    private void applyColorFilter() {
        if (this.first != null) {
            this.first.setColorFilter(this.colorFilter);
        }
        if (this.second != null) {
            this.second.setColorFilter(this.colorFilter);
        }
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.colorFilter = colorFilter;
        this.applyColorFilter();
    }

    public void clearColorFilter() {
        this.colorFilter = null;
        this.applyColorFilter();
    }

    public int getOpacity() {
        return this.first.getOpacity();
    }

    public void invalidateDrawable(@NonNull Drawable who) {
        this.invalidateSelf();
    }

    public void scheduleDrawable(@NonNull Drawable who, @NonNull Runnable what, long when) {
        this.scheduleSelf(what, when);
    }

    public void unscheduleDrawable(@NonNull Drawable who, @NonNull Runnable what) {
        this.unscheduleSelf(what);
    }

    private static class DrawableToAnimate {
        private final Drawable drawable;
        private final int duration;

        public DrawableToAnimate(Drawable drawable, int durationMs) {
            this.drawable = drawable;
            this.duration = durationMs;
        }
    }
}

