/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.framesequence.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.util.Pair;
import com.gfycat.common.ContextDetails;
import com.gfycat.common.utils.Assertions;
import com.gfycat.common.utils.Logging;
import com.gfycat.common.utils.Sugar;
import com.gfycat.framesequence.FrameSequence;
import com.gfycat.framesequence.FrameSequenceDrawable;
import com.gfycat.framesequence.R;
import com.gfycat.framesequence.view.FrameSequenceMemoryUsage;
import com.gfycat.framesequence.view.FrameSequenceSource;
import com.gfycat.framesequence.view.GfycatTransitionDrawable;
import com.gfycat.framesequence.view.OnStartAnimationListener;
import com.gfycat.framesequence.view.SizedColorDrawable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import java.io.InterruptedIOException;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class FrameSequenceView
extends AppCompatImageView {
    private static final String LOG_TAG = "FrameSequenceView";
    private static final int FADE_DURATION_MS = 200;
    private static final int MAX_START_LOADING_DELAY = 200;
    private static final int MIN_START_LOADING_DELAY = 50;
    private static final int MAX_COLOR_CHANNEL_VALUE = 255;
    private static final Random random = new Random();
    private FrameSequenceSource currentSource;
    private ContextDetails contextDetails = new ContextDetails(new Pair[0]);
    private GfycatTransitionDrawable gfycatTransitionDrawable;
    private FrameSequenceDrawable frameSequenceDrawable;
    private Disposable frameSequenceDisposable;
    private SingleNotificationListener onStartAnimationListener = new SingleNotificationListener();
    private boolean shouldPlay;
    private boolean shouldLoadPreview;
    private Disposable previewSubscription;
    private boolean attached;

    public FrameSequenceView(Context context) {
        super(context);
    }

    public FrameSequenceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.internalAttrsInit(context, attrs);
    }

    public FrameSequenceView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.internalAttrsInit(context, attrs);
    }

    private void internalAttrsInit(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FrameSequenceView);
        this.shouldLoadPreview = a.getBoolean(R.styleable.FrameSequenceView_shouldLoadPreview, false);
        this.shouldPlay = a.getBoolean(R.styleable.FrameSequenceView_autoplay, false);
        a.recycle();
    }

    public void setShouldLoadPreview(boolean shouldLoadPreview) {
        this.shouldLoadPreview = shouldLoadPreview;
    }

    protected void setup(@NonNull FrameSequenceSource frameSequenceSource) {
        Assertions.assertUIThread(IllegalAccessException::new);
        this.contextDetails = frameSequenceSource.getContextDetails().copy();
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"setupGfycat() ", this.contextDetails});
        if (this.currentSource != null) {
            this.internalRelease();
        }
        this.currentSource = frameSequenceSource;
        if (this.attached) {
            this.startDataLoading();
        }
    }

    private void startDataLoading() {
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"startDataLoading() ", this.contextDetails});
        this.gfycatTransitionDrawable = new GfycatTransitionDrawable((Drawable)new SizedColorDrawable(this.currentSource.getAverageColorInt(), this.currentSource.getWidth(), this.currentSource.getHeight()));
        this.setImageDrawable(this.gfycatTransitionDrawable);
        this.gfycatTransitionDrawable.setContextDetails(this.contextDetails);
        FrameSequenceSource source = this.currentSource;
        if (this.shouldLoadPreview) {
            this.previewSubscription = source.loadPoster().delaySubscription(this.randomDelayTime(), TimeUnit.MILLISECONDS).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(drawable -> this.onPreviewReceived((Drawable)drawable, !this.hasTransparency()), source::failedToGetPoster);
        }
        if (this.shouldPlay) {
            this.playInternal();
        }
    }

    private void restartIfPossible() {
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"restartIfPossible() ", this.currentSource != null, " ", this.contextDetails});
        if (this.currentSource != null) {
            this.startDataLoading();
        }
    }

    protected void onAttachedToWindow() {
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"onAttachedToWindow() ", this.contextDetails});
        this.attached = true;
        super.onAttachedToWindow();
        this.restartIfPossible();
    }

    protected void onDetachedFromWindow() {
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"onDetachedFromWindow() ", this.contextDetails});
        this.attached = false;
        super.onDetachedFromWindow();
        this.internalRelease();
    }

    private void releasePreview() {
        Sugar.doIfNotNull((Object)this.previewSubscription, Disposable::dispose);
        this.previewSubscription = null;
    }

    public void release() {
        this.internalRelease();
    }

    private void internalRelease() {
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"internalRelease() ", this.contextDetails});
        this.releasePreview();
        Sugar.doIfNotNull((Object)this.frameSequenceDisposable, Disposable::dispose);
        this.frameSequenceDisposable = null;
        if (this.frameSequenceDrawable != null) {
            this.frameSequenceDrawable.stop();
            this.frameSequenceDrawable.destroy();
            this.frameSequenceDrawable = null;
        }
        this.setImageDrawable(null);
    }

    public void setupPreview(Drawable drawable, boolean animate) {
        this.onPreviewReceived(drawable, animate);
    }

    private void changeDrawable(Drawable drawable, boolean animation) {
        if (animation) {
            this.gfycatTransitionDrawable.addDrawable(drawable, 200);
        } else {
            this.gfycatTransitionDrawable.setDrawable(drawable);
        }
    }

    private void onFrameSequenceLoaded(FrameSequenceDrawable loadedFrameSequence) {
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"onFrameSequenceLoaded() webp load = ", FrameSequenceMemoryUsage.getWebPMemoryUsage(), " should play = ", this.shouldPlay, " ", this.contextDetails});
        this.releasePreview();
        this.frameSequenceDrawable = loadedFrameSequence;
        boolean animate = !this.hasTransparency();
        this.changeDrawable(this.frameSequenceDrawable, animate);
        this.frameSequenceDrawable.setLoopListener(this::onLoop);
        if (this.shouldPlay()) {
            this.frameSequenceDrawable.start();
            this.onStartAnimationListener.onStart();
        }
    }

    private void onPreviewReceived(Drawable preview, boolean animation) {
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"onPreviewReceived() ", animation, " frameSequenceDrawable = ", this.frameSequenceDrawable, " ", this.contextDetails});
        if (this.frameSequenceDrawable == null) {
            this.changeDrawable(preview, animation);
        }
    }

    private void onLoop(int count) {
    }

    private boolean shouldPlay() {
        return this.shouldPlay;
    }

    public void setOnStartAnimationListener(OnStartAnimationListener onStartAnimationListener) {
        this.onStartAnimationListener.setRealListener(onStartAnimationListener);
    }

    public void play() {
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"play() ", this.contextDetails});
        this.shouldPlay = true;
        if (this.attached) {
            this.playInternal();
        }
    }

    public void pause() {
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"pause() ", this.contextDetails});
        this.shouldPlay = false;
        this.pauseInternal();
    }

    private void pauseInternal() {
        Sugar.doIfNotNull((Object)((Object)this.frameSequenceDrawable), FrameSequenceDrawable::stop);
    }

    private void playInternal() {
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"playInternal() ", this.contextDetails});
        if (this.frameSequenceDrawable != null) {
            this.frameSequenceDrawable.start();
            this.onStartAnimationListener.onStart();
        }
        FrameSequenceSource source = this.currentSource;
        if (this.frameSequenceDisposable == null && this.currentSource != null) {
            this.frameSequenceDisposable = source.loadFrameSequence().delay(this.randomDelayTime(), TimeUnit.MILLISECONDS).map(sequence -> new FrameSequenceDrawable((FrameSequence)sequence, source.getDropFramesStrategy(), source.getContextDetails())).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).retry((integer, throwable) -> throwable instanceof InterruptedIOException && this.frameSequenceDisposable != null && !this.frameSequenceDisposable.isDisposed()).subscribe(this::onFrameSequenceLoaded, source::failedToGetFrameSequence);
        }
    }

    private boolean hasTransparency() {
        return Color.alpha((int)this.currentSource.getAverageColorInt()) < 255;
    }

    private long randomDelayTime() {
        return 50 + random.nextInt(200);
    }

    private class SingleNotificationListener
    implements OnStartAnimationListener {
        private OnStartAnimationListener real;
        private boolean notified = false;

        private SingleNotificationListener() {
        }

        public void setRealListener(OnStartAnimationListener real) {
            this.real = real;
        }

        @Override
        public void onStart() {
            if (this.real != null && !this.notified) {
                this.notified = true;
                this.real.onStart();
            }
        }
    }
}

