/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.framesequence;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Log;
import com.gfycat.common.ContextDetails;
import com.gfycat.common.EPS;
import com.gfycat.common.utils.Assertions;
import com.gfycat.common.utils.Utils;
import com.gfycat.framesequence.DropFramesStrategy;
import com.gfycat.framesequence.FPSDebugger;
import com.gfycat.framesequence.FrameSequence;
import com.gfycat.framesequence.FrameSequenceConfiguration;
import com.gfycat.framesequence.SerialExecutorService;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class FrameSequenceDrawable
extends Drawable
implements Animatable {
    private static final String LOG_TAG = FrameSequenceDrawable.class.getSimpleName();
    private static final long MIN_DELAY_MS = 16L;
    private static final long DEFAULT_DELAY_MS = 100L;
    private static Handler uiHandler;
    private SerialExecutorService decodingExecutor;
    private LoopListener loopListener;
    private static BitmapProvider sAllocatingBitmapProvider;
    private Paint debugPaint;
    private final FrameSequence mFrameSequence;
    private final DropFramesStrategy mDropFramesStrategy;
    private final Paint mPaint;
    private BitmapShader mFrontBitmapShader;
    private BitmapShader mBackBitmapShader;
    private final Rect mSrcRect;
    private boolean mCircleMaskEnabled;
    private final Object mLock = new Object();
    private final BitmapProvider mBitmapProvider;
    private ContextDetails contextDetails;
    private volatile boolean mDestroyed = false;
    private Bitmap mFrontBitmap;
    private Bitmap mBackBitmap;
    private ByteBuffer bitmapBuffer;
    private static final int STATE_SCHEDULED = 1;
    private static final int STATE_DECODING = 2;
    private static final int STATE_WAITING_TO_SWAP = 3;
    private static final int STATE_READY_TO_SWAP = 4;
    private int mState;
    private long mCurrentLoop;
    private long mLastSwap;
    private long mNextSwap;
    private long mSwapDelay;
    private int mPreviousRenderedFrame;
    private int mNextFrameToDecode;
    private Runnable invalidateRequest;
    private Runnable mDecodeRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Bitmap bitmap;
            int nextFrame;
            Object object = FrameSequenceDrawable.this.mLock;
            synchronized (object) {
                if (FrameSequenceDrawable.this.mDestroyed) {
                    return;
                }
                nextFrame = FrameSequenceDrawable.this.mNextFrameToDecode;
                if (nextFrame < 0) {
                    return;
                }
                bitmap = FrameSequenceDrawable.this.mBackBitmap;
                FrameSequenceDrawable.this.mState = 2;
            }
            long timeToNextFrame = 0L;
            if (FrameSequenceDrawable.this.mLastSwap > 0L) {
                int newNextFrame = FrameSequenceDrawable.this.computeNextFrame(nextFrame);
                timeToNextFrame = FrameSequenceDrawable.this.cumulativeFrameDuration(nextFrame, newNextFrame);
                nextFrame = newNextFrame;
            }
            FrameSequenceDrawable.this.mFrameSequence.drawFrame(nextFrame, bitmap);
            if (timeToNextFrame < 16L) {
                timeToNextFrame = 100L;
            }
            boolean schedule = false;
            Bitmap bitmapToRelease = null;
            Object object2 = FrameSequenceDrawable.this.mLock;
            synchronized (object2) {
                if (FrameSequenceDrawable.this.mDestroyed) {
                    bitmapToRelease = FrameSequenceDrawable.this.mBackBitmap;
                    FrameSequenceDrawable.this.mBackBitmap = null;
                } else if (FrameSequenceDrawable.this.mNextFrameToDecode >= 0 && FrameSequenceDrawable.this.mState == 2) {
                    schedule = true;
                    FrameSequenceDrawable.this.mNextSwap = timeToNextFrame + FrameSequenceDrawable.this.mLastSwap;
                    FrameSequenceDrawable.this.mNextFrameToDecode = nextFrame;
                    if (FrameSequenceConfiguration.loggingEnabled()) {
                        Log.d((String)LOG_TAG, (String)("decode() state:" + FrameSequenceDrawable.stateName(FrameSequenceDrawable.this.mState) + " nextSwap at " + Utils.humanReadableTimeSmall((long)FrameSequenceDrawable.this.mNextSwap) + " nextFrame:" + FrameSequenceDrawable.this.mNextFrameToDecode + " timeToNextFrame:" + Utils.humanReadableTimeInterval((long)timeToNextFrame) + "  callback = " + FrameSequenceDrawable.this.getCallback() + "" + FrameSequenceDrawable.this.contextDetails));
                    }
                    FrameSequenceDrawable.this.mState = 3;
                }
            }
            if (schedule) {
                if (FrameSequenceConfiguration.loggingEnabled()) {
                    Log.d((String)LOG_TAG, (String)("   nextSwap " + Utils.humanReadableTimeSmall((long)FrameSequenceDrawable.this.mNextSwap) + " in " + Utils.humanReadableTimeInterval((long)(FrameSequenceDrawable.this.mNextSwap - SystemClock.uptimeMillis())) + " " + FrameSequenceDrawable.this.contextDetails));
                }
                FrameSequenceDrawable.this.requestInvalidateThreadSafe();
            }
            if (bitmapToRelease != null) {
                FrameSequenceDrawable.this.mBitmapProvider.releaseBitmap(bitmapToRelease);
            }
        }
    };
    private FPSDebugger fpsDebugger = new FPSDebugger(10);

    private int computeNextFrame(int nextFrame) {
        if (DropFramesStrategy.DropNotAllowed.equals((Object)this.mDropFramesStrategy)) {
            return nextFrame;
        }
        int desiredFrame = this.findDesiredNextFrame(nextFrame);
        if (desiredFrame == nextFrame) {
            return nextFrame;
        }
        if (desiredFrame < nextFrame) {
            return desiredFrame;
        }
        if (DropFramesStrategy.DropAllowed.equals((Object)this.mDropFramesStrategy)) {
            return desiredFrame;
        }
        int lastKeyFrameInRange = this.mFrameSequence.lastKeyFrameInRange(nextFrame, desiredFrame);
        if (DropFramesStrategy.KeyFrameOrDropNotAllowed.equals((Object)this.mDropFramesStrategy)) {
            if (lastKeyFrameInRange == -1) {
                return nextFrame;
            }
            return lastKeyFrameInRange;
        }
        if (DropFramesStrategy.KeyFrameOrDropAllowed.equals((Object)this.mDropFramesStrategy)) {
            if (lastKeyFrameInRange == -1) {
                return desiredFrame;
            }
            return lastKeyFrameInRange;
        }
        throw new IllegalStateException("Not reachable.");
    }

    private long cumulativeFrameDuration(int start, int end) {
        long result = this.mFrameSequence.getFrameDuration(start);
        while (start != end) {
            start = (start + 1) % this.mFrameSequence.getFrameCount();
            result += this.mFrameSequence.getFrameDuration(start);
        }
        return result;
    }

    private int findDesiredNextFrame(int nextFrame) {
        long nextFrameDuration = this.mFrameSequence.getFrameDuration(nextFrame);
        long predictedNextFrameTime = this.mLastSwap + nextFrameDuration - SystemClock.uptimeMillis();
        int droppedFrames = 0;
        while ((nextFrame != 0 || this.canDropFirstFrame()) && predictedNextFrameTime < FrameSequenceConfiguration.get().getMinTimeToRenderNextFrame()) {
            ++droppedFrames;
            nextFrame = (nextFrame + 1) % this.mFrameSequence.getFrameCount();
            predictedNextFrameTime = this.mLastSwap + (nextFrameDuration += this.mFrameSequence.getFrameDuration(nextFrame)) - SystemClock.uptimeMillis();
            if (!this.mDestroyed) continue;
            return nextFrame;
        }
        if (FrameSequenceConfiguration.loggingEnabled() && droppedFrames > 0) {
            Log.d((String)LOG_TAG, (String)("drop " + droppedFrames + " frames " + this.contextDetails));
        }
        return nextFrame;
    }

    private boolean canDropFirstFrame() {
        return false;
    }

    private void initUIHandler() {
        if (uiHandler == null) {
            uiHandler = new Handler();
        }
    }

    private void requestInvalidateThreadSafe() {
        Runnable runnable = () -> {
            this.invalidateRequest = this::requestInvalidate;
            this.scheduleSelf(this.invalidateRequest, this.mNextSwap);
        };
        if (uiHandler == null) {
            runnable.run();
        } else {
            uiHandler.post(runnable);
        }
    }

    private static Bitmap acquireAndValidateBitmap(BitmapProvider bitmapProvider, int minWidth, int minHeight) {
        Bitmap bitmap = bitmapProvider.acquireBitmap(minWidth, minHeight);
        if (bitmap.getWidth() < minWidth || bitmap.getHeight() < minHeight || bitmap.getConfig() != Bitmap.Config.ARGB_8888) {
            throw new IllegalArgumentException("Invalid bitmap provided");
        }
        return bitmap;
    }

    public FrameSequenceDrawable(FrameSequence frameSequence, DropFramesStrategy dropFramesStrategy, ContextDetails contextDetails) {
        this(frameSequence, dropFramesStrategy, sAllocatingBitmapProvider, new Point(Integer.MAX_VALUE, Integer.MAX_VALUE), contextDetails);
    }

    public FrameSequenceDrawable(FrameSequence frameSequence, DropFramesStrategy dropFramesStrategy, Point renderSize, ContextDetails contextDetails) {
        this(frameSequence, dropFramesStrategy, sAllocatingBitmapProvider, renderSize, contextDetails);
    }

    public FrameSequenceDrawable(FrameSequence frameSequence, DropFramesStrategy dropFramesStrategy, BitmapProvider bitmapProvider, Point renderSize, ContextDetails contextDetails) {
        if (frameSequence == null || bitmapProvider == null) {
            throw new IllegalArgumentException();
        }
        if (FrameSequenceConfiguration.loggingEnabled()) {
            Log.d((String)LOG_TAG, (String)("FrameSequenceDrawable::<init> " + contextDetails));
        }
        this.contextDetails = contextDetails;
        this.mFrameSequence = frameSequence;
        this.mDropFramesStrategy = dropFramesStrategy;
        this.normalizeRendererSize(renderSize, frameSequence.getWidth(), frameSequence.getHeight());
        int width = Math.min(frameSequence.getWidth(), renderSize.x);
        int height = Math.min(frameSequence.getHeight(), renderSize.y);
        this.mBitmapProvider = bitmapProvider;
        this.mFrontBitmap = FrameSequenceDrawable.acquireAndValidateBitmap(bitmapProvider, width, height);
        this.mBackBitmap = FrameSequenceDrawable.acquireAndValidateBitmap(bitmapProvider, width, height);
        if (frameSequence.mayHaveBlending()) {
            this.bitmapBuffer = ByteBuffer.allocate(this.mFrontBitmap.getHeight() * this.mFrontBitmap.getRowBytes());
        }
        this.mSrcRect = new Rect(0, 0, width, height);
        this.mPaint = new Paint();
        this.mPaint.setFilterBitmap(true);
        this.mFrontBitmapShader = new BitmapShader(this.mFrontBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        this.mBackBitmapShader = new BitmapShader(this.mBackBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        this.mLastSwap = 0L;
        this.mNextFrameToDecode = -1;
        this.mFrameSequence.drawFrame(0, this.mFrontBitmap);
        this.initializeDecodingThread();
    }

    private void normalizeRendererSize(Point renderSize, int frameWidth, int frameHeight) {
        if (renderSize.x == Integer.MAX_VALUE || renderSize.y == Integer.MAX_VALUE) {
            renderSize.x = frameWidth;
            renderSize.y = frameHeight;
            return;
        }
        float frameAR = (float)frameWidth / (float)frameHeight;
        float renderAR = (float)renderSize.x / (float)renderSize.y;
        if (!EPS.isSame((float)frameAR, (float)renderAR, (float)0.1f)) {
            Assertions.fail((Throwable)new Throwable("Aspect ratios are not equal: " + frameAR + "!=" + renderAR + "\nContext: " + this.contextDetails));
            renderSize.x = frameWidth;
            renderSize.y = frameHeight;
        }
    }

    private void initializeDecodingThread() {
        this.decodingExecutor = new SerialExecutorService(FrameSequenceConfiguration.get().getDecodingExecutor());
    }

    public void setLoopListener(LoopListener loopListener) {
        this.loopListener = loopListener;
    }

    public final void setCircleMaskEnabled(boolean circleMaskEnabled) {
        this.mCircleMaskEnabled = circleMaskEnabled;
        this.mPaint.setAntiAlias(circleMaskEnabled);
    }

    private void checkDestroyedLocked() {
        if (this.mDestroyed) {
            throw new IllegalStateException("Cannot perform operation on recycled drawable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDestroyed() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mDestroyed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Bitmap bitmapToReleaseA;
        if (this.mBitmapProvider == null) {
            throw new IllegalStateException("BitmapProvider must be non-null");
        }
        Bitmap bitmapToReleaseB = null;
        Object object = this.mLock;
        synchronized (object) {
            this.checkDestroyedLocked();
            bitmapToReleaseA = this.mFrontBitmap;
            this.mFrontBitmap = null;
            if (this.mState != 2) {
                bitmapToReleaseB = this.mBackBitmap;
                this.mBackBitmap = null;
            }
            this.mDestroyed = true;
        }
        this.mBitmapProvider.releaseBitmap(bitmapToReleaseA);
        if (bitmapToReleaseB != null) {
            this.mBitmapProvider.releaseBitmap(bitmapToReleaseB);
        }
        this.mFrameSequence.release();
        this.loopListener = null;
    }

    protected void finalize() throws Throwable {
        try {
            this.mFrameSequence.release();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Canvas canvas) {
        this.initUIHandler();
        Object object = this.mLock;
        synchronized (object) {
            if (FrameSequenceConfiguration.loggingEnabled()) {
                Log.d((String)LOG_TAG, (String)("draw(...) state:" + FrameSequenceDrawable.stateName(this.mState) + " " + this.contextDetails));
            }
            this.checkDestroyedLocked();
            if (this.mState == 3 && this.mNextSwap - SystemClock.uptimeMillis() <= 0L) {
                this.mState = 4;
            }
            if (this.isRunning() && this.mState == 4) {
                if (this.mFrameSequence.mayHaveBlending()) {
                    this.mBackBitmap.copyPixelsToBuffer((Buffer)this.bitmapBuffer);
                    this.bitmapBuffer.rewind();
                    this.mFrontBitmap.copyPixelsFromBuffer((Buffer)this.bitmapBuffer);
                    this.bitmapBuffer.rewind();
                } else {
                    Bitmap tmp = this.mBackBitmap;
                    this.mBackBitmap = this.mFrontBitmap;
                    this.mFrontBitmap = tmp;
                }
                BitmapShader tmpShader = this.mBackBitmapShader;
                this.mBackBitmapShader = this.mFrontBitmapShader;
                this.mFrontBitmapShader = tmpShader;
                if (this.mLastSwap > 0L && this.mNextSwap > 0L) {
                    this.mSwapDelay = SystemClock.uptimeMillis() - this.mNextSwap;
                    if (this.fpsDebugger != null) {
                        this.fpsDebugger.addFrame(this.mSwapDelay);
                    }
                }
                this.mLastSwap = SystemClock.uptimeMillis();
                if (FrameSequenceConfiguration.loggingEnabled()) {
                    Log.d((String)LOG_TAG, (String)("    swap at " + Utils.humanReadableTimeSmall((long)this.mLastSwap) + "  state:" + FrameSequenceDrawable.stateName(this.mState) + " " + this.contextDetails));
                    if (this.mNextSwap > SystemClock.uptimeMillis() + 100L) {
                        Log.d((String)LOG_TAG, (String)("    swap happens to early " + Utils.humanReadableTimeInterval((long)(this.mNextSwap - SystemClock.uptimeMillis())) + " " + this.contextDetails));
                    }
                }
                if (this.mPreviousRenderedFrame > this.mNextFrameToDecode) {
                    ++this.mCurrentLoop;
                    this.notifyLoop();
                }
                this.mPreviousRenderedFrame = this.mNextFrameToDecode;
                this.scheduleDecodeLocked();
            }
        }
        if (this.mCircleMaskEnabled) {
            Rect bounds = this.getBounds();
            this.mPaint.setShader((Shader)this.mFrontBitmapShader);
            float width = bounds.width();
            float height = bounds.height();
            float circleRadius = Math.min(width, height) / 2.0f;
            canvas.drawCircle(width / 2.0f, height / 2.0f, circleRadius, this.mPaint);
        } else {
            this.mPaint.setShader(null);
            canvas.drawBitmap(this.mFrontBitmap, this.mSrcRect, this.getBounds(), this.mPaint);
        }
        if (this.debugPaint != null) {
            int padding = 10;
            String text = "" + this.fpsDebugger.last() + " / " + this.fpsDebugger.max() + " / " + this.fpsDebugger.avg();
            canvas.drawText(text, (float)padding, (float)(this.getIntrinsicHeight() - padding), this.debugPaint);
        }
    }

    private static String stateName(int state) {
        if (state == 2) {
            return "STATE_DECODING";
        }
        if (state == 4) {
            return "READY_TO_SWAP";
        }
        if (state == 1) {
            return "SCHEDULED";
        }
        if (state == 3) {
            return "WAITING_TO_SWAP";
        }
        return "UNKNOWN";
    }

    private void notifyLoop() {
        if (this.loopListener != null) {
            this.loopListener.onLoop((int)this.mCurrentLoop);
        }
    }

    private void scheduleDecodeLocked() {
        this.mState = 1;
        this.mNextFrameToDecode = (this.mNextFrameToDecode + 1) % this.mFrameSequence.getFrameCount();
        this.decodingExecutor.submit(this.mDecodeRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestInvalidate() {
        boolean invalidate = false;
        Object object = this.mLock;
        synchronized (object) {
            if (FrameSequenceConfiguration.loggingEnabled()) {
                Log.d((String)LOG_TAG, (String)("requestInvalidate() state:" + FrameSequenceDrawable.stateName(this.mState) + " " + this.contextDetails));
            }
            if (this.mNextFrameToDecode >= 0 && this.mState == 3) {
                this.mState = 4;
                invalidate = true;
            }
        }
        if (invalidate) {
            this.invalidateSelf();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (FrameSequenceConfiguration.loggingEnabled()) {
            Log.d((String)LOG_TAG, (String)("start() " + this.contextDetails));
        }
        if (!this.isRunning()) {
            Object object = this.mLock;
            synchronized (object) {
                this.checkDestroyedLocked();
                if (this.mState == 1) {
                    return;
                }
                this.mCurrentLoop = 0L;
                this.scheduleDecodeLocked();
            }
        }
    }

    public void stop() {
        if (FrameSequenceConfiguration.loggingEnabled()) {
            Log.d((String)LOG_TAG, (String)("stop() " + this.contextDetails));
        }
        if (this.isRunning()) {
            this.unscheduleSelf(this.invalidateRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mNextFrameToDecode > -1 && !this.mDestroyed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unscheduleSelf(Runnable what) {
        Object object = this.mLock;
        synchronized (object) {
            this.mNextFrameToDecode = -1;
            this.mState = 0;
        }
        super.unscheduleSelf(what);
    }

    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (!visible) {
            this.stop();
        } else if (restart || changed) {
            this.stop();
            this.start();
        }
        return changed;
    }

    public long getLoopsCount() {
        return this.mCurrentLoop;
    }

    public void setFilterBitmap(boolean filter) {
        this.mPaint.setFilterBitmap(filter);
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }

    public int getIntrinsicWidth() {
        return this.mFrameSequence.getWidth();
    }

    public int getIntrinsicHeight() {
        return this.mFrameSequence.getHeight();
    }

    public int getOpacity() {
        return this.mFrameSequence.isOpaque() ? -1 : -2;
    }

    public void setDebugMode(boolean debugMode) {
        if (debugMode) {
            this.debugPaint = new Paint();
            this.debugPaint.setColor(-65536);
            this.debugPaint.setTextSize(24.0f);
        } else {
            this.debugPaint = null;
        }
    }

    static {
        sAllocatingBitmapProvider = new BitmapProvider(){

            @Override
            public Bitmap acquireBitmap(int minWidth, int minHeight) {
                return Bitmap.createBitmap((int)minWidth, (int)minHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }

            @Override
            public void releaseBitmap(Bitmap bitmap) {
            }
        };
    }

    static interface BitmapProvider {
        public Bitmap acquireBitmap(int var1, int var2);

        public void releaseBitmap(Bitmap var1);
    }

    public static interface LoopListener {
        public void onLoop(int var1);
    }
}

