/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.framesequence;

import com.gfycat.framesequence.Runnables;
import com.gfycat.framesequence.ThreadPriorityRunnable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class FrameSequenceConfiguration {
    private static final long DEFAULT_MIN_TIME_TO_RENDER_NEXT_FRAME = 40L;
    private static FrameSequenceConfiguration INSTANCE;
    private final LogLevel logLevel;
    private final long minTimeToRenderNextFrame;
    private final ExecutorService decodingExecutorService;

    private FrameSequenceConfiguration(long minTimeToRenderNextFrame, ExecutorService decodingExecutor, LogLevel logLevel) {
        this.minTimeToRenderNextFrame = minTimeToRenderNextFrame == -1L ? 40L : minTimeToRenderNextFrame;
        this.decodingExecutorService = decodingExecutor != null ? decodingExecutor : FrameSequenceConfiguration.getDefaultDecodingExecutor();
        this.logLevel = logLevel != null ? logLevel : LogLevel.NONE;
    }

    public static synchronized void init(FrameSequenceConfiguration configuration) {
        if (INSTANCE != null) {
            throw new IllegalStateException("FrameSequenceConfiguration::could be called only once. Be sure that this method was called before any drawable was rendered.");
        }
        INSTANCE = configuration;
    }

    private static void ensureInitialized() {
        if (INSTANCE == null) {
            INSTANCE = new Builder().build();
        }
    }

    public static FrameSequenceConfiguration get() {
        FrameSequenceConfiguration.ensureInitialized();
        return INSTANCE;
    }

    public static boolean loggingEnabled() {
        return LogLevel.VERBOSE.equals((Object)FrameSequenceConfiguration.get().getLogLevel());
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public Executor getDecodingExecutor() {
        return this.decodingExecutorService;
    }

    public long getMinTimeToRenderNextFrame() {
        return this.minTimeToRenderNextFrame;
    }

    private static ExecutorService getDefaultDecodingExecutor() {
        int threadsCount = FrameSequenceConfiguration.getDecodingExecutorThreadsCount();
        return Executors.newFixedThreadPool(threadsCount, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(new Runnables(new ThreadPriorityRunnable(10), runnable));
            }
        });
    }

    private static int getDecodingExecutorThreadsCount() {
        switch (Runtime.getRuntime().availableProcessors()) {
            case 1: {
                return 1;
            }
            case 2: 
            case 3: 
            case 4: {
                return 2;
            }
            case 5: 
            case 6: {
                return 3;
            }
            case 7: 
            case 8: {
                return 4;
            }
        }
        return 5;
    }

    public static class Builder {
        private LogLevel logLevel;
        private long minTimeToRenderNextFrame = -1L;
        private ExecutorService decodingExecutor;

        public Builder setLogLevel(LogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder setDecodingExecutor(ExecutorService decodingExecutor) {
            this.decodingExecutor = decodingExecutor;
            return this;
        }

        public Builder setMinTimeToRenderNextFrame(long minTimeToRenderNextFrame) {
            this.minTimeToRenderNextFrame = minTimeToRenderNextFrame;
            return this;
        }

        public FrameSequenceConfiguration build() {
            return new FrameSequenceConfiguration(this.minTimeToRenderNextFrame, this.decodingExecutor, this.logLevel);
        }
    }

    public static enum LogLevel {
        NONE,
        VERBOSE;

    }
}

