/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.framesequence;

public class FPSDebugger {
    private int framesCount = 0;
    private final long[] frameDuration;

    public FPSDebugger(int framesToKeep) {
        this.frameDuration = new long[framesToKeep];
    }

    public void addFrame(long duration) {
        this.frameDuration[this.framesCount % this.frameDuration.length] = duration;
        ++this.framesCount;
    }

    public long avg() {
        if (this.framesCount == 0) {
            return -1L;
        }
        long sum = 0L;
        int size = Math.min(this.frameDuration.length, this.framesCount);
        for (int i = 0; i < Math.min(this.frameDuration.length, this.framesCount); ++i) {
            sum += this.frameDuration[i];
        }
        return sum / (long)size;
    }

    public long max() {
        long max = Long.MIN_VALUE;
        int size = Math.min(this.frameDuration.length, this.framesCount);
        for (int i = 0; i < size; ++i) {
            if (max >= this.frameDuration[i]) continue;
            max = this.frameDuration[i];
        }
        return max;
    }

    public long last() {
        return this.frameDuration[this.framesCount % this.frameDuration.length];
    }
}

