/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.disklrucache;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class RandomAccessOutput
extends OutputStream {
    private RandomAccessFile randomAccessFile;

    public RandomAccessOutput() {
    }

    public RandomAccessOutput(File file) throws FileNotFoundException {
        this.randomAccessFile = new RandomAccessFile(file, "rw");
    }

    public long length() throws IOException {
        if (this.randomAccessFile != null) {
            return this.randomAccessFile.length();
        }
        return 0L;
    }

    public void seek(long pos) throws IOException {
        if (this.randomAccessFile != null) {
            this.randomAccessFile.seek(pos);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.randomAccessFile != null) {
            this.randomAccessFile.write(b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.randomAccessFile != null) {
            this.randomAccessFile.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.randomAccessFile != null) {
            this.randomAccessFile.write(b, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.randomAccessFile != null) {
            this.randomAccessFile.getFD().sync();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.randomAccessFile != null) {
            this.randomAccessFile.close();
        }
    }
}

