/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.storage;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import com.gfycat.common.utils.Assertions;
import com.gfycat.common.utils.Logging;
import com.gfycat.common.utils.ThreadUtils;
import com.gfycat.core.GfyCore;
import com.gfycat.core.GfyPrivate;
import com.gfycat.core.gfycatapi.pojo.Gfycat;
import com.gfycat.core.storage.DefaultDiskCache;
import com.gfycat.core.storage.MediaType;
import com.gfycat.core.storage.ParcelFileDescriptorUtil;
import com.gfycat.core.storage.VideoProviderContract;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class VideoFileProvider
extends ContentProvider {
    private static final String LOG_TAG = "VideoFileProvider";
    private static final int SUPPORTED_FORMAT_CODE = 1;
    private static final UriMatcher URI_MATCHER = new UriMatcher(-1);

    public boolean onCreate() {
        return true;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        switch (URI_MATCHER.match(uri)) {
            case 1: {
                MediaType mediaType = MediaType.valueOf((String)uri.getPathSegments().get(1));
                String gfyId = (String)uri.getPathSegments().get(2);
                return this.cursorFor(mediaType, gfyId);
            }
        }
        Assertions.fail((Throwable)new IllegalArgumentException("Unknown uri: " + uri));
        return null;
    }

    private Cursor cursorFor(MediaType mediaType, String gfyId) {
        MatrixCursor cursor = new MatrixCursor(new String[]{"_display_name", "_size"}, 1);
        cursor.addRow(new Object[]{gfyId, mediaType.getSizeHint()});
        return cursor;
    }

    public String getType(Uri uri) {
        switch (URI_MATCHER.match(uri)) {
            case 1: {
                MediaType mediaType = MediaType.valueOf((String)uri.getPathSegments().get(1));
                Logging.d((String)LOG_TAG, (Object[])new Object[]{"::getType(", uri, ") return ", mediaType.getMimeType()});
                return mediaType.getMimeType();
            }
        }
        Assertions.fail((Throwable)new IllegalArgumentException("Unknown uri: " + uri));
        return null;
    }

    public Uri insert(Uri uri, ContentValues values) {
        Assertions.fail((Throwable)new UnsupportedOperationException("VideoFileProvider::insert(" + uri + ")"));
        return null;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        Assertions.fail((Throwable)new UnsupportedOperationException("VideoFileProvider::delete(" + uri + ")"));
        return -1;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        Assertions.fail((Throwable)new UnsupportedOperationException("VideoFileProvider::update(" + uri + ")"));
        return -1;
    }

    public ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"::openFile(", uri, ", ", mode, ")"});
        this.guard(uri, mode);
        Params params = VideoFileProvider.paramsFromUri(uri);
        if (VideoProviderContract.SharingType.CACHED.equals((Object)params.sharingType)) {
            return this.getCachedParcelFileDescriptor(params);
        }
        if (VideoProviderContract.SharingType.REMOTE.equals((Object)params.sharingType)) {
            return this.getRemoteParcelFileDescriptor(params);
        }
        VideoFileProvider.logAndThrowFileNotFound("Unknown sharing type for uri = " + uri + " s sharing type = " + (Object)((Object)params.sharingType));
        return null;
    }

    private ParcelFileDescriptor getCachedParcelFileDescriptor(Params params) throws FileNotFoundException {
        File videoFile;
        DefaultDiskCache diskCache = DefaultDiskCache.get();
        if (!diskCache.isAvailable()) {
            VideoFileProvider.logAndThrowFileNotFound("VideoFileProvider::openFile() diskCache.isAvailable = false, can not return anything.");
        }
        if ((videoFile = diskCache.get(params.gfyId)) == null) {
            VideoFileProvider.logAndThrowFileNotFound("VideoFileProvider::openFile() videoFile == null.");
        }
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"::openFile(...) success gfyId = ", params.gfyId, " file = ", videoFile.getAbsolutePath()});
        return ParcelFileDescriptor.open((File)videoFile, (int)0x10000000);
    }

    private static void logAndThrowFileNotFound(String message) throws FileNotFoundException {
        Logging.d((String)LOG_TAG, (String)message);
        Assertions.fail((Throwable)new FileNotFoundException(message));
        throw new FileNotFoundException(message);
    }

    private void guard(Uri uri, String mode) throws FileNotFoundException {
        Assertions.assertNotUIThread(IllegalAccessException::new);
        if (!"r".equals(mode)) {
            VideoFileProvider.logAndThrowFileNotFound("VideoFileProvider::openFile() trying to access " + uri + " in mode = " + mode);
        }
    }

    private ParcelFileDescriptor getRemoteParcelFileDescriptor(Params params) throws FileNotFoundException {
        Gfycat gfycat = this.getGfycatSync(params.gfyId);
        if (gfycat == null) {
            throw new FileNotFoundException("Can not get gfycat item.");
        }
        String url = (String)ThreadUtils.withClearIdentitySafe(() -> params.mediaType.getUrl(gfycat));
        try {
            return ParcelFileDescriptorUtil.pipeFrom(GfyPrivate.get().getVideoDownloadingClient(), url);
        }
        catch (IOException e) {
            VideoFileProvider.logAndThrowFileNotFound("IOException occurred : " + e);
            return null;
        }
    }

    private Gfycat getGfycatSync(String gfyId) {
        return (Gfycat)GfyCore.getFeedManager().getGfycat(gfyId).blockingGet();
    }

    private static Params paramsFromUri(Uri uri) throws FileNotFoundException {
        if (URI_MATCHER.match(uri) == -1) {
            VideoFileProvider.logAndThrowFileNotFound("Unsupported uri = " + uri);
        }
        VideoProviderContract.SharingType sharingType = VideoProviderContract.SharingType.valueOf((String)uri.getPathSegments().get(0));
        MediaType mediaType = MediaType.valueOf((String)uri.getPathSegments().get(1));
        String gfyId = (String)uri.getPathSegments().get(2);
        if (TextUtils.isEmpty((CharSequence)gfyId)) {
            VideoFileProvider.logAndThrowFileNotFound("Can not parse params from uri = " + uri + " (gfyId = " + gfyId + " mediaType = " + (Object)((Object)mediaType) + " sharingType = " + (Object)((Object)sharingType) + ")");
        }
        return new Params(sharingType, mediaType, gfyId);
    }

    static {
        URI_MATCHER.addURI(VideoProviderContract.AUTHORITY, "*/*/*", 1);
    }

    private static class Params {
        private final VideoProviderContract.SharingType sharingType;
        private final MediaType mediaType;
        private final String gfyId;

        public Params(VideoProviderContract.SharingType sharingType, MediaType mediaType, String gfyId) {
            this.sharingType = sharingType;
            this.mediaType = mediaType;
            this.gfyId = gfyId;
        }
    }
}

