/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.storage;

import android.os.ParcelFileDescriptor;
import com.gfycat.common.utils.Logging;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.apache.commons.io.IOUtils;

public class ParcelFileDescriptorUtil {
    public static ParcelFileDescriptor pipeFrom(InputStream inputStream) throws IOException {
        ParcelFileDescriptor[] pipe = ParcelFileDescriptor.createPipe();
        ParcelFileDescriptor readSide = pipe[0];
        ParcelFileDescriptor writeSide = pipe[1];
        new TransferThread(inputStream, (OutputStream)new ParcelFileDescriptor.AutoCloseOutputStream(writeSide)).start();
        return readSide;
    }

    public static ParcelFileDescriptor pipeTo(OutputStream outputStream) throws IOException {
        ParcelFileDescriptor[] pipe = ParcelFileDescriptor.createPipe();
        ParcelFileDescriptor readSide = pipe[0];
        ParcelFileDescriptor writeSide = pipe[1];
        new TransferThread((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(readSide), outputStream).start();
        return writeSide;
    }

    public static ParcelFileDescriptor pipeFrom(OkHttpClient client, String url) throws IOException {
        ParcelFileDescriptor[] pipe = ParcelFileDescriptor.createPipe();
        ParcelFileDescriptor readSide = pipe[0];
        ParcelFileDescriptor writeSide = pipe[1];
        new UrlTransferThread(client, url, (OutputStream)new ParcelFileDescriptor.AutoCloseOutputStream(writeSide)).start();
        return readSide;
    }

    static class TransferThread
    extends Thread {
        private static final String LOG_TAG = TransferThread.class.getSimpleName();
        protected InputStream mIn;
        protected OutputStream mOut;

        TransferThread(InputStream in, OutputStream out) {
            this();
            this.mIn = in;
            this.mOut = out;
        }

        public TransferThread() {
            super("TransferThread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            Logging.d((String)LOG_TAG, (String)"run()");
            try {
                long total = 0L;
                this.prepareStreams();
                IOUtils.copy((InputStream)this.mIn, (OutputStream)this.mOut);
                Logging.d((String)LOG_TAG, (String)"writing() end");
            }
            catch (IOException e) {
                Logging.e((String)LOG_TAG, (Object[])new Object[]{"writing failed"});
            }
            finally {
                IOUtils.closeQuietly((InputStream)this.mIn);
                IOUtils.closeQuietly((OutputStream)this.mOut);
            }
        }

        void prepareStreams() throws IOException {
        }
    }

    static class UrlTransferThread
    extends TransferThread {
        final String url;
        private final OkHttpClient client;

        UrlTransferThread(OkHttpClient client, String url, OutputStream out) {
            super(null, out);
            this.url = url;
            this.client = client;
        }

        @Override
        void prepareStreams() throws IOException {
            this.mIn = this.client.newCall(new Request.Builder().url(this.url).build()).execute().body().byteStream();
        }
    }
}

