/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.storage;

import android.text.TextUtils;
import com.gfycat.common.Func1;
import com.gfycat.common.utils.Logging;
import com.gfycat.core.GfyPrivate;
import com.gfycat.core.gfycatapi.pojo.Gfycat;

public enum MediaType {
    MP4("MP4", "video/mp4", "mp4", "https://thumbs.{domainName}/{gfyName}-mobile.mp4", -1L, true, (Func1<Gfycat, String>)((Func1)Gfycat::getMp4MobileUrl)),
    GIF1("GIF1", "image/gif", "gif", "https://thumbs.{domainName}/{gfyName}-max-1mb.gif ", 0x100000L, false, (Func1<Gfycat, String>)((Func1)Gfycat::getGif1mbUrl)),
    GIF2("GIF2", "image/gif", "gif", "https://thumbs.{domainName}/{gfyName}-small.gif", 0x200000L, false, (Func1<Gfycat, String>)((Func1)Gfycat::getGif2mbUrl)),
    GIF5("GIF5", "image/gif", "gif", "https://thumbs.{domainName}/{gfyName}-size_restricted.gif", 0x500000L, false, (Func1<Gfycat, String>)((Func1)Gfycat::getGif5mbUrl)),
    WEBP("WEBP", "image/webp", "webp", "https://thumbs.{domainName}/{gfyName}.webp", -1L, false, (Func1<Gfycat, String>)((Func1)Gfycat::getWebPUrl)),
    TRANSPARENT_POSTER("TRANSPARENT_POSTER", "image/png", "png", "https://thumbs.{domainName}/{gfyName}-transparent.png", -1L, false, (Func1<Gfycat, String>)((Func1)Gfycat::getPosterPngUrl)),
    POSTER("POSTER", "image/jpg", "jpg", "https://thumbs.{domainName}/{gfyName}-mobile.jpg", -1L, false, (Func1<Gfycat, String>)((Func1)Gfycat::getPosterMobileUrl));

    private static final String LOG_TAG = "MediaType";
    private static final String DOMAIN_NAME_PART = "{domainName}";
    private static final String GFY_NAME_PART = "{gfyName}";
    private final String name;
    private final String mimeType;
    private final String extension;
    private final String urlTemplate;
    private final long sizeHint;
    private final boolean isVideo;
    private final Func1<Gfycat, String> getUrlFromGfycat;

    private MediaType(String name, String mimeType, String extension, String urlTemplate, long sizeHint, boolean isVideo, Func1<Gfycat, String> getFromGfycat) {
        this.name = name;
        this.mimeType = mimeType;
        this.extension = extension;
        this.urlTemplate = urlTemplate;
        this.sizeHint = sizeHint;
        this.isVideo = isVideo;
        this.getUrlFromGfycat = getFromGfycat;
    }

    public String getUrl(Gfycat gfycat) {
        return this.getUrlSafe((String)this.getUrlFromGfycat.call((Object)gfycat), gfycat.getGfyName());
    }

    private String getUrlSafe(String gfycatUrl, String gfyName) {
        if (TextUtils.isEmpty((CharSequence)gfycatUrl) && !TextUtils.isEmpty((CharSequence)this.urlTemplate)) {
            Logging.e((String)LOG_TAG, (Object[])new Object[]{"Using hardcoded url for " + this.mimeType + " of " + gfyName});
            return this.urlTemplate.replace(DOMAIN_NAME_PART, GfyPrivate.get().getDomainName()).replace(GFY_NAME_PART, gfyName);
        }
        return gfycatUrl;
    }

    public long getSizeHint() {
        return this.sizeHint;
    }

    public boolean isVideo() {
        return this.isVideo;
    }

    public String getName() {
        return this.name;
    }

    String getVideoStorageId(Gfycat gfycat) {
        return gfycat.getGfyId() + '_' + this.name.toLowerCase() + '.' + this.extension;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public static MediaType posterType(Gfycat gfycat) {
        return gfycat.hasTransparency() ? TRANSPARENT_POSTER : POSTER;
    }
}

