/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.storage;

import com.gfycat.common.ContextDetails;
import com.gfycat.core.gfycatapi.pojo.Gfycat;
import com.gfycat.core.storage.MediaFilesManager;
import com.gfycat.core.storage.MediaType;
import io.reactivex.Single;
import io.reactivex.subjects.ReplaySubject;
import java.io.File;

public class MediaFilesManagerAsyncWrapper
implements MediaFilesManager {
    private ReplaySubject<MediaFilesManager> subject = ReplaySubject.create();

    public void init(MediaFilesManager mediaFilesManager) {
        if (this.subject.hasComplete()) {
            return;
        }
        this.subject.onNext((Object)mediaFilesManager);
        this.subject.onComplete();
    }

    @Override
    public Single<byte[]> loadAsByteArray(Gfycat gfycat, MediaType mediaType) {
        return this.subject.singleOrError().flatMap(manager -> manager.loadAsByteArray(gfycat, mediaType));
    }

    @Override
    public Single<File> loadAsFile(Gfycat gfycat, MediaType mediaType) {
        return this.subject.singleOrError().flatMap(manager -> manager.loadAsFile(gfycat, mediaType));
    }

    @Override
    public Single<byte[]> loadAsByteArray(Gfycat gfycat, MediaType mediaType, ContextDetails contextDetails) {
        return this.subject.singleOrError().flatMap(manager -> manager.loadAsByteArray(gfycat, mediaType, contextDetails));
    }

    @Override
    public Single<File> loadAsFile(Gfycat gfycat, MediaType mediaType, ContextDetails contextDetails) {
        return this.subject.singleOrError().flatMap(manager -> manager.loadAsFile(gfycat, mediaType, contextDetails));
    }
}

