/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.storage;

import com.gfycat.core.storage.DefaultDiskCache;
import com.gfycat.core.storage.DiskCache;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.apache.commons.io.IOUtils;

public class DiskCacheUtils {
    public static String randomAvailableKeyWithSuffix(DiskCache cache, String suffix) {
        int MAX_TRY_COUNT = 5;
        for (int i = 0; i < MAX_TRY_COUNT; ++i) {
            String candidate = UUID.randomUUID() + suffix;
            if (!cache.isAvailable(candidate)) continue;
            return candidate;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String randomPathWithSuffixInCache(DiskCache cache, String suffix, byte[] bytes) {
        ByteArrayInputStream is = null;
        try {
            String fileKey = DiskCacheUtils.randomAvailableKeyWithSuffix(cache, suffix);
            is = new ByteArrayInputStream(bytes);
            cache.put(fileKey, is);
            String string2 = cache.get(fileKey).getPath();
            IOUtils.closeQuietly((InputStream)is);
            return string2;
        }
        catch (DefaultDiskCache.NotValidCacheException | DefaultDiskCache.OtherEditInProgressException | IOException e) {
            String string3 = null;
            return string3;
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }
}

