/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.storage;

import android.support.annotation.Nullable;
import com.gfycat.common.utils.Assertions;
import com.gfycat.common.utils.Logging;
import com.gfycat.core.storage.DiskCache;
import com.gfycat.disklrucache.DiskLruCache;
import io.reactivex.Observable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Queue;
import org.apache.commons.io.IOUtils;

public class DefaultDiskCache
implements DiskCache {
    public static final long DEFAULT_MIN_SPACE_MB = 50L;
    public static final long DEFAULT_MAX_SPACE_MB = 200L;
    private static final float GFYCAT_CACHE_SPACE_FRACTION = 0.5f;
    private static final long MIN_GUARANTEED_FREE_USER_SPACE_MB = 50L;
    private static final String LOG_TAG = "DefaultDiskCache";
    private static final String CACHE_FOLDER_RELATIVE_PATH = "gfycat_media_cache";
    private static final int APP_VERSION = 1;
    private static volatile DefaultDiskCache INSTANCE;
    private final DiskLruCache diskLruCache;

    private static DiskLruCache construct(Queue<File> cacheFolderOptions, CacheSizeOptions cacheSizeOptions) {
        DiskLruCache result = null;
        while (!cacheFolderOptions.isEmpty()) {
            File option = cacheFolderOptions.poll();
            result = DefaultDiskCache.construct(option, cacheSizeOptions);
            if (result == null) continue;
            Logging.c((String)LOG_TAG, (Object[])new Object[]{"DefaultDiskCache constructed at directory = ", option});
            break;
        }
        if (result == null) {
            Logging.c((String)LOG_TAG, (Object[])new Object[]{"Unable to construct DefaultDiskCache working without cache."});
        }
        return result;
    }

    private static DiskLruCache construct(File cacheFolder, CacheSizeOptions cacheSizeOptions) {
        if (cacheFolder == null) {
            return null;
        }
        try {
            Logging.d((String)LOG_TAG, (Object[])new Object[]{"::DefaultDiskCache(...) try to construct cache on dir = ", cacheFolder});
            return DiskLruCache.open(new File(cacheFolder, CACHE_FOLDER_RELATIVE_PATH), 1, DefaultDiskCache.calculateOptimalCacheSize(cacheFolder, cacheSizeOptions));
        }
        catch (IOException e) {
            Logging.c((String)LOG_TAG, (Object[])new Object[]{"Unable to construct cache, IOException happened while constructing cache at = ", cacheFolder, ". ", e});
        }
        catch (NotEnoughSpace e) {
            Logging.c((String)LOG_TAG, (Object[])new Object[]{"Unable to construct cache, not enough space usable = ", e.usableSpace, " gfycatSpace = ", e.gfycatSpace, " at = ", cacheFolder});
        }
        catch (CacheSizeNotSet e) {
            Logging.d((String)LOG_TAG, (String)"Cache size parameters are set to 0");
        }
        catch (CacheSizeSetIncorrectly e) {
            Logging.d((String)LOG_TAG, (String)"Unable to construct cache. Cache size parameters are set incorrectly");
        }
        return null;
    }

    private static long calculateOptimalCacheSize(File cacheFolder, CacheSizeOptions cacheSizeOptions) throws NotEnoughSpace, CacheSizeSetIncorrectly, CacheSizeNotSet {
        if (cacheSizeOptions.minSpaceMb > cacheSizeOptions.maxSpaceMb) {
            throw new CacheSizeSetIncorrectly();
        }
        if (cacheSizeOptions.maxSpaceMb == 0L) {
            throw new CacheSizeNotSet();
        }
        long minSpace = cacheSizeOptions.minSpaceMb * 0x100000L;
        long maxSpace = cacheSizeOptions.maxSpaceMb * 0x100000L;
        long freeUserSpace = cacheFolder.getUsableSpace();
        long fractionatedUserSpace = (long)((float)freeUserSpace * 0.5f);
        long allowedCacheSpace = freeUserSpace - 0x3200000L;
        long proposedCacheSpace = Math.max(minSpace, fractionatedUserSpace);
        if (allowedCacheSpace < minSpace) {
            throw new NotEnoughSpace(freeUserSpace, proposedCacheSpace);
        }
        if (allowedCacheSpace < proposedCacheSpace) {
            proposedCacheSpace = allowedCacheSpace;
        }
        if (proposedCacheSpace > maxSpace) {
            proposedCacheSpace = maxSpace;
        }
        return proposedCacheSpace;
    }

    private DefaultDiskCache(Queue<File> cacheFolderOptions, CacheSizeOptions cacheSizeOptions) {
        this.diskLruCache = DefaultDiskCache.construct(cacheFolderOptions, cacheSizeOptions);
    }

    public static synchronized DefaultDiskCache initialize(Queue<File> cacheFolderOptions, CacheSizeOptions cacheSizeOptions) {
        if (INSTANCE == null) {
            INSTANCE = new DefaultDiskCache(cacheFolderOptions, cacheSizeOptions);
        }
        return INSTANCE;
    }

    public static DefaultDiskCache get() {
        return INSTANCE;
    }

    private static void guard() {
        Assertions.assertNotUIThread(IllegalAccessException::new);
    }

    private boolean isValid() {
        return this.diskLruCache != null;
    }

    @Override
    public boolean isAvailable() {
        return this.isValid();
    }

    @Override
    public boolean isAvailable(String fileKey) {
        DefaultDiskCache.guard();
        if (!this.isValid()) {
            return false;
        }
        try {
            DiskLruCache.Snapshot snapshot = this.diskLruCache.get(fileKey);
            return snapshot == null;
        }
        catch (IOException e) {
            Logging.e((String)LOG_TAG, (Object[])new Object[]{"::DefaultDiskCache::get(" + fileKey + ") IOException happens while getting.", e});
            return false;
        }
    }

    @Override
    public File get(String fileKey) {
        DefaultDiskCache.guard();
        if (!this.isValid()) {
            return null;
        }
        try {
            DiskLruCache.Snapshot snapshot = this.diskLruCache.get(fileKey);
            if (snapshot == null) {
                return null;
            }
            return snapshot.getFile();
        }
        catch (IOException e) {
            Logging.e((String)LOG_TAG, (Object[])new Object[]{"::DefaultDiskCache::get(" + fileKey + ") IOException happens while getting.", e});
            return null;
        }
    }

    @Override
    public Observable<File> loadFile(String fileKey) {
        return Observable.create(subscriber -> {
            subscriber.onNext((Object)this.get(fileKey));
            subscriber.onComplete();
        });
    }

    private void abortQuietly(@Nullable DiskLruCache.Editor editor) {
        if (editor == null) {
            return;
        }
        try {
            editor.abort();
        }
        catch (IOException e) {
            Logging.e((String)LOG_TAG, (Object[])new Object[]{"::abortQuietly() fails", e});
        }
    }

    @Override
    public DiskLruCache.Editor edit(String fileKey) {
        DefaultDiskCache.guard();
        if (this.isValid()) {
            try {
                return this.diskLruCache.edit(fileKey);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void put(String fileKey, InputStream is) throws IOException, NotValidCacheException, OtherEditInProgressException {
        OutputStream os;
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"put(", fileKey, ")"});
        DefaultDiskCache.guard();
        if (!this.isValid()) {
            String message = "::put(" + fileKey + ") failed due to storage is invalid.";
            Logging.d((String)LOG_TAG, (String)message);
            throw new NotValidCacheException(message);
        }
        DiskLruCache.Editor val = null;
        try {
            val = this.diskLruCache.edit(fileKey);
            if (val == null) {
                String message = "::put(" + fileKey + ") other edit is in progress, skip.";
                Logging.d((String)LOG_TAG, (String)message);
                throw new OtherEditInProgressException(message);
            }
        }
        catch (IOException e) {
            this.abortQuietly(val);
            throw e;
        }
        try {
            os = val.newOutputStream();
        }
        catch (IOException e) {
            Logging.e((String)LOG_TAG, (Object[])new Object[]{"::put(" + fileKey + ") failed to get OutputStream ", e});
            this.abortQuietly(val);
            throw e;
        }
        try {
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            Logging.e((String)LOG_TAG, (Object[])new Object[]{"::put(" + fileKey + ") failed to copy content ", e});
            this.abortQuietly(val);
            throw e;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((OutputStream)os);
        }
        try {
            val.commit();
            Logging.d((String)LOG_TAG, (Object[])new Object[]{"put(", fileKey, ") SUCCESS"});
        }
        catch (IOException e) {
            Logging.e((String)LOG_TAG, (Object[])new Object[]{"::put(" + fileKey + ") FAILED to commit ", e});
            this.abortQuietly(val);
            throw e;
        }
    }

    private static class NotEnoughSpace
    extends Exception {
        final long gfycatSpace;
        final long usableSpace;

        public NotEnoughSpace(long usableSpace, long gfycatSpace) {
            this.usableSpace = usableSpace;
            this.gfycatSpace = gfycatSpace;
        }
    }

    private static class CacheSizeSetIncorrectly
    extends Exception {
        private CacheSizeSetIncorrectly() {
        }
    }

    private static class CacheSizeNotSet
    extends Exception {
        private CacheSizeNotSet() {
        }
    }

    public static class NotValidCacheException
    extends Exception {
        NotValidCacheException(String message) {
            super(message);
        }
    }

    public static class OtherEditInProgressException
    extends Exception {
        OtherEditInProgressException(String message) {
            super(message);
        }
    }

    public static class CacheSizeOptions {
        private long minSpaceMb = 50L;
        private long maxSpaceMb = 200L;

        public void setMinSpace(long megabytes) {
            this.minSpaceMb = megabytes < 0L ? 0L : megabytes;
        }

        public void setMaxSpace(long megabytes) {
            this.maxSpaceMb = megabytes < 0L ? 0L : megabytes;
        }
    }
}

