/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.storage;

import android.util.Pair;
import com.gfycat.common.ChainedException;
import com.gfycat.common.ContextDetails;
import com.gfycat.common.utils.Assertions;
import com.gfycat.common.utils.Logging;
import com.gfycat.core.gfycatapi.pojo.Gfycat;
import com.gfycat.core.storage.DefaultDiskCache;
import com.gfycat.core.storage.DiskCache;
import com.gfycat.core.storage.MediaApi;
import com.gfycat.core.storage.MediaFilesManager;
import com.gfycat.core.storage.MediaType;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.subjects.BehaviorSubject;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import org.apache.commons.io.FileUtils;
import retrofit2.CallAdapter;
import retrofit2.HttpException;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;

public class CachedMediaFilesManager
implements MediaFilesManager {
    private static final String LOG_TAG = "CachedMediaFilesManager";
    private static final int FOBIDDEN_CODE = 403;
    private final Map<String, BehaviorSubject<File>> ongoingDownloads = new HashMap<String, BehaviorSubject<File>>();
    private final DiskCache diskCache;
    private final MediaApi mediaApi;

    public CachedMediaFilesManager(OkHttpClient videoClient, DiskCache diskCache) {
        this.diskCache = diskCache;
        this.mediaApi = (MediaApi)new Retrofit.Builder().client(videoClient).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).baseUrl("https://not_used").build().create(MediaApi.class);
    }

    @Override
    public Single<byte[]> loadAsByteArray(Gfycat gfycat, MediaType mediaType) {
        return this.loadAsByteArray(gfycat, mediaType, new ContextDetails(new Pair[0]));
    }

    @Override
    public Single<byte[]> loadAsByteArray(Gfycat gfycat, MediaType mediaType, ContextDetails contextDetails) {
        return this.loadAsByteArray(mediaType.getUrl(gfycat), mediaType.getVideoStorageId(gfycat), contextDetails.copy().put("loadingType", "loadAsByteArray").put("mediaType", mediaType.getName()).put("gfyId", gfycat.getGfyId()));
    }

    @Override
    public Single<File> loadAsFile(Gfycat gfycat, MediaType mediaType) {
        return this.loadAsFile(gfycat, mediaType, new ContextDetails(new Pair[0]));
    }

    @Override
    public Single<File> loadAsFile(Gfycat gfycat, MediaType mediaType, ContextDetails contextDetails) {
        return this.loadAsFile(mediaType.getUrl(gfycat), mediaType.getVideoStorageId(gfycat), contextDetails.copy().put("loadingType", "loadAsFile").put("mediaType", mediaType.getName()).put("gfyId", gfycat.getGfyId()));
    }

    private Single<File> loadAsFile(String resource, String fileKey, ContextDetails contextDetails) {
        return this.findFileInCacheObservable(fileKey, contextDetails).onErrorResumeNext(this.findFileInPendingDownloadsOrDownload(resource, fileKey, contextDetails));
    }

    private Single<byte[]> loadAsByteArray(String resource, String uniqueKey, ContextDetails contextDetails) {
        return this.loadAsFile(resource, uniqueKey, contextDetails).flatMap(CachedMediaFilesManager::loadFileInMemory).onErrorResumeNext(throwable -> {
            if (throwable instanceof InterruptedIOException) {
                return Single.error((Throwable)throwable);
            }
            return this.loadFromNetworkAsByteArray(resource, contextDetails);
        });
    }

    private Single<byte[]> loadFromNetworkAsByteArray(String resource, ContextDetails contextDetails) {
        return this.mediaApi.load(resource).map(ResponseBody::bytes).onErrorResumeNext(throwable -> this.processErrors((Throwable)throwable, resource, contextDetails));
    }

    private <T> Single<T> processErrors(Throwable throwable, String resource, ContextDetails contextDetails) {
        if (throwable instanceof HttpException && ((HttpException)throwable).code() == 403) {
            return Single.error((Throwable)new ForbiddenGfycatException("Resource " + resource + " return 403. " + contextDetails));
        }
        if (throwable instanceof InterruptedIOException) {
            Logging.d((String)LOG_TAG, (String)("InterruptedIOException for " + resource + " " + contextDetails));
            return Single.error((Throwable)throwable);
        }
        if (throwable instanceof IOException) {
            String message = "IOException for " + resource + " " + contextDetails;
            return Single.error((Throwable)new IllegalStateException(message, throwable));
        }
        if (throwable instanceof DefaultDiskCache.NotValidCacheException) {
            return Single.error((Throwable)new ChainedException(throwable));
        }
        if (throwable instanceof DefaultDiskCache.OtherEditInProgressException) {
            String message = "DefaultDiskCache for " + resource + " " + contextDetails;
            Assertions.fail((Throwable)new RuntimeException(message, throwable));
            return Single.error((Throwable)new ChainedException(throwable));
        }
        String message = "Other Exception for " + resource + " " + contextDetails;
        return Single.error((Throwable)new IllegalStateException(message, throwable));
    }

    private static Single<byte[]> loadFileInMemory(File file) {
        try {
            return Single.just((Object)FileUtils.readFileToByteArray((File)file));
        }
        catch (IOException e) {
            return Single.error((Throwable)e);
        }
    }

    private Single<File> findFileInCacheObservable(String fileKey, ContextDetails contextDetails) {
        return Single.create(subscriber -> {
            File file = this.diskCache.get(fileKey);
            if (file != null) {
                Logging.d((String)LOG_TAG, (Object[])new Object[]{"Cache hit for: ", fileKey, " ", contextDetails});
                subscriber.onSuccess((Object)file);
            } else {
                Logging.d((String)LOG_TAG, (Object[])new Object[]{"No ", fileKey, " in cache.", " ", contextDetails});
                subscriber.tryOnError((Throwable)new RuntimeException("No such file in cache"));
            }
        }).doOnSubscribe(ignored -> Logging.d((String)LOG_TAG, (Object[])new Object[]{"findFileInCacheObservable(", fileKey, ") doOnSubscribe", " ", contextDetails}));
    }

    private Single<? extends File> findFileInPendingDownloadsOrDownload(String resource, String fileKey, ContextDetails contextDetails) {
        return Single.create(subscriber -> {
            boolean alreadyDownloading;
            BehaviorSubject behaviorSubject;
            Map<String, BehaviorSubject<File>> map = this.ongoingDownloads;
            synchronized (map) {
                behaviorSubject = this.ongoingDownloads.get(fileKey);
                alreadyDownloading = behaviorSubject != null;
                Logging.d((String)LOG_TAG, (Object[])new Object[]{"pending downloads ", fileKey, " alreadyDownloading = ", alreadyDownloading, " ", contextDetails});
                if (!alreadyDownloading) {
                    behaviorSubject = BehaviorSubject.create();
                    this.ongoingDownloads.put(fileKey, (BehaviorSubject<File>)behaviorSubject);
                    Logging.d((String)LOG_TAG, (Object[])new Object[]{"save behaviorSubject to ongoingDownloads ", fileKey, " ", contextDetails});
                }
            }
            behaviorSubject.subscribe(arg_0 -> ((SingleEmitter)subscriber).onSuccess(arg_0), arg_0 -> ((SingleEmitter)subscriber).tryOnError(arg_0));
            if (!alreadyDownloading) {
                BehaviorSubject finalSubject = behaviorSubject;
                this.downloadAndSaveToCacheObservable(this.diskCache, resource, fileKey, contextDetails).doOnSubscribe(ignored -> Logging.d((String)LOG_TAG, (Object[])new Object[]{"doNetworkRequest(", resource, ", ", fileKey, ")", " ", contextDetails})).doOnSuccess(ignored -> this.ongoingDownloads.remove(fileKey)).doOnError(throwable -> Logging.d((String)LOG_TAG, (Throwable)throwable, (Object[])new Object[]{"doNetworkRequest doOnError ", fileKey, " ", contextDetails})).doOnError(throwable -> this.ongoingDownloads.remove(fileKey)).subscribe(file -> {
                    finalSubject.onNext(file);
                    finalSubject.onComplete();
                }, throwable -> finalSubject.onError(throwable));
            }
        });
    }

    private Single<File> downloadAndSaveToCacheObservable(DiskCache diskCache, String resource, String fileKey, ContextDetails contextDetails) {
        return this.mediaApi.load(resource).map(response -> {
            diskCache.put(fileKey, response.byteStream());
            File file = diskCache.get(fileKey);
            if (file == null) {
                throw new IOException("Can not get file from diskCache, fileKey = " + fileKey + ", " + contextDetails + ", " + resource);
            }
            Logging.d((String)LOG_TAG, (Object[])new Object[]{"Success, return file for ", fileKey, " ", contextDetails});
            return file;
        }).onErrorResumeNext(throwable -> this.processErrors((Throwable)throwable, resource, contextDetails));
    }

    public static class ForbiddenGfycatException
    extends RuntimeException {
        public ForbiddenGfycatException(String message) {
            super(message);
        }
    }
}

