/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.notifications;

import android.annotation.TargetApi;
import android.app.NotificationChannel;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.app.NotificationCompat;
import android.util.Pair;
import com.gfycat.common.utils.Logging;
import com.gfycat.core.R;
import java.util.HashMap;
import java.util.Map;

public class NotificationManager {
    private static final String LOG_TAG = "NotificationManager";
    public static final String CHANNEL_PUSH_UPDATES = "channel_push_updates";
    public static final String CHANNEL_VIDEO_READY = "channel_video_ready";
    public static final String CHANNEL_VIDEO_PROCESSING = "channel_video_processing";
    private static NotificationManager sInstance;
    private Map<Integer, NotificationCompat.Builder> notifications = new HashMap<Integer, NotificationCompat.Builder>();
    private Map<Pair<String, Integer>, NotificationCompat.Builder> taggedNotifications = new HashMap<Pair<String, Integer>, NotificationCompat.Builder>();

    public static NotificationManager getInstance() {
        if (sInstance == null) {
            sInstance = new NotificationManager();
        }
        return sInstance;
    }

    private NotificationManager() {
    }

    @TargetApi(value=26)
    public void prepareChannels(Context context) {
        android.app.NotificationManager notificationManager = (android.app.NotificationManager)context.getSystemService("notification");
        notificationManager.createNotificationChannel(this.prepareChannelVideoReady(context));
        notificationManager.createNotificationChannel(this.prepareChannelProcessing(context));
        notificationManager.createNotificationChannel(this.prepareChannelPushUpdates(context));
    }

    @TargetApi(value=26)
    private NotificationChannel prepareChannelVideoReady(Context context) {
        String name = context.getString(R.string.channel_video_ready_name);
        String description = context.getString(R.string.channel_video_ready_description);
        int importance = 4;
        NotificationChannel channel = new NotificationChannel(CHANNEL_VIDEO_READY, (CharSequence)name, importance);
        channel.setDescription(description);
        channel.enableLights(true);
        channel.setLightColor(-16776961);
        return channel;
    }

    @TargetApi(value=26)
    private NotificationChannel prepareChannelProcessing(Context context) {
        String name = context.getString(R.string.channel_gif_processing_name);
        String description = context.getString(R.string.channel_gif_processing_description);
        int importance = 1;
        NotificationChannel channel = new NotificationChannel(CHANNEL_VIDEO_PROCESSING, (CharSequence)name, importance);
        channel.setDescription(description);
        return channel;
    }

    @TargetApi(value=26)
    private NotificationChannel prepareChannelPushUpdates(Context context) {
        String name = context.getString(R.string.channel_push_updates_name);
        String description = context.getString(R.string.channel_push_updates_description);
        int importance = 3;
        NotificationChannel channel = new NotificationChannel(CHANNEL_PUSH_UPDATES, (CharSequence)name, importance);
        channel.setDescription(description);
        return channel;
    }

    public boolean remove(int id) {
        Logging.i((String)LOG_TAG, (String)("remove id: " + id));
        return this.notifications.remove(id) != null;
    }

    public void cancel(Context context, int id) {
        android.app.NotificationManager mNotificationManager = (android.app.NotificationManager)context.getSystemService("notification");
        mNotificationManager.cancel(id);
    }

    public void addAndSend(Context context, String tag, int id, @NonNull String channelId, UpdateNotificationInterface update) {
        Logging.i((String)LOG_TAG, (String)("addAndSend id: " + id));
        NotificationCompat.Builder builder = this.taggedNotifications.get(Pair.create((Object)tag, (Object)id));
        Logging.d((String)LOG_TAG, (String)("builder: " + builder));
        if (builder == null) {
            builder = new NotificationCompat.Builder(context, channelId);
        }
        if (update != null) {
            update.updateNotification(builder);
        }
        this.taggedNotifications.put((Pair<String, Integer>)Pair.create((Object)tag, (Object)id), builder);
        this.sendNotification(context, id, builder);
    }

    public void addAndSend(Context context, int id, @NonNull String channelId, UpdateNotificationInterface update) {
        Logging.i((String)LOG_TAG, (String)("addAndSend id: " + id));
        NotificationCompat.Builder builder = this.notifications.get(id);
        Logging.d((String)LOG_TAG, (String)("builder: " + builder));
        if (builder == null) {
            builder = new NotificationCompat.Builder(context, channelId);
        }
        if (update != null) {
            update.updateNotification(builder);
        }
        this.notifications.put(id, builder);
        this.sendNotification(context, id, builder);
    }

    public void update(int id, UpdateNotificationInterface update) {
        Logging.i((String)LOG_TAG, (String)("update id: " + id));
        NotificationCompat.Builder builder = this.notifications.get(id);
        Logging.d((String)LOG_TAG, (String)("builder: " + builder));
        if (builder == null) {
            return;
        }
        if (update != null) {
            update.updateNotification(builder);
        }
    }

    public void updateAndSend(Context context, int id, UpdateNotificationInterface update) {
        Logging.i((String)LOG_TAG, (String)("updateAndSend id: " + id));
        NotificationCompat.Builder builder = this.notifications.get(id);
        Logging.d((String)LOG_TAG, (String)("builder: " + builder));
        if (builder == null) {
            return;
        }
        if (update != null) {
            update.updateNotification(builder);
        }
        this.sendNotification(context, id, builder);
    }

    private void sendNotification(Context context, int id, NotificationCompat.Builder builder) {
        Logging.i((String)LOG_TAG, (String)("sendNotification id: " + id + ", builder: " + builder));
        android.app.NotificationManager mNotificationManager = (android.app.NotificationManager)context.getSystemService("notification");
        mNotificationManager.notify(id, builder.build());
    }

    public static interface UpdateNotificationInterface {
        public void updateNotification(@NonNull NotificationCompat.Builder var1);
    }
}

