/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.gfycatapi.pojo;

import android.graphics.Color;
import android.text.TextUtils;
import com.gfycat.common.EPS;
import com.gfycat.common.utils.Assertions;
import com.gfycat.common.utils.Utils;
import com.gfycat.core.GfyPrivate;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class Gfycat
implements Serializable {
    private String gfyId;
    private String gfyName;
    private String gfyNumber;
    private int width;
    private int height;
    private String userName;
    private String createDate;
    private int views;
    private String title;
    private String description;
    private String projectionType;
    private int nsfw;
    private int published;
    private String avgColor;
    private boolean hasTransparency;
    private boolean hasAudio;
    private List<String> tags = Collections.emptyList();
    private float frameRate;
    private int numFrames;
    private String rating;
    private int mp4Size;
    private int webmSize;
    private String posterUrl;
    private String pngPosterUrl;
    private String mobilePosterUrl;
    private String miniPosterUrl;
    private String thumb100PosterUrl;
    private String mp4Url;
    private String mobileUrl;
    private String miniUrl;
    private String gifUrl;
    private String webmUrl;
    private String webpUrl;
    private String gif100px;
    private String max1mbGif;
    private String max2mbGif;
    private String max5mbGif;

    public int getAvgColorInt() {
        if (this.avgColor != null) {
            return Color.parseColor((String)this.avgColor);
        }
        return -1;
    }

    private String getUrlInternal(String url) {
        if (!"gfycat.com".equals(GfyPrivate.get().getDomainName()) && !TextUtils.isEmpty((CharSequence)url)) {
            return url.replace("gfycat.com", GfyPrivate.get().getDomainName());
        }
        return url;
    }

    public void setPosterUrl(String posterUrl) {
        this.posterUrl = posterUrl;
    }

    public String getPosterUrl() {
        return this.getUrlInternal(this.posterUrl);
    }

    public void setPosterPngUrl(String posterPngUrl) {
        this.pngPosterUrl = posterPngUrl;
    }

    public String getPosterPngUrl() {
        return this.getUrlInternal(this.pngPosterUrl);
    }

    public void setPosterMobileUrl(String posterMobileUrl) {
        this.mobilePosterUrl = posterMobileUrl;
    }

    public String getPosterMobileUrl() {
        return this.getUrlInternal(this.mobilePosterUrl);
    }

    public void setPosterMiniUrl(String posterMiniUrl) {
        this.miniPosterUrl = posterMiniUrl;
    }

    public String getPosterMiniUrl() {
        return this.getUrlInternal(this.miniPosterUrl);
    }

    public void setPosterThumb100Url(String posterThumb100PosterUrl) {
        this.thumb100PosterUrl = posterThumb100PosterUrl;
    }

    public String getPosterThumb100Url() {
        return this.getUrlInternal(this.thumb100PosterUrl);
    }

    public String getDesktopMp4Url() {
        return this.getUrlInternal(this.mp4Url);
    }

    public String getWebMUrl() {
        return this.getUrlInternal(this.webmUrl);
    }

    public int getWebMSize() {
        return this.webmSize;
    }

    public void setWebMUrl(String webmUrl) {
        this.webmUrl = webmUrl;
    }

    public void setWebMSize(int webpmSize) {
        this.webmSize = webpmSize;
    }

    public void setMp4MobileUrl(String mobileUrl) {
        this.mobileUrl = mobileUrl;
    }

    public String getMp4MobileUrl() {
        return this.getUrlInternal(this.mobileUrl);
    }

    public void setWebPUrl(String webpUrl) {
        this.webpUrl = webpUrl;
    }

    public String getWebPUrl() {
        return this.getUrlInternal(this.webpUrl);
    }

    public void setGif100pxUrl(String gif100pxUrl) {
        this.gif100px = gif100pxUrl;
    }

    public String getGif100pxUrl() {
        return this.getUrlInternal(this.gif100px);
    }

    public void setGifLargeUrl(String gifUrl) {
        this.gifUrl = gifUrl;
    }

    public String getGifLargeUrl() {
        return this.getUrlInternal(this.gifUrl);
    }

    public void setGif5mbUrl(String max5mbGifUrl) {
        this.max5mbGif = max5mbGifUrl;
    }

    public String getGif5mbUrl() {
        return this.getUrlInternal(this.max5mbGif);
    }

    public void setGif2mbUrl(String max2mbGifUrl) {
        this.max2mbGif = max2mbGifUrl;
    }

    public String getGif2mbUrl() {
        return this.getUrlInternal(this.max2mbGif);
    }

    public void setGif1mbUrl(String max1mbGifUrl) {
        this.max1mbGif = max1mbGifUrl;
    }

    public String getGif1mbUrl() {
        return this.getUrlInternal(this.max1mbGif);
    }

    public String getAvgColor() {
        return this.avgColor;
    }

    public void setAvgColor(String avgColor) {
        this.avgColor = avgColor;
    }

    public boolean hasTransparency() {
        return this.hasTransparency;
    }

    public void setHasTransparency(boolean hasTransparency) {
        this.hasTransparency = hasTransparency;
    }

    public boolean hasAudio() {
        return this.hasAudio;
    }

    public void setHasAudio(boolean hasAudio) {
        this.hasAudio = hasAudio;
    }

    public String getGfyId() {
        return this.gfyId;
    }

    public void setGfyId(String gfyId) {
        this.gfyId = gfyId;
    }

    public String getGfyName() {
        return this.gfyName;
    }

    public void setGfyName(String gfyName) {
        this.gfyName = gfyName;
    }

    public String getGfyNumber() {
        return this.gfyNumber;
    }

    public void setGfyNumber(String gfyNumber) {
        this.gfyNumber = gfyNumber;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getMp4MiniUrl() {
        return this.getUrlInternal(this.miniUrl);
    }

    public void setMp4MiniUrl(String mp4MiniUrl) {
        this.miniUrl = mp4MiniUrl;
    }

    @Deprecated
    public String getMp4Url() {
        return this.getUrlInternal(this.mp4Url);
    }

    public void setMp4Url(String mp4Url) {
        this.mp4Url = mp4Url;
    }

    public int getMp4Size() {
        return this.mp4Size;
    }

    public void setMp4Size(int mp4Size) {
        this.mp4Size = mp4Size;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public long getCreateDateMilliseconds() {
        return Long.valueOf(this.createDate) * 1000L;
    }

    public String getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public int getViews() {
        return this.views;
    }

    public void setViews(int views) {
        this.views = views;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getTags() {
        return this.tags != null ? this.tags : Collections.emptyList();
    }

    public void setTags(List<String> tags) {
        tags = tags == null ? Collections.emptyList() : tags;
        this.tags = tags;
    }

    public float getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(float frameRate) {
        this.frameRate = frameRate;
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    public void setNumFrames(int numFrames) {
        this.numFrames = numFrames;
    }

    public void setContentRating(String contentRating) {
        this.rating = contentRating;
    }

    public void setProjectionType(String projectionType) {
        this.projectionType = projectionType;
    }

    public String getProjectionType() {
        return this.projectionType;
    }

    public ProjectionType projectionType() {
        for (ProjectionType type : ProjectionType.values()) {
            if (!type.isEqual(this.projectionType)) continue;
            return type;
        }
        Assertions.fail((Throwable)new UnsupportedOperationException("Unknown projection type + " + this.projectionType));
        return ProjectionType.Plain;
    }

    public ContentRating getContentRating() {
        return ContentRating.fromResponesValue(this.rating);
    }

    public float getLength() {
        if (EPS.isAboutZero((float)this.frameRate)) {
            return -1.0f;
        }
        return (float)this.numFrames / this.frameRate;
    }

    public boolean isValid() {
        return !TextUtils.isEmpty((CharSequence)this.gfyId) && !TextUtils.isEmpty((CharSequence)this.gfyName) && this.width > 0 && this.height > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Gfycat gfycat = (Gfycat)o;
        if (!Utils.equals((Object)this.gfyId, (Object)gfycat.gfyId)) {
            return false;
        }
        return Utils.equals((Object)this.gfyName, (Object)gfycat.gfyName);
    }

    public int hashCode() {
        int result = 0;
        if (this.gfyId != null) {
            result += this.gfyId.hashCode();
        }
        if (this.gfyName != null) {
            result = 31 * result + this.gfyName.hashCode();
        }
        return result;
    }

    public int getNsfw() {
        return this.nsfw;
    }

    public String toString() {
        return "Gfycat{gfyId='" + this.gfyId + '\'' + ", gfyName='" + this.gfyName + '\'' + ", gfyNumber='" + this.gfyNumber + '\'' + ", width=" + this.width + ", height=" + this.height + ", mp4Url='" + this.mp4Url + '\'' + ", mp4Size=" + this.mp4Size + ", userName='" + this.userName + '\'' + ", createDate='" + this.createDate + '\'' + ", views=" + this.views + ", title='" + this.title + '\'' + ", description='" + this.description + '\'' + ", projectionType='" + this.projectionType + '\'' + ", nsfw=" + this.nsfw + ", published=" + this.published + ", avgColor='" + this.avgColor + '\'' + ", tags=" + this.tags + ", webmUrl='" + this.webmUrl + '\'' + ", webmSize='" + this.webmSize + '\'' + ", webpUrl='" + this.webpUrl + '\'' + ", posterUrl='" + this.posterUrl + '\'' + '}';
    }

    public void setNsfw(int nsfw) {
        this.nsfw = nsfw;
    }

    public int getPublished() {
        return this.published;
    }

    public void setPublished(int published) {
        this.published = published;
    }

    public boolean isPublished() {
        return this.published == 1;
    }

    public boolean isSafeForWork() {
        return this.nsfw == 0;
    }

    public boolean hasTags() {
        return this.getTags() != null && !this.getTags().isEmpty();
    }

    public static enum ContentRating {
        R("R"),
        PG13("PG13", "PG-13"),
        PG("PG"),
        G("G");

        public final String urlEncodedValue;
        public final String responseValue;

        private ContentRating(String value) {
            this(value, value);
        }

        private ContentRating(String urlEncodedValue, String responseValue) {
            this.urlEncodedValue = urlEncodedValue;
            this.responseValue = responseValue;
        }

        public static ContentRating fromResponesValue(String contentRating) {
            for (ContentRating rating : ContentRating.values()) {
                if (!Utils.equals((Object)rating.responseValue, (Object)contentRating)) continue;
                return rating;
            }
            return null;
        }
    }

    public static enum ProjectionType {
        Plain,
        Equirectangular("equirectangular"),
        Facebookcube("facebook-cube");

        private final String[] values;

        private ProjectionType(String ... values) {
            this.values = values;
        }

        private ProjectionType() {
            this("", null);
        }

        public boolean isEqual(String projectionType) {
            for (String value : this.values) {
                if (!Utils.equals((Object)value, (Object)projectionType)) continue;
                return true;
            }
            return false;
        }
    }
}

