/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.gfycatapi;

import com.gfycat.core.gfycatapi.pojo.BlockedUsers;
import com.gfycat.core.gfycatapi.pojo.GfycatCategoriesList;
import com.gfycat.core.gfycatapi.pojo.GfycatList;
import com.gfycat.core.gfycatapi.pojo.NSFWUpdateRequest;
import com.gfycat.core.gfycatapi.pojo.OneGfyItem;
import com.gfycat.core.gfycatapi.pojo.PublishedUpdateRequest;
import com.gfycat.core.gfycatapi.pojo.ResetPasswordRequest;
import com.gfycat.core.gfycatapi.pojo.SearchResult;
import com.gfycat.core.gfycatapi.pojo.TransferGfycatsRequest;
import com.gfycat.core.gfycatapi.pojo.UpdateUserInfo;
import com.gfycat.core.gfycatapi.pojo.UserInfo;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.Single;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.HEAD;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface GfycatAPI {
    public static final String TRENDING = "gfycats/trending";
    public static final String SEARCH = "gfycats/search";
    public static final String SEARCH_TEXT = "search_text";
    public static final String MIN_LENGTH = "minLength";
    public static final String MAX_LENGTH = "maxLength";
    public static final String MIN_ASPECT = "minAspectRatio";
    public static final String MAX_ASPECT = "maxAspectRatio";
    public static final String CONTENT_RATING = "rating";

    @GET(value="gfycats/search")
    public Observable<SearchResult> search(@Query(value="search_text") String var1, @Query(value="cursor") String var2, @Query(value="count") int var3, @Query(value="minLength") String var4, @Query(value="maxLength") String var5, @Query(value="minAspectRatio") String var6, @Query(value="maxAspectRatio") String var7, @Query(value="rating") String var8);

    @GET(value="gfycats/trending")
    public Observable<GfycatList> getTrendingGfycats(@Query(value="digest") String var1, @Query(value="count") int var2);

    @GET(value="gfycats/trending")
    public Observable<GfycatList> getListForTag(@Query(value="tagName") String var1, @Query(value="digest") String var2, @Query(value="count") int var3);

    @GET(value="reactions/populated")
    public Observable<GfycatList> getReactions(@Query(value="tagName") String var1, @Query(value="digest") String var2, @Query(value="gfyCount") int var3);

    @GET(value="sound/search")
    public Observable<SearchResult> soundSearch(@Query(value="search_text") String var1, @Query(value="cursor") String var2, @Query(value="count") int var3, @Query(value="minLength") String var4, @Query(value="maxLength") String var5, @Query(value="minAspectRatio") String var6, @Query(value="maxAspectRatio") String var7, @Query(value="rating") String var8);

    @GET(value="sound")
    public Observable<GfycatList> getTrendingSoundGfycats(@Query(value="digest") String var1, @Query(value="count") int var2, @Query(value="minLength") String var3, @Query(value="maxLength") String var4, @Query(value="minAspectRatio") String var5, @Query(value="maxAspectRatio") String var6, @Query(value="rating") String var7);

    @GET(value="gfycats/{gfyId}")
    public Observable<OneGfyItem> getOneGfycatItemObservable(@Path(value="gfyId") String var1);

    @GET(value="me")
    public Observable<UserInfo> getMyInfo();

    @GET(value="users/{username}/gfycats")
    public Observable<GfycatList> getListForUser(@Path(value="username") String var1, @Query(value="cursor") String var2, @Query(value="count") int var3);

    @HEAD(value="users/{username}")
    public Single<Response<Void>> checkAvailability(@Path(value="username") String var1);

    @PATCH(value="users")
    public Completable resetPassword(@Body ResetPasswordRequest var1);

    @GET(value="me/gfycats")
    public Observable<GfycatList> getMyGfycats(@Query(value="cursor") String var1, @Query(value="count") int var2);

    @POST(value="me/send_verification_email")
    public Completable verifyUserEmail(@Body String var1);

    @POST(value="users/{username}/report-user")
    public Observable<Response<ResponseBody>> blockUser(@Path(value="username") String var1);

    @DELETE(value="me/blocked-users/{userid}")
    public Observable<Response<ResponseBody>> unBlockUser(@Path(value="userid") String var1);

    @POST(value="gfycats/{gfyid}/report-content")
    public Observable<Response<ResponseBody>> blockContent(@Path(value="gfyid") String var1);

    @POST(value="me/blocked-users")
    public Observable<Response<ResponseBody>> blockUsers(@Body BlockedUsers var1);

    @PUT(value="me/gfycats/{gfyid}/nsfw")
    public Observable<Response<ResponseBody>> updateNSFW(@Path(value="gfyid") String var1, @Body NSFWUpdateRequest var2);

    @PUT(value="me/gfycats/{gfyid}/published")
    public Observable<Response<ResponseBody>> updatePublishedState(@Path(value="gfyid") String var1, @Body PublishedUpdateRequest var2);

    @DELETE(value="me/gfycats/{gfyid}")
    public Observable<Response<ResponseBody>> delete(@Path(value="gfyid") String var1);

    @GET(value="reactions/populated?gfyCount=1")
    public Observable<GfycatCategoriesList> getCategories(@Query(value="locale") String var1);

    @PATCH(value="me")
    public Completable updateUserProfile(@Body UpdateUserInfo var1);

    @POST(value="me/profile_image_url")
    public Single<Response<ResponseBody>> getUploadURL();

    @GET(value="me/profile_image_url/status/{ticket}")
    public Observable<Response<ResponseBody>> getAvatarStatus(@Path(value="ticket") String var1);

    @PATCH(value="users/{username}/gfycats")
    public Completable transferGfycats(@Path(value="username") String var1, @Body TransferGfycatsRequest var2);
}

