/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.downloading;

import com.gfycat.core.FeedIdentifier;
import com.gfycat.core.FeedType;
import com.gfycat.core.GfyCore;
import com.gfycat.core.PublicFeedIdentifier;
import com.gfycat.core.downloading.GetMoreGfycatsObservableFactory;
import com.gfycat.core.downloading.MapMoreSearchResult;
import com.gfycat.core.gfycatapi.GfycatAPI;
import com.gfycat.core.gfycatapi.pojo.GfycatList;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import java.util.HashMap;
import java.util.Map;

public class GetMoreGfycatsObservableFactoryMap
implements GetMoreGfycatsObservableFactory {
    private Map<FeedType, GetMoreGfycatsObservableFactory> prefixObservableMap = new HashMap<FeedType, GetMoreGfycatsObservableFactory>();

    public GetMoreGfycatsObservableFactoryMap() {
        this.prefixObservableMap.put(FeedIdentifier.Type.TRENDING, new TrendingObservableFactory());
        this.prefixObservableMap.put(FeedIdentifier.Type.SEARCH, new SearchObservableFactory());
        this.prefixObservableMap.put(FeedIdentifier.Type.TAG, new TagObservableFactory());
        this.prefixObservableMap.put(FeedIdentifier.Type.REACTIONS, new ReactionObservableFactory());
        this.prefixObservableMap.put(FeedIdentifier.Type.USER, new UserObservableFactory());
        this.prefixObservableMap.put(FeedIdentifier.Type.ME, new MeObservableFactory());
        this.prefixObservableMap.put(FeedIdentifier.Type.SOUND_TRENDING, new SoundTrendingObservableFactory());
        this.prefixObservableMap.put(FeedIdentifier.Type.SOUND_SEARCH, new SoundSearchObservableFactory());
    }

    @Override
    public Observable<GfycatList> create(GfycatAPI api, FeedIdentifier feedIdentifier, String nextPartIdentifier, int count) {
        return this.prefixObservableMap.get(feedIdentifier.getType()).create(api, feedIdentifier, nextPartIdentifier, count);
    }

    private static class SoundSearchObservableFactory
    implements GetMoreGfycatsObservableFactory {
        private SoundSearchObservableFactory() {
        }

        @Override
        public Observable<GfycatList> create(GfycatAPI api, FeedIdentifier feedIdentifier, String nextPartIdentifier, int count) {
            PublicFeedIdentifier remoteFeedIdentifier = (PublicFeedIdentifier)feedIdentifier;
            return api.soundSearch(remoteFeedIdentifier.getParameter("search_text"), nextPartIdentifier, count, remoteFeedIdentifier.getParameter("minLength"), remoteFeedIdentifier.getParameter("maxLength"), remoteFeedIdentifier.getParameter("minAspectRation"), remoteFeedIdentifier.getParameter("maxAspectRation"), remoteFeedIdentifier.getParameter("contentRating")).map((Function)new MapMoreSearchResult());
        }
    }

    private static class SoundTrendingObservableFactory
    implements GetMoreGfycatsObservableFactory {
        private SoundTrendingObservableFactory() {
        }

        @Override
        public Observable<GfycatList> create(GfycatAPI api, FeedIdentifier feedIdentifier, String nextPartIdentifier, int count) {
            PublicFeedIdentifier remoteFeedIdentifier = (PublicFeedIdentifier)feedIdentifier;
            return api.getTrendingSoundGfycats(nextPartIdentifier, count, remoteFeedIdentifier.getParameter("minLength"), remoteFeedIdentifier.getParameter("maxLength"), remoteFeedIdentifier.getParameter("minAspectRation"), remoteFeedIdentifier.getParameter("maxAspectRation"), remoteFeedIdentifier.getParameter("contentRating"));
        }
    }

    private class MeObservableFactory
    implements GetMoreGfycatsObservableFactory {
        private MeObservableFactory() {
        }

        @Override
        public Observable<GfycatList> create(GfycatAPI api, FeedIdentifier feedIdentifier, String digestOrCursor, int count) {
            return GfyCore.getUserAccountManager().isSignedIn() ? api.getMyGfycats(digestOrCursor, count) : Observable.empty();
        }
    }

    private class UserObservableFactory
    implements GetMoreGfycatsObservableFactory {
        private UserObservableFactory() {
        }

        @Override
        public Observable<GfycatList> create(GfycatAPI api, FeedIdentifier feedIdentifier, String digestOrCursor, int count) {
            return api.getListForUser(feedIdentifier.toName(), digestOrCursor, count);
        }
    }

    private static class ReactionObservableFactory
    implements GetMoreGfycatsObservableFactory {
        private ReactionObservableFactory() {
        }

        @Override
        public Observable<GfycatList> create(GfycatAPI api, FeedIdentifier feedIdentifier, String nextPartIdentifier, int count) {
            return api.getReactions(feedIdentifier.toName(), nextPartIdentifier, count);
        }
    }

    private static class TagObservableFactory
    implements GetMoreGfycatsObservableFactory {
        private TagObservableFactory() {
        }

        @Override
        public Observable<GfycatList> create(GfycatAPI api, FeedIdentifier feedIdentifier, String nextPartIdentifier, int count) {
            return api.getListForTag(feedIdentifier.toName(), nextPartIdentifier, count);
        }
    }

    private static class SearchObservableFactory
    implements GetMoreGfycatsObservableFactory {
        private SearchObservableFactory() {
        }

        @Override
        public Observable<GfycatList> create(GfycatAPI api, FeedIdentifier feedIdentifier, String nextPartIdentifier, int count) {
            PublicFeedIdentifier remoteFeedIdentifier = (PublicFeedIdentifier)feedIdentifier;
            return api.search(remoteFeedIdentifier.getParameter("search_text"), nextPartIdentifier, count, remoteFeedIdentifier.getParameter("minLength"), remoteFeedIdentifier.getParameter("maxLength"), remoteFeedIdentifier.getParameter("minAspectRation"), remoteFeedIdentifier.getParameter("maxAspectRation"), remoteFeedIdentifier.getParameter("contentRating")).map((Function)new MapMoreSearchResult());
        }
    }

    private static class TrendingObservableFactory
    implements GetMoreGfycatsObservableFactory {
        private TrendingObservableFactory() {
        }

        @Override
        public Observable<GfycatList> create(GfycatAPI api, FeedIdentifier feedIdentifier, String nextPartIdentifier, int count) {
            return api.getTrendingGfycats(nextPartIdentifier, count);
        }
    }
}

