/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.downloading;

import com.gfycat.common.utils.Assertions;
import com.gfycat.core.FeedIdentifier;
import com.gfycat.core.FeedType;
import com.gfycat.core.GfyCore;
import com.gfycat.core.PublicFeedIdentifier;
import com.gfycat.core.RecentFeedIdentifier;
import com.gfycat.core.downloading.GetGfycatsObservableFactory;
import com.gfycat.core.downloading.MapSearchResult;
import com.gfycat.core.downloading.NotAvailableInTheAppException;
import com.gfycat.core.gfycatapi.GfycatAPI;
import com.gfycat.core.gfycatapi.pojo.Gfycat;
import com.gfycat.core.gfycatapi.pojo.GfycatList;
import com.gfycat.core.gfycatapi.pojo.OneGfyItem;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import java.util.HashMap;
import java.util.Map;

public class GetGfycatsObservableFactoryMap
implements GetGfycatsObservableFactory {
    private Map<FeedType, GetGfycatsObservableFactory> prefixObservableMap = new HashMap<FeedType, GetGfycatsObservableFactory>();

    public GetGfycatsObservableFactoryMap() {
        this.prefixObservableMap.put(FeedIdentifier.Type.TRENDING, new TrendingObservableFactory());
        this.prefixObservableMap.put(FeedIdentifier.Type.SEARCH, new SearchObservableFactory());
        this.prefixObservableMap.put(FeedIdentifier.Type.TAG, new TagObservableFactory());
        this.prefixObservableMap.put(FeedIdentifier.Type.REACTIONS, new ReactionObservableFactory());
        this.prefixObservableMap.put(FeedIdentifier.Type.SINGLE, new SingleObservableFactory());
        this.prefixObservableMap.put(FeedIdentifier.Type.USER, new UserObservableFactory());
        this.prefixObservableMap.put(FeedIdentifier.Type.ME, new MeObservableFactory());
        this.prefixObservableMap.put(RecentFeedIdentifier.RECENT_FEED_TYPE, new RecentObservableFactory());
        this.prefixObservableMap.put(FeedIdentifier.Type.SOUND_TRENDING, new SoundTrendingObservableFactory());
        this.prefixObservableMap.put(FeedIdentifier.Type.SOUND_SEARCH, new SoundSearchObservableFactory());
    }

    @Override
    public Observable<GfycatList> create(GfycatAPI api, FeedIdentifier feedIdentifier, int count) {
        return this.prefixObservableMap.get(feedIdentifier.getType()).create(api, feedIdentifier, count);
    }

    private static class SoundSearchObservableFactory
    implements GetGfycatsObservableFactory {
        private SoundSearchObservableFactory() {
        }

        @Override
        public Observable<GfycatList> create(GfycatAPI api, FeedIdentifier feedIdentifier, int count) {
            PublicFeedIdentifier remoteFeedIdentifier = (PublicFeedIdentifier)feedIdentifier;
            return api.soundSearch(remoteFeedIdentifier.getParameter("search_text"), null, count, remoteFeedIdentifier.getParameter("minLength"), remoteFeedIdentifier.getParameter("maxLength"), remoteFeedIdentifier.getParameter("minAspectRation"), remoteFeedIdentifier.getParameter("maxAspectRation"), remoteFeedIdentifier.getParameter("contentRating")).flatMap((Function)new MapSearchResult());
        }
    }

    private static class SoundTrendingObservableFactory
    implements GetGfycatsObservableFactory {
        private SoundTrendingObservableFactory() {
        }

        @Override
        public Observable<GfycatList> create(GfycatAPI api, FeedIdentifier feedIdentifier, int count) {
            PublicFeedIdentifier remoteFeedIdentifier = (PublicFeedIdentifier)feedIdentifier;
            return api.getTrendingSoundGfycats(null, count, remoteFeedIdentifier.getParameter("minLength"), remoteFeedIdentifier.getParameter("maxLength"), remoteFeedIdentifier.getParameter("minAspectRation"), remoteFeedIdentifier.getParameter("maxAspectRation"), remoteFeedIdentifier.getParameter("contentRating"));
        }
    }

    private class RecentObservableFactory
    implements GetGfycatsObservableFactory {
        private RecentObservableFactory() {
        }

        @Override
        public Observable<GfycatList> create(GfycatAPI api, FeedIdentifier feedIdentifier, int count) {
            return Observable.empty();
        }
    }

    private class MeObservableFactory
    implements GetGfycatsObservableFactory {
        private MeObservableFactory() {
        }

        @Override
        public Observable<GfycatList> create(GfycatAPI api, FeedIdentifier feedIdentifier, int count) {
            return GfyCore.getUserAccountManager().isSignedIn() ? api.getMyGfycats(null, count) : Observable.empty();
        }
    }

    private class UserObservableFactory
    implements GetGfycatsObservableFactory {
        private UserObservableFactory() {
        }

        @Override
        public Observable<GfycatList> create(GfycatAPI api, FeedIdentifier feedIdentifier, int count) {
            return api.getListForUser(feedIdentifier.toName(), null, count);
        }
    }

    private static class SingleObservableFactory
    implements GetGfycatsObservableFactory {
        private SingleObservableFactory() {
        }

        @Override
        public Observable<GfycatList> create(GfycatAPI api, FeedIdentifier feedIdentifier, int count) {
            return api.getOneGfycatItemObservable(feedIdentifier.toName()).map((Function)new MapOneItemToGfycatList(feedIdentifier));
        }

        private static class MapOneItemToGfycatList
        implements Function<OneGfyItem, GfycatList> {
            private final FeedIdentifier feedIdentifier;

            private MapOneItemToGfycatList(FeedIdentifier feedIdentifier) {
                this.feedIdentifier = feedIdentifier;
            }

            public GfycatList apply(OneGfyItem oneGfyItem) {
                Assertions.assertNotNull((Object)oneGfyItem, NullPointerException::new);
                if (oneGfyItem == null) {
                    return new GfycatList();
                }
                Gfycat item = oneGfyItem.getGfyItem();
                if (oneGfyItem.getErrorMessage() != null) {
                    throw new NotAvailableInTheAppException(this.feedIdentifier.toName(), oneGfyItem.getErrorMessage().getDescription());
                }
                Assertions.assertNotNull((Object)item, NullPointerException::new);
                if (item == null) {
                    return new GfycatList();
                }
                return new GfycatList(item);
            }
        }
    }

    private static class ReactionObservableFactory
    implements GetGfycatsObservableFactory {
        private ReactionObservableFactory() {
        }

        @Override
        public Observable<GfycatList> create(GfycatAPI api, FeedIdentifier feedIdentifier, int count) {
            return api.getReactions(feedIdentifier.toName(), null, count);
        }
    }

    private static class TagObservableFactory
    implements GetGfycatsObservableFactory {
        private TagObservableFactory() {
        }

        @Override
        public Observable<GfycatList> create(GfycatAPI api, FeedIdentifier feedIdentifier, int count) {
            return api.getListForTag(feedIdentifier.toName(), null, count);
        }
    }

    private static class SearchObservableFactory
    implements GetGfycatsObservableFactory {
        private SearchObservableFactory() {
        }

        @Override
        public Observable<GfycatList> create(GfycatAPI api, FeedIdentifier feedIdentifier, int count) {
            PublicFeedIdentifier remoteFeedIdentifier = (PublicFeedIdentifier)feedIdentifier;
            return api.search(remoteFeedIdentifier.getParameter("search_text"), null, count, remoteFeedIdentifier.getParameter("minLength"), remoteFeedIdentifier.getParameter("maxLength"), remoteFeedIdentifier.getParameter("minAspectRation"), remoteFeedIdentifier.getParameter("maxAspectRation"), remoteFeedIdentifier.getParameter("contentRating")).flatMap((Function)new MapSearchResult());
        }
    }

    private static class TrendingObservableFactory
    implements GetGfycatsObservableFactory {
        private TrendingObservableFactory() {
        }

        @Override
        public Observable<GfycatList> create(GfycatAPI api, FeedIdentifier feedIdentifier, int count) {
            return api.getTrendingGfycats(null, count);
        }
    }
}

