/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.downloading;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.util.Pair;
import android.text.TextUtils;
import com.gfycat.common.utils.Assertions;
import com.gfycat.common.utils.Logging;
import com.gfycat.common.utils.Sugar;
import com.gfycat.common.utils.Utils;
import com.gfycat.core.FeedIdentifier;
import com.gfycat.core.RecentFeedIdentifier;
import com.gfycat.core.db.CloseMode;
import com.gfycat.core.db.FeedCacheUriContract;
import com.gfycat.core.db.GfycatFeedCache;
import com.gfycat.core.downloading.CategoriesCache;
import com.gfycat.core.downloading.FeedData;
import com.gfycat.core.downloading.FeedDescription;
import com.gfycat.core.downloading.FeedManager;
import com.gfycat.core.downloading.GetGfycatsObservableFactory;
import com.gfycat.core.downloading.GetGfycatsObservableFactoryMap;
import com.gfycat.core.downloading.GetMoreGfycatsObservableFactory;
import com.gfycat.core.downloading.GetMoreGfycatsObservableFactoryMap;
import com.gfycat.core.gfycatapi.GfycatAPI;
import com.gfycat.core.gfycatapi.pojo.Gfycat;
import com.gfycat.core.gfycatapi.pojo.GfycatCategoriesList;
import com.gfycat.core.gfycatapi.pojo.GfycatCategory;
import com.gfycat.core.gfycatapi.pojo.GfycatList;
import com.gfycat.core.gfycatapi.pojo.GfycatRecentCategory;
import com.gfycat.core.gfycatapi.pojo.OneGfyItem;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.BehaviorSubject;
import java.nio.channels.IllegalSelectorException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.reactivestreams.Publisher;

public class FeedManagerImpl
implements FeedManager {
    private static final String LOG_TAG = "FeedManagerImpl";
    private static final int DEFAULT_GET_NEW_ITEMS_VALUE = 1;
    public static final int DEFAULT_GET_ITEMS_VALUE = 100;
    public static final int DEFAULT_GET_MORE_ITEMS_VALUE = 100;
    private static final int RECENT_GFYCATS_LIMIT = 100;
    private BehaviorSubject<GfycatCategoriesList> ongoingCategoriesRequest;
    private final CategoriesCache categoriesCache;
    private final GfycatFeedCache gfycatFeedCache;
    private final GfycatAPI gfycatApi;
    private GetGfycatsObservableFactory getGfycatsObservableFactory = new GetGfycatsObservableFactoryMap();
    private GetMoreGfycatsObservableFactory getMoreGfycatsObservableFactory = new GetMoreGfycatsObservableFactoryMap();

    public FeedManagerImpl(CategoriesCache categoriesCache, GfycatAPI gfycatApi, GfycatFeedCache gfycatFeedCache) {
        this.categoriesCache = categoriesCache;
        this.gfycatApi = gfycatApi;
        this.gfycatFeedCache = gfycatFeedCache;
    }

    @Override
    public Single<Gfycat> getGfycat(String gfyId) {
        Assertions.assertNotUIThread(IllegalSelectorException::new);
        return Single.create(subscriber -> {
            Gfycat gfycat = this.gfycatFeedCache.getGfycat(gfyId);
            if (gfycat != null) {
                subscriber.onSuccess((Object)gfycat);
            } else {
                Disposable localDisposable = this.gfycatApi.getOneGfycatItemObservable(gfyId).map(OneGfyItem::getGfyItem).subscribe(arg_0 -> ((SingleEmitter)subscriber).onSuccess(arg_0), arg_0 -> ((SingleEmitter)subscriber).tryOnError(arg_0));
                subscriber.setCancellable(() -> ((Disposable)localDisposable).dispose());
            }
        });
    }

    @Override
    public Observable<GfycatCategoriesList> getCategories() {
        if (this.ongoingCategoriesRequest == null) {
            this.ongoingCategoriesRequest = BehaviorSubject.create();
            this.doLoadCategories().subscribeOn(Schedulers.io()).doAfterTerminate(() -> {
                this.ongoingCategoriesRequest = null;
            }).subscribe(item -> this.ongoingCategoriesRequest.onNext(item), error -> this.ongoingCategoriesRequest.onError(error), () -> this.ongoingCategoriesRequest.onComplete());
        }
        return this.ongoingCategoriesRequest;
    }

    public Single<GfycatRecentCategory> getRecentCategory() {
        return Single.create(subscriber -> subscriber.onSuccess((Object)new GfycatRecentCategory(RecentFeedIdentifier.RECENT_FEED_TYPE.getName(), FeedManagerImpl.getFeedDataFromDB(this.gfycatFeedCache, RecentFeedIdentifier.recent()).getGfycats()))).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    private Observable<GfycatCategoriesList> doLoadCategories() {
        return Observable.create(subscriber -> {
            Pair<GfycatCategoriesList, Boolean> cacheEntry = this.categoriesCache.get();
            if (cacheEntry != null) {
                subscriber.onNext(cacheEntry.first);
            }
            if (cacheEntry != null && !((Boolean)cacheEntry.second).booleanValue()) {
                subscriber.onComplete();
                return;
            }
            Disposable networkDisposable = this.gfycatApi.getCategories(Locale.getDefault().getLanguage()).map(this::filterInvalidCategories).subscribe(categoriesList -> {
                if (this.categoriesCache.update((GfycatCategoriesList)categoriesList)) {
                    subscriber.onNext(categoriesList);
                }
                subscriber.onComplete();
            }, arg_0 -> ((ObservableEmitter)subscriber).onError(arg_0));
            subscriber.setCancellable(() -> ((Disposable)networkDisposable).dispose());
        });
    }

    private GfycatCategoriesList filterInvalidCategories(GfycatCategoriesList gfycatCategoriesList) {
        Iterator<GfycatCategory> listIterator = gfycatCategoriesList.getTags().iterator();
        while (listIterator.hasNext()) {
            GfycatCategory category = listIterator.next();
            if (category.isValid()) continue;
            Logging.c((String)LOG_TAG, (Object[])new Object[]{"Server returned invalid category in categories response category = ", category});
            listIterator.remove();
        }
        return gfycatCategoriesList;
    }

    @Override
    public Flowable<FeedData> observeGfycats(Context context, FeedIdentifier identifier) {
        return this.observeGfycats(identifier);
    }

    @Override
    public Flowable<FeedData> observeGfycats(FeedIdentifier identifier) {
        return Flowable.merge((Publisher)Flowable.just((Object)identifier), FeedCacheUriContract.observeChanges(identifier)).subscribeOn(AndroidSchedulers.mainThread()).observeOn(Schedulers.computation()).doOnNext(dbIdentifier -> Assertions.assertEquals((Object)dbIdentifier, (Object)identifier, IllegalAccessException::new)).filter(identifier::equals).map(feedIdentifier -> FeedManagerImpl.getFeedDataFromDB(this.gfycatFeedCache, feedIdentifier));
    }

    @Override
    public Completable getGfycats(FeedIdentifier feedIdentifier) {
        return this.getGfycatsObservableFactory.create(this.gfycatApi, feedIdentifier, 100).flatMap((Function)new GenericErrorCheck()).doOnNext((Consumer)new InsertOrReplaceAction(this.gfycatFeedCache, feedIdentifier, CloseMode.Auto)).ignoreElements().subscribeOn(Schedulers.io());
    }

    @Override
    public Completable getNewGfycats(FeedDescription feedDescription) {
        return this.getMoreGfycats(feedDescription, 1);
    }

    @Override
    public Completable getMoreGfycats(FeedDescription feedDescription) {
        return this.getMoreGfycats(feedDescription, 100);
    }

    public void prefetchCategories() {
        if (this.categoriesCache.get() == null) {
            Disposable[] subscription;
            Logging.d((String)LOG_TAG, (String)"prefetchCategories() start");
            subscription = new Disposable[]{this.getCategories().subscribe(gfycatCategoriesList -> Sugar.doIfNotNull((Object)subscription[0], Disposable::dispose), com.gfycat.common.Function::ignore)};
        } else {
            Logging.d((String)LOG_TAG, (String)"prefetchCategories() not needed");
        }
    }

    public Observable<Void> createFeedIfNotExist(final FeedIdentifier feedIdentifier, final Gfycat gfycat, final String digest, final CloseMode closeMode) {
        return Observable.fromCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                InsertOrReplaceAction action = new InsertOrReplaceAction(FeedManagerImpl.this.gfycatFeedCache, feedIdentifier, closeMode);
                action.accept(new GfycatList(gfycat, digest));
                return null;
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    private Completable getMoreGfycats(FeedDescription feedDescription, int count) {
        return this.getMoreGfycatsObservableFactory.create(this.gfycatApi, feedDescription.getIdentifier(), feedDescription.getDigest(), count).flatMap((Function)new GenericErrorCheck()).doOnNext((Consumer)new UpdateFeedAction(this.gfycatFeedCache, feedDescription.getIdentifier(), feedDescription.getDigest())).ignoreElements().subscribeOn(Schedulers.io());
    }

    public Completable addRecentGfycat(@NonNull Gfycat gfycat) {
        return Completable.create(completableSubscriber -> {
            this.gfycatFeedCache.insertFeed(RecentFeedIdentifier.recent(), new GfycatList(Collections.singletonList(gfycat)), CloseMode.Close, true);
            completableSubscriber.onComplete();
        }).doOnComplete(() -> Logging.d((String)LOG_TAG, (String)(gfycat.getGfyId() + " added to Recent category"))).doAfterTerminate(this::ensureRecentFitLimit).ambWith((CompletableSource)this.ensureRecentFitLimit()).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    private Completable ensureRecentFitLimit() {
        return this.getRecentCategory().observeOn(Schedulers.io()).map(GfycatCategory::getGfycats).subscribeOn(Schedulers.io()).doOnSuccess(recentGfycats -> {
            int deletedCount = 0;
            while (recentGfycats.size() - deletedCount > 100) {
                Gfycat itemToDelete = (Gfycat)recentGfycats.get(recentGfycats.size() - 1 - deletedCount);
                this.removeFromRecentAsync(itemToDelete);
                ++deletedCount;
            }
            if (deletedCount > 0) {
                Logging.d((String)LOG_TAG, (String)("deleted " + deletedCount + " outdated recent gfycats"));
            }
        }).ignoreElement();
    }

    private void removeFromRecentAsync(Gfycat gfycat) {
        Completable.fromAction(() -> this.gfycatFeedCache.removeFromRecent(gfycat)).subscribeOn(Schedulers.io()).subscribe();
    }

    private static FeedData getFeedDataFromDB(GfycatFeedCache gfycatFeedCache, FeedIdentifier feedIdentifier) {
        return gfycatFeedCache.getFeedData(feedIdentifier);
    }

    public void dropFeed(FeedIdentifier feedIdentifier) {
        this.gfycatFeedCache.delete(feedIdentifier);
    }

    class NetworkErrors {
        static final String NO_SEARCH_RESULT = "No search results";

        NetworkErrors() {
        }
    }

    private static class GenericErrorCheck
    implements Function<GfycatList, Observable<GfycatList>> {
        private GenericErrorCheck() {
        }

        public Observable<GfycatList> apply(GfycatList searchResult) {
            if (!TextUtils.isEmpty((CharSequence)searchResult.getErrorMessage())) {
                return Observable.error((Throwable)new FeedManager.InternalGfycatException(searchResult.getErrorMessage()));
            }
            return Observable.just((Object)searchResult);
        }
    }

    private static class InsertOrReplaceAction
    implements Consumer<GfycatList> {
        private final GfycatFeedCache gfycatFeedCache;
        private final FeedIdentifier identifier;
        private final CloseMode closeMode;

        private InsertOrReplaceAction(GfycatFeedCache gfycatFeedCache, FeedIdentifier identifier, CloseMode closeMode) {
            this.identifier = identifier;
            this.gfycatFeedCache = gfycatFeedCache;
            this.closeMode = closeMode;
        }

        public void accept(GfycatList gfycatList) {
            this.gfycatFeedCache.insertFeed(this.identifier, gfycatList, this.closeMode);
        }
    }

    private static class UpdateFeedAction
    implements Consumer<GfycatList> {
        private final GfycatFeedCache gfycatFeedCache;
        private final FeedIdentifier identifier;
        private final String previousDigest;

        private UpdateFeedAction(GfycatFeedCache gfycatFeedCache, FeedIdentifier identifier, String previousDigest) {
            this.gfycatFeedCache = gfycatFeedCache;
            this.identifier = identifier;
            this.previousDigest = previousDigest;
        }

        public void accept(GfycatList gfycatList) {
            Assertions.assertNotUIThread(IllegalAccessException::new);
            if (Utils.isEmpty(gfycatList.getGfycats()) && Utils.isEmpty(gfycatList.getNewGfycats())) {
                this.gfycatFeedCache.closeFeed(this.identifier, this.previousDigest);
            } else {
                this.gfycatFeedCache.updateFeed(this.identifier, this.previousDigest, gfycatList);
            }
        }
    }
}

