/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.downloading;

import com.gfycat.core.FeedIdentifier;

public class FeedDescription {
    private final boolean isClosed;
    private final FeedIdentifier identifier;
    private final String digest;
    private final long creationTime;

    public FeedDescription(FeedIdentifier feedIdentifier) {
        this(false, feedIdentifier, null);
    }

    public FeedDescription(boolean isClosed, FeedIdentifier identifier, String digest) {
        this(isClosed, identifier, digest, 0L);
    }

    public FeedDescription(boolean isClosed, FeedIdentifier identifier, String digest, long creationTime) {
        this.isClosed = isClosed;
        this.identifier = identifier;
        this.creationTime = creationTime;
        this.digest = digest;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public FeedIdentifier getIdentifier() {
        return this.identifier;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getDigest() {
        return this.digest;
    }

    public String toString() {
        return "{identifier: " + (this.identifier == null ? "null" : this.identifier.toString()) + " | isClosed: " + this.isClosed + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeedDescription that = (FeedDescription)o;
        if (this.isClosed != that.isClosed) {
            return false;
        }
        if (!this.identifier.equals(that.identifier)) {
            return false;
        }
        return this.digest != null ? this.digest.equals(that.digest) : that.digest == null;
    }

    public int hashCode() {
        int result = this.isClosed ? 1 : 0;
        result = 31 * result + this.identifier.hashCode();
        result = 31 * result + (this.digest != null ? this.digest.hashCode() : 0);
        return result;
    }
}

