/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.downloading;

import com.gfycat.common.utils.Logging;
import com.gfycat.core.FeedIdentifier;
import com.gfycat.core.downloading.FeedDescription;
import com.gfycat.core.gfycatapi.pojo.Gfycat;
import java.util.Collections;
import java.util.List;

public class FeedData {
    private final FeedDescription feedDescription;
    private final List<Gfycat> gfycats;

    public FeedData(FeedDescription feedDescription) {
        this(feedDescription, Collections.emptyList());
    }

    public FeedData(FeedDescription feedDescription, List<Gfycat> gfycats) {
        this.feedDescription = feedDescription;
        this.gfycats = gfycats;
    }

    public boolean isEmpty() {
        return this.feedDescription == null || this.gfycats == null || this.gfycats.isEmpty();
    }

    public FeedIdentifier getIdentifier() {
        return this.feedDescription.getIdentifier();
    }

    public boolean isClosed() {
        return this.feedDescription.isClosed();
    }

    public FeedDescription getFeedDescription() {
        return this.feedDescription;
    }

    public List<Gfycat> getGfycats() {
        return this.gfycats;
    }

    public int getCount() {
        return this.gfycats == null ? -1 : this.gfycats.size();
    }

    public String toString() {
        return "FeedData{feedDescription=" + this.feedDescription + ", gfycats=" + (this.gfycats == null ? "null" : Integer.valueOf(this.gfycats.size())) + '}';
    }

    void dump(String logTag) {
        Logging.d((String)logTag, (Object[])new Object[]{"feedDescription = ", this.feedDescription, " size = ", this.gfycats.size(), " ", this.hashCode()});
        for (Gfycat gfycat : this.gfycats) {
            Logging.d((String)logTag, (Object[])new Object[]{"gfyId = ", gfycat.getGfyId(), " ", this.hashCode()});
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeedData feedData = (FeedData)o;
        if (!this.feedDescription.equals(feedData.feedDescription)) {
            return false;
        }
        return this.gfycats != null ? this.gfycats.equals(feedData.gfycats) : feedData.gfycats == null;
    }

    public int hashCode() {
        int result = this.feedDescription.hashCode();
        result = 31 * result + (this.gfycats != null ? this.gfycats.hashCode() : 0);
        return result;
    }
}

