/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.downloading;

import android.content.Context;
import android.support.v4.util.Pair;
import com.gfycat.common.utils.Assertions;
import com.gfycat.common.utils.Logging;
import com.gfycat.core.SingleObjectRepository;
import com.gfycat.core.downloading.pojo.GfycatCategoriesData;
import com.gfycat.core.gfycatapi.pojo.GfycatCategoriesList;

public class CategoriesCache {
    private static final String LOG_TAG = "CategoriesCache";
    private static final String PREFERENCES_NAME = "gfycat_categories";
    private final SingleObjectRepository<GfycatCategoriesData> categoriesCache;
    private static final long CATEGORIES_EXPIRATION_TIME = 0L;

    public CategoriesCache(Context context) {
        this.categoriesCache = new SingleObjectRepository<GfycatCategoriesData>(context, PREFERENCES_NAME, GfycatCategoriesData.class, new GfycatCategoriesData());
    }

    private void guard() {
        Assertions.assertNotUIThread(IllegalAccessException::new);
    }

    private boolean isCacheExpired(long lastUpdateTime) {
        return lastUpdateTime + 0L < System.currentTimeMillis();
    }

    public Pair<GfycatCategoriesList, Boolean> get() {
        this.guard();
        GfycatCategoriesData cachedData = this.categoriesCache.get();
        if (cachedData != null && cachedData.version != 1L) {
            Logging.d((String)LOG_TAG, (String)"dropCategories cache");
            cachedData = null;
            this.drop();
        }
        return cachedData != null ? Pair.create((Object)cachedData.categoriesList, (Object)this.isCacheExpired(cachedData.lastUpdateTime)) : null;
    }

    public boolean update(GfycatCategoriesList newCategoriesList) {
        this.guard();
        Pair<GfycatCategoriesList, Boolean> previousList = this.get();
        this.categoriesCache.put(new GfycatCategoriesData(newCategoriesList, System.currentTimeMillis(), 1L));
        return previousList == null || !newCategoriesList.equals(previousList.first);
    }

    void drop() {
        this.guard();
        this.categoriesCache.remove();
    }
}

