/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.db.upgrade;

import android.database.sqlite.SQLiteDatabase;
import com.gfycat.core.db.upgrade.CanNotUpgrade;
import com.gfycat.core.db.upgrade.UpgradeScript;
import java.util.HashMap;
import java.util.Map;

public class UpgradeManager {
    private SQLiteDatabase db;
    private int currentVersion;
    private final Map<Integer, UpgradeScript> upgradeScripts = new HashMap<Integer, UpgradeScript>();

    public UpgradeManager(SQLiteDatabase db, int oldVersion) {
        this.db = db;
        this.currentVersion = oldVersion;
    }

    public void upgradeTo(int newVersion) throws CanNotUpgrade {
        while (this.currentVersion != newVersion) {
            UpgradeScript currentScript = this.upgradeScripts.get(this.currentVersion);
            if (currentScript == null) {
                throw new CanNotUpgrade("No upgrade script.", this.currentVersion, newVersion);
            }
            this.currentVersion = this.upgradeScripts.get(this.currentVersion).upgrade(this.db);
        }
    }
}

