/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteClosable;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.gfycat.common.ContentValuesBuilder;
import com.gfycat.common.utils.Assertions;
import com.gfycat.common.utils.Logging;
import com.gfycat.common.utils.Sugar;
import com.gfycat.common.utils.Utils;
import com.gfycat.core.FeedIdentifier;
import com.gfycat.core.GfyUtils;
import com.gfycat.core.PublicFeedIdentifier;
import com.gfycat.core.RecentFeedIdentifier;
import com.gfycat.core.db.CloseMode;
import com.gfycat.core.db.CursorHelper;
import com.gfycat.core.db.DBInsertionHelper;
import com.gfycat.core.db.FeedCacheUriContract;
import com.gfycat.core.db.FeedIndexer;
import com.gfycat.core.db.GfycatDBHelper;
import com.gfycat.core.db.GfycatDatabaseContracts;
import com.gfycat.core.db.GfycatFeedCache;
import com.gfycat.core.downloading.FeedData;
import com.gfycat.core.downloading.FeedDescription;
import com.gfycat.core.gfycatapi.pojo.Gfycat;
import com.gfycat.core.gfycatapi.pojo.GfycatList;
import io.reactivex.functions.Function;
import java.io.Closeable;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class GfycatFeedDatabaseCache
implements GfycatFeedCache {
    private static final String LOG_TAG = "GfycatFeedDatabaseCache";
    private static final boolean VERBOSE = false;
    private static final String ITEMS_ORDER_COLUMN_NAME = "ITEMS_ORDER_COLUMN_NAME";
    private final Context context;
    private final GfycatDBHelper dbHelper;
    private SQLiteDatabase readableDatabase;
    private SQLiteDatabase writableDatabase;

    public GfycatFeedDatabaseCache(Context context) {
        Logging.d((String)LOG_TAG, (String)"onCreate()");
        this.context = context;
        this.dbHelper = new GfycatDBHelper(context);
    }

    private SQLiteDatabase getWritableDatabase() {
        if (this.writableDatabase == null) {
            this.writableDatabase = this.dbHelper.getWritableDatabase();
        }
        return this.writableDatabase;
    }

    private SQLiteDatabase getReadableDatabase() {
        if (this.readableDatabase == null) {
            this.readableDatabase = this.dbHelper.getReadableDatabase();
        }
        return this.readableDatabase;
    }

    private void guard() {
        Assertions.assertNotUIThread(IllegalAccessException::new);
    }

    private <T> T mapGfycatCursor(String gfyId, Function<Cursor, T> func) throws CanNotFindGfyIdException {
        Object object;
        Cursor cursor = null;
        try {
            cursor = this.getReadableDatabase().query("gfyList", null, "gfyId = \"" + gfyId + "\"", null, null, null, null);
            if (cursor.getCount() == 0) {
                throw new CanNotFindGfyIdException();
            }
            if (cursor.getCount() > 1) {
                Assertions.fail((Throwable)new IllegalStateException("Multiple gfycats by id = " + gfyId));
            }
            cursor.moveToFirst();
            object = func.apply((Object)cursor);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(cursor);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)cursor);
        return (T)object;
    }

    private long getGfyDBId(String gfyId) {
        try {
            return (Long)this.mapGfycatCursor(gfyId, cursor -> cursor.getLong(cursor.getColumnIndex("_id")));
        }
        catch (CanNotFindGfyIdException e) {
            return -1L;
        }
    }

    @Override
    public Gfycat getGfycat(String gfyId) {
        try {
            return (Gfycat)this.mapGfycatCursor(gfyId, CursorHelper::getGfycatFromCursor);
        }
        catch (CanNotFindGfyIdException e) {
            return null;
        }
    }

    @Override
    public void insertFeed(FeedIdentifier identifier, GfycatList data, CloseMode closeMode) {
        this.guard();
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"insertFeed(", identifier, ") nextPart = " + data.getNextDataPartIdentifier()});
        this.insertFeed(identifier, data, closeMode, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertFeed(FeedIdentifier identifier, GfycatList gfycatList, CloseMode closeMode, boolean append) {
        this.guard();
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"insertFeed(", identifier, ") nextPart = " + gfycatList.getNextDataPartIdentifier()});
        String feedUniqueName = identifier.toUniqueIdentifier();
        SQLiteDatabase db = this.getWritableDatabase();
        if (this.isSameAsInDB(feedUniqueName, gfycatList)) {
            Logging.d((String)LOG_TAG, (String)"Feed is same as DB, skip update.");
            return;
        }
        db.beginTransaction();
        try {
            long feed_Id = this.insertWithPolicy(feedUniqueName, gfycatList, closeMode, append);
            if (feed_Id == -1L) {
                throw new InternalOperationException("Can not insert feed. feedUniqueName = " + feedUniqueName);
            }
            this.saveFeedData(db, feed_Id, gfycatList);
            db.setTransactionSuccessful();
        }
        catch (SQLException | InternalOperationException e) {
            Assertions.fail((Throwable)e);
            return;
        }
        catch (Exception e) {
            Assertions.fail((Throwable)e);
            return;
        }
        finally {
            db.endTransaction();
        }
        this.notifyIdentifierChange(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFeed(FeedIdentifier identifier, String previousDigest, GfycatList gfycatList) {
        this.guard();
        Logging.w((String)LOG_TAG, (Object[])new Object[]{"updateFeed(", identifier, ") previousDigest = " + previousDigest + " digest = " + gfycatList.getNextDataPartIdentifier()});
        String feedUniqueName = identifier.toUniqueIdentifier();
        SQLiteDatabase db = this.getWritableDatabase();
        db.beginTransaction();
        try {
            if (!this.updateFeedDigest(db, feedUniqueName, gfycatList.getNextDataPartIdentifier(), previousDigest)) {
                throw new WrongDigestException("Can not update digest for feedUniqueName = " + feedUniqueName);
            }
            long feed_Id = this.getFeedIdByUniqueName(feedUniqueName);
            if (feed_Id == -1L) {
                throw new InternalOperationException("Can not find feed for feedUniqueName = " + feedUniqueName);
            }
            this.saveFeedData(db, feed_Id, gfycatList);
            db.setTransactionSuccessful();
        }
        catch (InternalOperationException e) {
            Assertions.fail((Throwable)e);
            return;
        }
        catch (WrongDigestException e) {
            Logging.d((String)LOG_TAG, (Throwable)e, (Object[])new Object[]{"Wrong digest exception happens."});
            return;
        }
        finally {
            db.endTransaction();
        }
        this.notifyIdentifierChange(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeFeed(FeedIdentifier identifier, String previousDigest) {
        this.guard();
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"closeFeed(", identifier, ")"});
        String feedUniqueName = identifier.toUniqueIdentifier();
        SQLiteDatabase db = this.getWritableDatabase();
        db.beginTransaction();
        try {
            if (!this.updateFeedDigest(db, feedUniqueName, "", previousDigest)) {
                throw new InternalOperationException("Can not close feed for feedUniqueName = " + feedUniqueName);
            }
            db.setTransactionSuccessful();
        }
        catch (InternalOperationException e) {
            Logging.d((String)LOG_TAG, (Object[])new Object[]{"Insertion exception happens. ", e});
            return;
        }
        finally {
            db.endTransaction();
        }
        this.notifyIdentifierChange(identifier);
    }

    @Override
    public boolean markDeleted(Gfycat item, boolean deleted) {
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"markDeleted(", item, ", ", deleted, ")"});
        if (deleted) {
            this.removeSingleItemFeed(item, false);
        }
        return this.updateGfycatAndNotify(item.getGfyId(), DBInsertionHelper.deletedCV(deleted));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromRecent(Gfycat item) {
        this.guard();
        SQLiteDatabase db = this.getWritableDatabase();
        String feedUniqueName = RecentFeedIdentifier.recent().toUniqueIdentifier();
        long feedId = this.getFeedIdByUniqueName(feedUniqueName);
        long gfyDbId = this.getGfyDBId(item.getGfyId());
        db.beginTransaction();
        try {
            this.removeRelation(db, feedId, gfyDbId);
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
    }

    @Override
    public boolean markPublished(Gfycat item, boolean published) {
        return this.updateGfycatAndNotify(item.getGfyId(), new ContentValuesBuilder().put("published", published ? 1 : 0).build());
    }

    @Override
    public boolean markNsfw(Gfycat item, boolean nsfw) {
        return this.updateGfycatAndNotify(item.getGfyId(), new ContentValuesBuilder().put("nsfw", nsfw ? 1 : 0).build());
    }

    @Override
    public boolean delete(FeedIdentifier feedIdentifier) {
        boolean result = this.internalDelete(feedIdentifier, true);
        this.notifyIdentifierChange(feedIdentifier);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean internalDelete(FeedIdentifier feedIdentifier, boolean notify) {
        try {
            boolean bl = this.getWritableDatabase().delete("gfyFeed", "feedUniqueName = ?", new String[]{Utils.safeEncode((String)feedIdentifier.toUniqueIdentifier())}) == 1;
            return bl;
        }
        finally {
            if (notify) {
                this.notifyIdentifierChange(feedIdentifier);
            }
        }
    }

    @Override
    public FeedData getFeedData(FeedIdentifier feedIdentifier) {
        FeedDescription feedDescription = GfycatFeedDatabaseCache.getFeed(this.getReadableDatabase(), feedIdentifier);
        if (feedDescription == null) {
            return new FeedData(new FeedDescription(feedIdentifier));
        }
        long id = this.getFeedIdByUniqueName(feedIdentifier.toUniqueIdentifier());
        return new FeedData(feedDescription, this.getGfycatsForFeed(id));
    }

    @Override
    public boolean blockItem(Gfycat gfcycat, boolean block) {
        long result;
        if (block) {
            ContentValues cv = new ContentValues();
            cv.put("gfy_id", gfcycat.getGfyId());
            result = this.getWritableDatabase().insert("blocked_gfycats", null, cv);
        } else {
            result = this.getWritableDatabase().delete("blocked_gfycats", "gfy_id = ?", new String[]{gfcycat.getGfyId()});
        }
        this.notifyRootChange();
        Assertions.assertEquals((long)1L, (long)result, IllegalStateException::new);
        return result == 1L;
    }

    @Override
    public boolean blockUser(String userName, boolean block) {
        long result;
        if (block) {
            ContentValues cv = new ContentValues();
            cv.put("username", userName);
            result = this.getWritableDatabase().insert("blocked_users", null, cv);
        } else {
            result = this.getWritableDatabase().delete("blocked_users", "username = ?", new String[]{userName});
        }
        this.notifyRootChange();
        Assertions.assertEquals((long)1L, (long)result, IllegalStateException::new);
        return result == 1L;
    }

    private long insertWithPolicy(String feedUniqueName, GfycatList gfycatList, CloseMode closeMode, boolean append) throws InternalOperationException {
        if (append) {
            return this.insertIfNotExistFeed(this.getWritableDatabase(), feedUniqueName, gfycatList.getNextDataPartIdentifier(), closeMode);
        }
        return this.insertOrReplaceFeed(this.getWritableDatabase(), feedUniqueName, gfycatList.getNextDataPartIdentifier(), closeMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIndexInFeedWithAggregation(SQLiteDatabase db, long feedId, String aggregationFunction) {
        Cursor cursor = db.rawQuery("SELECT " + aggregationFunction + "(" + "indexInFeed" + ") as " + "indexInFeed" + " FROM " + "gfycatFeedRelations" + " WHERE " + "feed_Id" + " = ?", new String[]{String.valueOf(feedId)});
        int index = 0;
        try {
            if (cursor.getCount() != 0) {
                cursor.moveToFirst();
                index = cursor.getInt(cursor.getColumnIndex("indexInFeed"));
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)cursor);
        }
        return index;
    }

    private int getMaxIndexInFeed(SQLiteDatabase db, long feedId) {
        return this.getIndexInFeedWithAggregation(db, feedId, "max");
    }

    private int getMinIndexInFeed(SQLiteDatabase db, long feedId) {
        return this.getIndexInFeedWithAggregation(db, feedId, "min");
    }

    private long insertGfycat(SQLiteDatabase writableDB, Gfycat value) {
        long gfyDbId = this.getGfyDBId(value.getGfyId());
        if (gfyDbId < 0L) {
            return writableDB.insert("gfyList", null, DBInsertionHelper.gfycatToCV(value));
        }
        writableDB.update("gfyList", DBInsertionHelper.gfycatToCV(value), "_id = " + gfyDbId, null);
        return gfyDbId;
    }

    private long insertRelation(SQLiteDatabase db, long feedId, long gfyDbId, FeedIndexer indexer, boolean replaceIfExists) {
        long feedGfycatRelationId = -1L;
        Cursor cursor = this.getReadableDatabase().query("gfycatFeedRelations", null, "gfycat_Id = " + gfyDbId + " AND " + "feed_Id" + " = " + feedId, null, null, null, null);
        if (cursor != null && cursor.moveToFirst()) {
            if (replaceIfExists) {
                long relationIdToRemove = cursor.getLong(cursor.getColumnIndex("_id"));
                db.delete("gfycatFeedRelations", "_id = ?", new String[]{String.valueOf(relationIdToRemove)});
            } else {
                feedGfycatRelationId = cursor.getLong(cursor.getColumnIndex("_id"));
            }
        }
        if (feedGfycatRelationId == -1L) {
            feedGfycatRelationId = db.insert("gfycatFeedRelations", null, DBInsertionHelper.feedGfycatItemsRelationsToCV(gfyDbId, feedId, indexer.nextIndex()));
        }
        IOUtils.closeQuietly((Closeable)cursor);
        return feedGfycatRelationId;
    }

    private void removeRelation(SQLiteDatabase db, long feedId, long gfyDbId) {
        db.delete("gfycatFeedRelations", "gfycat_Id = " + gfyDbId + " AND " + "feed_Id" + " = " + feedId, null);
    }

    private void saveGfyListFeedData(SQLiteDatabase db, long feedId, List<Gfycat> items, FeedIndexer indexer, boolean replaceFeedGfycatRelationIfExists) throws InternalOperationException {
        for (Gfycat gfycat : items) {
            long gfyDbId = this.insertGfycat(db, gfycat);
            if (gfyDbId == -1L) {
                throw new InternalOperationException("Can not insert gfycat with gfyId = " + gfycat.getGfyId());
            }
            long feedGfycatRelation_Id = this.insertRelation(db, feedId, gfyDbId, indexer, replaceFeedGfycatRelationIfExists);
            if (feedGfycatRelation_Id == -1L) {
                throw new InternalOperationException("Can not insert relation = " + gfycat.getGfyId());
            }
            if (!VERBOSE) continue;
            Logging.d((String)LOG_TAG, (String)("save to db: " + gfycat.getGfyId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFeedData(SQLiteDatabase db, long feedId, GfycatList gfycatList) throws InternalOperationException {
        int minIndex = this.getMinIndexInFeed(db, feedId);
        int maxIndex = this.getMaxIndexInFeed(db, feedId);
        db.beginTransaction();
        try {
            this.saveGfyListFeedData(db, feedId, gfycatList.getGfycats(), new FeedIndexer(maxIndex, true), false);
            this.saveGfyListFeedData(db, feedId, gfycatList.getNewGfycats(), new FeedIndexer(minIndex, false), true);
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
    }

    /*
     * Exception decompiling
     */
    private boolean isSameAsInDB(String feedUniqueName, GfycatList gfycatList) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[FORLOOP]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Gfycat> getGfycatsForFeed(long feed_id) {
        List<Gfycat> list;
        Cursor cursor = null;
        try {
            cursor = this.getGfycatsCursorForFeed(feed_id);
            list = CursorHelper.getGfycatsFromCursor(cursor);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(cursor);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)cursor);
        return list;
    }

    private Cursor getGfycatsCursorForFeed(long feed_id) {
        String query = "SELECT " + this.buildProjectionForGfycatForFeed() + " FROM " + "gfyFeed" + ", " + "gfycatFeedRelations" + ", " + "gfyList" + " WHERE " + "gfyFeed" + "." + "_id" + " = " + "gfycatFeedRelations" + "." + "feed_Id" + " AND " + "gfyList" + "." + "_id" + " = " + "gfycatFeedRelations" + "." + "gfycat_Id" + " AND " + "gfyFeed" + "." + "_id" + " = " + feed_id + " AND " + "gfyList" + "." + "deleted" + " = 0  AND " + "gfyList" + "." + "gfyId" + " NOT IN (SELECT " + "gfy_id" + " FROM " + "blocked_gfycats" + ") AND " + "userName" + " NOT IN (SELECT " + "username" + " FROM " + "blocked_users" + ") ORDER BY " + ITEMS_ORDER_COLUMN_NAME + ";";
        if (VERBOSE) {
            Logging.d((String)LOG_TAG, (Object[])new Object[]{"getGfycatsForFeed query = ", query});
        }
        return this.getReadableDatabase().rawQuery(query, null);
    }

    private String buildProjectionForGfycatForFeed() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < GfycatDatabaseContracts.GfycatContract.BASE_PROJECTION.length; ++i) {
            String field = GfycatDatabaseContracts.GfycatContract.BASE_PROJECTION[i];
            sb.append("gfyList").append(".").append(field).append(" as ").append(field);
            if (i >= GfycatDatabaseContracts.GfycatContract.BASE_PROJECTION.length - 1) continue;
            sb.append(", ");
        }
        sb.append(", ").append("gfycatFeedRelations").append(".").append("indexInFeed").append(" as ").append(ITEMS_ORDER_COLUMN_NAME);
        return sb.toString();
    }

    private boolean isFeedOutdated(Cursor cursor) {
        Date createDate = null;
        try {
            createDate = Utils.ISO8601.parse(cursor.getString(cursor.getColumnIndex("createDate")));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return GfyUtils.isFeedOutdated(createDate);
    }

    private Cursor getFeedByUniqueName(String uniqueName) {
        return this.getReadableDatabase().query("gfyFeed", null, "feedUniqueName = ?", new String[]{Utils.safeEncode((String)uniqueName)}, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long insertOrReplaceFeed(SQLiteDatabase db, String feedUniqueName, String nextPartIdentifier, CloseMode closeMode) throws InternalOperationException {
        long feedId = -1L;
        db.beginTransaction();
        try {
            db.delete("gfyFeed", "feedUniqueName = ?", new String[]{Utils.safeEncode((String)feedUniqueName)});
            feedId = db.insert("gfyFeed", null, DBInsertionHelper.feedCV(feedUniqueName, nextPartIdentifier, !closeMode.isOpen(nextPartIdentifier)));
            if (feedId == -1L) {
                throw new InternalOperationException("::insertFeed() can not insert feed, feedUniqueName = " + feedUniqueName);
            }
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
        return feedId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long insertIfNotExistFeed(SQLiteDatabase db, String feedUniqueName, String nextPartIdentifier, CloseMode closeMode) throws InternalOperationException {
        long feedId = -1L;
        db.beginTransaction();
        try {
            feedId = this.getFeedIdByUniqueName(feedUniqueName);
            if (feedId == -1L) {
                feedId = db.insert("gfyFeed", null, DBInsertionHelper.feedCV(feedUniqueName, nextPartIdentifier, !closeMode.isOpen(nextPartIdentifier)));
                Logging.d((String)LOG_TAG, (String)("New feed " + feedUniqueName + " inserted with rowId = " + feedId));
            }
            if (feedId == -1L) {
                throw new InternalOperationException("::insertFeed() can not insert feed, feedUniqueName = " + feedUniqueName);
            }
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
        return feedId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getFeedIdByUniqueName(String uniqueName) {
        Cursor cursor = this.getFeedByUniqueName(uniqueName);
        if (cursor.getCount() != 0 && cursor.moveToFirst()) {
            try {
                long l = cursor.getLong(cursor.getColumnIndex("_id"));
                return l;
            }
            finally {
                IOUtils.closeQuietly((Closeable)cursor);
            }
        }
        return -1L;
    }

    private boolean updateFeedDigest(SQLiteDatabase db, String feedUniqueName, String digest, String previousDigest) {
        return db.update("gfyFeed", DBInsertionHelper.feedDigestCV(digest, false), "feedUniqueName = ? AND digest = ?", new String[]{Utils.safeEncode((String)feedUniqueName), previousDigest}) == 1;
    }

    private void removeSingleItemFeed(Gfycat item, boolean notify) {
        this.internalDelete(PublicFeedIdentifier.fromSingleItem(item.getGfyId()), notify);
    }

    private boolean updateGfycatAndNotify(String gfyId, ContentValues contentValues) {
        this.guard();
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"updateGfycatAndNotify(", gfyId, ")"});
        SQLiteDatabase db = this.getWritableDatabase();
        int result = db.update("gfyList", contentValues, "gfyId = ?; ", new String[]{gfyId});
        Assertions.assertEquals((int)1, (int)result, () -> new IllegalStateException("GfycatFeedDatabaseCache::updateGfycatAndNotify(" + gfyId + ") wrong updated count"));
        this.notifyRootChange();
        return result == 1;
    }

    private void notifyRootChange() {
        Logging.d((String)LOG_TAG, (String)"notifyRootChange()");
        FeedCacheUriContract.getFeedChangeEventBus().notifyRootChange();
    }

    private void notifyIdentifierChange(FeedIdentifier identifier) {
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"notifyIdentifierChange(", identifier, ")"});
        FeedCacheUriContract.getFeedChangeEventBus().notifyChange(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FeedDescription getFeed(SQLiteDatabase readableDB, FeedIdentifier feedIdentifier) {
        try (Cursor cursor = null;){
            cursor = readableDB.query("gfyFeed", null, "feedUniqueName = ?", new String[]{String.valueOf(Utils.safeEncode((String)feedIdentifier.toUniqueIdentifier()))}, null, null, null);
            if (cursor == null || cursor.getCount() != 1) {
                FeedDescription feedDescription = null;
                return feedDescription;
            }
            cursor.moveToFirst();
            FeedDescription feedDescription = CursorHelper.getFeedDescriptionFromCursor(cursor);
            return feedDescription;
        }
    }

    public void close() {
        Sugar.doIfNotNull((Object)this.readableDatabase, SQLiteClosable::close);
        this.readableDatabase = null;
        Sugar.doIfNotNull((Object)this.writableDatabase, SQLiteClosable::close);
        this.writableDatabase = null;
        Sugar.doIfNotNull((Object)this.dbHelper, SQLiteOpenHelper::close);
        this.dbHelper.close();
    }

    private static class CanNotFindGfyIdException
    extends Throwable {
        private CanNotFindGfyIdException() {
        }
    }

    private static class WrongDigestException
    extends Exception {
        WrongDigestException(String message) {
            super(message);
        }
    }

    private static class InternalOperationException
    extends Exception {
        InternalOperationException(String s) {
            super(s);
        }
    }
}

