/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.db;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.gfycat.common.utils.Logging;
import com.gfycat.core.db.SQLCreationScripts;
import com.gfycat.core.db.SQLUtils;
import io.reactivex.functions.Consumer;

public class GfycatDBHelper
extends SQLiteOpenHelper
implements SQLCreationScripts {
    private static final String LOG_TAG = "GfyDB";
    private static String DB_NAME = "Gfycat.db";
    private static int DB_VERSION = 31;

    public GfycatDBHelper(Context context) {
        super(context, DB_NAME, null, DB_VERSION);
    }

    public void onCreate(SQLiteDatabase db) {
        Logging.d((String)LOG_TAG, (String)"onCreate()");
        SQLUtils.performTransactionWith(db, (Consumer<SQLiteDatabase>)((Consumer)sqLiteDatabase -> this.createTables(db)));
    }

    private void createTables(SQLiteDatabase db) {
        Logging.d((String)LOG_TAG, (String)"createTables()");
        db.execSQL(" CREATE TABLE IF NOT EXISTS gfyList (_id INTEGER  PRIMARY KEY, gfyId TEXT  NOT NULL  UNIQUE , gfyName TEXT  NOT NULL , gfyNumber INTEGER  NOT NULL , width INTEGER , height INTEGER , posterUrl TEXT , pngPosterUrl TEXT , mobilePosterUrl TEXT , miniPosterUrl TEXT , thumb100PosterUrl TEXT , mp4Url TEXT , mobileUrl TEXT , miniUrl TEXT , gifUrl TEXT , webmUrl TEXT , webpUrl TEXT , gif100px TEXT , max1mbGif TEXT , max2mbGif TEXT , max5mbGif TEXT , mp4Size INTEGER , webmSize INTEGER , userName TEXT  NOT NULL , servertCreateDate TEXT  NOT NULL , localCreateDate TEXT  NOT NULL , views INTEGER , title TEXT , description TEXT , projectionType TEXT , tags BLOB , deleted INTEGER  DEFAULT 0, nsfw INTEGER  DEFAULT 0, published INTEGER  DEFAULT 0, has_transparency INTEGER  DEFAULT 0, has_audio INTEGER  DEFAULT 0, content_rating TEXT , num_frames INTEGER  DEFAULT 0, frame_rate REAL  DEFAULT 0.0, avgColor TEXT  );");
        db.execSQL(" CREATE TABLE IF NOT EXISTS gfyFeed (_id INTEGER  PRIMARY KEY, digest TEXT , createDate TEXT  NOT NULL , feedUniqueName TEXT  NOT NULL  UNIQUE , local_isClosed INTEGER  NOT NULL  DEFAULT 0 );");
        db.execSQL(" CREATE TABLE IF NOT EXISTS gfycatFeedRelations (_id INTEGER  PRIMARY KEY, feed_Id INTEGER  REFERENCES gfyFeed(_id) ON DELETE CASCADE , gfycat_Id INTEGER  REFERENCES gfyList(_id) ON DELETE CASCADE , indexInFeed INTEGER  NOT NULL  );");
        db.execSQL(" CREATE TABLE IF NOT EXISTS blocked_users (username TEXT  UNIQUE  NOT NULL  );");
        db.execSQL(" CREATE TABLE IF NOT EXISTS blocked_gfycats (gfy_id TEXT  UNIQUE  NOT NULL  );");
    }

    private void dropAllTables(SQLiteDatabase db) {
        Logging.d((String)LOG_TAG, (String)"dropAllTables()");
        db.execSQL("DROP TABLE IF EXISTS blocked_gfycats");
        db.execSQL("DROP TABLE IF EXISTS blocked_users");
        db.execSQL("DROP TABLE IF EXISTS gfycatFeedRelations");
        db.execSQL("DROP TABLE IF EXISTS gfyList");
        db.execSQL("DROP TABLE IF EXISTS gfyFeed");
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"onUpgrade", " oldVersion = ", oldVersion, " newVersion = ", newVersion});
        this.dropAllTables(db);
        this.createTables(db);
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"onDowngrade", " oldVersion = ", oldVersion, " newVersion = ", newVersion});
        this.dropAllTables(db);
        this.createTables(db);
    }

    public void onConfigure(SQLiteDatabase db) {
        Logging.d((String)LOG_TAG, (String)("onConfigure() " + DB_VERSION));
        db.execSQL("PRAGMA foreign_keys = ON;");
    }
}

