/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.db;

import com.gfycat.core.FeedIdentifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FeedChangeEventBus {
    private HashMap<FeedIdentifier, List<FeedObserver>> feedObservers = new HashMap();

    private List<FeedObserver> getOrInsert(FeedIdentifier feedIdentifier) {
        List<FeedObserver> result = this.feedObservers.get(feedIdentifier);
        if (result == null) {
            result = new ArrayList<FeedObserver>();
            this.feedObservers.put(feedIdentifier, result);
        }
        return result;
    }

    public void registerFeedObserver(FeedIdentifier feedIdentifier, FeedObserver feedObserver) {
        if (feedObserver == null || feedIdentifier == null) {
            return;
        }
        this.getOrInsert(feedIdentifier).add(feedObserver);
    }

    public void unregisterFeedObserver(FeedObserver feedObserver) {
        if (feedObserver == null) {
            return;
        }
        for (List<FeedObserver> observers : this.feedObservers.values()) {
            observers.remove(feedObserver);
        }
    }

    public void notifyRootChange() {
        for (Map.Entry<FeedIdentifier, List<FeedObserver>> entry : this.feedObservers.entrySet()) {
            for (FeedObserver observer : entry.getValue()) {
                observer.onChange(entry.getKey());
            }
        }
    }

    public void notifyChange(FeedIdentifier feedIdentifier) {
        List<FeedObserver> observers = this.feedObservers.get(feedIdentifier);
        if (observers != null) {
            for (FeedObserver observer : observers) {
                observer.onChange(feedIdentifier);
            }
        }
    }

    public static interface FeedObserver {
        public void onChange(FeedIdentifier var1);
    }
}

