/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.db;

import com.gfycat.common.utils.Logging;
import com.gfycat.core.FeedIdentifier;
import com.gfycat.core.db.FeedChangeEventBus;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import java.util.concurrent.TimeUnit;

public class FeedCacheUriContract {
    private static final String LOG_TAG = "FeedCacheUriContract";
    private static final long MINIMUM_CHANGES_EMIT_PERIOD_MILLIS = 100L;
    private static final FeedChangeEventBus FEED_CHANGE_EVENT_BUS = new FeedChangeEventBus();

    public static FeedChangeEventBus getFeedChangeEventBus() {
        return FEED_CHANGE_EVENT_BUS;
    }

    public static Flowable<FeedIdentifier> observeChanges(FeedIdentifier identifier) {
        return Flowable.create(emitter -> {
            FeedChangeEventBus.FeedObserver feedObserver = feedIdentifier -> {
                Logging.d((String)LOG_TAG, (Object[])new Object[]{"onChange(", identifier, ")"});
                emitter.onNext((Object)identifier);
            };
            FEED_CHANGE_EVENT_BUS.registerFeedObserver(identifier, feedObserver);
            emitter.setCancellable(() -> FEED_CHANGE_EVENT_BUS.unregisterFeedObserver(feedObserver));
        }, (BackpressureStrategy)BackpressureStrategy.BUFFER).throttleLatest(100L, TimeUnit.MILLISECONDS);
    }
}

