/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.db;

import android.content.ContentValues;
import com.gfycat.common.utils.Utils;
import com.gfycat.core.gfycatapi.pojo.Gfycat;
import java.util.Date;

class DBInsertionHelper {
    DBInsertionHelper() {
    }

    static ContentValues gfycatToCV(Gfycat gfycat) {
        ContentValues cv = new ContentValues();
        cv.put("gfyId", gfycat.getGfyId());
        cv.put("gfyName", gfycat.getGfyName());
        cv.put("gfyNumber", gfycat.getGfyNumber());
        cv.put("width", Integer.valueOf(gfycat.getWidth()));
        cv.put("height", Integer.valueOf(gfycat.getHeight()));
        cv.put("posterUrl", gfycat.getPosterUrl());
        cv.put("pngPosterUrl", gfycat.getPosterPngUrl());
        cv.put("mobilePosterUrl", gfycat.getPosterMobileUrl());
        cv.put("miniPosterUrl", gfycat.getPosterMiniUrl());
        cv.put("thumb100PosterUrl", gfycat.getPosterThumb100Url());
        cv.put("mp4Url", gfycat.getMp4Url());
        cv.put("mobileUrl", gfycat.getMp4MobileUrl());
        cv.put("miniUrl", gfycat.getMp4MiniUrl());
        cv.put("gifUrl", gfycat.getGifLargeUrl());
        cv.put("webmUrl", gfycat.getWebMUrl());
        cv.put("webpUrl", gfycat.getWebPUrl());
        cv.put("gif100px", gfycat.getGif100pxUrl());
        cv.put("max1mbGif", gfycat.getGif1mbUrl());
        cv.put("max2mbGif", gfycat.getGif2mbUrl());
        cv.put("max5mbGif", gfycat.getGif5mbUrl());
        cv.put("mp4Size", Integer.valueOf(gfycat.getMp4Size()));
        cv.put("webmSize", Integer.valueOf(gfycat.getWebMSize()));
        cv.put("userName", gfycat.getUserName());
        cv.put("servertCreateDate", gfycat.getCreateDate());
        cv.put("localCreateDate", Utils.ISO8601.format(new Date()));
        cv.put("views", Integer.valueOf(gfycat.getViews()));
        cv.put("title", gfycat.getTitle());
        cv.put("description", gfycat.getDescription());
        cv.put("projectionType", gfycat.getProjectionType());
        cv.put("tags", Utils.serializeListOfStrings(gfycat.getTags()));
        cv.put("nsfw", Integer.valueOf(gfycat.getNsfw()));
        cv.put("published", Integer.valueOf(gfycat.getPublished()));
        cv.put("avgColor", gfycat.getAvgColor());
        cv.put("has_transparency", Integer.valueOf(gfycat.hasTransparency() ? 1 : 0));
        cv.put("has_audio", Integer.valueOf(gfycat.hasAudio() ? 1 : 0));
        cv.put("content_rating", gfycat.getContentRating() == null ? null : gfycat.getContentRating().responseValue);
        cv.put("num_frames", Integer.valueOf(gfycat.getNumFrames()));
        cv.put("frame_rate", Float.valueOf(gfycat.getFrameRate()));
        return cv;
    }

    static ContentValues feedDigestCV(String nextPartIdentifier, boolean isClosed) {
        ContentValues cv = new ContentValues();
        cv.put("local_isClosed", Boolean.valueOf(isClosed));
        cv.put("digest", nextPartIdentifier);
        return cv;
    }

    static ContentValues closeFeedCV() {
        ContentValues cv = new ContentValues();
        cv.put("local_isClosed", Boolean.valueOf(true));
        return cv;
    }

    static ContentValues feedCV(String uniqueName, String nextPartIdentifier, boolean isClosed) {
        ContentValues cv = DBInsertionHelper.feedDigestCV(nextPartIdentifier, isClosed);
        cv.put("createDate", Utils.ISO8601.format(new Date()));
        cv.put("feedUniqueName", Utils.safeEncode((String)uniqueName));
        return cv;
    }

    static ContentValues feedGfycatItemsRelationsToCV(long gfyId, long feedId, int indexInFeed) {
        ContentValues cv = new ContentValues();
        cv.put("feed_Id", Long.valueOf(feedId));
        cv.put("gfycat_Id", Long.valueOf(gfyId));
        cv.put("indexInFeed", Integer.valueOf(indexInFeed));
        return cv;
    }

    static ContentValues deletedCV(boolean deleted) {
        ContentValues cv = new ContentValues();
        cv.put("deleted", Integer.valueOf(deleted ? 1 : 0));
        return cv;
    }
}

