/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.db;

import android.database.Cursor;
import com.gfycat.common.utils.Assertions;
import com.gfycat.common.utils.Utils;
import com.gfycat.core.FeedIdentifierFactory;
import com.gfycat.core.downloading.FeedDescription;
import com.gfycat.core.gfycatapi.pojo.Gfycat;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CursorHelper {
    private static final String LOG_TAG = "CursorHelper";

    static FeedDescription getFeedDescriptionFromCursor(Cursor cursor) {
        return new FeedDescription(cursor.getInt(cursor.getColumnIndex("local_isClosed")) == 1, FeedIdentifierFactory.fromUniqueIdentifier(Utils.safeDecode((String)cursor.getString(cursor.getColumnIndex("feedUniqueName")))), cursor.getString(cursor.getColumnIndex("digest")), Utils.parseDateSafe((String)cursor.getString(cursor.getColumnIndex("createDate")), (DateFormat)Utils.ISO8601, (Date)new Date(0L)).getTime());
    }

    public static Gfycat getGfycatFromCursor(Cursor cursor) {
        Gfycat gfycat = new Gfycat();
        gfycat.setGfyId(cursor.getString(cursor.getColumnIndex("gfyId")));
        gfycat.setGfyName(cursor.getString(cursor.getColumnIndex("gfyName")));
        gfycat.setGfyNumber(cursor.getString(cursor.getColumnIndex("gfyNumber")));
        gfycat.setWidth(cursor.getInt(cursor.getColumnIndex("width")));
        gfycat.setHeight(cursor.getInt(cursor.getColumnIndex("height")));
        gfycat.setPosterUrl(cursor.getString(cursor.getColumnIndex("posterUrl")));
        gfycat.setPosterPngUrl(cursor.getString(cursor.getColumnIndex("pngPosterUrl")));
        gfycat.setPosterMobileUrl(cursor.getString(cursor.getColumnIndex("mobilePosterUrl")));
        gfycat.setPosterMiniUrl(cursor.getString(cursor.getColumnIndex("miniPosterUrl")));
        gfycat.setPosterThumb100Url(cursor.getString(cursor.getColumnIndex("thumb100PosterUrl")));
        gfycat.setMp4Url(cursor.getString(cursor.getColumnIndex("mp4Url")));
        gfycat.setMp4MobileUrl(cursor.getString(cursor.getColumnIndex("mobileUrl")));
        gfycat.setMp4MiniUrl(cursor.getString(cursor.getColumnIndex("miniUrl")));
        gfycat.setGifLargeUrl(cursor.getString(cursor.getColumnIndex("gifUrl")));
        gfycat.setWebMUrl(cursor.getString(cursor.getColumnIndex("webmUrl")));
        gfycat.setWebPUrl(cursor.getString(cursor.getColumnIndex("webpUrl")));
        gfycat.setGif100pxUrl(cursor.getString(cursor.getColumnIndex("gif100px")));
        gfycat.setGif1mbUrl(cursor.getString(cursor.getColumnIndex("max1mbGif")));
        gfycat.setGif2mbUrl(cursor.getString(cursor.getColumnIndex("max2mbGif")));
        gfycat.setGif5mbUrl(cursor.getString(cursor.getColumnIndex("max5mbGif")));
        gfycat.setMp4Size(cursor.getInt(cursor.getColumnIndex("mp4Size")));
        gfycat.setWebMSize(cursor.getInt(cursor.getColumnIndex("webmSize")));
        gfycat.setUserName(cursor.getString(cursor.getColumnIndex("userName")));
        gfycat.setCreateDate(cursor.getString(cursor.getColumnIndex("servertCreateDate")));
        gfycat.setViews(cursor.getInt(cursor.getColumnIndex("views")));
        gfycat.setTitle(cursor.getString(cursor.getColumnIndex("title")));
        gfycat.setDescription(cursor.getString(cursor.getColumnIndex("description")));
        gfycat.setProjectionType(cursor.getString(cursor.getColumnIndex("projectionType")));
        gfycat.setTags(Utils.deSerializeListOfStrings((byte[])cursor.getBlob(cursor.getColumnIndex("tags"))));
        gfycat.setNsfw(cursor.getInt(cursor.getColumnIndex("nsfw")));
        gfycat.setPublished(cursor.getInt(cursor.getColumnIndex("published")));
        gfycat.setAvgColor(cursor.getString(cursor.getColumnIndex("avgColor")));
        gfycat.setHasTransparency(cursor.getInt(cursor.getColumnIndex("has_transparency")) == 1);
        gfycat.setHasAudio(cursor.getInt(cursor.getColumnIndex("has_audio")) == 1);
        gfycat.setContentRating(cursor.getString(cursor.getColumnIndex("content_rating")));
        gfycat.setFrameRate(cursor.getFloat(cursor.getColumnIndex("frame_rate")));
        gfycat.setNumFrames(cursor.getInt(cursor.getColumnIndex("num_frames")));
        return gfycat;
    }

    public static List<Gfycat> getGfycatsFromCursor(Cursor cursor) {
        Assertions.assertNotUIThread(IllegalStateException::new);
        ArrayList<Gfycat> result = new ArrayList<Gfycat>(cursor.getCount());
        while (cursor.moveToNext()) {
            result.add(CursorHelper.getGfycatFromCursor(cursor));
        }
        return result;
    }
}

